/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.model.alarm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsg;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgChain;
import com.yy.aomi.analysis.common.model.alarm.QueueBlockAlarm;
import com.yy.aomi.analysis.common.model.alarm.RpcAlarm;
import com.yy.aomi.analysis.common.model.analysis.MonitorAppInfo;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;

public class AlarmMsgErrorNode<T extends AlarmMsg> {
    private String analysisId;
    private String processKey;
    private Integer ownerId;
    private Integer parantId;
    private T alarmMsg;

    public AlarmMsgErrorNode() {
    }

    public AlarmMsgErrorNode(Integer ownerId, Integer parantId, T alarmMsg) {
        this.ownerId = ownerId;
        this.parantId = parantId;
        this.alarmMsg = alarmMsg;
    }

    public AlarmMsgErrorNode(String analysisId, String processKey, Integer ownerId, Integer parantId, T alarmMsg) {
        this.analysisId = analysisId;
        this.processKey = processKey;
        this.ownerId = ownerId;
        this.parantId = parantId;
        this.alarmMsg = alarmMsg;
    }

    public static void main(String[] args) throws Exception {
        Map<MonitorAppInfo, AlarmMsgChain> map = AlarmMsgErrorNode.getData();
        AlarmMsgErrorNode.printMap(map);
        List<String[]> jsons = AlarmMsgErrorNode.split(map);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (String[] item : jsons) {
            for (String str : item) {
                list.add(JSONObject.parseObject((String)str));
            }
        }
        Map<MonitorAppInfo, AlarmMsgChain> result = AlarmMsgErrorNode.restore(list);
        AlarmMsgErrorNode.printMap(result);
    }

    public static Map<MonitorAppInfo, AlarmMsgChain> restore(List<JSONObject> list) throws Exception {
        ArrayList<AlarmMsgErrorNode> itemList;
        List<AlarmMsgErrorNode> beanList = AlarmMsgErrorNode.jsonToObject(list);
        HashMap<MonitorAppInfo, AlarmMsgChain> result = new HashMap<MonitorAppInfo, AlarmMsgChain>();
        HashMap<MonitorAppInfo, ArrayList<AlarmMsgErrorNode>> map = new HashMap<MonitorAppInfo, ArrayList<AlarmMsgErrorNode>>();
        for (AlarmMsgErrorNode item : beanList) {
            String processKey = item.getProcessKey();
            itemList = (ArrayList<AlarmMsgErrorNode>)map.get(processKey);
            if (itemList == null) {
                itemList = new ArrayList<AlarmMsgErrorNode>();
                MonitorAppInfo appInfo = new MonitorAppInfo();
                String[] processInfos = processKey.split(":");
                appInfo.setClientname(processInfos[0]);
                ArrayList<String> ips = new ArrayList<String>();
                ips.add(processInfos[1]);
                appInfo.setIpList(ips);
                ArrayList<Integer> ports = new ArrayList<Integer>();
                ports.add(Integer.parseInt(processInfos[2]));
                appInfo.setPortList(ports);
                map.put(appInfo, itemList);
            }
            itemList.add(item);
        }
        Set keys = map.keySet();
        for (MonitorAppInfo key : keys) {
            itemList = (List)map.get((Object)key);
            result.put(key, AlarmMsgErrorNode.buildTree(itemList));
        }
        return result;
    }

    public static AlarmMsgChain restoreAlarmMsgChain(List<JSONObject> list) throws Exception {
        List<AlarmMsgErrorNode> beanList = AlarmMsgErrorNode.jsonToObject(list);
        return AlarmMsgErrorNode.buildTree(beanList);
    }

    public static List<AlarmMsgErrorNode> jsonToObject(List<JSONObject> list) throws Exception {
        ArrayList<AlarmMsgErrorNode> result = new ArrayList<AlarmMsgErrorNode>();
        for (JSONObject json : list) {
            AlarmMsgErrorNode item = null;
            json.remove((Object)"@timestamp");
            int modelType = json.getJSONObject("alarmMsg").getJSONObject("mergeKey").getIntValue("modelType");
            switch (modelType) {
                case 1: {
                    new TypeReference<AlarmMsgErrorNode<QueueBlockAlarm>>(){}.getClass();
                    item = (AlarmMsgErrorNode)JSONObject.parseObject((String)json.toJSONString(), (Type)new TypeReference<AlarmMsgErrorNode<QueueBlockAlarm>>(){}.getType(), (Feature[])new Feature[0]);
                    break;
                }
                case 2: {
                    item = (AlarmMsgErrorNode)JSONObject.parseObject((String)json.toJSONString(), (Type)new TypeReference<AlarmMsgErrorNode<RpcAlarm>>(){}.getType(), (Feature[])new Feature[0]);
                    break;
                }
                default: {
                    throw new Exception("error unknow modelType " + modelType);
                }
            }
            result.add(item);
        }
        return result;
    }

    public static List<String[]> split(Map<MonitorAppInfo, AlarmMsgChain> map) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Set<MonitorAppInfo> keys = map.keySet();
        String analysisId = UUID.randomUUID().toString();
        Date now = new Date();
        String time = DateFormatUtils.formatUTC((Date)now, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        for (MonitorAppInfo appInfo : keys) {
            AlarmMsgChain trees = map.get((Object)appInfo);
            String processKey = appInfo.getServiceHostId();
            result.add(AlarmMsgErrorNode.splitTreeToJson(trees, analysisId, processKey, time));
        }
        return result;
    }

    public static List<AlarmMsgErrorNode<AlarmMsg>> splitTree(AlarmMsgChain<AlarmMsg> alarmMsgChain, String analysisId, String processKey) {
        ArrayList<AlarmMsgErrorNode<AlarmMsg>> result = new ArrayList<AlarmMsgErrorNode<AlarmMsg>>();
        int lastId = 0;
        int parent = 0;
        for (AlarmMsg item : alarmMsgChain) {
            lastId = AlarmMsgErrorNode.encodeItem(item, lastId, parent, 1, result, analysisId, processKey);
        }
        return result;
    }

    public static String[] splitTreeToJson(AlarmMsgChain<AlarmMsg> alarmMsgChain, String analysisId, String processKey, String time) {
        List<AlarmMsgErrorNode<AlarmMsg>> result = AlarmMsgErrorNode.splitTree(alarmMsgChain, analysisId, processKey);
        ArrayList<String> jsons = new ArrayList<String>(result.size());
        for (AlarmMsgErrorNode<AlarmMsg> node : result) {
            List<AlarmMsg> children = node.getAlarmMsg().children;
            node.getAlarmMsg().children = null;
            JSONObject object = JSONObject.parseObject((String)JSONObject.toJSONString(node));
            object.put("@timestamp", (Object)time);
            jsons.add(object.toJSONString());
            node.getAlarmMsg().children = children;
        }
        String[] jsonArray = new String[jsons.size()];
        jsons.toArray(jsonArray);
        return jsonArray;
    }

    public static int encodeItem(AlarmMsg item, int id, int parant, int level, List<AlarmMsgErrorNode<AlarmMsg>> result, String analysisId, String processKey) {
        int lastId = id + 1;
        AlarmMsgErrorNode<AlarmMsg> node = new AlarmMsgErrorNode<AlarmMsg>(analysisId, processKey, lastId, parant, item);
        result.add(node);
        List<AlarmMsg> children = item.getChildren();
        parant = lastId;
        for (AlarmMsg child : children) {
            lastId = AlarmMsgErrorNode.encodeItem(child, lastId, parant, level + 1, result, analysisId, processKey);
        }
        return lastId;
    }

    public static AlarmMsgChain buildTree(List<AlarmMsgErrorNode> list) {
        AlarmMsgChain alarmMsgChain = new AlarmMsgChain();
        Collections.sort(list, new Comparator<AlarmMsgErrorNode>(){

            @Override
            public int compare(AlarmMsgErrorNode o1, AlarmMsgErrorNode o2) {
                if (o1.getParantId() == o2.getParantId()) {
                    return o1.getOwnerId() - o2.getOwnerId();
                }
                return o1.getParantId() - o2.getParantId();
            }
        });
        HashMap<Integer, AlarmMsgErrorNode> map = new HashMap<Integer, AlarmMsgErrorNode>();
        for (AlarmMsgErrorNode node : list) {
            map.put(node.getOwnerId(), node);
        }
        if (list.size() > 0) {
            AlarmMsg root = new AlarmMsg();
            for (AlarmMsgErrorNode node : list) {
                AlarmMsg am = node.getAlarmMsg();
                Integer parantId = node.getParantId();
                am.children = new ArrayList<AlarmMsg>();
                if (parantId == 0) {
                    root.add(am);
                    alarmMsgChain.add(am);
                    continue;
                }
                AlarmMsgErrorNode node2 = (AlarmMsgErrorNode)map.get(parantId);
                AlarmMsg parantAm = node2.getAlarmMsg();
                parantAm.add(am);
            }
        }
        return alarmMsgChain;
    }

    public static void printMap(Map<MonitorAppInfo, AlarmMsgChain> map) {
        Set<MonitorAppInfo> keys = map.keySet();
        for (MonitorAppInfo key : keys) {
            AlarmMsgChain trees = map.get((Object)key);
            AlarmMsgErrorNode.print(trees);
        }
    }

    public static void print(AlarmMsgChain<AlarmMsg> alarmMsgChain) {
        for (AlarmMsg item : alarmMsgChain) {
            AlarmMsgErrorNode.printItem(item, 0);
        }
    }

    public static void printItem(AlarmMsg item, int level) {
        List<AlarmMsg> children = item.getChildren();
        for (AlarmMsg child : children) {
            AlarmMsgErrorNode.printItem(child, level + 1);
        }
    }

    public String toString() {
        return "AlarmMsgErrorNode [analysisId=" + this.analysisId + ", processKey=" + this.processKey + ", ownerId=" + this.ownerId + ", parantId=" + this.parantId + ", modelType=]";
    }

    public String getAnalysisId() {
        return this.analysisId;
    }

    public void setAnalysisId(String analysisId) {
        this.analysisId = analysisId;
    }

    public String getProcessKey() {
        return this.processKey;
    }

    public void setProcessKey(String processKey) {
        this.processKey = processKey;
    }

    public Integer getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public Integer getParantId() {
        return this.parantId;
    }

    public void setParantId(Integer parantId) {
        this.parantId = parantId;
    }

    public AlarmMsg getAlarmMsg() {
        return this.alarmMsg;
    }

    public void setAlarmMsg(T alarmMsg) {
        this.alarmMsg = alarmMsg;
    }

    private static Map<MonitorAppInfo, AlarmMsgChain> getData() {
        HashMap<MonitorAppInfo, AlarmMsgChain> alarmMsgChainMap = new HashMap<MonitorAppInfo, AlarmMsgChain>();
        MonitorAppInfo appInfo = new MonitorAppInfo();
        appInfo.setClientname("appName1");
        MonitorAppInfo appInfo2 = new MonitorAppInfo();
        appInfo2.setClientname("appName2");
        alarmMsgChainMap.put(appInfo, AlarmMsgErrorNode.getAlarmMsgChain());
        alarmMsgChainMap.put(appInfo2, AlarmMsgErrorNode.getAlarmMsgChain());
        return alarmMsgChainMap;
    }

    private static AlarmMsgChain getAlarmMsgChain() {
        AlarmMsgChain alarmMsgChain = new AlarmMsgChain();
        QueueBlockAlarm node1 = new QueueBlockAlarm();
        node1.setTotalCount(1L);
        QueueBlockAlarm node2 = new QueueBlockAlarm();
        node2.setTotalCount(2L);
        QueueBlockAlarm node3 = new QueueBlockAlarm();
        node3.setTotalCount(3L);
        QueueBlockAlarm node4 = new QueueBlockAlarm();
        node4.setTotalCount(4L);
        node1.add(node2);
        node1.add(node3);
        node3.add(node4);
        RpcAlarm node5 = new RpcAlarm();
        node5.setTotalCount(5L);
        RpcAlarm node6 = new RpcAlarm();
        node6.setTotalCount(6L);
        RpcAlarm node7 = new RpcAlarm();
        node7.setTotalCount(7L);
        RpcAlarm node8 = new RpcAlarm();
        node8.setTotalCount(8L);
        node5.add(node6);
        node5.add(node7);
        node7.add(node8);
        node8.add(node4);
        alarmMsgChain.add(node1);
        alarmMsgChain.add(node5);
        return alarmMsgChain;
    }
}

