/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.model.alarm;

import com.alibaba.fastjson.annotation.JSONField;
import com.yy.aomi.analysis.common.constant.AlarmLevel;
import com.yy.aomi.analysis.common.model.alarm.ErrorDetail;
import com.yy.aomi.analysis.common.model.alarm.UriInvokeInfo;
import com.yy.aomi.analysis.common.model.analysis.MonitorAppInfo;
import com.yy.aomi.common.model.proto.ModelContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;

public class AlarmMsg {
    protected int level = AlarmLevel.ERROR;
    protected String treeId;
    protected String modelId;
    protected int modelType;
    protected int errorType;
    protected String className;
    protected long totalCount;
    protected long errorCount;
    protected long beginTime;
    protected long reportTime;
    protected List<UriInvokeInfo> uriList = new ArrayList<UriInvokeInfo>();
    public List<AlarmMsg> children = new ArrayList<AlarmMsg>();
    protected boolean isMerge;
    protected ModelContext context;
    protected ErrorDetail detail;
    @JSONField(serialize=false)
    protected MonitorAppInfo app;

    public AlarmMsg() {
        this.className = this.getClass().getName();
    }

    public void add(AlarmMsg alarm) {
        if (alarm != null) {
            this.children.add(alarm);
        }
    }

    public void addAll(List<AlarmMsg> alarms) {
        if (alarms != null) {
            this.children.addAll(alarms);
        }
    }

    public boolean isMerge() {
        return this.isMerge;
    }

    public void setIsMerge(boolean isMerge) {
        this.isMerge = isMerge;
    }

    public long getReportTime() {
        return this.reportTime;
    }

    public void setReportTime(long reportTime) {
        this.reportTime = reportTime;
    }

    public String getClassName() {
        return this.className;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public List<UriInvokeInfo> getUriList() {
        return this.uriList;
    }

    public void setUriList(List<UriInvokeInfo> uriList) {
        this.uriList = uriList;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public List<AlarmMsg> getChildren() {
        return this.children;
    }

    public MonitorAppInfo getApp() {
        return this.app;
    }

    public void setApp(MonitorAppInfo app) {
        this.app = app;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public void setErrorType(int errorType) {
        this.errorType = errorType;
    }

    public AlarmMsg newInstance() {
        AlarmMsg alarmMsg = null;
        try {
            alarmMsg = (AlarmMsg)BeanUtils.cloneBean((Object)this);
            ArrayList<UriInvokeInfo> newList = new ArrayList<UriInvokeInfo>();
            for (UriInvokeInfo uta : this.getUriList()) {
                UriInvokeInfo uriAlarmInfo = new UriInvokeInfo(uta.getUri(), uta.getCount(), uta.getErrorCount(), uta.getTotalTime(), uta.getThProcTl(), uta.getRpcHost());
                uriAlarmInfo.setThreadUseRate(uta.getThreadUseRate());
                newList.add(uriAlarmInfo);
            }
            alarmMsg.setUriList(newList);
        }
        catch (Exception e) {
            throw new RuntimeException("AlarmMsg cloneBean fail", e);
        }
        return alarmMsg;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public void setChildren(List<AlarmMsg> children) {
        this.children = children;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public boolean hasChildren() {
        return !CollectionUtils.isEmpty(this.children);
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public ModelContext getContext() {
        return this.context;
    }

    public void setContext(ModelContext context) {
        this.context = context;
    }

    public ErrorDetail getDetail() {
        return this.detail;
    }

    public void setDetail(ErrorDetail detail) {
        this.detail = detail;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String toString() {
        return "AlarmMsg{level=" + this.level + ", treeId='" + this.treeId + '\'' + ", modelId='" + this.modelId + '\'' + ", modelType=" + this.modelType + ", errorType=" + this.errorType + ", className='" + this.className + '\'' + ", totalCount=" + this.totalCount + ", errorCount=" + this.errorCount + ", beginTime=" + this.beginTime + ", reportTime=" + this.reportTime + ", uriList=" + this.uriList + ", children=" + this.children + ", isMerge=" + this.isMerge + ", context=" + this.context + ", detail=" + this.detail + ", app=" + (Object)((Object)this.app) + '}';
    }
}

