/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.dao.redis;

import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.JedisPoolConfig;

public class RedisConfiguration {
    public static StringRedisTemplate createStringRedisTemplate(String hostName, int port, int maxIdle, int maxTotal, int index, long maxWaitMillis) {
        StringRedisTemplate temple = new StringRedisTemplate();
        temple.setConnectionFactory(RedisConfiguration.connectionFactory(hostName, port, maxIdle, maxTotal, index, maxWaitMillis, false));
        return temple;
    }

    public static RedisConnectionFactory connectionFactory(String hostName, int port, int maxIdle, int maxTotal, int index, long maxWaitMillis, boolean testOnBorrow) {
        JedisConnectionFactory jedis = new JedisConnectionFactory();
        jedis.setHostName(hostName);
        jedis.setPort(port);
        if (index != 0) {
            jedis.setDatabase(index);
        }
        jedis.setPoolConfig(RedisConfiguration.poolCofig(maxIdle, maxTotal, maxWaitMillis, testOnBorrow));
        jedis.afterPropertiesSet();
        JedisConnectionFactory factory = jedis;
        return factory;
    }

    public static JedisPoolConfig poolCofig(int maxIdle, int maxTotal, long maxWaitMillis, boolean testOnBorrow) {
        JedisPoolConfig poolCofig = new JedisPoolConfig();
        poolCofig.setMaxIdle(maxIdle);
        poolCofig.setMaxTotal(maxTotal);
        poolCofig.setMaxWaitMillis(maxWaitMillis);
        poolCofig.setTestOnBorrow(testOnBorrow);
        return poolCofig;
    }
}

