/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.dao.mysql.impl;

import com.yy.aomi.analysis.common.dao.mysql.IUniqueIdDao;
import com.yy.aomi.analysis.common.dao.mysql.jpa.UniqueIdRepository;
import com.yy.aomi.analysis.common.model.entity.mysql.UniqueId;
import com.yy.aomi.common.util.JavaDeflate;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class UniqueIdDaoImpl
implements IUniqueIdDao {
    private static Logger logger = LoggerFactory.getLogger(UniqueIdDaoImpl.class);
    @Autowired
    UniqueIdRepository repository;
    private AtomicLong order = new AtomicLong(0L);
    private Long baseId;
    private long batchSize = 1000L;

    @Override
    @Transactional
    public long getUniqueId() throws Exception {
        UniqueId uniqueId = this.repository.findBySrvName("aomi");
        long value = uniqueId.getValue();
        logger.info(Thread.currentThread().getName() + " value=" + value);
        uniqueId.setValue(value + this.batchSize);
        this.repository.save(uniqueId);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUniqueId2Base64() throws Exception {
        if (this.baseId == null || this.order.get() >= this.batchSize) {
            UniqueIdDaoImpl uniqueIdDaoImpl = this;
            synchronized (uniqueIdDaoImpl) {
                if (this.baseId == null || this.order.get() >= this.batchSize) {
                    this.baseId = this.getUniqueId();
                    this.order.set(0L);
                }
            }
        }
        long result = this.baseId + this.order.getAndAdd(1L);
        return JavaDeflate.encodeBase64((long)result);
    }
}

