/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.constant;

import java.util.HashMap;
import java.util.Map;

public class ErrorDefinition {
    private static Map<Integer, String> errorMsgMap = new HashMap<Integer, String>();
    public static final int UN_ERROR = 0;
    public static final int QUEUE_ERROR = 1;
    public static final int RPC_ERROR = 2;
    public static final int THREAD_HANDLE_ERROR = 3;
    public static final int DATABASE_ERROR = 4;
    public static final int MACHINE_ERROR = 5;

    public static String getErrorName(Integer errorCode) {
        String result = errorMsgMap.get(errorCode);
        if (result == null) {
            result = "\u672a\u77e5\u9519\u8bef";
        }
        return result;
    }

    public static boolean isError(int errorType) {
        return errorType != 0;
    }

    static {
        errorMsgMap.put(2, "\u961f\u5217\u5835");
        errorMsgMap.put(3, "\u7ebf\u7a0b\u5904\u7406\u8d85\u65f6");
        errorMsgMap.put(25, "RPC\u8d85\u65f6");
        errorMsgMap.put(27, "\u7f51\u7edc\u4e22\u5305");
        errorMsgMap.put(31, "\u7f51\u7edc\u4f20\u8f93\u6162");
        errorMsgMap.put(32, "\u5bf9\u7aef\u5904\u7406\u6162");
        errorMsgMap.put(33, "RPC\u8fde\u63a5\u5931\u8d25");
        errorMsgMap.put(34, "RPC\u5176\u5b83\u9519\u8bef");
        errorMsgMap.put(61, "\u7ebf\u7a0b\u5904\u7406\u8d85\u65f6");
        errorMsgMap.put(62, "\u7ebf\u7a0b\u963b\u585e\u7387\u9ad8");
    }

    public static class Machine {
        public static final int DISK_SPACE_USE_RATE = 151;
        public static final int DISK_IO_USE_RATE = 152;
        public static final int DISK_READ_ONLY = 153;
        public static final int DISK_SPACE_FULL = 162;
        public static final int ETH_IN = 154;
        public static final int ETH_OUT = 155;
        public static final int ETH_RATE = 156;
        public static final int ETH_BONDING = 157;
        public static final int ETH_CON_SPEED = 158;
        public static final int IP_PING = 159;
        public static final int SYS_MEMORY_FREE = 160;
        public static final int CPU_TOTAL_USE_RATE = 161;
        public static final int PROC_MEMORY_USE = 163;
        public static final int PROC_CPU_USE = 164;
        public static final int PROC_EXCEPTION = 165;
        public static final int LOAD_AVERAGE_5_MIN = 169;
        public static final int CRONTAB_HEARTBEAT = 167;
        public static final int CRONTAB_STOP = 168;
    }

    public static class DataBase {
        public static final int MYSQL_MUT_LOCK = 101;
        public static final int MYSQL_SLAVE = 102;
        public static final int MYSQL_MUT_ALIVE = 103;
        public static final int MYSQL_MUT_SLAVE = 104;
        public static final int MYSHARD_SYNC_D_ALIVE = 105;
        public static final int REDIS_ERROR = 131;
        public static final int MONGO_CONNECTIONS_CURRENT = 141;
    }

    public static class ThreadHandle {
        public static final int CALL_TIMEOUT = 61;
        public static final int BLOCKING_RATE_HIGH = 62;
    }

    public static class RPC {
        public static final int AVG_TIMEOUT = 21;
        public static final int ERROR_RATE_OVERFLOW = 22;
        public static final int ERROR_ADD_RATE_OVERFLOW = 23;
        public static final int CONNECT_TIMEOUT = 24;
        public static final int READ_TIMEOUT = 25;
        public static final int CONNECT_BROKEN = 26;
        public static final int LOSS_PACKETS = 27;
        public static final int INTERRUPT = 28;
        public static final int SINGLE_FAULT = 29;
        public static final int SINGLE_BLOCKED = 30;
        public static final int TRANS_SLOW = 31;
        public static final int HANDLE_SLOW = 32;
        public static final int CONNECT_FAIL = 33;
        public static final int OTHER_ERROR = 34;
    }

    public static class Queue {
        public static final int OVERFLOW = 1;
        public static final int BLOCK = 2;
        public static final int HANDLE_TIMEOUT = 3;

        public static boolean isBlock(int error) {
            return error == 2;
        }
    }
}

