package com.yy.aomi.analysis.common.util;

import com.yy.aomi.common.model.proto.ModelStatInfo;
import com.yy.aomi.analysis.common.model.alarm.UriInvokeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * Created by chengaochang on 2017/8/14.
 */
public class UriSortUtil {
    private static final Logger logger = LoggerFactory.getLogger(UriSortUtil.class);

    public static void sortUriAlarmByThreadUseRate(List<UriInvokeInfo> uriInvokeInfoList) {
        if (!CollectionUtils.isEmpty(uriInvokeInfoList)) {
            Collections.sort(uriInvokeInfoList, (o1, o2) -> {
                if (o1.getThreadUseRate() > o2.getThreadUseRate()) {
                    return -1;
                } else if (o1.getThreadUseRate() < o2.getThreadUseRate()) {
                    return 1;
                } else {
                    return 0;
                }
            });
        }
    }

    public static void sortUriAlarmByPercent(List<UriInvokeInfo> uriInvokeInfoList) {
        if (!CollectionUtils.isEmpty(uriInvokeInfoList)) {
            Collections.sort(uriInvokeInfoList, (o1, o2) -> {
                if (o1.getPercent() > o2.getPercent()) {
                    return -1;
                } else if (o1.getPercent() < o2.getPercent()) {
                    return 1;
                } else {
                    return 0;
                }
            });
        }
    }

    public static void sortUriAlarmByAvgTime(List<UriInvokeInfo> uriInvokeInfoList) {
        if (!CollectionUtils.isEmpty(uriInvokeInfoList)) {
            Collections.sort(uriInvokeInfoList, (o1, o2) -> {
                if (o1.getAvgTime() > o2.getAvgTime()) {
                    return -1;
                } else if (o1.getAvgTime() < o2.getAvgTime()) {
                    return 1;
                } else {
                    return 0;
                }
            });
        }
    }


    public static void sortUriStatByThreadUseRate(List<ModelStatInfo> statInfoList) {
        if (!CollectionUtils.isEmpty(statInfoList)) {
            Collections.sort(statInfoList, (o1, o2) -> {
                if (o1.getThreadUseRate() > o2.getThreadUseRate()) {
                    return -1;
                } else if (o1.getThreadUseRate() < o2.getThreadUseRate()) {
                    return 1;
                } else {
                    return 0;
                }
            });
        }
    }

    public static List<UriInvokeInfo> getSortUriAlarmByUri(List<UriInvokeInfo> uriInvokeInfoList) {

        if (CollectionUtils.isEmpty(uriInvokeInfoList)) {
            return uriInvokeInfoList;
        }

        List<UriInvokeInfo> newList = new LinkedList<>();
        for (int i = 0; i < uriInvokeInfoList.size(); i++) {

            UriInvokeInfo vo1 = uriInvokeInfoList.get(i);
            int splitIndex = vo1.getUri().indexOf("+");
            String vo1UriCompareStr = vo1.getUri() + "+";
            boolean isFound = false;

            if (splitIndex < 0) {
                for (int j = 0; j < newList.size(); j++) {
                    UriInvokeInfo vo2 = newList.get(j);
                    if (vo2.getUri().startsWith(vo1UriCompareStr)) {
                        newList.add(j, vo1);
                        isFound = true;
                        break;
                    }
                }
                if (!isFound) {
                    newList.add(vo1);
                }
            } else {

                String[] uris = null;
                for (int j = newList.size() - 1; j >= 0; j--) {
                    UriInvokeInfo vo2 = newList.get(j);
                    String vo2UriCompareStr = vo2.getUri() + "+";
                    //向上查找当前uri是list uri的下级的数据
                    if (vo1.getUri().startsWith(vo2UriCompareStr)) {

                        if (uris == null) {
                            uris = vo1.getUri().split("\\+");
                        }

                        int lastChildOfVo2 = -1;

                        for (int h = newList.size() - 1; h > j; h--) {
                            UriInvokeInfo vo3 = newList.get(h);
                            String[] otherUris = vo3.getUri().split("\\+");

                            if (lastChildOfVo2 == -1) {
                                if (vo3.getUri().startsWith(vo2UriCompareStr)) {
                                    lastChildOfVo2 = h;
                                }
                            }
                            if (uris.length > otherUris.length) {
                                continue;
                            }

                            int end = uris.length - 1;
                            boolean isOnlyLastNotEq = true;
                            for (int l = 0; l < end; l++) {
                                if (!otherUris[l].equals(uris[l])) {
                                    isOnlyLastNotEq = false;
                                    break;
                                }
                            }
                            if (isOnlyLastNotEq) {
                                isOnlyLastNotEq = !otherUris[end].equals(uris[end]);
                            }

                            if (isOnlyLastNotEq) {
                                isFound = true;
                                newList.add(h + 1, vo1);
                                break;
                            }
                        }

                        if (!isFound) {
                            if (lastChildOfVo2 > -1) {
                                newList.add(lastChildOfVo2 + 1, vo1);
                            } else {
                                newList.add(j + 1, vo1);
                            }
                            isFound = true;
                        }
                        break;

                    } else if (vo2.getUri().startsWith(vo1UriCompareStr)) {
                        //查找列表Uri为当前uri的上一级数据
                        for (int h = 0; h < j; h++) {
                            UriInvokeInfo vo3 = newList.get(h);
                            if (vo3.getUri().startsWith(vo1UriCompareStr)) {
                                isFound = true;
                                newList.add(h, vo1);
                                break;
                            }
                        }

                        if (!isFound) {
                            isFound = true;
                            newList.add(j, vo1);
                        }
                        break;
                    }
                }

                if (!isFound) {
                    newList.add(vo1);
                }

            }
        }

        return newList;
    }


    public static void main(String[] args) {
        List<UriInvokeInfo> uriInvokeInfoList = new ArrayList<>();
        UriInvokeInfo alarm = new UriInvokeInfo("a", 4, 1, 0, 0,"");
        alarm.setThreadUseRate(100);
        UriInvokeInfo alarm1 = new UriInvokeInfo("a+b", 5, 2, 0,0, "");
        alarm1.setThreadUseRate(40);

        UriInvokeInfo alarm4 = new UriInvokeInfo("a+b+c", 6, 3, 0,0, "");
        alarm4.setThreadUseRate(40);

        UriInvokeInfo alarm2 = new UriInvokeInfo("a+c", 7, 4, 0, 0,"");
        alarm2.setThreadUseRate(30);
        UriInvokeInfo alarm3 = new UriInvokeInfo("a+d", 8, 5, 0, 0,"");
        alarm3.setThreadUseRate(30);

        UriInvokeInfo alarm5 = new UriInvokeInfo("a+d+e", 9, 6, 0, 0,"");
        alarm5.setThreadUseRate(30);

        UriInvokeInfo alarm6 = new UriInvokeInfo("a+c+d", 0, 0, 0, 0,"");
        alarm6.setThreadUseRate(30);
        UriInvokeInfo alarm7 = new UriInvokeInfo("a+d+e+f", 0, 0, 0, 0,"");
        alarm7.setThreadUseRate(30);

        UriInvokeInfo alarm8 = new UriInvokeInfo("b+c+e", 0, 0, 0, 0,"");
        alarm8.setThreadUseRate(20);
        UriInvokeInfo alarm9 = new UriInvokeInfo("b", 0, 0, 0, 0,"");
        alarm9.setThreadUseRate(20);

        UriInvokeInfo alarm10 = new UriInvokeInfo("b+c+e+f+g", 0, 0, 0, 0,"");
        alarm10.setThreadUseRate(10);

        UriInvokeInfo alarm16 = new UriInvokeInfo("b+c+e+f", 0, 0, 0, 0,"");
        alarm10.setThreadUseRate(10);

        UriInvokeInfo alarm11 = new UriInvokeInfo("b+c+f", 0, 0, 0, 0,"");
        alarm11.setThreadUseRate(1);

        UriInvokeInfo alarm12 = new UriInvokeInfo("b+c", 0, 0, 0, 0,"");
        alarm12.setThreadUseRate(20);

        UriInvokeInfo alarm13 = new UriInvokeInfo("c", 0, 0, 0, 0,"");
        alarm13.setThreadUseRate(20);


        UriInvokeInfo alarm15 = new UriInvokeInfo("c+m+x", 0, 0, 0, 0,"");
        alarm15.setThreadUseRate(20);

        UriInvokeInfo alarm14 = new UriInvokeInfo("c+m", 0, 0, 0, 0,"");
        alarm14.setThreadUseRate(20);


        uriInvokeInfoList.add(alarm15);
        uriInvokeInfoList.add(alarm7);
        uriInvokeInfoList.add(alarm12);
        uriInvokeInfoList.add(alarm);
        uriInvokeInfoList.add(alarm3);
        uriInvokeInfoList.add(alarm9);
        uriInvokeInfoList.add(alarm2);
        uriInvokeInfoList.add(alarm6);
        uriInvokeInfoList.add(alarm5);
        uriInvokeInfoList.add(alarm8);
        uriInvokeInfoList.add(alarm10);
        uriInvokeInfoList.add(alarm11);
        uriInvokeInfoList.add(alarm4);
        uriInvokeInfoList.add(alarm1);
        uriInvokeInfoList.add(alarm14);
        uriInvokeInfoList.add(alarm13);
        uriInvokeInfoList.add(alarm16);

        logger.info("sort before list:");
//        for (UriInvokeInfo alarmx : uriInvokeInfoList) {
//            logger.info(alarmx.getUri() + ":" + alarmx.threadUseRate());
//        }
        sortUriAlarmByPercent(uriInvokeInfoList);
        logger.info("sort finish list:{}",uriInvokeInfoList);
//        for (UriInvokeInfo alarmxx : newList) {
//            logger.info(alarmxx.getUri() + ":" + alarmxx.getThreadUseRate());
//        }

    }
}
