package com.yy.aomi.analysis.common.util;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.Map;

/**
 * Created by chengaochang on 2017/4/13.
 */
public class TimeStatScalesUtil {

    /**计算各区间成功率
     * @param scales
     * @return
     */
    public static int getLessThanTimeScaleCount(Map<String, Integer> scales,int maxScaleTime){
        int count = 0;
        if(MapUtils.isEmpty(scales)){
            return count;
        }
        for(String oneScale:scales.keySet()){
            int maxValue = parseMaxValue(oneScale);
            if(maxScaleTime > maxValue){
                count += scales.get(oneScale);
            }
        }
        return count;
    }

    /**计算各区间成功率
     * @param scales
     * @return
     */
    public static int getLargeThanTimeScaleCount(Map<String, Integer> scales,long maxScaleTime){
        int count = 0;
        if(MapUtils.isEmpty(scales)){
            return count;
        }
        for(String oneScale:scales.keySet()){
            int maxValue = parseMaxValue(oneScale);
            if(maxScaleTime <= maxValue){
                count += scales.get(oneScale);
            }
        }
        return count;
    }

    public static int parseMaxValue(String oneScale){
        String maxNumStr = oneScale.substring(oneScale.indexOf(',') + 1, oneScale.indexOf(')'));
        int maxValue = 0;
        if(NumberUtils.isDigits(maxNumStr)){
            maxValue = Integer.parseInt(maxNumStr);
        }else{
            maxValue = Integer.MAX_VALUE;
        }
        return maxValue;
    }
}
