package com.yy.aomi.analysis.common.util;

import java.math.BigDecimal;

/**
 * Created by chengaochang on 2017/6/15.
 */
public class ThreadAnalysisUtil {

    /**
     * 线程使用率
     *
     * @param useTime
     * @param totalTime
     * @return
     */
    public static double getThreadUseRate(long useTime, long totalTime) {
        if (totalTime == 0) {
            return 0d;
        }
        double threadUseRate = useTime / (totalTime * 1.0);
        if (threadUseRate < 1) {
            BigDecimal rateBig = new BigDecimal(threadUseRate);
            threadUseRate = rateBig.setScale(4, BigDecimal.ROUND_HALF_DOWN).doubleValue();
        } else {
            threadUseRate = 1;
        }
        return threadUseRate;
    }

}
