package com.yy.aomi.analysis.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.analysis.common.model.analysis.MonitorAppInfo;
import com.yy.aomi.common.model.proto.Body;
import com.yy.aomi.common.model.proto.Header;
import com.yy.aomi.common.model.proto.Root;
import com.yy.aomi.common.util.JavaDeflate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import java.util.List;

/**
 * create by zhangzhibin(909074682)
 * 2018/10/10
 */
public class SdkDataParserUtil {
    static final Logger logger = LoggerFactory.getLogger(SdkDataParserUtil.class);

    public static Root parse(String data) throws Exception{
        JSONObject jsonValue = JSONObject.parseObject(data);
        String data_compress = jsonValue.getString("data");
        // 解压data属性
        String data_uncompress = JavaDeflate.uncompress(data_compress);
        Root root = JSON.parseObject(data_uncompress, Root.class);
        return root;
    }

    public  static MonitorAppInfo transToAppInfo(Root root){
        Header header = root.getHeader();
        Body body = root.getBody();
        MonitorAppInfo appInfo = new MonitorAppInfo();
        BeanUtils.copyProperties(header,appInfo);
        List<Integer> portsList = JSON.parseArray(header.getPorts(),Integer.class);
        List<String> ipList = JSON.parseArray(header.getIps(),String.class);
        appInfo.setPortList(portsList);
        appInfo.setIpList(ipList);
        appInfo.setProcInfo(body.getProcInfo());
        return appInfo;
    }
}
