package com.yy.aomi.analysis.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;

/**
 * Created by chengaochang on 2017/8/15.
 */
public class MD5Encoder {

    private static final Logger logger = LoggerFactory.getLogger(MD5Encoder.class);

    private static final char hexDigits[] = {
            '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
            'a', 'b', 'c', 'd', 'e', 'f'
    };

    public static String encrypt32(String source)
    {
        return encrypt32(source.getBytes());
    }

    public static String encrypt32(byte source[])
    {
        String s = null;
        try
        {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source);
            byte tmp[] = md.digest();
            char str[] = new char[32];
            int k = 0;
            for(int i = 0; i < 16; i++)
            {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 15];
                str[k++] = hexDigits[byte0 & 15];
            }

            s = new String(str);
        }
        catch(Exception e)
        {
            logger.error("",e);
        }
        return s;
    }

    public static String encrypt16(byte source[]) {
        return encrypt32(source).substring(8, 24);
    }

   /**
     * @Description:加密-16位小写
     * @author:chengoachang
     */
    public static String encrypt16(String encryptStr) {
        return encrypt16(encryptStr.getBytes());
    }

    public static void main(String[] args) {
        System.out.println(encrypt32("abc"));
        System.out.println(encrypt32("abcd"));
        System.out.println(encrypt32("abcde"));
    }

}
