package com.yy.aomi.analysis.common.util;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

/**进制转换
 * create by zhangzhibin(909074682)
 * 2017/7/31
 */
public class EncoderUtil {
    private static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static void main(String[] args){
//        long num = 1646561L;
//        String encode = encodeBase64(System.currentTimeMillis());
//        System.out.println(encode);
//        System.out.println(encode.length());
//        System.out.println(decodeBase64(encode));
        String result = sha256("jfijewfoijfoijfwjfjofjwjfoiwjfoijewfoijeojofjwjfoiwjfoijewfoijeofijwoifjoiwfjoieitueijgjfjefoijewfoijjfjofjwjfoiwjfoijewfoijeofijwoifjoiwfjoieitueijgjfjefoijewfoijjfjofjwjfoiwjfoijewfoijeofijwoifjoiwfjoieitueijgjfjefoijewfoijjfjofjwjfoiwjfoijewfoijeofijwoifjoiwfjoieitueijgjfjefoijewfoijjfjofjwjfoiwjfoijewfoijeofijwoifjoiwfjoieitueijgjfjefoijewfoijjffijwoifjoiwfjoieitueijgjfjefoijewfoijjfoiwjfoijewofijwfwoij");
        System.out.println(result.length());
        System.out.println(result);
    }

    /**sha256算法hash字符串，并转成64位编码
     * @param s
     * @return
     */
    public static String sha256(String s){
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putString(s, Charset.forName("iso8859-1"));
        String after = BaseEncoding.base64().encode(hasher.hash().asBytes());
        return after;
    }

    /**10进制转64进制，不支持负数
     * @param v
     * @return
     */
    public static String encodeBase64(long v) {
        char[] a = alphabet.toCharArray();
        v = Math.abs(v);
        String s = "";
        for (int i = 0; i < 11; i++) {
            long val = v & 63;
            s = a[(int) val] + s;
            v >>= 6;
        }
        while (s.startsWith("A") && s.length() > 1)
            s = s.substring(1, s.length());
        return s;
    }

    /**64进制转10进制，不支持负数，必须是用本类的encodeBase64方法编码才能解码
     * @param s
     * @return
     */
    public static long decodeBase64(String s) {
        char[] a = alphabet.toCharArray();
        Map<Character, Integer> map = new HashMap<>();
        for (int i = 0; i < a.length; i++)
            map.put(a[i], i);
        char[] chars = s.toCharArray();
        long v = 0;
        for (char c : chars) {
            v <<= 6;
            v = v | map.get(c);
        }
        return v;
    }
}
