/**
 * Copyright (C), 2018-2018, XXX有限公司
 * FileName: AlarmTreeNodeBuilder
 * Author:   chengaochang
 * Date:     18/10/18 下午12:09
 * Description: AlarmTreeNodeBuilder
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yy.aomi.analysis.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.analysis.common.model.alarm.*;
import com.yy.aomi.analysis.common.util.tree.TreeNode;
import com.yy.aomi.common.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * 〈一句话功能简述〉<br> 
 * 〈AlarmTreeNodeBuilder〉
 *
 * @author cgc
 * @create 18/10/18
 * @since 1.0.0
 */
public class AlarmTreeNodeBuilder {

    static Logger logger = LoggerFactory.getLogger(AlarmTreeNodeBuilder.class);

    public static AlarmMsgNodeTree buildTreeNodeByAlarm(AlarmMsg orgAlarmMsg) {
        try {
            AlarmMsg alarmMsg = orgAlarmMsg.newInstance();
            AlarmMsgChain<AlarmMsg> msgChain = new AlarmMsgChain<>();
            msgChain.add(alarmMsg);
            AlarmMsgProcNode alarmMsgTreeNode = new AlarmMsgProcNode(msgChain);
            AlarmMsgNodeTree tree = new AlarmMsgNodeTree();
            tree.setRoot(alarmMsgTreeNode);
            return tree;
        } catch (Exception e) {
            logger.error("", e);
        }
        return null;
    }


    /**
     * 由catcher服务统一保存错误链信息
     *
     * @param tree
     */
    public static TreeNode<ErrorChainNode> buildErrorChainTreeNode(AlarmMsgNodeTree tree) {
        int errorProcCount = tree.calErrorCount();
        int procCount = tree.calProcCount();
        if (procCount > 1) {
            tree.setAnalyseType(ErrorChainNode.ANALYSE_TYPE_CATCHER);
        } else {
            tree.setAnalyseType(ErrorChainNode.ANALYSE_TYPE_ANALYSE);
        }
        //创建新的树id
        String treeId = generateUniqueId();

        tree.setTreeId(treeId);

        TreeNode<ErrorChainNode> treeNode = new TreeNode<ErrorChainNode>() {};
        try {
            ErrorChainNode errorChainNode = buildErrorChainNodeList(tree.getRoot().getAlarmMsg(), tree.getAnalyseType());
            ErrorChainNode errorNode = errorChainNode;
            for (AlarmMsgNodeChain chain :tree.getChildren()){
                for(AlarmMsgProcNode node : chain){
                    for(AlarmMsg alarmMsg : node.getMsgChain()){
                        List<ErrorChainNode> chainNodeList = new ArrayList<>();
                        ErrorChainNode tmpErrorNode = buildErrorChainNodeList(alarmMsg,tree.getAnalyseType());
                        chainNodeList.add(tmpErrorNode);
                        errorNode.setChildren(chainNodeList);
                        errorNode = tmpErrorNode;
                    }
                }
            }
            errorChainNode.setProcCount(errorProcCount);
            treeNode.setTreeId(treeId);
            treeNode.setMsgNode(errorChainNode);
            errorChainNode.setTreeNode(treeNode);
        } catch (Exception e) {
            logger.error("", e);
        }
        tree.getRoot().getAlarmMsg().setTreeId(treeId);

        return treeNode;
    }


    /**
     *
     * @param alarmMsg
     * @param analyseType
     * @return
     * @throws Exception
     */
    private static ErrorChainNode buildErrorChainNodeList(AlarmMsg alarmMsg, int analyseType) throws Exception {

        ErrorChainNode errorChainNode = new ErrorChainNode();
        BeanUtils.copyProperties(alarmMsg,errorChainNode);

        errorChainNode.setMsgId(generateUniqueId());
        errorChainNode.setBeginTime(alarmMsg.getBeginTime());
        errorChainNode.setEndTime(alarmMsg.getReportTime());

        if (alarmMsg.getApp() != null) {
            errorChainNode.setAppName(alarmMsg.getApp().getClientname());
            errorChainNode.setPorts(String.valueOf(alarmMsg.getApp().defaultPort()));
            errorChainNode.setIps(alarmMsg.getApp().defaultIp());
            errorChainNode.setOrgIps(ProcessUtil.parseIps(alarmMsg.getApp().getIpList()));
            errorChainNode.setOrgPorts(ProcessUtil.parsePorts(alarmMsg.getApp().getPortList()));
            // 业务线id
            errorChainNode.setBusinessId(alarmMsg.getApp().getBusinessid());
        }

        if (alarmMsg.getContext() != null) {
            errorChainNode.setCtx((JSONObject) JSON.toJSON(alarmMsg.getContext()));
        }
        //设置结点的分析类型
        errorChainNode.setAnalyseType(analyseType);

        if (alarmMsg.hasChildren()) {
            List<ErrorChainNode> children = new ArrayList<>();
            for (AlarmMsg child : alarmMsg.getChildren()) {
                if (child.getApp() == null) {
                    child.setApp(alarmMsg.getApp());
                }
                ErrorChainNode childNode = buildErrorChainNodeList(child, analyseType);
                children.add(childNode);
            }
            errorChainNode.setChildren(children);
        }
        return errorChainNode;
    }

    public static String generateUniqueId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}