package com.yy.aomi.analysis.common.service;

import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.analysis.common.dao.mysql.IUniqueIdDao;
import com.yy.aomi.analysis.common.model.alarm.ErrorChainNode;
import com.yy.aomi.analysis.common.util.TinyUrlDataUtil;
import com.yy.aomi.analysis.common.util.tree.TreeNode;
import com.yy.aomi.common.autoconfigure.SystemConf;
import com.yy.aomi.elastic.DateUtils;
import com.yy.aomi.elastic.ESCondition;
import com.yy.aomi.elastic.ElasticSearchImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.text.MessageFormat;
import java.util.Date;


/**短链接生成及插入es
 * create by zhangzhibin(909074682)
 * 2017/7/31
 */
@Service
public class TinyUrlService {

    protected static Logger logger = LoggerFactory.getLogger(TinyUrlService.class);
    @Autowired
    private ElasticSearchImpl elkSearchImpl;

    @Autowired
    private IUniqueIdDao uniqueIdDao;

    @Autowired
    private SystemConf systemConf;


    /**生成短链接，并把短链接和长链接的关系保存到elasticsearch
     * @param url
     * @return
     * @throws Exception
     */
    public String getTinyUrlByParams(String url) throws  Exception{
        String aomiJumpDemo = systemConf.getConf("aomi.jump");
        String tinyId = uniqueIdDao.getUniqueId2Base64();
        JSONObject tinyUrlModel = new JSONObject();
        tinyUrlModel.put(TinyUrlDataUtil.tinyId,tinyId);
        tinyUrlModel.put(TinyUrlDataUtil.uri,url);
        tinyUrlModel.put(TinyUrlDataUtil.timestamp, DateUtils.formatUTCByUTCPattern(new Date()));
        ESCondition condition = new ESCondition(TinyUrlDataUtil.type,TinyUrlDataUtil.index);
        condition.setInsertRecords(new String[]{tinyUrlModel.toJSONString()});
        elkSearchImpl.insert(condition);

        String aomiJumpUrl = MessageFormat.format(aomiJumpDemo,tinyId);
        return aomiJumpUrl;
    }

    /**通过错误告警的信息，生成短链接
     * @param businessId
     * @param treeId
     * @param begingTime
     * @return
     */
    public String getErrorChainTinyUrl(String businessId,String treeId,long begingTime){
        //生成url

        String result = null;
        if(businessId == null){
            businessId ="0";
        }

        String errorChainUrlDemo = systemConf.getConf("aomi.errorchain.url");
        String url =  formatString(errorChainUrlDemo,businessId,treeId,begingTime);
        try {
            result = getTinyUrlByParams(url);
        }catch (Exception ex){
            //logger.warn("",ex);
        }
        logger.info("getTinyUrlByParams url={},shortUrl={}",url,result);

        return result;
    }

    private String formatString(String demo,Object... params){
        int len = params.length;
        for(int i=0;i<len;i++){
            demo = demo.replace("{"+i+"}",params[i].toString());
        }
        return demo;
    }


}
