package com.yy.aomi.analysis.common.service;

import com.yy.aomi.analysis.common.dao.http.URI;
import com.yy.aomi.analysis.common.dao.http.MachineClient;
import com.yy.aomi.analysis.common.model.ops.MachineQueryModel;
import com.yy.aomi.analysis.common.model.ops.MachineServerInfo;
import com.yy.aomi.common.autoconfigure.SystemConf;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by chengaochang on 2017/8/3.
 */
@Service
public class MachineMgrService {
    private static final Logger logger = LoggerFactory.getLogger(MachineMgrService.class);

    @Autowired
    private SystemConf systemConf;

    @Autowired
    private MachineClient machineInfo;

    private static final String MACHINE_ROOM_QUERY_URL_KEY = "machine.room.url";
    private static final String DEFAULT_MACHINE_ROOM_QUERY_URL = "http://cmdb.sysop.duowan.com:8088/webservice/server/getServerInfos.do";
    private static final Map<String, MachineServerInfo> machineRoomInfoMap = new ConcurrentHashMap<>();


    public List<MachineServerInfo> getServerInfos(List<String> queryIpList) {
        List<MachineServerInfo> machineServerInfoList = new ArrayList<>();
        if (CollectionUtils.isEmpty(queryIpList)) {
            return machineServerInfoList;
        }
        for (Iterator<String> ipIt = queryIpList.iterator(); ipIt.hasNext(); ) {
            String ip = ipIt.next();
            MachineServerInfo roomInfo = machineRoomInfoMap.get(ip);
            if (roomInfo != null) {
                ipIt.remove();
            }
        }

        if (queryIpList.isEmpty()) {
            return machineServerInfoList;
        }

        List<MachineServerInfo> cmdbMachineServerInfoList = getServerInfosFromCmdb(queryIpList);
        for(MachineServerInfo serverInfo:cmdbMachineServerInfoList){
            machineRoomInfoMap.put(serverInfo.getIp(), serverInfo);
        }
        machineServerInfoList.addAll(cmdbMachineServerInfoList);
        return machineServerInfoList;

    }

    public MachineServerInfo getServerInfo(String ip) {
        List<MachineServerInfo> machineServerInfos = getServerInfos(ip);
        if(!machineServerInfos.isEmpty()){
            return machineServerInfos.get(0);
        }
        return null;
    }

    public List<MachineServerInfo> getServerInfos(String ips) {
        List<MachineServerInfo> machineServerInfoList = new ArrayList<>();
        if (StringUtils.isEmpty(ips)) {
            return machineServerInfoList;
        }
        String[] ipArry = ips.split(",");
        List<String> queryIpList = new ArrayList<>();

        for (String ip : ipArry) {
            MachineServerInfo roomInfo = machineRoomInfoMap.get(ip);
            if (roomInfo != null) {
                machineServerInfoList.add(roomInfo);
            } else {
                queryIpList.add(ip);
            }
        }

        if (queryIpList.isEmpty()) {
            return machineServerInfoList;
        }

        List<MachineServerInfo> cmdbMachineServerInfoList = getServerInfosFromCmdb(queryIpList);
        for(MachineServerInfo serverInfo:cmdbMachineServerInfoList){
            machineRoomInfoMap.put(serverInfo.getIp(), serverInfo);
        }
        machineServerInfoList.addAll(cmdbMachineServerInfoList);
        return machineServerInfoList;
    }


    public List<MachineServerInfo> getServerInfosFromCmdb(List<String> queryIpList) {

//        List<MachineServerInfo> ipList = new ArrayList<>();
//
//        String url = conf.getConf(MACHINE_ROOM_QUERY_URL_KEY);
//        if (url == null) {
//            url = DEFAULT_MACHINE_ROOM_QUERY_URL;
//        }

        String queryIps = StringUtils.join(queryIpList, ",");
        Map<String, String> params = new HashMap<>();
        params.put("ip", queryIps);

        String content = null;
        int tryTime = 3;

        MachineQueryModel queryModel = null;
        while ((tryTime--) >= 0) {
            try {
//                URLMethodRet ret = URLMethod.doMethod(url, params, URLMethod.MethodType.URL_GET);
//                content = ret.getUTFString();
                queryModel = machineInfo.getServerInfos(queryIps);
                break;
            } catch (Exception e) {
                if (tryTime == 0) {
                    logger.info("get " + URI.CMDB_GET_SERVERINFOS + "  error,ip={}", queryIps);
                    break;
                }
                else {
                    logger.info("get " + URI.CMDB_GET_SERVERINFOS + "  error,ip={} ,try 3 times tryTime={}", queryIps, tryTime);
                }
            }
        }

//        JSONObject result = JSON.parseObject(content, JSONObject.class);
//
//        if (result.getBoolean("success") == false) {
//            return ipList;
//        }

//        JSONArray datas = result.getJSONArray("object");
//        if (!CollectionUtils.isEmpty(datas)) {
//            for (int i = 0; i < datas.size(); i++) {
//                MachineServerInfo serverInfo = datas.getObject(i, MachineServerInfo.class);
//                ipList.add(serverInfo);
//            }
//        }

        if(queryModel!=null && queryModel.isSuccess() && queryModel.getObject()!=null){
            return queryModel.getObject();
        }

        return Collections.emptyList();
    }

}
