package com.yy.aomi.analysis.common.service;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

/**
 * Created by linhui on 2018/07/10.
 */
public class ChannelService {

    private static final Logger logger = LoggerFactory.getLogger(ChannelService.class);

    private Properties properties;

    private String ip;
    private String port;

    public void init(String configFilePath){
        try(InputStream in = new FileInputStream(configFilePath)){
            properties = new Properties();
            properties.load(in);

            if(StringUtils.isNotEmpty(properties.getProperty("ip"))){
                ip = properties.getProperty("ip");
            }

            if(StringUtils.isNotEmpty(properties.getProperty("port"))){
                port = properties.getProperty("port");
            }
        }catch (Exception e){
            logger.error(e.getMessage(), e);
        }
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}
