package com.yy.aomi.analysis.common.service;

import com.yy.aomi.analysis.common.model.alarm.AlarmMsg;
import com.yy.aomi.analysis.common.model.alarm.QueueBlockAlarm;
import com.yy.aomi.analysis.common.util.UriSortUtil;
import com.yy.aomi.analysis.common.model.alarm.UriInvokeInfo;
import com.yy.aomi.analysis.common.util.ThreadAnalysisUtil;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by chengaochang on 2017/6/14.
 */
@Service
public class AlarmMsgMergeService {

    /**
     * 同级别进程节点错误两两对比合并
     *
     * @param alarmMsg
     * @param nextAlarmMsg
     * @return
     * @throws Exception
     */
    public  List<AlarmMsg> mergeSameLevelErrorInfo(AlarmMsg alarmMsg, AlarmMsg nextAlarmMsg, int topCount) throws Exception {
        List<AlarmMsg> mergeAlarmMsgList = new ArrayList<AlarmMsg>();
        if (alarmMsg != null && nextAlarmMsg != null) {
            if (alarmMsg.getClass().equals(nextAlarmMsg.getClass())) {
                //一种错误类型要合并
                List<AlarmMsg> children = alarmMsg.getChildren();
                List<AlarmMsg> nextChildren = nextAlarmMsg.getChildren();

                boolean firstIsEmpty = CollectionUtils.isEmpty(children);
                boolean nexIsEmpty = CollectionUtils.isEmpty(nextChildren);

                AlarmMsg mergeAlarmMsg = nextAlarmMsg.newInstance();
                mergeAlarmMsg.setChildren(new ArrayList<>());
                if (!firstIsEmpty || !nexIsEmpty) {
                    int maxIndex = children.size() > nextChildren.size() ? children.size() : nextChildren.size();
                    for (int n = 0; n < maxIndex; n++) {
                        AlarmMsg child = null, nextChild = null;
                        if (n < children.size()) {
                            child = children.get(n);
                        }
                        if (n < nextChildren.size()) {
                            nextChild = nextChildren.get(n);
                        }
                        List<AlarmMsg> alarmMsgList = mergeSameLevelErrorInfo(child, nextChild, topCount);
                        mergeAlarmMsg.addAll(alarmMsgList);
                    }
                }

                //合并统计信息
                List<AlarmMsg> mergeList = new ArrayList<>();
                mergeList.add(alarmMsg);
                mergeList.add(nextAlarmMsg);

                if(alarmMsg.getBeginTime() < nextAlarmMsg.getBeginTime()){
                    mergeAlarmMsg.setBeginTime((alarmMsg.getBeginTime()));
                }

                if(alarmMsg.getReportTime() > nextAlarmMsg.getReportTime()){
                    mergeAlarmMsg.setReportTime(alarmMsg.getReportTime());
                }

                mergeSameErrorUriStatInfo(mergeAlarmMsg, mergeList, topCount);
                mergeAlarmMsg.setIsMerge(true);
                mergeAlarmMsgList.add(mergeAlarmMsg);
            } else {
                sortAlarmUriList(alarmMsg, alarmMsg.getUriList(), topCount);
                sortAlarmUriList(nextAlarmMsg, nextAlarmMsg.getUriList(), topCount);
                mergeAlarmMsgList.add(alarmMsg);
                mergeAlarmMsgList.add(nextAlarmMsg);
            }

            return mergeAlarmMsgList;
        } else if (alarmMsg != null) {
            sortAlarmUriList(alarmMsg, alarmMsg.getUriList(), topCount);
            mergeAlarmMsgList.add(alarmMsg);
        } else if (nextAlarmMsg != null) {
            sortAlarmUriList(nextAlarmMsg, nextAlarmMsg.getUriList(), topCount);
            mergeAlarmMsgList.add(nextAlarmMsg);
        }
        return mergeAlarmMsgList;
    }


    /**
     * 同级进程节点相同错误合并，并根据uri的平均时间及错误数倒序截取top10
     *
     * @param mergeAlarmMsg 最终合并的错误对象
     * @param alarmMsgList  子错误列表
     * @return
     * @throws Exception
     */
    public  AlarmMsg mergeSameErrorUriStatInfo(AlarmMsg mergeAlarmMsg, List<AlarmMsg> alarmMsgList, int topCount) throws Exception {
        //合并统计信息
        Map<String, UriInvokeInfo> uriTimeoutAlarmMap = new HashMap<>();
        for (AlarmMsg alarmMsg : alarmMsgList) {
            List<UriInvokeInfo> topUriStatList = alarmMsg.getUriList();
            for (UriInvokeInfo uta : topUriStatList) {
                UriInvokeInfo uriSta = uriTimeoutAlarmMap.get(uta.getUri());
                if (uriSta == null) {
                    uriSta = new UriInvokeInfo(uta.getUri(), uta.getCount(), uta.getErrorCount(), uta.getTotalTime(),uta.getThProcTl(),uta.getRpcHost());
                    uriTimeoutAlarmMap.put(uta.getUri(), uriSta);
                } else {
                    uriSta.setCount(uta.getCount() + uriSta.getCount());
                    uriSta.setErrorCount(uta.getErrorCount() + uriSta.getErrorCount());
                    uriSta.setTotalTime(uta.getTotalTime() + uriSta.getTotalTime());
                    if(uta.getCount()>0){
                        uriSta.setAvgTime(uta.getTotalTime() / uta.getCount());
                    }
                    uriSta.setThProcTl(uta.getThProcTl() + uriSta.getThProcTl());
                }
            }
        }
        List<UriInvokeInfo> uriInvokeInfoList = new ArrayList<UriInvokeInfo>();
        for (UriInvokeInfo uriAlarm : uriTimeoutAlarmMap.values()) {
            uriInvokeInfoList.add(uriAlarm);
        }

        if (mergeAlarmMsg instanceof QueueBlockAlarm) {
            //线程使用率汇总
            QueueBlockAlarm queueBlockAlarm = (QueueBlockAlarm) mergeAlarmMsg;
            long threadUseTotalTime = queueBlockAlarm.queue().getThreadTotalTime();
            for (UriInvokeInfo uriAlarm : uriInvokeInfoList) {
                uriAlarm.setThreadUseRate(ThreadAnalysisUtil.getThreadUseRate(uriAlarm.getThProcTl(), threadUseTotalTime));
            }
        }

        sortAlarmUriList(mergeAlarmMsg, uriInvokeInfoList, topCount);

        long totalCount = 0, totalErrorCount = 0;
        for (UriInvokeInfo uriInvokeInfo : uriInvokeInfoList) {
            totalCount += uriInvokeInfo.getCount();
            totalErrorCount += uriInvokeInfo.getErrorCount();
        }
        mergeAlarmMsg.setErrorCount(totalErrorCount);
        mergeAlarmMsg.setTotalCount(totalCount);
        return mergeAlarmMsg;
    }

    public  void sortAlarmUriList(AlarmMsg mergeAlarmMsg, List<UriInvokeInfo> uriInvokeInfoList, int topCount) {
        if (uriInvokeInfoList.size() > 1) {
            if (mergeAlarmMsg instanceof QueueBlockAlarm) {

                UriSortUtil.sortUriAlarmByThreadUseRate(uriInvokeInfoList);

            } else {
                UriSortUtil.sortUriAlarmByAvgTime(uriInvokeInfoList);
            }

            if (uriInvokeInfoList.size() < topCount) {
                topCount = uriInvokeInfoList.size();
            }
            List<UriInvokeInfo> subList = uriInvokeInfoList.subList(0, topCount);
            mergeAlarmMsg.setUriList(UriSortUtil.getSortUriAlarmByUri(subList));
        } else {
            mergeAlarmMsg.setUriList(uriInvokeInfoList);
        }
    }
}
