package com.yy.aomi.analysis.common.quartz;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.util.Map;

/**
 * Created by chengaochang on 2017/3/7.
 */
public abstract class AbstractJob extends QuartzJobBean {
    protected final Logger log = LoggerFactory.getLogger(getClass());

    public Map<String,Object> getParameter(JobExecutionContext jobExecutionContext) {
        return (Map<String,Object>) jobExecutionContext.getMergedJobDataMap().get(WorkScheduler.JOB_PARAM);
    }

    @Override
    public void executeInternal(JobExecutionContext context) throws JobExecutionException {
        Map<String,Object> parameters = getParameter(context);
        String className = getClass().getSimpleName();
        long t = System.currentTimeMillis();
        try {
            log.info("************execute job:{} begin *************", className);
            execute(parameters);
            log.info("************execute job:{} end,useTime={}*************", className,(System.currentTimeMillis() - t));
        } catch (Exception e) {
            log.warn("execute job:{} error!", className);
            throw new JobExecutionException(e);
        }
    }

    protected abstract void execute(Map<String,Object> paramMap) throws Exception;

}
