package com.yy.aomi.analysis.common.model.ops;

import com.yy.aomi.common.constant.DateConstant;
import org.apache.commons.lang3.time.DateFormatUtils;

/**
 * {"minDelay":29,"avgDelay":30,"outLossPercent":0.06,"lossPercent":0.03,"reportTime":1509937140000}
 * Created by chengaochang on 2017/11/7.
 */
public class IqData {
    private long minDelay;
    private long avgDelay;
    private double outLossPercent;
    private double lossPercent;
    private long reportTime;
    private String fmtTime;

    public IqData() {

    }

    public IqData(long minDelay, long avgDelay, double outLossPercent, double lossPercent, long reportTime) {
        this.minDelay = minDelay;
        this.avgDelay = avgDelay;
        this.outLossPercent = outLossPercent;
        this.lossPercent = lossPercent;
        setReportTime(reportTime);
    }

    public long getMinDelay() {
        return minDelay;
    }

    public void setMinDelay(long minDelay) {
        this.minDelay = minDelay;
    }

    public long getAvgDelay() {
        return avgDelay;
    }

    public void setAvgDelay(long avgDelay) {
        this.avgDelay = avgDelay;
    }

    public double getOutLossPercent() {
        return outLossPercent;
    }

    public void setOutLossPercent(double outLossPercent) {
        this.outLossPercent = outLossPercent;
    }

    public double getLossPercent() {
        return lossPercent;
    }

    public void setLossPercent(double lossPercent) {
        this.lossPercent = lossPercent;
    }

    public long getReportTime() {
        return reportTime;
    }

    public void setReportTime(long reportTime) {
        this.reportTime = reportTime;
        if(reportTime > 0){
            fmtTime = DateFormatUtils.format(reportTime, DateConstant.yyyyMMddHHmmss);
        }
    }

    public String getFmtTime() {
        return fmtTime;
    }

    public void setFmtTime(String fmtTime) {
        this.fmtTime = fmtTime;
    }

    @Override
    public String toString() {
        return "IqData{" +
                "minDelay=" + minDelay +
                ", avgDelay=" + avgDelay +
                ", outLossPercent=" + outLossPercent +
                ", lossPercent=" + lossPercent +
                ", reportTime=" + reportTime +
                '}';
    }
}
