package com.yy.aomi.analysis.common.model.entity.mysql;


import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * Created by chengaochang on 2017/10/16.
 */
@Entity(name = "ser_call_chain")
public class SerCallChain implements Serializable {

    @Id
    @Column(name = "id")
    private String id;

    @Column(name = "chainKey")
    private String chainKey;

    @Column(name = "businessIds")
    private String businessIds;

    /**
     * 节点数组字符串
     */
    @Column(name = "nodes")
    private String nodes;


    /**
     * 节点数
     */
    @Column(name = "size")
    private int size;

    /**
     * 更新时间
     */
    @Column(name = "modifyTime")
    private Date modifyTime;

    public SerCallChain() {
    }

    public SerCallChain(String id, String chainKey, String businessIds, String nodes, int size) {
        this.id = id;
        this.chainKey = chainKey;
        this.businessIds = businessIds;
        this.nodes = nodes;
        this.size = size;
        this.modifyTime = new Date();
    }

    public String getNodes() {
        return nodes;
    }

    public void setNodes(String nodes) {
        this.nodes = nodes;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getChainKey() {
        return chainKey;
    }

    public void setChainKey(String chainKey) {
        this.chainKey = chainKey;
    }


    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SerCallChain chain = (SerCallChain) o;

        return !(chainKey != null ? !chainKey.equals(chain.chainKey) : chain.chainKey != null);
    }

    @Override
    public int hashCode() {
        return chainKey != null ? chainKey.hashCode() : 0;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBusinessIds() {
        return businessIds;
    }

    public void setBusinessIds(String businessIds) {
        this.businessIds = businessIds;
    }

    @Override
    public String toString() {
        return "SerCallChain{" +
                "id='" + id + '\'' +
                ", chainKey='" + chainKey + '\'' +
                ", businessIds='" + businessIds + '\'' +
                ", nodes='" + nodes + '\'' +
                ", size=" + size +
                ", modifyTime=" + modifyTime +
                '}';
    }
}
