package com.yy.aomi.analysis.common.model.entity.mysql;

/**
 * Created by chengaochang on 2017/8/30.
 */


import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 上次操作时间记录
 */
@Entity(name = "option_last_time")
public class LastOpsTime implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Integer id;

    private Integer type;

    /**
     * 上次操作结束时间
     */
    @Column(name = "lastTime")
    private Date lastTime;


    public LastOpsTime() {
    }

    public LastOpsTime(Integer type) {
        this.type = type;
    }

    public LastOpsTime(Integer type, Date lastTime) {
        this.type = type;
        this.lastTime = lastTime;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Date getLastTime() {
        return lastTime;
    }

    public void setLastTime(Date lastTime) {
        this.lastTime = lastTime;
    }

    @Override
    public String toString() {
        return "LastOpsTime{" +
                "id=" + id +
                ", type=" + type +
                ", lastTime=" + lastTime +
                '}';
    }
}
