package com.yy.aomi.analysis.common.model.entity.mysql;


import javax.persistence.*;
import java.io.Serializable;

/**
* @author <a href= "mailto:909074682@yy.com" style="color:##E0E;">zhangzhibin</a>
* @date 2017年4月19日下午6:08:21 
* @version V1.0   
*/
@Entity(name = "business_summary")
public class BusinessSummary implements Serializable{

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	
	@Column
	private String charge;
	
	@Column
	private String business;
	
	@Column(name = "jobNumber")
	private String jobNumber;
	
	@Column(name = "phoneNumber")
	private String phoneNumber;
	
	@Column(name = "categoryId")
	private String categoryId;

	@Column(name = "inAomi")
	private Integer inAomi = 0;

	public static final  int IN_AOMI = 1;

	public static final  int NOT_IN_AOMI = 0;
	
	
	
	public BusinessSummary() {
		super();
	}

	public BusinessSummary(String charge, String business, String jobNumber, String phoneNumber, String categoryId) {
		super();
		this.charge = charge;
		this.business = business;
		this.jobNumber = jobNumber;
		this.phoneNumber = phoneNumber;
		this.categoryId = categoryId;
	}

	/**clone当前对象
	 * @return
	 */
	public BusinessSummary cloneObject() {
		BusinessSummary clone = new BusinessSummary(charge,business,jobNumber,phoneNumber,categoryId);
		clone.setId(id);
		clone.setInAomi(inAomi);
		return clone;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getCharge() {
		return charge;
	}

	public void setCharge(String charge) {
		this.charge = charge;
	}

	public String getBusiness() {
		return business;
	}

	public void setBusiness(String business) {
		this.business = business;
	}

	public String getJobNumber() {
		return jobNumber;
	}

	public void setJobNumber(String jobNumber) {
		this.jobNumber = jobNumber;
	}

	public String getPhoneNumber() {
		return phoneNumber;
	}

	public void setPhoneNumber(String phoneNumber) {
		this.phoneNumber = phoneNumber;
	}

	public String getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(String categoryId) {
		this.categoryId = categoryId;
	}

	public Integer getInAomi() {
		return inAomi;
	}

	public void setInAomi(Integer inAomi) {
		this.inAomi = inAomi;
	}



	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;

		BusinessSummary that = (BusinessSummary) o;

		if (!id.equals(that.id)) return false;
		if (!charge.equals(that.charge)) return false;
		if (!business.equals(that.business)) return false;
		if (!jobNumber.equals(that.jobNumber)) return false;
		if (!phoneNumber.equals(that.phoneNumber)) return false;
		if (!categoryId.equals(that.categoryId)) return false;
		return inAomi.equals(that.inAomi);
	}

	@Override
	public int hashCode() {
		int result = id.hashCode();
		result = 31 * result + charge.hashCode();
		result = 31 * result + business.hashCode();
		result = 31 * result + jobNumber.hashCode();
		result = 31 * result + phoneNumber.hashCode();
		result = 31 * result + categoryId.hashCode();
		result = 31 * result + inAomi.hashCode();
		return result;
	}

	@Override
	public String toString() {
		return "BusinessSummary{" +
				"charge='" + charge + '\'' +
				", business='" + business + '\'' +
				", jobNumber='" + jobNumber + '\'' +
				", phoneNumber='" + phoneNumber + '\'' +
				", categoryId='" + categoryId + '\'' +
				'}';
	}
}
