package com.yy.aomi.analysis.common.model.analysis;

import com.alibaba.fastjson.annotation.JSONField;
import com.yy.aomi.common.model.proto.Header;
import com.yy.aomi.common.model.proto.ProcMonInfo;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by chengaochang on 2017/2/10.
 * {“clientname”:”ent”, “ips”:”127.0.0.1”, “ports”:3660, “pid”:11211, “srvid”:1, “groupid”:23}
 */
public class MonitorAppInfo extends Header{

    /**
     * 非协议字段，由ips转换
     */
    public List<String> ipList;

    /**
     * 非协议字段，由ports转换
     */
    public List<Integer> portList;

    /**
     * 非协议字段，由外面传入
     */
    private ProcMonInfo procInfo;

    @JSONField(serialize = false)
    private String serviceHostId;

    public MonitorAppInfo(){}

    public MonitorAppInfo(String clientname, String pid, String srvid, String groupid, long time,long reportTime) {
        this.clientname = clientname;
        this.pid = pid;
        this.srvid = srvid;
        this.groupid = groupid;
        this.time = time;
        this.reportTime = reportTime;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getReportTime() {
        if(reportTime == 0){
            reportTime = time;
        }
        return reportTime;
    }

    public void setReportTime(long reportTime) {
        this.reportTime = reportTime;
    }

    public String getClientname() {
        return clientname;
    }

    public void setClientname(String clientname) {
        this.clientname = clientname;
    }

    public List<String> getIpList() {
        return ipList;
    }

    public void setIpList(List<String> ips) {
        if(ips == null){
            ips = new ArrayList<>(1);
        }else{
            Collections.sort(ips);
        }
        this.ipList = ips;
    }

    public List<Integer> getPortList() {
        return portList;
    }

    public void setPortList(List<Integer> ports) {
        if(ports == null){
            ports = new ArrayList<>(1);
        }else{
            Collections.sort(ports);
        }
        this.portList = ports;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getSrvid() {
        return srvid;
    }

    public void setSrvid(String srvid) {
        this.srvid = srvid;
    }

    public String getGroupid() {
        return groupid;
    }

    public void setGroupid(String groupid) {
        this.groupid = groupid;
    }

    public String getBusinessid() {
        return businessid;
    }

    public void setBusinessid(String businessid) {
        this.businessid = businessid;
    }

    public ProcMonInfo getProcInfo() {
        return procInfo;
    }

    public void setProcInfo(ProcMonInfo procMonInfo) {
        this.procInfo = procMonInfo;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @JSONField(serialize = false)
    public String getServiceHostId() {
        if (serviceHostId == null) {
            this.serviceHostId = clientname + ":" + defaultIp() + ":" + defaultPort();
        }
        return this.serviceHostId;
    }



    public String defaultHost() {
        return defaultIp() + ":" + defaultPort();
    }


    public int defaultPort() {
        if (!CollectionUtils.isEmpty(portList)) {
            return portList.get(0);
        }
        return 0;
    }

    public String defaultIp() {
        if (!CollectionUtils.isEmpty(ipList)) {
            return ipList.get(0);
        }
        return null;
    }


    public MonitorAppInfo copyAppInfoByHost(String ip, int port){
        MonitorAppInfo appInfo = new MonitorAppInfo(clientname,pid,srvid,groupid,time,reportTime);
        List<String> ips = new ArrayList<>(1);
        List<Integer> ports = new ArrayList<>(1);
        ips.add(ip);
        ports.add(port);
        appInfo.portList = ports;
        appInfo.ipList = ips;
        appInfo.procInfo = copyProcMonInfo();
        appInfo.businessid = businessid;
        appInfo.source = source;
        return appInfo;
    }

    public MonitorAppInfo copyAppInfoByHost(){
        MonitorAppInfo appInfo = new MonitorAppInfo(clientname,pid,srvid,groupid,time,reportTime);
        List<String> ips = new ArrayList<>();
        List<Integer> ports = new ArrayList<>();
        if(ipList!=null){
            ips.addAll(ipList);
        }
        if(portList!=null){
            ports.addAll(portList);
        }
        appInfo.portList = ports;
        appInfo.ipList = ips;
        appInfo.procInfo = copyProcMonInfo();
        appInfo.businessid = businessid;
        appInfo.source = source;
        return appInfo;
    }

    private ProcMonInfo copyProcMonInfo(){
        if(this.procInfo != null){
            ProcMonInfo proc = new ProcMonInfo(procInfo.getSystemMemSize(),procInfo.getSystemCpuSize(),procInfo.getProcessMemSize());
            proc.setProcessCpuUsage(procInfo.getProcessCpuUsage());
            proc.setSystemCpuUsage(procInfo.getSystemCpuUsage());
            proc.setProcessMemUsage(procInfo.getProcessMemUsage());
            proc.setSystemMemUsage(procInfo.getSystemMemUsage());
            return proc;
        }
        return null;
    }



    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MonitorAppInfo appInfo = (MonitorAppInfo) o;
        if (clientname != null ? !clientname.equals(appInfo.clientname) : appInfo.clientname != null) return false;
        if(!(hostsPartEq(ipList,appInfo.ipList)))return false;
        return hostsPartEq(portList, appInfo.portList);
    }

    private boolean hostsPartEq(List<?> hostsPart, List<?> thatHostsPart) {
        if (hostsPart == thatHostsPart) {
            return true;
        }
        if (hostsPart != null) {
            if (thatHostsPart == null) {
                return false;
            }
            if (!thatHostsPart.isEmpty() && !hostsPart.isEmpty()) {
                return hostsPart.get(0).equals(thatHostsPart.get(0));
            }

            return hostsPart.size() == thatHostsPart.size();
        } else {
            return thatHostsPart == null;
        }
    }

    @Override
    public int hashCode() {
        int result = clientname != null ? clientname.hashCode() : 0;
        result = 31 * result + (ipList != null && ipList.size()>0 ? ipList.get(0).hashCode() : 0);
        result = 31 * result + (portList != null && portList.size()>0 ? portList.get(0).hashCode() : 0);
        return result;
    }


    @Override
    public String toString() {
        return "MonitorAppInfo{" +
                "clientname='" + clientname + '\'' +
                ", groupid='" + groupid + '\'' +
                ", srvid='" + srvid + '\'' +
                ", businessid='" + businessid + '\'' +
                ", pid='" + pid + '\'' +
                ", source='" + source + '\'' +
                ", ipList=" + ipList +
                ", portList=" + portList +
                ", time=" + time +
                ", reportTime=" + reportTime +
                ", procInfo=" + procInfo +
                ", serviceHostId='" + serviceHostId + '\'' +
                '}';
    }


}
