package com.yy.aomi.analysis.common.model.analysis;

import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.common.constant.ModelType;
import com.yy.aomi.common.model.proto.ModelContext;
import com.yy.aomi.common.model.proto.RpcContext;
import com.yy.aomi.common.model.proto.ThreadPoolContext;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsg;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by chengaochang on 2017/8/8.
 */
public class ModelAnalysisData {

    private int modelType;

    private String modelId;

    private ModelContext context;

    private List<UriAnalysisData> uriNodes;

    private AlarmMsg summaryAlarm;

    public ModelAnalysisData() {
    }

    public ModelAnalysisData(int modelType, String modelId, ModelContext context) {
        this.modelType = modelType;
        this.modelId = modelId;
        this.context = context;
    }

    public void addUriData(UriAnalysisData uriAnalysisData) {
        if (uriNodes == null) {
            uriNodes = new ArrayList<>();
        }
        uriNodes.add(uriAnalysisData);
    }


    public int getModelType() {
        return modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public String getModelId() {
        return modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }


    public List<UriAnalysisData> getUriNodes() {
        return uriNodes;
    }

    public void setUriNodes(List<UriAnalysisData> uriNodes) {
        this.uriNodes = uriNodes;
    }


    public ModelContext getContext() {
        return context;
    }

    public void setContext(ModelContext context) {
        this.context = context;
    }

    public AlarmMsg getSummaryAlarm() {
        return summaryAlarm;
    }

    public void setSummaryAlarm(AlarmMsg summaryAlarm) {
        this.summaryAlarm = summaryAlarm;
    }


    /**
     * 获取模型分析数据
     * @param modelType
     * @param ctx
     * @return
     */
    public static ModelAnalysisData instance(int modelType, String modelId, JSONObject ctx){
        ModelContext context = null;
        switch (modelType) {
            case ModelType.RPC_MODEL:
                context = ctx.toJavaObject(RpcContext.class);
                break;
            case ModelType.HANDLE_MODEL:
                context = ctx.toJavaObject(ThreadPoolContext.class);
                break;
            case ModelType.DB_MODEL:
//                context = ctx.toJavaObject(DatabaseAlarmIssue.class);
                break;
            case ModelType.MACHINE_MODEL:
//                context = ctx.toJavaObject(MachineAlarmIssue.class);
                break;
            default:
                break;
        }
        return new ModelAnalysisData(modelType, modelId, context);
    }

    @Override
    public String toString() {
        return "ModelAnalysisData{" +
                "modelType=" + modelType +
                ", modelId='" + modelId + '\'' +
                ", context=" + context +
                ", uriNodes=" + uriNodes +
                ", summaryAlarm=" + summaryAlarm +
                '}';
    }
}
