package com.yy.aomi.analysis.common.model.analysis;

import com.yy.aomi.common.model.proto.ThreadPoolContext;

/**
 * Created by chengaochang on 2017/2/10.
 * 处理模型数据结构
 * {“key”: “1|186+2|186”, “count”: 200, “totalTime”: 12000ms, “maxTime”: 500ms, “minTime”:20ms}
 */
public class HandleMonitorModel extends BaseMonitorModel<ThreadPoolContext> {

    public HandleMonitorModel() {

    }

    public HandleMonitorModel(int type, String id) {
        super(type, id);
    }


    public int queueMaxSize() {
        return this.context.getQueueMaxSize();
    }

    public void queueMaxSize(int queueMaxSize) {
        this.context.setQueueMaxSize(queueMaxSize);
    }

    public int maxThreads() {
        return this.context.getMaxThreads();
    }

    public void maxThreads(int maxThreads) {
        this.context.setMaxThreads(maxThreads);
    }

    public int activeThreads() {
        return this.context.getActiveThreads();
    }

    public void activeThreads(int activeThreads) {
        this.context.setActiveThreads(activeThreads);
    }

    public int queueId() {
        return this.context.getQueueId();
    }

    public void queueId(int queueId) {
        this.context.setQueueId(queueId);
    }

    public int minThreads() {
        return this.context.getMinThreads();
    }

    public void minThreads(int minThreads) {
        this.context.setMinThreads(minThreads);
    }

    public int queueCurSize() {
        return this.context.getQueueCurSize();
    }

    public void queueCurSize(int queueCurSize) {
        this.context.setQueueCurSize(queueCurSize);
    }

    public void maxUsedThreads(int maxUsedThreads) {
        this.context.setMaxUsedThreads(maxUsedThreads);
    }

    public double threadUseRate() {
        return context.getThreadUseRate();
    }

    public void threadUseRate(double threadUseRate) {
        context.setThreadUseRate(threadUseRate);
    }

    public long threadTotalTime() {
        return context.getThreadTotalTime();
    }

    public void threadTotalTime(long threadTotalTime) {
        context.setThreadTotalTime(threadTotalTime);
    }

    @Override
    public String toString() {
        return "HandleMonitorModel{" +
                "id='" + id + '\'' +
                ", type=" + type +
                ", events=" + events +
                ", time=" + time +
                ","+context.toString()+
                ", \n itemMap=" + itemMap +
                '}';
    }
}
