package com.yy.aomi.analysis.common.model.analysis;

import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.common.model.proto.ModelContext;
import com.yy.aomi.common.model.proto.ModelStatInfo;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by chengaochang on 2017/2/10.
 *
 * 监控模型基类
 */
public class BaseMonitorModel<C extends ModelContext> {

    protected MonitorAppInfo appInfo;
    /**
     * 模型id
     */
    protected String id;

    /**
     * 模型类型
     */
    protected int type;

    /**
     * 上报时间
     */
    protected long time;

    /**
     * 模型事件
     */
    protected Map<String, Integer> events = new HashMap<>();

    /**
     * 模型处理总时间
     */
    protected long totalTime;


    /**
     * uri处理统计信息
     */
    protected Map<String, ModelStatInfo> itemMap = new HashMap<>();

    /**
     *  running uri处理统计信息
     */
    protected Map<String, ModelStatInfo> runningUriMap = new HashMap<>();

    /**
     * 模型上下文
     */
    protected C context;


    public BaseMonitorModel() {

    }


    public BaseMonitorModel(int type, String id) {
        this.type = type;
        this.id = id;
    }

    public void setContext(C context) {
        this.context = context;
    }

    public C getContext(){
        return context;
    }

    public void setContextByJSON(JSONObject context,Class<C> cClass) {
        if(context!=null){
            C ctx = context.toJavaObject(cClass);
            this.context = ctx;
        }
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Map<String,Integer> getEvents() {
        return events;
    }

    public void setEvents(Map<String,Integer> events) {
        this.events = events;
    }

    public Map<String, ModelStatInfo> getItemMap() {
        return itemMap;
    }

    public void setItemMap(Map<String, ModelStatInfo> itemMap) {
        this.itemMap = itemMap;
    }

    public long getTotalTime() {
        return totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public MonitorAppInfo getAppInfo() {
        return appInfo;
    }

    public void setAppInfo(MonitorAppInfo appInfo) {
        this.appInfo = appInfo;
    }


    public Map<String, ModelStatInfo> getRunningUriMap() {
        return runningUriMap;
    }

    public void setRunningUriMap(Map<String, ModelStatInfo> runningUriMap) {
        this.runningUriMap = runningUriMap;
    }

    @Override
    public String toString() {
        return "BaseMonitorModel{" +
                "appInfo=" + appInfo +
                ", id='" + id + '\'' +
                ", type=" + type +
                ", time=" + time +
                ", events=" + events +
                ", totalTime=" + totalTime +
                ", itemMap=" + itemMap +
                '}';
    }
}
