package com.yy.aomi.analysis.common.model.alarm;

/**
 * Created by chengaochang on 2017/3/13.
 * top3:uri/次数/均值
 */
public class UriInvokeInfo {
    private String uri;
    private long count;//调用总次数
    private long avgTime;//平均处理时间
    private long errorCount;
    private long totalTime;
    private long thProcTl;
    public double percent;
    protected double threadUseRate;
    private String rpcHost;


    public UriInvokeInfo(){
    }

    public UriInvokeInfo(String uri, long count, long errorCount, long totalTime, long thProcTl, String rpcHost) {
        this(uri,count,errorCount,totalTime,thProcTl);
        this.rpcHost = rpcHost;
    }

    public UriInvokeInfo(String uri, long count, long errorCount, long totalTime, long thProcTl) {
        this.uri = uri;
        this.count = count;
        this.errorCount = errorCount;
        this.totalTime = totalTime;
        this.avgTime = count==0 ? 0 : totalTime/count;
        this.percent = getPercent();
        this.thProcTl = thProcTl;
    }


    public long getErrorCount() {
        return errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public long getCount() {
        return count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getAvgTime() {
        return avgTime;
    }

    public void setAvgTime(long avgTime) {
        this.avgTime = avgTime;
    }

    public long getTotalTime() {
        return totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public double getPercent() {
        if(count>0){
            percent = Double.parseDouble(String.format("%.2f", errorCount*100/(count*1.0)));
        }
        return percent;
    }

    public double getThreadUseRate() {
        return threadUseRate;
    }

    public void setThreadUseRate(double threadUseRate) {
        this.threadUseRate = threadUseRate;
    }

    public String getRpcHost() {
        return rpcHost;
    }

    public void setRpcHost(String rpcHost) {
        this.rpcHost = rpcHost;
    }

    public long getThProcTl() {

        return thProcTl;
    }

    public void setThProcTl(long thProcTl) {
        this.thProcTl = thProcTl;
    }

    @Override
    public String toString() {
        return "UriInvokeInfo{" +
                "uri='" + uri + '\'' +
                ", count=" + count +
                ", avgTime=" + avgTime +
                ", errorCount=" + errorCount +
                ", totalTime=" + totalTime +
                ", thProcTl=" + thProcTl +
                ", percent=" + percent +
                ", threadUseRate=" + threadUseRate +
                ", rpcHost='" + rpcHost + '\'' +
                '}';
    }
}
