package com.yy.aomi.analysis.common.model.alarm;

import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.analysis.common.util.tree.TreeNode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author <a href="mailto:simling82@gmail.com">Simling</a>
 * @version v1.0 on 2018/7/18
 */
public class EventAnalysis {
    private Long id;
    private String type;//事件类型 info warn error
    private Integer level;//事件级别 1,2,3
    private Integer analyseType;//事件分析类型 1:单进程分析 2 多进程分析
    private int rootCause;//是否根事件 0 否 1 是
    private String url;//跳转地址
    private String data;//事件原始数据
    private String treeId;
    private String appId;//应用id
    private String serviceName;//所在应用下的服务名
    private String groupId;//服务组id

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    protected long createTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private long beginTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private long endTime;

    private String charge;

    public EventAnalysis() {
    }


    public EventAnalysis(TreeNode<ErrorChainNode> treeNode) {
        ErrorChainNode msgNode = treeNode.getMsgNode();
        this.treeId = treeNode.getTreeId();
        if(treeNode.getParentId() == -1){
            this.rootCause = 1;
        }
        this.serviceName = msgNode.getAppName();
        this.analyseType = msgNode.getAnalyseType();
        this.groupId = msgNode.getBusinessId();
        this.beginTime = msgNode.getBeginTime();
        this.endTime = msgNode.getEndTime();
        this.data = JSONObject.toJSONString(treeNode);
        this.charge = msgNode.getCharge();
    }


    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Integer getAnalyseType() {
        return analyseType;
    }

    public void setAnalyseType(Integer analyseType) {
        this.analyseType = analyseType;
    }

    public int getRootCause() {
        return rootCause;
    }

    public void setRootCause(int rootCause) {
        this.rootCause = rootCause;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCharge() {
        return charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    @Override
    public String toString() {
        return "EventAnalysis{" +
                ", type='" + type + '\'' +
                ", level=" + level +
                ", analyseType=" + analyseType +
                ", rootCause=" + rootCause +
                ", url='" + url + '\'' +
                ", data='" + data + '\'' +
                ", treeId='" + treeId + '\'' +
                ", appId='" + appId + '\'' +
                ", serviceName='" + serviceName + '\'' +
                ", groupId='" + groupId + '\'' +
                ", createTime=" + createTime +
                ", beginTime=" + beginTime +
                ", endTime=" + endTime +
                '}';
    }
}
