package com.yy.aomi.analysis.common.model.alarm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.yy.aomi.analysis.common.util.tree.TreeIF;
import com.yy.aomi.analysis.common.util.tree.TreeNode;

import java.util.List;

/**
 * Created by chengaochang on 2017/5/18.
 */
public class ErrorChainNode implements TreeIF<ErrorChainNode> {

    @JSONField(serialize = false)
    public static final int ANALYSE_TYPE_ANALYSE = 1;
    @JSONField(serialize = false)
    public static final int ANALYSE_TYPE_CATCHER = 2;

    @JSONField(serialize = false)
    protected TreeNode<ErrorChainNode> treeNode;

//    private ErrorMsgNode msgNode;
//
    protected String msgId;
    /**
     * 1发告警时创建的错误节点，2是寻根分析时创建的节点
     */
    protected int procCount;//影响进程数
    protected int analyseType;
    protected String businessId;
    protected String modelId;
    protected int modelType;
    protected String appName;
    protected String ips;
    protected String ports;
    protected String orgIps;
    protected String orgPorts;
    protected String rpcHost;
    protected long beginTime;
    protected long endTime;
    protected int errorType;
    protected long totalCount;
    protected long errorCount;
    protected JSONObject ctx;
    protected ErrorDetail detail;//发生错误时的详细上报及统计数据
    protected List<UriInvokeInfo> uriList;
    protected List<ErrorChainNode> children;
    protected String charge;//负责人
    public ErrorChainNode(){

    }

    public ErrorChainNode(String appName, String ips, String ports, String businessId) {
        this.appName = appName;
        this.ips = ips;
        this.ports = ports;
        this.businessId = businessId;
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public int getAnalyseType() {
        return analyseType;
    }

    public void setAnalyseType(int analyseType) {
        this.analyseType = analyseType;
    }

    public String getModelId() {
        return modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public int getModelType() {
        return modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public int getErrorType() {
        return errorType;
    }

    public void setErrorType(int errorType) {
        this.errorType = errorType;
    }

    public long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getErrorCount() {
        return errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public long getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getRpcHost() {
		return rpcHost;
	}

	public void setRpcHost(String rpcHost) {
		this.rpcHost = rpcHost;
	}

	public String getIps() {
        return ips;
    }

    public void setIps(String ips) {
        this.ips = ips;
    }

    public String getPorts() {
        return ports;
    }

    public void setPorts(String ports) {
        this.ports = ports;
    }

    public String getBusinessId() {
        return businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public List<UriInvokeInfo> getUriList() {
        return uriList;
    }

    public void setUriList(List<UriInvokeInfo> uriList) {
        this.uriList = uriList;
    }

    public List<ErrorChainNode> getChildren() {
        return children;
    }

    public void setChildren(List<ErrorChainNode> children) {
        this.children = children;
    }


    public int getProcCount() {
        return procCount;
    }

    public void setProcCount(int procCount) {
        this.procCount = procCount;
    }

    @Override
    public long acquireOriginalCreateTime() {
        if(this.beginTime == 0){
            return System.currentTimeMillis();
        }
        return this.beginTime;
    }

    @Override
    public void setTreeNode(TreeNode<ErrorChainNode> node) {
        this.treeNode = node;
    }

    public TreeNode<ErrorChainNode> getTreeNode() {
        return treeNode;
    }

    public JSONObject getCtx() {
        return ctx;
    }

    public void setCtx(JSONObject ctx) {
        this.ctx = ctx;
    }

    public ErrorDetail getDetail() {
        return detail;
    }

    public void setDetail(ErrorDetail detail) {
        this.detail = detail;
    }

    public String getOrgIps() {
        return orgIps;
    }

    public void setOrgIps(String orgIps) {
        this.orgIps = orgIps;
    }

    public String getOrgPorts() {
        return orgPorts;
    }

    public void setOrgPorts(String orgPorts) {
        this.orgPorts = orgPorts;
    }

    public String getCharge() {
        return charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    @Override
    public String toString() {
        return "ErrorChainNode{" +
                "uriList=" + uriList +
                ", msgId='" + msgId + '\'' +
                ", procCount=" + procCount +
                ", analyseType=" + analyseType +
                ", businessId='" + businessId + '\'' +
                ", modelId='" + modelId + '\'' +
                ", modelType=" + modelType +
                ", appName='" + appName + '\'' +
                ", ips='" + ips + '\'' +
                ", ports='" + ports + '\'' +
                ", orgIps='" + orgIps + '\'' +
                ", orgPorts='" + orgPorts + '\'' +
                ", rpcHost='" + rpcHost + '\'' +
                ", beginTime=" + beginTime +
                ", endTime=" + endTime +
                ", errorType=" + errorType +
                ", totalCount=" + totalCount +
                ", errorCount=" + errorCount +
                ", ctx=" + ctx +
                ", detail=" + detail +
                '}';
    }
}
