package com.yy.aomi.analysis.common.model.alarm;

import com.alibaba.fastjson.annotation.JSONField;
import com.yy.aomi.analysis.common.model.analysis.MonitorAppInfo;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * Created by chengaochang on 2017/3/30.
 */
public class AlarmMsgTreeNode {
    private String treeId;
    private String msg;
    /**
     * 1发告警时创建的错误节点，2是寻根分析时创建的节点
     */
    @JSONField(serialize = false)
    private int analyseType;
    private String summary;
    private String processor;
    private List<AlarmMsgTreeNode> children;

    @JSONField(serialize = false)
    private String errorType;

    @JSONField(serialize = false)
    public AlarmMsg alarmMsg;

    @JSONField(serialize = false)
    public MonitorAppInfo app;

    public AlarmMsgTreeNode(AlarmMsg alarmMsg) {
        if (alarmMsg.getApp() != null) {
            this.processor = alarmMsg.getApp().getServiceHostId();
        }
        //resetAlarmUri(alarmMsg);
        this.treeId = alarmMsg.getTreeId();
        this.alarmMsg = alarmMsg;
        this.app = alarmMsg.getApp();
    }

//    private void resetAlarmUri(AlarmMsg alarmMsg){
//        if(alarmMsg!=null){
//            boolean isRpc = ModelType.isRpc(alarmMsg.getModelType());
//            if(isRpc){
//                for(UriInvokeInfo uta:alarmMsg.getUriList()){
//                    CombUriVo combUriVo = UriParseMethod.parseCombUri(isRpc,uta.getUri());
//                    uta.setUri(combUriVo.getUri());
//                }
//            }
//        }
//    }

    public void addChild(AlarmMsgTreeNode node) {
        if (children == null) {
            children = new ArrayList<>();
        }
        children.add(node);
    }

    public void addChildren(List<AlarmMsgTreeNode> nodes) {
        if (children == null) {
            children = new ArrayList<>();
        }
        children.addAll(nodes);
    }

    public AlarmMsgTreeNode searchTreeLastChild() {
        AlarmMsgTreeNode alarmMsg = null;
        if (hasChildren()) {
            alarmMsg = children.get(children.size() - 1);
            AlarmMsgTreeNode next = alarmMsg.searchTreeLastChild();
            if (next == null) {
                return alarmMsg;
            }
        }
        return alarmMsg;
    }

    public int getAnalyseType() {
        return analyseType;
    }

    public void setAnalyseType(int analyseType) {
        this.analyseType = analyseType;
    }

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getErrorType() {
        return errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getProcessor() {
        return processor;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }


    public List<AlarmMsgTreeNode> getChildren() {
        return children;
    }

    public void setChildren(List<AlarmMsgTreeNode> children) {
        this.children = children;
    }


    public boolean hasChildren() {
        return CollectionUtils.isEmpty(children) == false;
    }


    public MonitorAppInfo getApp() {
        return app;
    }

    public void setApp(MonitorAppInfo app) {
        this.app = app;
    }

    public AlarmMsg getAlarmMsg() {
        return alarmMsg;
    }

    public void setAlarmMsg(AlarmMsg alarmMsg) {
        this.alarmMsg = alarmMsg;
    }

    public void getAllTreeIds(Set<String> ids){
        if(treeId!=null && treeId.isEmpty()==false){
            ids.add(treeId);
        }
        if(hasChildren()){
            for (AlarmMsgTreeNode child : children) {
                child.getAllTreeIds(ids);
            }
        }
    }



    @Override
    public String toString() {
        return "AlarmMsgTreeNode{" +
                ", msg='" + msg + '\'' +
                ", summary='" + summary + '\'' +
                ", processor='" + processor + '\'' +
                ", errorType='" + errorType + '\'' +
                ", alarmMsg=" + alarmMsg +
                ", app=" + app +
                ", children=" + children +
                '}';
    }

}
