/**
 * Copyright (C), 2018-2018, XXX有限公司
 * FileName: AlarmMsgNodeTree
 * Author:   chengaochang
 * Date:     18/10/23 下午12:17
 * Description: AlarmMsgNodeTree
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yy.aomi.analysis.common.model.alarm;

import com.yy.aomi.analysis.common.constant.ErrorDefinition;

import java.util.ArrayList;
import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * 〈AlarmMsgNodeTree〉
 *
 * @author cgc
 * @create 18/10/23
 * @since 1.0.0
 */
public class AlarmMsgNodeTree {
    private String treeId;
    private int analyseType;
    private AlarmMsgProcNode root;
    private List<AlarmMsgNodeChain> children = new ArrayList<>(1);

    public AlarmMsgNodeTree(){}

    public List<AlarmMsgNodeChain> getChildren() {
        return children;
    }

    public void setChildren(List<AlarmMsgNodeChain> children) {
        this.children = children;
    }

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public AlarmMsgProcNode getRoot() {
        return root;
    }

    public void setRoot(AlarmMsgProcNode root) {
        this.root = root;
    }

    public int calProcCount(){
        int count = 1;
        for(AlarmMsgNodeChain chain : children){
            count += chain.size();
        }
        return count;
    }

    public  int calErrorCount(){
        int count = 1;
        for(AlarmMsgNodeChain chain : children){
            for(AlarmMsgProcNode node : chain){
                if(ErrorDefinition.isError(node.getAlarmMsg().getErrorType())){
                    count ++;
                }
            }
        }
        return count;
    }

    public int getAnalyseType() {
        return analyseType;
    }

    public void setAnalyseType(int analyseType) {
        this.analyseType = analyseType;
    }
}