package com.yy.aomi.analysis.common.model.alarm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.yy.aomi.common.constant.DateConstant;
import com.yy.aomi.analysis.common.constant.ELKConstant;
import com.yy.aomi.common.constant.ModelType;
import com.yy.aomi.analysis.common.model.analysis.MonitorAppInfo;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.*;

/**
 * @author <a href= "mailto:909074682@yy.com" style="color:##E0E;">zhangzhibin</a>
 * @version V1.0
 * @date 2017年3月30日下午4:46:30
 */
public class AlarmMsgErrorNode<T extends AlarmMsg> {

    private String analysisId;
    private String processKey;
    private Integer ownerId;
    private Integer parantId;
    private T alarmMsg;


    public AlarmMsgErrorNode() {
        super();
    }


    public AlarmMsgErrorNode(Integer ownerId, Integer parantId, T alarmMsg) {
        super();
        this.ownerId = ownerId;
        this.parantId = parantId;
        this.alarmMsg = alarmMsg;
    }


    public AlarmMsgErrorNode(String analysisId, String processKey, Integer ownerId, Integer parantId,
                             T alarmMsg) {
        super();
        this.analysisId = analysisId;
        this.processKey = processKey;
        this.ownerId = ownerId;
        this.parantId = parantId;
        this.alarmMsg = alarmMsg;
    }


    /**
     * @param args
     * @throws Exception
     */
    public static void main(String[] args) throws Exception {

        Map<MonitorAppInfo, AlarmMsgChain> map = getData();
        printMap(map);
//		System.out.println("-------11111------");
        List<String[]> jsons = split(map);
        List<JSONObject> list = new ArrayList<>();
        for (String[] item : jsons) {
            for (String str : item) {
                list.add(JSONObject.parseObject(str));
            }
        }


        Map<MonitorAppInfo, AlarmMsgChain> result = restore(list);
//		System.out.println("------222222-------");
        printMap(result);


    }

    public static Map<MonitorAppInfo, AlarmMsgChain> restore(List<JSONObject> list) throws Exception {
        List<AlarmMsgErrorNode> beanList = jsonToObject(list);
        Map<MonitorAppInfo, AlarmMsgChain> result = new HashMap<>();
        Map<MonitorAppInfo, List<AlarmMsgErrorNode>> map = new HashMap<>();
        for (AlarmMsgErrorNode<AlarmMsg> item : beanList) {
            String processKey = item.getProcessKey();
            List<AlarmMsgErrorNode> itemList = map.get(processKey);
            if (itemList == null) {
                itemList = new ArrayList<>();
                MonitorAppInfo appInfo = new MonitorAppInfo();
                String[]processInfos = processKey.split(":");
                appInfo.setClientname(processInfos[0]);
                ArrayList<String> ips = new ArrayList();
                ips.add(processInfos[1]);
                appInfo.setIpList(ips);

                ArrayList<Integer> ports = new ArrayList();
                ports.add(Integer.parseInt(processInfos[2]));
                appInfo.setPortList(ports);

                map.put(appInfo, itemList);
            }
            itemList.add(item);
        }

        Set<MonitorAppInfo> keys = map.keySet();
        for (MonitorAppInfo key : keys) {
            List<AlarmMsgErrorNode> itemList = map.get(key);
            result.put(key, buildTree(itemList));
        }

        return result;
    }

    public static AlarmMsgChain restoreAlarmMsgChain(List<JSONObject> list) throws Exception {
        List<AlarmMsgErrorNode> beanList = jsonToObject(list);
        return buildTree(beanList);
    }

    public static List<AlarmMsgErrorNode> jsonToObject(List<JSONObject> list) throws Exception {
        List<AlarmMsgErrorNode> result = new ArrayList<>();
        for (JSONObject json : list) {
            AlarmMsgErrorNode<AlarmMsg> item = null;

            json.remove(ELKConstant.TIME_KEY);
            int modelType = json.getJSONObject("alarmMsg").getJSONObject("mergeKey").getIntValue("modelType");

            switch (modelType) {
                case ModelType.HANDLE_MODEL:
                    new TypeReference<AlarmMsgErrorNode<QueueBlockAlarm>>() {
                    }.getClass();
                    item = JSONObject.parseObject(json.toJSONString(), new TypeReference<AlarmMsgErrorNode<QueueBlockAlarm>>() {
                    }.getType());

                    break;
                case ModelType.RPC_MODEL:
                    item = JSONObject.parseObject(json.toJSONString(), new TypeReference<AlarmMsgErrorNode<RpcAlarm>>() {
                    }.getType());
                    break;
                default:
                    throw new Exception("error unknow modelType " + modelType);
            }

            result.add(item);

        }
        return result;
    }

    public static List<String[]> split(Map<MonitorAppInfo, AlarmMsgChain> map) {
        List<String[]> result = new ArrayList<>();
        Set<MonitorAppInfo> keys = map.keySet();
        String analysisId = UUID.randomUUID().toString();
        Date now = new Date();
        //生成当前时间格式
        String time = DateFormatUtils.formatUTC(now, DateConstant.UTC_TIME_PATTERN);
        for (MonitorAppInfo appInfo : keys) {
            AlarmMsgChain trees = map.get(appInfo);
            String processKey = appInfo.getServiceHostId();
            result.add(splitTreeToJson(trees, analysisId, processKey, time));
        }

        return result;
    }


    public static List<AlarmMsgErrorNode<AlarmMsg>> splitTree(AlarmMsgChain<AlarmMsg> alarmMsgChain, String analysisId, String processKey) {
        List<AlarmMsgErrorNode<AlarmMsg>> result = new ArrayList<>();
//		AlarmMsgErrorNode node = new AlarmMsgErrorNode(0, -1, null);
//		result.add(node);
//		System.out.println(node.toString());
        int lastId = 0;
        int parent = 0;
        for (AlarmMsg item : alarmMsgChain) {
            lastId = encodeItem(item, lastId, parent, 1, result, analysisId, processKey);
        }
        return result;
    }

    public static String[] splitTreeToJson(AlarmMsgChain<AlarmMsg> alarmMsgChain, String analysisId, String processKey, String time) {
        List<AlarmMsgErrorNode<AlarmMsg>> result = splitTree(alarmMsgChain, analysisId, processKey);
        List<String> jsons = new ArrayList<>(result.size());

        for (AlarmMsgErrorNode<AlarmMsg> node : result) {
            List<AlarmMsg> children = node.getAlarmMsg().children;
            node.getAlarmMsg().children = null;
            JSONObject object = JSONObject.parseObject(JSONObject.toJSONString(node));
            object.put(ELKConstant.TIME_KEY, time);
            jsons.add(object.toJSONString());
            node.getAlarmMsg().children = children;
        }
        String[] jsonArray = new String[jsons.size()];
        jsons.toArray(jsonArray);
        return jsonArray;
    }


    public static int encodeItem(AlarmMsg item, int id, int parant, int level, List<AlarmMsgErrorNode<AlarmMsg>> result, String analysisId, String processKey) {
        int lastId = id + 1;

        //AlarmMsgErrorNode node = new AlarmMsgErrorNode(lastId, parant, item);
        AlarmMsgErrorNode<AlarmMsg> node = new AlarmMsgErrorNode<>(analysisId, processKey, lastId, parant, item);
        result.add(node);
//		for(int i=0;i<level;i++){
//			System.out.print("--");
//		}
        List<AlarmMsg> children = item.getChildren();
        parant = lastId;
        for (AlarmMsg child : children) {
            lastId = encodeItem(child, lastId, parant, level + 1, result, analysisId, processKey);
        }
        return lastId;
    }

    public static AlarmMsgChain buildTree(List<AlarmMsgErrorNode> list) {
        AlarmMsgChain<AlarmMsg> alarmMsgChain = new AlarmMsgChain<>();
        Collections.sort(list, new Comparator<AlarmMsgErrorNode>() {

            @Override
            public int compare(AlarmMsgErrorNode o1, AlarmMsgErrorNode o2) {
                if (o1.getParantId() == o2.getParantId()) {
                    return o1.getOwnerId() - o2.getOwnerId();
                }
                return o1.getParantId() - o2.getParantId();
            }


        });
        Map<Integer, AlarmMsgErrorNode<AlarmMsg>> map = new HashMap<>();
        for (AlarmMsgErrorNode<AlarmMsg> node : list) {
            map.put(node.getOwnerId(), node);

        }


        if (list.size() > 0) {
            AlarmMsg root = new AlarmMsg();
            for (AlarmMsgErrorNode<AlarmMsg> node : list) {
                AlarmMsg am = node.getAlarmMsg();
                Integer parantId = node.getParantId();
                am.children = new ArrayList<>();
                if (parantId == 0) {
                    root.add(am);
                    alarmMsgChain.add(am);
                } else {
                    AlarmMsgErrorNode<AlarmMsg> node2 = map.get(parantId);
                    AlarmMsg parantAm = node2.getAlarmMsg();
                    parantAm.add(am);
                }
            }

        }


        return alarmMsgChain;
    }


    public static void printMap(Map<MonitorAppInfo, AlarmMsgChain> map) {
        Set<MonitorAppInfo> keys = map.keySet();
        for (MonitorAppInfo key : keys) {
            AlarmMsgChain trees = map.get(key);
            print(trees);
        }
    }

    public static void print(AlarmMsgChain<AlarmMsg> alarmMsgChain) {
        for (AlarmMsg item : alarmMsgChain) {
            printItem(item, 0);
        }
    }

    public static void printItem(AlarmMsg item, int level) {
//		for(int i=0;i<level;i++){
//			System.out.print("--");
//		}
//		System.out.println(item.getTotalCount()+"  "+item.toString());
        List<AlarmMsg> children = item.getChildren();
        for (AlarmMsg child : children) {
            printItem(child, level + 1);
        }
    }


    @Override
    public String toString() {
        return "AlarmMsgErrorNode [analysisId=" + analysisId + ", processKey=" + processKey + ", ownerId=" + ownerId
                + ", parantId=" + parantId + ", modelType=" + "]";
    }


    public String getAnalysisId() {
        return analysisId;
    }


    public void setAnalysisId(String analysisId) {
        this.analysisId = analysisId;
    }


    public String getProcessKey() {
        return processKey;
    }


    public void setProcessKey(String processKey) {
        this.processKey = processKey;
    }


    public Integer getOwnerId() {
        return ownerId;
    }


    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }


    public Integer getParantId() {
        return parantId;
    }


    public void setParantId(Integer parantId) {
        this.parantId = parantId;
    }


    public AlarmMsg getAlarmMsg() {
        return alarmMsg;
    }


    public void setAlarmMsg(T alarmMsg) {
        this.alarmMsg = alarmMsg;
    }


    /**
     * 获取测试数据
     *
     * @return
     */
    private static Map<MonitorAppInfo, AlarmMsgChain> getData() {

        Map<MonitorAppInfo, AlarmMsgChain> alarmMsgChainMap = new HashMap<MonitorAppInfo, AlarmMsgChain>();

        MonitorAppInfo appInfo = new MonitorAppInfo();
        appInfo.setClientname("appName1");
        MonitorAppInfo appInfo2 =  new MonitorAppInfo();
        appInfo2.setClientname("appName2");

        alarmMsgChainMap.put(appInfo, getAlarmMsgChain());
        alarmMsgChainMap.put(appInfo2, getAlarmMsgChain());

        return alarmMsgChainMap;
    }

    private static AlarmMsgChain getAlarmMsgChain() {
        AlarmMsgChain alarmMsgChain = new AlarmMsgChain<>();
        QueueBlockAlarm node1 = new QueueBlockAlarm();
        node1.setTotalCount(1);
        QueueBlockAlarm node2 = new QueueBlockAlarm();
        node2.setTotalCount(2);
        QueueBlockAlarm node3 = new QueueBlockAlarm();
        node3.setTotalCount(3);
        QueueBlockAlarm node4 = new QueueBlockAlarm();
        node4.setTotalCount(4);
        node1.add(node2);
        node1.add(node3);
        node3.add(node4);


        RpcAlarm node5 = new RpcAlarm();
        node5.setTotalCount(5);
        RpcAlarm node6 = new RpcAlarm();
        node6.setTotalCount(6);
        RpcAlarm node7 = new RpcAlarm();
        node7.setTotalCount(7);
        RpcAlarm node8 = new RpcAlarm();
        node8.setTotalCount(8);

        node5.add(node6);
        node5.add(node7);
        node7.add(node8);
        node8.add(node4);


        alarmMsgChain.add(node1);
        alarmMsgChain.add(node5);

        return alarmMsgChain;
    }


}
