package com.yy.aomi.analysis.common.model.alarm;

import com.alibaba.fastjson.annotation.JSONField;
import com.yy.aomi.analysis.common.constant.AlarmLevel;
import com.yy.aomi.analysis.common.model.analysis.MonitorAppInfo;
import com.yy.aomi.common.model.proto.ModelContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by chengaochang on 2017/3/13.
 */
public class AlarmMsg {
    protected int level = AlarmLevel.ERROR;
    protected String treeId;
    protected String modelId;
    protected int modelType;
    protected int errorType;
    protected String className;
    protected long totalCount;
    protected long errorCount;
    protected long beginTime;
    protected long reportTime;
    protected List<UriInvokeInfo> uriList = new ArrayList<>();
    public List<AlarmMsg> children = new ArrayList<AlarmMsg>();
    protected boolean isMerge;
    protected ModelContext context;
    protected ErrorDetail detail;//发生错误时的详细上报及统计数据

    @JSONField(serialize = false)
    protected MonitorAppInfo app;

    public AlarmMsg() {
        this.className = getClass().getName();
    }


    public void add(AlarmMsg alarm) {
        if (alarm != null) {
            children.add(alarm);
        }

    }

    public void addAll(List<AlarmMsg> alarms) {
        if (alarms != null) {
            children.addAll(alarms);
        }
    }


    public boolean isMerge() {
        return isMerge;
    }

    public void setIsMerge(boolean isMerge) {
        this.isMerge = isMerge;
    }

    public long getReportTime() {
        return reportTime;
    }

    public void setReportTime(long reportTime) {
        this.reportTime = reportTime;
    }

    public String getClassName() {
        return className;
    }

    public long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public List<UriInvokeInfo> getUriList() {
        return uriList;
    }

    public void setUriList(List<UriInvokeInfo> uriList) {
        this.uriList = uriList;
    }

    public long getErrorCount() {
        return errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public List<AlarmMsg> getChildren() {
        return children;
    }

    public MonitorAppInfo getApp() {
        return app;
    }

    public void setApp(MonitorAppInfo app) {
        this.app = app;
    }


    public int getErrorType() {
        return errorType;
    }

    public void setErrorType(int errorType) {
        this.errorType = errorType;
    }

    public AlarmMsg newInstance() {
        AlarmMsg alarmMsg = null;
        try {
            alarmMsg = (AlarmMsg) BeanUtils.cloneBean(this);
            List<UriInvokeInfo> newList = new ArrayList<>();
            for (UriInvokeInfo uta : getUriList()) {
                UriInvokeInfo uriAlarmInfo = new UriInvokeInfo(uta.getUri(), uta.getCount(), uta.getErrorCount(), uta.getTotalTime(), uta.getThProcTl(),uta.getRpcHost());
                uriAlarmInfo.setThreadUseRate(uta.getThreadUseRate());
                newList.add(uriAlarmInfo);
            }
            alarmMsg.setUriList(newList);
        } catch (Exception e) {
            throw new RuntimeException("AlarmMsg cloneBean fail",e);
        }
        return alarmMsg;
    }


    public String getModelId() {
        return modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public int getModelType() {
        return modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public void setChildren(List<AlarmMsg> children) {
        this.children = children;
    }

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public boolean hasChildren() {
        return CollectionUtils.isEmpty(children) == false;
    }

    public long getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public ModelContext getContext() {
        return context;
    }

    public void setContext(ModelContext context) {
        this.context = context;
    }

    public ErrorDetail getDetail() {
        return detail;
    }

    public void setDetail(ErrorDetail detail) {
        this.detail = detail;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public String toString() {
        return "AlarmMsg{" +
                "level=" + level +
                ", treeId='" + treeId + '\'' +
                ", modelId='" + modelId + '\'' +
                ", modelType=" + modelType +
                ", errorType=" + errorType +
                ", className='" + className + '\'' +
                ", totalCount=" + totalCount +
                ", errorCount=" + errorCount +
                ", beginTime=" + beginTime +
                ", reportTime=" + reportTime +
                ", uriList=" + uriList +
                ", children=" + children +
                ", isMerge=" + isMerge +
                ", context=" + context +
                ", detail=" + detail +
                ", app=" + app +
                '}';
    }
}
