package com.yy.aomi.analysis.common.dao.mysql.jpa;

import com.yy.aomi.analysis.common.model.entity.mysql.UniqueId;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.LockModeType;

/**
 * create by zhangzhibin(909074682)
 * 2018/9/25
 */
public interface UniqueIdRepository extends CrudRepository<UniqueId,Integer> {

    /**加锁，保证同一时间，只能单个线程在读取
     * @param srvName
     * @return
     * @throws Exception
     */
    @Transactional
    @Lock(LockModeType.PESSIMISTIC_WRITE)
    UniqueId findBySrvName(String srvName) throws Exception;

}
