package com.yy.aomi.analysis.common.dao.mysql.impl;

import com.yy.aomi.analysis.common.dao.mysql.jpa.UniqueIdRepository;
import com.yy.aomi.analysis.common.model.entity.mysql.UniqueId;
import com.yy.aomi.common.util.JavaDeflate;
import com.yy.aomi.analysis.common.dao.mysql.IUniqueIdDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.concurrent.atomic.AtomicLong;

/**短链接相关的dao
 * create by zhangzhibin(909074682)
 * 2018/9/25
 */
@Repository
public class UniqueIdDaoImpl implements IUniqueIdDao {

    private static Logger logger = LoggerFactory.getLogger(UniqueIdDaoImpl.class);
    @Autowired
    UniqueIdRepository repository;

    private AtomicLong order = new AtomicLong(0);
    private Long baseId;
    private long batchSize = 1000;

    /**这是个事务，先取值，然后修改保存，是一个原子操作，整个流程没完成之前，不允许别的进程读取该行记录，@Transactional注解不可删除
     * @return
     * @throws Exception
     */
    @Override
    @Transactional
    public long getUniqueId() throws Exception {
        UniqueId uniqueId = repository.findBySrvName("aomi");
        long value = uniqueId.getValue();
        logger.info(Thread.currentThread().getName()+" value="+value);
        uniqueId.setValue(value+batchSize);
        repository.save(uniqueId);

        return value;
    }

    @Override
    public String getUniqueId2Base64() throws Exception {
        if(baseId == null || order.get()>=batchSize){
            synchronized (this){
                if(baseId == null || order.get()>=batchSize){
                    baseId = getUniqueId();
                    order.set(0);
                }
            }
        }
        long result = baseId+order.getAndAdd(1);
        return JavaDeflate.encodeBase64(result);
    }
}
