package com.yy.aomi.analysis.common.dao.mysql.impl;

import com.yy.aomi.analysis.common.dao.mysql.ISerCallChainDao;
import com.yy.aomi.analysis.common.dao.mysql.jpa.SerCallChainRepository;
import com.yy.aomi.analysis.common.model.entity.mysql.SerCallChain;
import org.apache.commons.collections.IteratorUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * create by zhangzhibin(909074682)
 * 2018/9/25
 */
@Repository
public class SerCallChainDaoImpl implements ISerCallChainDao {

    @Autowired
    SerCallChainRepository repository;


    @Override
    @Transactional
    public int deleteOverdue(Date modifyTime) throws Exception {
        return repository.deleteAllByModifyTimeLessThan(modifyTime);
    }

    @Override
    public List<String> queryAllChainkey() throws Exception {
        List<String> result = new ArrayList<>(10000);
        repository.findAll().iterator().forEachRemaining(item -> result.add(item.getChainKey()));
        return result;
    }

    @Override
    @Transactional
    public int insertCallChains(List<SerCallChain> procCallChainList) throws Exception {
//        procCallChainList.forEach(item->repository.save(item));
        repository.saveAll(procCallChainList);
        return procCallChainList.size();
    }

    @Override
    @Transactional
    public int updateCallChains(List<SerCallChain> procCallChainList) throws Exception {
        repository.saveAll(procCallChainList);
        return procCallChainList.size();
    }

    @Override
    @Transactional
    public int deleteCallChains(List<String> procCallChainList) throws Exception {
        return repository.deleteByChainKeyIn(procCallChainList);
    }

//    @Override
//    public List<ProcCallChain> queryChains(String businessId) throws Exception {
//        return null;
//    }
//
//    @Override
//    public List<ProcCallChain> queryChainsByClientname(String clientname) throws Exception {
//        return null;
//    }

    @Override
    public List<SerCallChain> queryAll() throws Exception {
        return IteratorUtils.toList(repository.findAll().iterator(),10000);
    }
}
