package com.yy.aomi.analysis.common.dao.es;

import com.yy.aomi.elastic.ElasticSearchImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**初始化es实现
 * create by zhangzhibin(909074682)
 * 2018/9/25
 */
@Configuration
public class EsConfig {

    @Value("${elasticsearch.cluster_name}")
    String cluster_name;
    @Value("${elasticsearch.elastic_hosts}")
    String elastic_hosts;

    @Bean
    public ElasticSearchImpl getElasticSearchImpl() throws Exception{
        ElasticSearchImpl elasticSearch = new ElasticSearchImpl();
        elasticSearch.setCluster_name(cluster_name);
        elasticSearch.setElastic_hosts(elastic_hosts);
        elasticSearch.initEs();
        return elasticSearch;
    }

}
