package com.yy.aomi.analysis.common.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by chengaochang on 2017/3/7.
 * 错误模型如下：
 * 队列堵 （handleModel覆盖）
 * 同步阻塞未返回 （线程监控模型覆盖）
 * 同步处理超时 （RPC模型）
 * 连接中断事件统计 （RPC模型）
 * 连接不上事件统计 （RPC模型）
 * 处理慢
 * 请求量异常
 */
public class ErrorDefinition {

    private static Map<Integer,String> errorMsgMap = new HashMap<>();

    static {
        errorMsgMap.put(2,"队列堵");
        errorMsgMap.put(3,"线程处理超时");
        errorMsgMap.put(25,"RPC超时");
        errorMsgMap.put(27,"网络丢包");
        errorMsgMap.put(31,"网络传输慢");
        errorMsgMap.put(32,"对端处理慢");
        errorMsgMap.put(33,"RPC连接失败");
        errorMsgMap.put(34,"RPC其它错误");
        errorMsgMap.put(61,"线程处理超时");
        errorMsgMap.put(62,"线程阻塞率高");
    }

    /**返回错误编码的中文名
     * @param errorCode
     * @return
     */
    public static String getErrorName(Integer errorCode){
        String result = errorMsgMap.get(errorCode);
        if(result == null){
            result = "未知错误";
        }
        return result;
    }

    public static final int UN_ERROR = 0;

    public static final int QUEUE_ERROR = 1;

    public static final int RPC_ERROR = 2;

    public static final int THREAD_HANDLE_ERROR = 3;

    public static final int DATABASE_ERROR = 4;

    public static final int MACHINE_ERROR = 5;


    /**
     * 1~20
     */
    public static class Queue {
        /**
         * 队列溢出*
         */
        public static final int OVERFLOW = 1;

        /**
         * 队列堵*
         */
        public static final int BLOCK = 2;

        /**
         * 处理超时*
         */
        public static final int HANDLE_TIMEOUT = 3;

        public static boolean isBlock(int error) {
            return error == BLOCK;
        }
    }

    /**
     * 21~60
     */
    public static class RPC {

        public static final int AVG_TIMEOUT = 21;

        public static final int ERROR_RATE_OVERFLOW = 22;

        public static final int ERROR_ADD_RATE_OVERFLOW = 23;

        public static final int CONNECT_TIMEOUT = 24;

        public static final int READ_TIMEOUT = 25;

        public static final int CONNECT_BROKEN = 26;

        public static final int LOSS_PACKETS = 27;//丢包

        public static final int INTERRUPT = 28;//中断

        public static final int SINGLE_FAULT = 29;//单点故障

        public static final int SINGLE_BLOCKED = 30;//单点不通

        public static final int TRANS_SLOW = 31;//网络传输慢
        /**
         * 处理慢
         */
        public static final int HANDLE_SLOW = 32;

        /**
         * 连接失败
         */
        public static final int CONNECT_FAIL = 33;

        /**
         * 其它错误
         */
        public static final int OTHER_ERROR = 34;
    }

    /**
     * 61~100
     */
    public static class ThreadHandle {
        /**
         * 调用超时
         */
        public static final int CALL_TIMEOUT = 61;

        /**
         * 线程阻塞率高
         */
        public static final int BLOCKING_RATE_HIGH = 62;

    }


    /**
     * 数据库告警错误类型101~150
     */
    public static class DataBase {
        public static final int MYSQL_MUT_LOCK = 101;//mysql被锁的线程数mysql_mut_lock

        public static final int MYSQL_SLAVE = 102;//MySQL_Slave

        public static final int MYSQL_MUT_ALIVE = 103;//mysql存活mysql_mut_alive

        public static final int MYSQL_MUT_SLAVE = 104;//mysql从库延迟mysql_mut_slave

        public static final int MYSHARD_SYNC_D_ALIVE = 105;//MyShard sync_d存活

        public static final int REDIS_ERROR = 131;//待续

        public static final int MONGO_CONNECTIONS_CURRENT = 141;//connections.current

    }

    /**
     * 机器告警错误类型151~200
     */
    public static class Machine {
        public static final int DISK_SPACE_USE_RATE = 151;//磁盘空间使用率
        public static final int DISK_IO_USE_RATE = 152;// 磁盘IO使用率
        public static final int DISK_READ_ONLY = 153;// 硬盘只读
        public static final int DISK_SPACE_FULL = 162;// 磁盘空间已满


        public static final int ETH_IN = 154;//网卡入口流量(eth* in)
        public static final int ETH_OUT = 155;//网卡出口流量(eth* out)
        public static final int ETH_RATE = 156;//网卡速率
        public static final int ETH_BONDING = 157;//网卡bonding异常
        public static final int ETH_CON_SPEED = 158;// eth* speed（eth1 连接速度）
        public static final int IP_PING = 159;//Ip ping

        public static final int SYS_MEMORY_FREE = 160;//系统内存剩余量
        public static final int CPU_TOTAL_USE_RATE = 161;//机器cpu总利用率
        public static final int PROC_MEMORY_USE = 163;//进程内存使用量
        public static final int PROC_CPU_USE = 164;//进程cpu使用率
        public static final int PROC_EXCEPTION = 165;//进程异常告警
        public static final int LOAD_AVERAGE_5_MIN = 169;//Load average 5 min

        public static final int CRONTAB_HEARTBEAT = 167;//crontab心跳告警
        public static final int CRONTAB_STOP = 168;// /etc/crontab停止运行
    }


    public static boolean isError(int errorType) {
        return errorType != UN_ERROR;
    }

}
