package com.yy.aomi;

import com.yy.aomi.analysis.common.dao.mysql.*;
import com.yy.aomi.analysis.common.model.entity.mysql.BusinessSummary;
import com.yy.aomi.elastic.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;

import java.util.Date;

/**
 * create by zhangzhibin(909074682)
 * 2018/9/26
 */
//@EnableFeignClients
//@SpringBootApplication
public class CommonApplication  implements CommandLineRunner {

    private static Logger logger = LoggerFactory.getLogger(CommonApplication.class);

    @Value("${elasticsearch.cluster_name}")
    String val;

    @Autowired
    ISerCallChainDao serCallChainDao;


//    @Autowired
//    ElasticSearchImpl elasticSearch;

//    @Autowired
//    IBusinessServiceDao businessServiceDao;
//
    @Autowired
    IBusinessSummaryDao businessSummaryDao;
//
//    @Autowired
//    ILastOpsTimeDao lastOpsTimeDao;
//
//    @Autowired
//    ISerCallChainDao procCallChainDao;

    @Autowired
    IUniqueIdDao uniqueIdDao;

//    @Autowired
//    MachineClient client;
//
//    @Autowired
//    NetworkClient networkClient;

    public static void main(String[] args) throws Exception {
        SpringApplication.run(CommonApplication.class);

    }

    @Override
    public void run(String... args) throws Exception {

        try{
            BusinessSummary businessSummary = businessSummaryDao.getByBusinessId("24234234234");

//            testDeleteOverdueSerCallChain();
            System.out.println("----------end");
        }catch (Exception e){
            logger.error("error",e);
        }


    }


    public void testDeleteOverdueSerCallChain() throws Exception{
        Date date = new Date(System.currentTimeMillis() - 6*DateUtils.DAY);
        int size = serCallChainDao.deleteOverdue(date);
        System.out.println(size);
    }

    public void testConfig() throws Exception{
        System.out.println("---------"+val);
    }

    public void testMysqlUniqueId() throws Exception{
        testUnique();
        testUnique();
        testUnique();



    }

    public void testUnique() throws Exception{
        new Thread(()->{
            try{
                String size = uniqueIdDao.getUniqueId2Base64();
                logger.info(Thread.currentThread().getName()+" size="+size);
            }catch (Exception e){

            }

        }).start();
    }

//    public void testEs() throws Exception{
//        ESCondition condition = new ESCondition("logs","tiny-url");
//
//        long size = elasticSearch.count(condition);
//        System.out.println("--------------size = "+size);
//
//        System.out.println(client.getServerInfos("58.215.173.55"));
//
//        IdcNetworkQueryResult result = JSON.parseObject(networkClient.idc2idcDetail("10950","10950","2018-09-13 10:09","2018-09-13 16:09"),IdcNetworkQueryResult.class);
//        System.out.println("IdcNetworkQueryResult="+result);
//    }

    public void testMysqlBusinessService() throws Exception{
//        BusinessService bs = businessServiceDao.getByClientName("java.yymusic.idol-web");
//        System.out.println(bs.getCharge());
//        System.out.println("-----------");
//        List<BusinessService> list = businessServiceDao.getByBusinessId("16");
//        list.forEach(item-> System.out.println(item.getCharge()));

//        Thread.sleep(5000);
//        String bid = businessServiceDao.getBusinessIdByClientname("moneyquery");
//        System.out.println("bid="+bid);
    }

//    public void testMysqlBusinessSummary() throws Exception{
//        BusinessSummary bs = businessSummaryDao.getByBusinessId("7");
//        System.out.println("business="+bs.getBusiness());
//        System.out.println("--------");
//        List<BusinessSummary> list = businessSummaryDao.getAll();
//        list.forEach(item -> System.out.println(item.getBusiness()));
//    }

    public void testMysqlLastOption() throws Exception{
//        LastOpsTime lastOpsTime  = lastOpsTimeDao.getByType(1);
//        System.out.println("id="+lastOpsTime.getId());
//        LastOpsTime newOps = new LastOpsTime();
//        newOps.setLastTime(new Date());
//        newOps.setType(2);
//        newOps.setId(71);
//        lastOpsTimeDao.saveOrUpdate(newOps);

    }

    public void testMysqlProCall() throws Exception{
//        ProcCallChain procCallChain1 = new ProcCallChain();
//        procCallChain1.setChainKey("chainkey");
//        procCallChain1.setFirstNodeName("ch");
//        procCallChain1.setSize(1);
//        procCallChain1.setNodes("node");
//        procCallChain1.setTime(new Date());
//
//        ProcCallChain procCallChain2 = new ProcCallChain();
//        procCallChain2.setChainKey("chainkey2");
//        procCallChain2.setFirstNodeName("ch2");
//        procCallChain2.setSize(2);
//        procCallChain2.setNodes("node2");
//        procCallChain2.setTime(new Date());
//
//        List<ProcCallChain> list = new ArrayList<>();
//        list.add(procCallChain1);
//        list.add(procCallChain2);
//
//        procCallChainDao.insertCallChains(list);
//
//        int size = procCallChainDao.queryAllChainkey().size();
//        System.out.println("size="+size);


//        List<String> list = new ArrayList<>();
//        list.add("chainKey");
//        list.add("chainKey2");
//
//        int size = procCallChainDao.deleteCallChains(list);
//        System.out.println("---size="+size);


    }

}
