package com.yy.yylivesdk4cloud.video;


import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.view.SurfaceView;

import java.util.List;
import java.util.concurrent.TimeUnit;

import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.PublishVideoConfig;
import com.yy.mediaframework.VideoPublish;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.yylivesdk4cloud.BuildConfig;
import com.yy.yylivesdk4cloud.ExternalVideoSource;
import com.yy.yylivesdk4cloud.ThunderAPI;
import com.yy.yylivesdk4cloud.ThunderConstant;
import com.yy.yylivesdk4cloud.ThunderDefaultCamera;
import com.yy.yylivesdk4cloud.ThunderScreenCapture;
import com.yy.yylivesdk4cloud.ThunderVideoCapture;
import com.yy.yylivesdk4cloud.ThunderPreviewConfig;
import com.yy.yylivesdk4cloud.ThunderPlayerView;
import com.yy.yylivesdk4cloud.ThunderPreviewView;
import com.yy.yylivesdk4cloud.ThunderPublisher;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoConfigManager;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

/**
 * Created by xiaojun on 2018/1/4.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

/* 对应 C++ 代码的 ThunderVideoEngineImp 类 */
public class ThunderVideoEngineImp implements IPublishListener, ITextureListener {

    public static final int YYPUBLISH_VIDEO_STATE_NONE = 0;
    public static final int YYPUBLISH_VIDEO_STATE_PREVIEW = 1;
    public static final int YYPUBLISH_VIDEO_STATE_ENCODE = 2;

    HashMap<String, ThunderPlayerView> mVideoViewMap;
    HashMap<String, Long> mVideoViewStreamKeyAndIdMap;
    HashMap<String, Integer> mVideoScaleModeMap;
    HashMap<String, IVideoDecodeObserver> mVideoFrameObserverMap;
    HashMap<String, Boolean> mVideoFrameObserverEnableMap;
    private VideoPublish mPublisher = null;
    private long mCallBackPtr = 0;
    private boolean bMixMode = false;
    private ThunderVideoCapture mCapture;
    private OrangeFilterWrapper mOrangeFilterWrapper;

    private final static int VIDEO_STAT_FPS = 0;
    private final static int VIDEO_STAT_BITRATE = 1;
    private final static int VIDEO_STATE_RESOLUTION = 2;
    private VideoConfigManager mVideoConfigManager;
    private int mVideoPublishState = YYPUBLISH_VIDEO_STATE_NONE;
    private int mVideoPreviewState = YYPUBLISH_VIDEO_STATE_NONE;
    private YVideoPublishVideoConfig mCurrentVideoConfig = null;
    private Handler mUiHandler = null;
    private Map<String, WeakReference> mPlayViewAndStreamKeyMap = new HashMap<>();
    private VideoFrameYuvCapture mVideoFrameCapture = VideoFrameYuvCapture.getInstance();
    private ThunderVideoPlayListener mThunderVideoPlayListener = null;
    private boolean mIsEnableWebSdkCompatibility = false;
    private Boolean mScreenCaptureInited = false;
    private Boolean mOriginYuvCaptureInited = false;

    public ThunderVideoEngineImp() {
        //比拉取配置要早,异步检查硬编兼容性
        final CountDownLatch waitSync = new CountDownLatch(1);
		Runnable runTestVideoEncoderCrash = new Runnable() {
			@Override
			public void run() {
				try {
					YYVideoCodec.testVideoEncoderCrash();
				} catch (Exception e) {
					ThunderLog.error("ThunderVideoEngineImp", "testVideoEncoderCrash crash " + e.toString());
				}
				waitSync.countDown();
			}
		};
		new Thread(runTestVideoEncoderCrash).start();

		try{
			waitSync.await(500, TimeUnit.MILLISECONDS);
		}catch (Exception e){
			ThunderLog.error("ThunderVideoEngineImp", "testVideoEncoderCrash waitSync crash " + e.toString());
		}

    }

    public void init() {
        mVideoViewMap = new HashMap<String, ThunderPlayerView>();
        mVideoScaleModeMap = new HashMap<String, Integer>();
        mVideoViewStreamKeyAndIdMap = new HashMap<String, Long>();
        mVideoFrameObserverMap = new HashMap<String, IVideoDecodeObserver>();
        mVideoFrameObserverEnableMap = new HashMap<String, Boolean>();
        mPublisher = VideoPublish.getInstance();
        mVideoConfigManager = VideoConfigManager.instance();
        mThunderVideoPlayListener = new ThunderVideoPlayListener(YYVideoLibMgr.instance().getAppContext(), this);
        YYVideoLibMgr.instance().setVideoInfoListener(mThunderVideoPlayListener);
        mUiHandler = new android.os.Handler(Looper.getMainLooper());
        ThunderVideoConfig config = new ThunderVideoConfig();
        //YYVideoSDK.getInstance().enbaleSTLibrary(false);
        config.AsyncLoad();
    }

    public void setPreviewScaleMode(int scaleMode) {
        if (mPublisher != null) {
            mPublisher.setScaleMode(scaleMode);
        }
    }

    public static String getVideoEngineVersion() {
        return "Android: " + BuildConfig.YY_VIDEOLIB_VERSION
                + "&" + BuildConfig.YY_VIDEOPLAYER_VERSION;
    }

    public void updatePlayVideoStream(String streamKey, long streamId, final int streamType, boolean bSoftDecode) {
        ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream bSoftDecode ==" + Boolean.toString(bSoftDecode));
        //先拆掉前面的流程,releaseDecoder是传输拆掉，view是在setDecodeType里面拆掉重建
        final ThunderPlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            ThunderLog.warn("ThunderVideoEngineImp",
                    "updatePlayVideoStream: cann't find video view for stream:%s",
                    streamKey);
            return;
        }

        long oldStreamId = mVideoViewStreamKeyAndIdMap.get(streamKey) == null ? -1 : mVideoViewStreamKeyAndIdMap.get(streamKey);

        if ((bSoftDecode == true /*&& view.getViewType() != 0*/)) {
            ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream bSoftDecode == true, view == hard,need change");
            if(oldStreamId != -1){
                view.unLinkFromStream(oldStreamId);
            }

            if(Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()){
                view.prepareView(VideoConstant.DecoderType.SOFT_DEOCDER);
            }else {
                //新建程流
                final CountDownLatch barrier = new CountDownLatch(1);
                mUiHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        view.prepareView(VideoConstant.DecoderType.SOFT_DEOCDER);
                        barrier.countDown();
                    }
                });
                try {
                    barrier.await();
                } catch (InterruptedException e) {
                    ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
                }
            }
            ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);
            view.linkToStream(streamId);
        } else{
//         if(((mVideoConfigManager.getPlayViewTypeFromStream(streamType) == VideoConstant.DecoderType.SOFT_DEOCDER && view.getViewType() == 0 )||
//                mVideoConfigManager.getPlayViewTypeFromStream(streamType) == VideoConstant.DecoderType.ANDROID_HARD_DECODER1 && view.getViewType() == 1) &&
//                oldStreamId == streamId){
//            ThunderLog.info(ThunderLog.kLogTagVideo, "updatePlayVideoStream unchange stream:%s - %d - %d - %d", streamKey, streamId, oldStreamId, streamType);
//            return;
//        }
            ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream unlink stream:%s-%d", streamKey, oldStreamId);
            view.unLinkFromStream(oldStreamId);

            //新建流程
            setDecodeType(streamKey, streamType);

            ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);
            view.linkToStream(streamId);
        }

        String uid = String.valueOf(streamId >> 32);
        mVideoFrameObserverEnableMap.put(uid, true);

        int scaleMode = mVideoScaleModeMap.get(streamKey) == null ? -1 : mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream mVideoScaleModeMap can't find scaleMode in map :" + mVideoScaleModeMap.size());
            return;
        }
        view.setScaleMode(scaleMode);
        return;
    }

    public void setLowDelayMode(boolean mode){
        if( mCurrentVideoConfig != null  && mCurrentVideoConfig.bLowLatency != mode ){
            mPublisher.setLowDelayMode(mode);
            mCurrentVideoConfig.bLowLatency = mode;
        }

        ThunderLog.info("ThunderVideoEngineImp", "setLowDelayMode new mode " + mode + " old :" + (mCurrentVideoConfig != null ? mCurrentVideoConfig.bLowLatency : "null"));
    }

    public int setDecodeType(String streamKey, final int streamType) {
        final int decodeType = mVideoConfigManager.getPlayViewTypeFromStream(streamType);
        ThunderLog.info("ThunderVideoEngineImp", "setDecodeType streamKey " + streamKey + " type:" + streamType);
        if (mVideoConfigManager == null) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoConfigManager == null!");
            return -1;
        }
        int scaleMode = mVideoScaleModeMap.get(streamKey) == null ? -1 : mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find scaleMode in map :" + mVideoScaleModeMap.size());
            return -1;
        }

        final ThunderPlayerView view = mVideoViewMap.get(streamKey);
        if (mVideoViewMap.get(streamKey) == null) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find view in map :" + mVideoViewMap.size());
            return -1;
        }
        if(Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()){
            view.prepareView(decodeType);
        }else {
            final CountDownLatch barrier = new CountDownLatch(1);
            mUiHandler.post(new Runnable() {
                @Override
                public void run() {
                    view.prepareView(decodeType);
                    barrier.countDown();
                }
            });
            try {
                barrier.await();
            } catch (InterruptedException e) {
                ThunderLog.error("ThunderVideoEngineImp", "setDecodeType .barrier.await" + e.toString());
            }

        }
//		if (!bSuccess) {
//			ThunderLog.error("ThunderVideoEngineImp",
//					"setDecodeType: prepareView failed for " + streamType + " streamkey:" + streamKey);
//			return ;
//		}
        view.setScaleMode(scaleMode);
        ThunderLog.info("ThunderVideoEngineImp", streamKey + " setDecodeType success : scaleMode" + scaleMode + ", decodeType: " + decodeType);

        return (decodeType == VideoConstant.DecoderType.ANDROID_HARD_DECODER1 ? 1 : 0);
    }

    public boolean H265PlaySupport() {
        if (mVideoConfigManager == null) {
            return false;
        }
        ThunderLog.info("ThunderVideoEngineImp", "H265PlaySupport " + mVideoConfigManager.H265PlaySupport());
        return mVideoConfigManager.H265PlaySupport();
    }

    public boolean startVideoEngine() {
        return true;
    }

    public int getVideoDecodeTranscoding(int transcoding) {
        if (mVideoConfigManager == null) {
            return transcoding;
        }
        return mVideoConfigManager.getVideoDecodeTranscoding(transcoding);
    }


    public int getVideoEncodeTranscoding(int playType, int mode) {
        if (mVideoConfigManager == null) {
            return mode;
        }
        return mVideoConfigManager.getVideoEncodeTranscoding(playType, mode);
    }

    public boolean stopVideoEngine() {
        return true;
    }

    public void setVideoEngineCallBack(long ptr) {
        mCallBackPtr = ptr;
    }

    private boolean isUsingDefaultCamera() {
        return !bMixMode && (mCapture == null ? false : mCapture instanceof ThunderDefaultCamera);
    }

    public void attachVideoCapture(Object capture) {

        if(mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE ){
            if(mCapture != null && mCapture instanceof  ThunderScreenCapture){
                mPublisher.stopPublishScreenVideo();
            }else if(mCapture != null && mCapture.getClass() == ExternalVideoSource.class ){
                mPublisher.stopPublishLiveVideo();
            }else if(mCapture == null ||mCapture instanceof ThunderDefaultCamera){
               mPublisher.stopPublishLiveVideo();
            }
        }

        ThunderLog.info("ThunderVideoEngineImp", "detach capture: " + (mCapture == null ? "ThunderDefaultCamera" : mCapture.toString()) + " mVideoPublishState" + mVideoPublishState);

        mCapture = (ThunderVideoCapture) capture;
        ThunderLog.info("ThunderVideoEngineImp", "attach capture: " + mCapture.toString());

        if(mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE){
            //这里编码参数以startEncoder和update为准,和IOS对齐
//            int playType = mCurrentVideoConfig.playType;
//            if(mCapture instanceof ThunderScreenCapture){
//                playType = VideoLiveConfig.Type.SCREEN_CAPTURE;
//            }

            VideoEncoderConfig newEncoderConfig = getVideoEncoderConfigByType(mCurrentVideoConfig.playType , mCurrentVideoConfig.mode);

            List<ResolutionModifyConfig> resolutionModifyConfigs = new ArrayList<>();
            if (mCapture.getClass() == ThunderScreenCapture.class && ((ThunderScreenCapture) mCapture).isLandscap()) {
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;

                copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else if ((mCapture == null || mCapture.getClass() == ThunderDefaultCamera.class) &&
                    ((ThunderPreviewConfig) mCapture.getCaptureConfig()).captureOrientation ==
                    ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
                //横屏模式
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;

                copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            }else {
                copyResolutionModifyConfig(resolutionModifyConfigs);
            }
//            mPublisher.enableMirror(mCurrentVideoConfig.bMirrorFrontCamera);
            newEncoderConfig.mLowDelay = mCurrentVideoConfig.bLowLatency;

            mPublisher.setResolutionModifyConfigs(resolutionModifyConfigs, mVideoConfigManager.getCurrentIntervalSecs());

            if(mCapture instanceof ThunderScreenCapture) {
                if(mScreenCaptureInited == false){
                    ThunderScreenCapture thunderScreenCapture = (ThunderScreenCapture) mCapture;
                    mPublisher.initScreenLiveSession(thunderScreenCapture.getMediaProjection(), this, thunderScreenCapture.isLandscap());
                    mScreenCaptureInited = true;
                }

                mPublisher.startPublishScreenVideo("general", null, newEncoderConfig);
                ThunderLog.info("ThunderVideoEngineImp", "startPublishScreenVideo %dx%d %d %d %s %b %b",
                        newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate,
                        newEncoderConfig.mEncodeType.name(), mCurrentVideoConfig.bMirrorFrontCamera, newEncoderConfig.mLowDelay );
            }else if(mCapture != null && mCapture.getClass() == ExternalVideoSource.class){
                if(mOriginYuvCaptureInited == false){
                    ThunderLog.warn("ThunderVideoEngineImp", "startOriginDataCapture !");
                    mPublisher.startOriginDataCapture(null,this);
                    mCapture.startCapture(new ThunderPublisher.IVideoPublisher() {
                        @Override
                        public void pushVideoData(byte[] data, int format, int width, int height, int rotation, long timestamp) {
                            setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
                        }

                        @Override
                        public void pushVideoData(byte[] encodedData, ThunderConstant.ThunderVideoEncodeType type, long dts, long pts) {

                        }
                    });
                    mOriginYuvCaptureInited = true;
                }

                mPublisher.startPublishLiveVideo("general", null, newEncoderConfig);
                ThunderLog.info("ThunderVideoEngineImp", "startPublishLiveVideo yuv %dx%d %d %d %s %b %b",
                        newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate,
                        newEncoderConfig.mEncodeType.name(), mCurrentVideoConfig.bMirrorFrontCamera, newEncoderConfig.mLowDelay );

            }else {
                mPublisher.startPublishLiveVideo("general", null, newEncoderConfig);
                ThunderLog.info("ThunderVideoEngineImp", "startPublishLiveVideo %dx%d %d %d %s %b %b",
                        newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate,
                        newEncoderConfig.mEncodeType.name(), mCurrentVideoConfig.bMirrorFrontCamera, newEncoderConfig.mLowDelay );

            }
        }
    }

    private CameraPreviewConfig getCameraPreviewConfigByType(int playType, int previewMode) {
        CameraPreviewConfig result = mVideoConfigManager.getCameraPreviewConfigByType(playType, previewMode);
        ThunderLog.info("ThunderVideoEngineImp", "getCameraPreviewConfigByType:" + result.toString());
        return result;
    }

    private int getBeautyLevelInCurrentConfig() {
        int result = 0;
        if (mVideoConfigManager != null) {
            result = mVideoConfigManager.getCurrentBeautifyLevel();
        }

        ThunderLog.info("ThunderVideoEngineImp", "getBeautyLevelInCurrentConfig:" + result);
        return result;
    }

    private boolean getPreviewShareCtxConfig() {
        boolean result = true;
        if (mVideoConfigManager != null) {
            result = mVideoConfigManager.getPreviewShareCtxSupport();
        }

        ThunderLog.info("ThunderVideoEngineImp", "getPreviewShareCtxConfig:" + result);
        return result;
    }

    private boolean getUseClear() {
        boolean result = true;
        if (mVideoConfigManager != null) {
            result = mVideoConfigManager.getUseClear();
        }

        ThunderLog.info("ThunderVideoEngineImp", "getUseClear:" + result);
        return result;
    }

    private VideoEncoderConfig getVideoEncoderConfigByType(int playType, int mode) {
        VideoEncoderConfig result = mVideoConfigManager.getVideoEncodeConfigByType(playType, mode);
        ThunderLog.info("ThunderVideoEngineImp", "getVideoEncoderConfigByType:" + result.toString());
        return result;
    }

    private boolean checkLowDelayByType(int playType) {
        return mVideoConfigManager.checkLowDelayByType(playType);
    }

    private CameraPreviewConfig toCamerePreviewConfig(ThunderPreviewConfig config) {
        CameraPreviewConfig newConf = new CameraPreviewConfig(CameraPreviewConfig.PREVIEW_MODE_NORMAL);
        newConf.mCaptureResolutionWidth = config.captureResolutionWidth;
        newConf.mCaptureResolutionHeight = config.captureResolutionHeight;
        newConf.mCameraPosition = config.cameraPosition;
        newConf.mCaptureFrameRate = config.captureFrameRate;
        newConf.mCaptureOrientation = config.captureOrientation;
        return newConf;
    }

    public YVideoPublishVideoConfig setOrientation(int orientatin) {
        ThunderLog.info("ThunderVideoEngineImp", " setOrientation " + orientatin);
        if (mCapture != null && mCapture instanceof ThunderScreenCapture) {
            ThunderScreenCapture thunderScreenCapture = (ThunderScreenCapture) mCapture;
            if ((thunderScreenCapture.isLandscap() && orientatin != ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) ||
                    (!thunderScreenCapture.isLandscap()) && (orientatin != ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT)) {
                stopEncodeVideo();
                thunderScreenCapture.setIslandScape(orientatin == ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE);
                startEncodeVideo(mCurrentVideoConfig.bMirrorFrontCamera, mCurrentVideoConfig.bLowLatency, mCurrentVideoConfig.playType, mCurrentVideoConfig.mode);
            }

            return mCurrentVideoConfig;
        } else {

            ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
            ThunderPreviewConfig config = (ThunderPreviewConfig) camera.getCaptureConfig();
            if (orientatin != config.captureOrientation) {
                //横竖屏变换
                config.captureOrientation = orientatin;
                config.captureResolutionWidth = config.captureResolutionWidth + config.captureResolutionHeight;
                config.captureResolutionHeight = config.captureResolutionWidth - config.captureResolutionHeight;
                config.captureResolutionWidth = config.captureResolutionWidth - config.captureResolutionHeight;
                camera.setCaptureConfig(config);
            }

            if((mCapture != null && mCapture instanceof ThunderScreenCapture && mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE && mVideoPreviewState == YYPUBLISH_VIDEO_STATE_PREVIEW) ||
                    (mCapture == null && mVideoPublishState != YYPUBLISH_VIDEO_STATE_ENCODE && mVideoPreviewState == YYPUBLISH_VIDEO_STATE_PREVIEW)){
                //预览开启，但是开播为录屏，此时只更新预览; 或者预览开启
                mPublisher.updateCameraPreviewParam(toCamerePreviewConfig(config));
            }else {

                boolean recover = mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE ? true : false;

                stopEncodeVideo();
                mPublisher.updateCameraPreviewParam(toCamerePreviewConfig(config));
                if(mCurrentVideoConfig != null && recover){
                    startEncodeVideo(mCurrentVideoConfig.bMirrorFrontCamera, mCurrentVideoConfig.bLowLatency, mCurrentVideoConfig.playType, mCurrentVideoConfig.mode);
                }
            }

            if (mCurrentVideoConfig != null) {
                mCurrentVideoConfig.orientation = orientatin;
                mCurrentVideoConfig.encodeResolutionWidth = mCurrentVideoConfig.encodeResolutionWidth + mCurrentVideoConfig.encodeResolutionHeight;
                mCurrentVideoConfig.encodeResolutionHeight = mCurrentVideoConfig.encodeResolutionWidth - mCurrentVideoConfig.encodeResolutionHeight;
                mCurrentVideoConfig.encodeResolutionWidth = mCurrentVideoConfig.encodeResolutionWidth - mCurrentVideoConfig.encodeResolutionHeight;
            }

            if (mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE) {
                return mCurrentVideoConfig;
            } else {
                return null;
            }
        }
    }

    public int startPreview(Object toView, int playType, int publishMode) {
        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        ThunderPreviewConfig config = (ThunderPreviewConfig) camera.getCaptureConfig();

        mPublisher.setPhonePerformanceLevel(getBeautyLevelInCurrentConfig());
        mPublisher.setPreviewShreCtxCfg(getPreviewShareCtxConfig());
        mPublisher.setUseGLClear(getUseClear());


        CameraPreviewConfig newConfig = getCameraPreviewConfigByType(playType, publishMode);
        newConfig.mCameraPosition = ((ThunderPreviewConfig) camera.getCaptureConfig()).cameraPosition;
        if (config.captureOrientation ==  ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
            //横屏模式
            int mid = newConfig.mCaptureResolutionWidth;
            newConfig.mCaptureResolutionWidth = newConfig.mCaptureResolutionHeight;
            newConfig.mCaptureResolutionHeight = mid;

        }

        if (mVideoFrameCapture != null) {
            mVideoFrameCapture.updateVideoCaptureFrameInfo(newConfig.mCaptureResolutionWidth, newConfig.mCaptureResolutionHeight);
        }

        newConfig.mCaptureOrientation = config.captureOrientation;
        mPublisher.startPreviewWithView(((ThunderPreviewView) toView).getSurfaceView(),
                newConfig, this);

        if (camera.getCameraDataCallback() != null) {
            ThunderLog.info("ThunderVideoEngineImp", "setTextureListener %s %s",
                    camera.getCameraDataCallback().toString(), this.toString());
            mPublisher.setTextureListener(this);
        }
        mOrangeFilterWrapper = mPublisher.getOrangeFilterWrapperObject();

        //同步当前camera的config
        config.captureFrameRate = newConfig.mCaptureFrameRate;
        config.captureResolutionHeight = newConfig.mCaptureResolutionHeight;
        config.captureResolutionWidth = newConfig.mCaptureResolutionWidth;
        camera.setCaptureConfig(config);

        mVideoPreviewState = YYPUBLISH_VIDEO_STATE_PREVIEW;

        if(mCapture != null && mCapture.getClass() == ThunderDefaultCamera.class && mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE){
            //这里说明attach过,且当前attach是摄像头, 并处于开播状态这时候直接开播
            ThunderLog.info("ThunderVideoEngineImp", "startPreview attach camera SO publish:" + playType +":" + publishMode);
            startEncodeVideo(false,false,playType,publishMode);
        }

        return 0;
    }


    public void setOriginFrameToEncode(final byte[] data, final int format, final int width, final int height,final int rotation,final long timestamp){
        if(mPublisher != null ){
            mPublisher.setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
        }
    }

    public int stopPreview() {
        if (mVideoPreviewState != YYPUBLISH_VIDEO_STATE_PREVIEW) {
            ThunderLog.info("ThunderVideoEngineImp", "stopPreview previewState wrong:" + mVideoPublishState);
        }
        mVideoPreviewState = YYPUBLISH_VIDEO_STATE_NONE;
        return mPublisher.stopPreview();
    }

    /**
     * 从配置中心提取配置开播
     *
     * @param bMirrorFrontCamera 镜像
     * @param bLowLatency        低延时
     * @param playType           玩法
     * @param mode               模式
     * @return 实际使用的编码参数
     */
    public YVideoPublishVideoConfig startEncodeVideo(
            boolean bMirrorFrontCamera,
            boolean bLowLatency,
            int playType,
            int mode) {
            //以playtype为主
//        if(mCapture != null && mCapture.getClass() == ThunderScreenCapture.class){
//            ThunderLog.info("ThunderVideoEngineImp", "updatePublishVideoConfig change playType from %d :%d", playType, VideoLiveConfig.Type.SCREEN_CAPTURE);
//            playType = VideoLiveConfig.Type.SCREEN_CAPTURE;
//        }

        VideoEncoderConfig newEncoderConfig = getVideoEncoderConfigByType(playType, mode);
        List<ResolutionModifyConfig> resolutionModifyConfigs = new ArrayList<>();
        if (mCapture != null && mCapture.getClass() == ThunderScreenCapture.class && ((ThunderScreenCapture) mCapture).isLandscap()) {
            int mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;

            copyResolutionModifyConfigReverse(resolutionModifyConfigs);
        } else if ((mCapture == null || mCapture.getClass() == ThunderDefaultCamera.class) &&
                ((ThunderPreviewConfig) ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).captureOrientation ==
                ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
                //横屏模式
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;

                copyResolutionModifyConfigReverse(resolutionModifyConfigs);
        }else {
            copyResolutionModifyConfig(resolutionModifyConfigs);
        }

        if (mIsEnableWebSdkCompatibility) {
            newEncoderConfig.mLowDelay = true;
        } else {
            newEncoderConfig.mLowDelay = checkLowDelayByType(playType);
        }

        ThunderLog.info("ThunderVideoEngineImp", "startPublishVideo %dx%d %d %d %s %b %b",
                newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate,
                newEncoderConfig.mEncodeType.name(), bMirrorFrontCamera, newEncoderConfig.mLowDelay );


        if (mCapture != null && mCapture.getClass() == ThunderScreenCapture.class && mScreenCaptureInited == false) {
            // 录屏
            ThunderScreenCapture thunderScreenCapture = (ThunderScreenCapture) mCapture;
            mPublisher.initScreenLiveSession(thunderScreenCapture.getMediaProjection(), this, thunderScreenCapture.isLandscap());
            mScreenCaptureInited = true;
        }

        //设置动态分辨率
        mPublisher.setResolutionModifyConfigs(resolutionModifyConfigs, mVideoConfigManager.getCurrentIntervalSecs());
        int ret = -1;
        if( mCapture != null && mCapture instanceof ThunderScreenCapture){
            ret  = mPublisher.startPublishScreenVideo("general", null, newEncoderConfig);
        }else {
            ret  = mPublisher.startPublishLiveVideo("general", null, newEncoderConfig);
        }


        if (ret == 0) {
            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }

            int videoLevel = mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;

            if (mCurrentVideoConfig == null) {
                mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth,
                        newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }

            mCurrentVideoConfig.bLowLatency = newEncoderConfig.mLowDelay;
            mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
            mCurrentVideoConfig.playType = playType;
            mCurrentVideoConfig.mode = videoLevel;
            mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            mCurrentVideoConfig.bHardwareEncoder = hard;
            mCurrentVideoConfig.encodeType = encodeType;

            mCurrentVideoConfig.orientation = mCurrentVideoConfig.encodeResolutionWidth > mCurrentVideoConfig.encodeResolutionHeight ?
                    ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE : ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT;
        }

        if (mVideoPublishState != YYPUBLISH_VIDEO_STATE_PREVIEW) {
            ThunderLog.info("ThunderVideoEngineImp", "startPublishVideo videoState wrong:" + mVideoPublishState);
        }
        mVideoPublishState = YYPUBLISH_VIDEO_STATE_ENCODE;
        return mCurrentVideoConfig;
    }

    public int stopEncodeVideo() {
        ThunderLog.info("ThunderVideoEngineImp", "stopEncodeVideo ....");
        mVideoConfigManager.resetCurrentVideoLiveConfig();
        if (mVideoPublishState != YYPUBLISH_VIDEO_STATE_ENCODE) {
            ThunderLog.info("ThunderVideoEngineImp", "stopEncodeVideo videoState wrong:" + mVideoPublishState);
        }
        mVideoPublishState = YYPUBLISH_VIDEO_STATE_NONE;
        mPublisher.stopPublishVideo();

        if(mOriginYuvCaptureInited){
            mPublisher.stopOriginDataCapture();
            mCapture.stopCapture();
            mOriginYuvCaptureInited = false;
        }

        if (mScreenCaptureInited) {
            mPublisher.deInitScreenLiveSession();
            mScreenCaptureInited = false;
        }
        return 0;
    }


    public void changeScreenLiveMode(boolean pictureMode, Object bitmap) {
        mPublisher.changeScreenLiveMode(pictureMode, (Bitmap) bitmap);
    }

    public int startPlayVideoStream(String streamKey,
                                    Object toView,
                                    int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return -1;
        }
        ThunderPlayerView view = (ThunderPlayerView) toView;
        ThunderLog.info("ThunderVideoEngineImp", "startPlayVideoStream " + streamKey + " scaleMode:" + scaleMode);

        mVideoScaleModeMap.put(streamKey, scaleMode);
        mVideoViewMap.put(streamKey, view);
        YYVideoLibMgr.instance().setUseClear(getUseClear());
        return 0;
    }

    public int stopPlayVideoStream(String streamKey) {
        final ThunderPlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            return -1;
        }
        ThunderLog.info("ThunderVideoEngineImp", "stopPlayVideoStream" + streamKey);
        view.unLinkFromStream();

        if(Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()){
            view.unPrepareView();
        }else {
            mUiHandler.post(new Runnable() {
                @Override
                public void run() {
                    view.unPrepareView();
                }
            });
        }
        mVideoViewMap.remove(streamKey);
        mVideoViewStreamKeyAndIdMap.remove(streamKey);
        return 0;
    }

    public void setPlayVideoViewScaleMode(Object toView, int scaleMode){
        String streamKey = null;
        if(toView == null) {
            return;
        }
        Set<Map.Entry<String, ThunderPlayerView>> entrySet = mVideoViewMap.entrySet();
        Iterator<Map.Entry<String, ThunderPlayerView>> it = entrySet.iterator();
        while (it.hasNext()){
            Map.Entry<String, ThunderPlayerView> me = it.next();
            if(toView.equals(me.getValue())){
                streamKey = me.getKey();
                mVideoScaleModeMap.put(streamKey, scaleMode);
                me.getValue().setScaleMode(scaleMode);
                return;
            }
        }
        ThunderLog.warn("ThunderVideoEngineImp", "setPlayVideoViewScaleMode toView is not found!");
        return;
    }

    public void setVideoFrameObserver(String uid, Object observer){

        if(observer == null){
            ThunderLog.info("ThunderVideoEngineImp", "setVideoFrameObserver remove " + uid + " ->" + observer);
            mVideoFrameObserverMap.remove(uid);
            mVideoFrameObserverEnableMap.remove(uid);
        }else {
            ThunderLog.info("ThunderVideoEngineImp", "setVideoFrameObserver " + uid + " ->" + observer);
            mVideoFrameObserverMap.put(uid, (IVideoDecodeObserver) observer);
        }
    }

    public boolean updatePlayVideoView(String streamKey, Object toView, int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return false;
        }

        ThunderPlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            return false;
        }

        if (!view.equals(toView)) {
            ThunderLog.warn("ThunderVideoEngineImp", "may toView is change!");
            return false;
        }
        mVideoScaleModeMap.put(streamKey, scaleMode);
        ThunderLog.debug("ThunderVideoEngineImp", "update play scale mode: " + scaleMode);
        return view.setScaleMode(scaleMode);
    }


    private void copyResolutionModifyConfig( List<ResolutionModifyConfig> dst){
        if(mVideoConfigManager.getCurrentModifyConfig() != null && mVideoConfigManager.getCurrentModifyConfig().size() > 0){
            for (int i = 0; i < mVideoConfigManager.getCurrentModifyConfig().size(); i++) {
                ResolutionModifyConfig tmp = new ResolutionModifyConfig( mVideoConfigManager.getCurrentModifyConfig().get(i).width,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).height,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).minCodeRate,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).maxCodeRate,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).minFrameRate,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).maxFrameRate,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).videoEncoderType,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).encoderParams );
                dst.add(tmp);
            }
        }
    }

    private void copyResolutionModifyConfigReverse( List<ResolutionModifyConfig> dst){
        if(mVideoConfigManager.getCurrentModifyConfig() != null && mVideoConfigManager.getCurrentModifyConfig().size() > 0){
            for (int i = 0; i < mVideoConfigManager.getCurrentModifyConfig().size(); i++) {
                ResolutionModifyConfig tmp = new ResolutionModifyConfig( mVideoConfigManager.getCurrentModifyConfig().get(i).height,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).width,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).minCodeRate,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).maxCodeRate,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).minFrameRate,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).maxFrameRate,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).videoEncoderType,
                        mVideoConfigManager.getCurrentModifyConfig().get(i).encoderParams );
                dst.add(tmp);
            }
        }
    }

    /**
     * *  更新预览和开播参数,从配置中心中依据playType 和 mode 匹配详细的参数值
     *
     * @param bMirrorFrontCamera 镜像开启
     * @param bLowLatency        低延时
     * @param playType           玩法{@link com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig.Type}
     * @param mode               模式{@link com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig.Level}
     * @return 实际使用的编码参数 {@link YVideoPublishVideoConfig}
     */
    public YVideoPublishVideoConfig updatePublishVideoConfig(
            boolean bMirrorFrontCamera,
            boolean bLowLatency,
            int playType,
            int mode) {
        if (mCurrentVideoConfig == null || playType != mCurrentVideoConfig.playType || mode != mCurrentVideoConfig.mode) {
            VideoEncoderConfig newEncoderConfig = getVideoEncoderConfigByType(playType, mode);

            List<ResolutionModifyConfig> resolutionModifyConfigs = new ArrayList<>();
            if (mCapture != null && mCapture.getClass() == ThunderScreenCapture.class && ((ThunderScreenCapture) mCapture).isLandscap()) {
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;

                copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else if ((mCapture == null || mCapture.getClass() == ThunderDefaultCamera.class) &&
                    ((ThunderPreviewConfig) ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).captureOrientation ==
                    ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
                //横屏模式
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;

                copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            }else {
                copyResolutionModifyConfig(resolutionModifyConfigs);
            }


            PublishVideoConfig videoConfig = new PublishVideoConfig();
            videoConfig.assign(newEncoderConfig);

            videoConfig.mLowDelay = checkLowDelayByType(playType);

            if (videoConfig.mLowDelay != bLowLatency) {
                ThunderLog.info("ThunderVideoEngineImp", "updatePublishVideoConfig %b :%d", bLowLatency, playType);
            }

            //设置动态分辨率
            mPublisher.setResolutionModifyConfigs(resolutionModifyConfigs, mVideoConfigManager.getCurrentIntervalSecs());
            mPublisher.stopPublishVideo();

            if(mCapture != null && mCapture.getClass() == ThunderScreenCapture.class){
                mPublisher.startPublishScreenVideo("general", null, videoConfig);
            }else if(mCapture != null && mCapture.getClass() == ExternalVideoSource.class){
                mPublisher.updateOriginPublishVideoConfig(videoConfig);
            }else {
                mPublisher.updateLivePublishVideoConfig(videoConfig);
            }

            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }

            int videoLevel = mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;

            if (mCurrentVideoConfig == null) {
                mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth,
                        newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }

            mCurrentVideoConfig.playType = playType;
            mCurrentVideoConfig.mode = videoLevel;
            mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            mCurrentVideoConfig.bHardwareEncoder = hard;
            mCurrentVideoConfig.encodeType = encodeType;
            if(mCapture == null || mCapture.getClass() == ThunderDefaultCamera.class) {
                mCurrentVideoConfig.orientation = ((ThunderPreviewConfig) ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).captureOrientation;
            } else {
                mCurrentVideoConfig.orientation = 0;
            }

            mCurrentVideoConfig.bLowLatency = videoConfig.mLowDelay;
        }

//		if(bLowLatency != mCurrentVideoConfig.bLowLatency){
//			mPublisher.setLowDelayMode(bLowLatency);
//			mCurrentVideoConfig.bLowLatency = bLowLatency;
//		}

        if (bMirrorFrontCamera != mCurrentVideoConfig.bMirrorFrontCamera) {
            mPublisher.enableMirror(bMirrorFrontCamera);
            mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
        }
        if(YYPUBLISH_VIDEO_STATE_ENCODE != mVideoPublishState){
            mVideoPublishState = YYPUBLISH_VIDEO_STATE_ENCODE;
            ThunderLog.info("ThunderVideoEngineImp", "updatePublishVideoConfig state:" + YYPUBLISH_VIDEO_STATE_ENCODE);
        }
        return mCurrentVideoConfig;
    }

    public boolean setCameraPosition(int position) {
        ((ThunderPreviewConfig) ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).cameraPosition = position;
        return mPublisher.setCameraPosition(position);
    }

    public int setPubWatermark(float x, float y, Object image) {
        return mPublisher.setWatermark((Bitmap) image, (int)x, (int)y);
    }

    public int setPubFaceBeautyLevel(float level) {
//		mPublisher.setBeautyParam(level);
        if (mOrangeFilterWrapper != null) {
            mOrangeFilterWrapper.setBeautyParam(level);
        }
        return 0;
    }

    public int onVideoStreamArrive(String streamKey, long streamId) {
        ThunderPlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            ThunderLog.warn("ThunderVideoEngineImp",
                    "onVideoStreamArrive: cannot find video view for stream:%s",
                    streamKey);
            return -1;
        }
        ThunderLog.info("ThunderVideoEngineImp", "link stream:%s, %d", streamKey, streamId);
        view.linkToStream(streamId);
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback(mThunderVideoPlayListener);
        }
        mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
        String uid = String.valueOf(streamId >> 32);
        mVideoFrameObserverEnableMap.put(uid, true);
        return 0;
    }

    public int onVideoStreamStop(String streamKey, long streamId) {
        ThunderPlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            ThunderLog.warn("ThunderVideoEngineImp",
                    "onVideoStreamStop: cann't find video view for stream:%s",
                    streamKey);
            return -1;
        }
        ThunderLog.info("ThunderVideoEngineImp", "unlink stream:%s-%d", streamKey, streamId);
        view.unLinkFromStream(streamId);
        String uid = String.valueOf(streamId >> 32);
        mVideoFrameObserverEnableMap.put(uid, false);
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback(null);
        }
        return 0;
    }

    public int onRequestIFrame() {
        mPublisher.requestEncodeIFrame();
        return 0;
    }

    //弱网
    public int onDynamicBitrate(long bitrate) {
        // 传输回调回来的比特率数值单位是 kbps
        mPublisher.setNetworkBitrateSuggest((int) bitrate * 1000);
        return 0;
    }

    /**
     * 获取海度统计数据
     */
    public String getAnchorHiidoStatInfo(long streamId) {
        return VideoDataStat.getInstance().getAnchorVideoData(streamId);
    }

    public String getAudienceHiidoStatInfo(long streamId) {
        return VideoPlayerDataStat.getInstance().getAudienceVideoData(streamId);
    }

    /**
     * 获取视频实时统计数据
     */
    public int getPublishRuntimeInfo(int type) {
        switch (type) {
            case VIDEO_STAT_FPS:
                return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.FRAME);
            case VIDEO_STAT_BITRATE:
                return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.BITRATE);
            case VIDEO_STATE_RESOLUTION:
                return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.RESOLUTION);
        }
        return 0;
    }

    public long getPlayRuntimeInfo(long streamId, int type) {
        switch (type) {
            case VIDEO_STAT_FPS:
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.FRAME);
            case VIDEO_STAT_BITRATE:
                break; // 播放不统计码率
            case VIDEO_STATE_RESOLUTION:
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
        }
        return 0;
    }

    /**
     * 后台配置下发的主播端采集时间戳校正值
     *
     * @param adjustVal
     * @return
     */
    public int setPublisherPtsAdjustVal(int adjustVal) {
        if (mPublisher != null) {
            ThunderLog.debug("ThunderVideoEngineImp", "setPublisherPtsAdjustVal " + adjustVal);
            mPublisher.setDeltaYYPtsMillions(adjustVal);
        }
        return 0;
    }

    /**
     * 视频数据回调函数，传回的是编码后的数据
     */
    @Override
    public void onEncodeFrameData(byte[] data,
                                  int len,
                                  long pts,
                                  long dts,
                                  int frameType,
                                  VideoEncoderType encoderType) {
        int encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
        boolean bHardware = false;

        switch (encoderType) {
            case SOFT_ENCODER_X264:
                bHardware = false;
                encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                break;
            case HARD_ENCODER_H264:
                bHardware = true;
                encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                break;
            case SOFT_ENCODER_H265:
                bHardware = false;
                encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
                break;
            case HARD_ENCODER_H265:
                bHardware = true;
                encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
                break;
            case DEFAULT:
            case ERROR:
                ThunderLog.warn(ThunderLog.kLogTagVideo, "unknown encoder type" + encoderType.toString());
        }

        if (mCallBackPtr != 0) {
            onVideoEncodedFrame(mCallBackPtr, data, len, pts, dts, frameType, encodeType, bHardware);
        }
    }

    /**
     * 采集回调
     */
    @Override
    public int onTextureCallback(int textureId, int width, int height) {
//		ThunderLog.info("ThunderVideoEngineImp", "onTextureCallback %d %dx%d",
//				textureId, width, height);
        if (!isUsingDefaultCamera()) {
            return textureId;
        }
        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        if (camera.getCameraDataCallback() == null) {
            return textureId;
        }
        return camera.getCameraDataCallback().onTextureCallback(textureId, width, height);
    }

    void onVideoRenderNotify(final ArrayList<VideoRenderNotify> notifications) {
        if (mCallBackPtr != 0) {
            ThunderNative.onVideoRenderEvent(mCallBackPtr, notifications);
        }
    }

    void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        ThunderLog.info("ThunderVideoEngineImp", "onHardwareDecodeErrorNotify %d",
                errorType);
//		if (errorType < 4) { //0 reset_error 1 init_error 2 decoding_error 3 stop_block_error
        ThunderNative.enableHardwareDecoder(false, ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264);
        ThunderNative.enableHardwareDecoder(false, ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265);
        if (mVideoConfigManager != null) {
            mVideoConfigManager.disableHardDecode(true);
        }
//		}
    }

    public boolean queryOnlyDecoded(int uid){
        IVideoDecodeObserver observer = mVideoFrameObserverMap.get(String.valueOf(uid));
        if(observer == null){
            return false;
        }
        return true;
    }


    public void onDecodedFrameData(long uid, int w, int h, byte[] data,int dateLen, long renderTimeMs){
        IVideoDecodeObserver observer = mVideoFrameObserverMap.get(String.valueOf(uid));
        if(observer == null){
            ThunderLog.info("ThunderVideoEngineImp", "onVideoDecodedFrame not found uid " + uid );
            return;
        }

        if(mVideoFrameObserverEnableMap.get(String.valueOf(uid)) != null && mVideoFrameObserverEnableMap.get(String.valueOf(uid)) == true);{
            observer.onVideoDecodeFrame(uid, w, h, data, dateLen, renderTimeMs);
        }
    }


    private native void onVideoEncodedFrame(long callback,
                                            byte[] data,
                                            int len,
                                            long pts,
                                            long dts,
                                            int frameType,
                                            int encodeType,
                                            boolean bHardware);

    /**
     * 返回给Jni层当前实际使用的配置
     */
    private static class YVideoPublishVideoConfig {
        int encodeFrameRate;
        int encodeBitrate;
        int encodeResolutionWidth;
        int encodeResolutionHeight;
        int encodeType;
        boolean bHardwareEncoder;
        int mode;
        boolean bMirrorFrontCamera;
        boolean bLowLatency;
        int playType;
        int orientation;

        public YVideoPublishVideoConfig(int encodeFrameRate, int encodeBitrate, int encodeResolutionWidth, int encodeResolutionHeight, int encodeType, boolean bHardwareEncoder, int mode) {
            this.encodeFrameRate = encodeFrameRate;
            this.encodeBitrate = encodeBitrate;
            this.encodeResolutionWidth = encodeResolutionWidth;
            this.encodeResolutionHeight = encodeResolutionHeight;
            this.encodeType = encodeType;
            this.bHardwareEncoder = bHardwareEncoder;
            this.mode = mode;
        }

        @Override
        public String toString() {
            String tmp = "" + this.encodeResolutionWidth +
                    "x" + this.encodeResolutionHeight +
                    "@" + this.encodeFrameRate +
                    " " + this.encodeBitrate +
                    " hard:" + this.bHardwareEncoder +
                    " mode:" + this.mode;
            return tmp;
        }
    }

    public void stopAndRecoverVideoEncode(boolean stop) {
        if (mPublisher != null && mVideoPublishState != YYPUBLISH_VIDEO_STATE_NONE) {
            mPublisher.stopAndRecoverStream(stop);
        }
    }

    public void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond, long firstFrameToRenderInMilliSec,  int eatenFrames) {
        ThunderNative.onFirstFrameRenderNotify(userGroupId,streamId,currentSystemMilliSecond,firstFrameToRenderInMilliSec,eatenFrames);
    }

    public void onUpdateVideoSizeChanged(long streamId, int width, int height) {
        ThunderNative.onUpdateVideoSizeChanged(streamId,width,height);
    }

    public void setWebSdkCompatibility(boolean enable) {
        mIsEnableWebSdkCompatibility = enable;
    }

    public void setPreviewMirror(boolean enable) {
        if (mPublisher != null) {
            mPublisher.enablePreviewMirror(enable);
        }
    }

    public void setMirror(boolean enable) {
        if (mPublisher != null) {
            mPublisher.enableMirror(enable);
        }
    }
}
