package com.yy.yylivesdk4cloud.log;

import com.yy.yylivesdk4cloud.ThunderAPI;
import com.yy.yylivesdk4cloud.helper.ThunderLog;

import org.json.JSONObject;

public class LogConfigManager {
	private final static String TAG = "cfg_LogConfigManager";
	private final static String ARGO_CONFIG_KEY_LOG_CTRL_STRATEGY = "thunder_log_control_strategy";
	private LogConfig mConfig = null;

	public final static String[] ARGO_CONFIG_KEYS = {
			ARGO_CONFIG_KEY_LOG_CTRL_STRATEGY
	};

	private static class SingletonHolder {
		private static final LogConfigManager INSTANCE = new LogConfigManager();
	}

	public static LogConfigManager instance() {
		return SingletonHolder.INSTANCE;
	}

	private LogConfigManager() {
	}


	public void onConfig(String key, String config) {
		if (key == null || config == null) {
			return;
		}
		if (key.equals(ARGO_CONFIG_KEY_LOG_CTRL_STRATEGY)) {
			parseLogConfig(config);
		}
	}

	private void parseLogConfig(final String config) {
		try {
			JSONObject jsonObject = new JSONObject(config);
			mConfig = new LogConfig();
			mConfig.freelyWriteLogCount = jsonObject.optInt("freelyWriteLogCount");
			mConfig.maxQueueSize = jsonObject.optInt("maxQueueSize");
			mConfig.limitingInterval = jsonObject.optInt(("limitingInterval"));
			mConfig.audioengineLimit = jsonObject.optInt("audioengineLimit");
			mConfig.transsdkLimit = jsonObject.optInt("transsdkLimit");
			mConfig.platformLimit = jsonObject.optInt("platformLimit");
			ThunderLog.info(TAG, mConfig.toString());

			ThunderAPI.sharedInstance().fetchedLogConfig();
		} catch (Exception e) {
			ThunderLog.error(TAG, " parseLogConfig error :" + e.toString());
		}
	}

	public LogConfig getLogConfig() {
		return mConfig;
	}
}
