package com.yy.yylivesdk4cloud;

import android.graphics.Bitmap;
import android.graphics.Rect;

import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;

import java.util.ArrayList;
import java.util.HashMap;

import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_NO_MIRROR_PUBLISH_MIRROR;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_MIRROR;
import static com.yy.yylivesdk4cloud.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_NO_MIRROR;

/**
 * Created by aoe on 2018/12/19.
 */

 class ThunderPublishRoomImp implements ThunderPublishRoom {
    private ThunderVideoCapture mVideoCapture = null;
    private ThunderAudioCapture mAudioCapture = null;
    private ThunderDefaultCamera mDefaultCamera = new ThunderDefaultCamera();
    private ThunderDefaultMic mDefaultMic = new ThunderDefaultMic();

    private String mChannelId = null;
    private long mUid = 0;
    private boolean mOwner = false;
    private boolean mPublishing = false;
    private boolean mAudioOnly = false;
    private boolean mEnableVideo = false;
    private boolean mEnableAudio = false;
    private int mPublishMode = ThunderConstant.ThunderPublishVideoMode.THUNDERPUBLISH_VIDEO_MODE_DEFAULT;
    private int mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;
    private int mCamaraPosition = ThunderConstant.ThunderCameraPosition.THUNDERCAMERA_POSITION_FRONT;
    private int mPubOrientation = ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT;

    private int mChannelProfile = ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_LIVE;
    private int mAudioProfile = ThunderRtcConstant.AudioConfig.THUNDER_AUDIO_CONFIG_DEFAULT;
    private int mCommunitMode = ThunderRtcConstant.CommutMode.THUNDER_COMMUT_MODE_DEFAULT;
    private int mScenarioMode = ThunderRtcConstant.ScenarioMode.THUNDER_SCENARIO_MODE_DEFAULT;



    public int startVideoPreview(Object view, int playType, int publishMode) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        mPlayType = playType;
        mPublishMode = publishMode;

//        if (mVideoCapture == null) {
//            this.attachVideoCapture(mDefaultCamera);
//        }
        ThunderLog.info(ThunderLog.kLogTagCall, "startVideoPreview view:%s", view.toString());
        int convertType = convertPlayType(playType);
        return ThunderNative.startVideoPreview(view, convertType, publishMode);
    }


    public int stopVideoPreview() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "stopVideoPreview");
        return ThunderNative.stopVideoPreview();
    }

    public int startLiveInteract(ThunderLayout layout) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mChannelId == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startLiveInteract roomId null");
            return -1;
        }
        if (layout == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startLiveInteract layout error");
            return -1;
        }
        if (layout.layouts.size() == 0 || layout.speakers.size() == 0) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startLiveInteract param error");
            return -1;
        }

        mAudioOnly = false;
        mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_INTERACT;
        ThunderPublishVideoConfig videoConfig = convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = convertAudioConfig();
        if (layout.layouts.size() == 1) { //同频道
            ThunderChannelLayout channelLayout = layout.layouts.get(0);
            if (mPublishing) {
                ThunderNative.updatePublishLive(channelLayout.roomId, true,  videoConfig, audioConfig, layout);
            } else {
                mPublishing = true;
                if (mAudioCapture == null) {
                    ThunderNative.attachAudioCapture(mDefaultMic);
                }
                ThunderNative.startPublishLive(channelLayout.roomId, true, videoConfig, audioConfig, layout);
            }
            mOwner = channelLayout.owner;
        }else { //跨频道
            for (ThunderChannelLayout channelLayout : layout.layouts) {
                ThunderLayout liveLayout = convertLayout(layout, channelLayout);
                ThunderNative.updatePublishLive(channelLayout.roomId, false, videoConfig, audioConfig, liveLayout);
            }
            mOwner = true;
        }

        ThunderLog.info(ThunderLog.kLogTagCall, "startLiveInteract %s", layout.toString());
        return 0;
    }

    public int stopLiveInteract() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        ThunderLog.info(ThunderLog.kLogTagCall, "stopLiveInteract %b", mOwner);
        if (mOwner) {
            mAudioOnly = false;
            mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;
            ThunderPublishVideoConfig videoConfig = convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = convertAudioConfig();
            ThunderLayout layout = makeLayout(null);
            return ThunderNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }else {
            return stopSinglePublish();
        }
    }

    public int startAudioInteract(ArrayList<String> speakers) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mChannelId == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startAudioInteract roomId null");
            return -1;
        }
        if (speakers == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startAudioInteract speakers error");
            return -1;
        }
        mAudioOnly = true;
        mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;
        ThunderPublishVideoConfig videoConfig = convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = convertAudioConfig();
        ThunderLayout layout = makeLayout(speakers);
        if (mPublishing) {
            ThunderNative.updatePublishLive(mChannelId, true,  videoConfig, audioConfig, layout);
        } else {
            mPublishing = true;
            if (mAudioCapture == null) {
                ThunderNative.attachAudioCapture(mDefaultMic);
            }
            videoConfig.encodeResolutionHeight = 0;
            videoConfig.encodeResolutionWidth = 0;
            ThunderNative.startPublishLive(mChannelId, true, videoConfig, audioConfig, layout);
        }
        ThunderChannelLayout channelLayout = layout.getChannelLayout(0);
        mOwner = channelLayout.owner;

        ThunderLog.info(ThunderLog.kLogTagCall, "startAudioInteract %s", layout.toString());
        return 0;
    }

    public int stopAudioInteract() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        ThunderLog.info(ThunderLog.kLogTagCall, "stopAudioInteract %b", mOwner);
        if (mOwner) {
            mAudioOnly = false;
            mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;
            ThunderPublishVideoConfig videoConfig = convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = convertAudioConfig();
            ThunderLayout layout = makeLayout(null);
            return ThunderNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }else {
            return stopSinglePublish();
        }
    }

    public int startSinglePublish(int playType, int publishMode) {
        if (mUid == 0){
            return 0;
        }

        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mChannelId == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startPublish roomId null");
            return -1;
        }

        mPlayType = playType;
        mPublishMode = publishMode;
        mPublishing = true;
        mAudioOnly = false;
        mOwner = true;

        if (mAudioCapture == null) {
            ThunderNative.attachAudioCapture(mDefaultMic);
        }

        ThunderPublishVideoConfig videoConfig = convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = convertAudioConfig();
        ThunderLayout layout = makeLayout(null);

        ThunderLog.info(ThunderLog.kLogTagCall, "startPublish %s", layout.toString());
        return ThunderNative.startPublishLive(mChannelId, false, videoConfig, audioConfig, layout);
    }

    public int stopSinglePublish() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "stopPublish %s", mChannelId);
        if (mChannelId == null) {
            return 0;
        }

        mPublishing = false;
        mOwner = false;
        mAudioOnly = false;
        return ThunderNative.stopPublishLive(mChannelId);
    }

    public int updatePublishMode(int publishMode) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        if (mPublishMode == publishMode) {
            ThunderLog.info(ThunderLog.kLogTagCall, "updatePublishMode ignore same");
            return 0;
        }
        if (!mPublishing) {
            mPublishMode = publishMode;
            ThunderLog.info(ThunderLog.kLogTagCall, "updatePublishMode not publishing");
            return 0;
        }

        boolean bSuport = false;
        int convertType = convertPlayType(mPlayType);
        HashMap<Integer, String> modeMap = ThunderNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            ThunderLog.info(ThunderLog.kLogTagCall, "updatePublishMode empty");
            return -1;
        }
        for (Integer key : modeMap.keySet()) {
            if (key == publishMode) {
                bSuport = true;
                break;
            }
        }
        if (bSuport) {
            mPublishMode = publishMode;
            ThunderPublishVideoConfig videoConfig = convertVideoConfig();
            if (mPlayType == ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_INTERACT) {
                ThunderNative.updateVideoConfig(videoConfig);
                return 0;
            }
            ThunderPublishAudioConfig audioConfig = convertAudioConfig();
            ThunderLayout layout = makeLayout(null);
            ThunderNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "updatePublishMode %d %b", publishMode, bSuport);
        return 0;
    }

    public HashMap<Integer, String> getPublishMode(int playType) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return null;
        }

        int convertType = convertPlayType(playType);
        return ThunderNative.getSupportModeInfoWithPlayType(convertType);
    }

    public int getDefaultPublishMode(int playType){
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        int convertType = convertPlayType(playType);
        return ThunderNative.getDefaultPublishVideoMode(convertType);
    }

    public ThunderPublishInfo getCurrentPublishInfo() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return null;
        }
        ThunderPublishInfo publishInfo = ThunderNative.getPublishInfo();

        if (publishInfo != null) {
            publishInfo.publishOrientation = mPubOrientation;
            publishInfo.cameraPosition = mCamaraPosition;
        }
        return publishInfo;
    }

    public boolean setCameraPosition(int position) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return false;
        }
        mCamaraPosition = position;
        ThunderLog.info(ThunderLog.kLogTagCall, "setCameraPosition %d", position);
        return ThunderNative.setCameraPosition(position);
    }

    public void setPublishOrientation(int orientation){
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return;
        }
        mPubOrientation = orientation;
        ThunderNative.setOrientation(orientation);
    }

    public int setWatermark(int posX, int posY, Bitmap image) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

//        if (image == null) {
//            return -1;
//        }
        ThunderLog.info(ThunderLog.kLogTagCall, "setWatermark in (%d,%d)", posX, posY);
        return ThunderNative.setWatermark(posX, posY, image);
    }

    public int setFaceBeautyLevel(float level) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        // float保证六位有效数字
        if (level >= 1.000001f) {
            level = 1.0f;
        } else if (level < 0.000001f) {
            level = 0.0f;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "setFaceBeautyLevel %f", level);
        return ThunderNative.setFaceBeautyLevel(level);
    }

    public boolean setMicVolume(int volume) {
        if (volume < 0) {
            volume  = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "setMicVolume %d", volume);

        return ThunderNative.setMicVolume(volume);
    }

    public OrangeFilterWrapper getBeautyFilter(){
        return ThunderBridgeLib.getInstance().getBeautyFilter();
    }

    public ThunderDefaultMic getDefaluteMic() {
        if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
            return null;
        }
        return mDefaultMic;
    }

    public void attachAudioCapture(ThunderAudioCapture capture) {
        if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
            return;
        }
        if (capture == null) {
            mAudioCapture = mDefaultMic;
        } else {
            mAudioCapture = capture;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "attachAudioCapture %s", mAudioCapture.toString());
        ThunderNative.attachAudioCapture(mAudioCapture);

    }

    public void attachVideoCapture(ThunderVideoCapture capture) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return;
        }
//        if (capture == null) {
//            mVideoCapture = mDefaultCamera;
//        } else {
        mVideoCapture = capture;
//        }
        ThunderLog.info(ThunderLog.kLogTagCall, "attachVideoCapture %s", mVideoCapture.toString());
        ThunderNative.attachVideoCapture(mVideoCapture);
    }

    public void setChannelId(String channelId){
        mChannelId = channelId;
    }

    public void syncUserInfo(long uid, int userRole) {
        ThunderLog.info(ThunderLog.kLogTagCall, "syncUserInfo" + uid);
        mUid = uid;
    }

    public void updateProfile(int channelProfile, int audioProfile,
                              int commutMode, int scenarioMode) {
        mChannelProfile = channelProfile;
        mAudioProfile =audioProfile;
        mCommunitMode = commutMode;
        mScenarioMode = scenarioMode;
    }

    @Override
    public int startCapture() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return -1;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "start capture");
        return ThunderNative.startCapture();
    }

    @Override
    public int stopCapture() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return -1;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "stop capture");
        return ThunderNative.stopCapture();
    }

    private ThunderPublishVideoConfig convertVideoConfig() {
        int convertType = convertPlayType(mPlayType);
        ThunderPublishVideoConfig config = ThunderNative.getRemoteVideoConfig(convertType, mPublishMode);
        return config;
    }

    private ThunderPublishAudioConfig convertAudioConfig() {
        ThunderPublishAudioConfig config = new ThunderPublishAudioConfig(ThunderPublishAudioConfig.YYPUBLISH_AUDIO_MODE_NORMALDELAY_NORMALFLOW_HIGHQUALITY_BROADCAST);
        config.bUseAudioProfile = true;

        config.audioConfig = mAudioProfile;
        config.commutMode = mCommunitMode;
        config.scenarioMode = mScenarioMode;
        config.roomConfig = mChannelProfile;

        return config;
    }

    private ThunderLayout convertLayout(ThunderLayout liveLayout, ThunderChannelLayout channelLayout) {
        ArrayList<ThunderChannelLayout> layouts = new ArrayList<ThunderChannelLayout>();
        layouts.add(channelLayout);
        ThunderLayout layout = new ThunderLayout();
        layout.width = liveLayout.width;
        layout.height = liveLayout.height;
        layout.layouts = layouts;
        layout.speakers = liveLayout.speakers;
        return layout;
    }

    private ThunderLayout makeLayout(ArrayList<String> speakers) {
        int convertType = convertPlayType(mPlayType);
        ThunderPublishVideoConfig config = ThunderNative.getRemoteVideoConfig(convertType, mPublishMode);
        Rect rect = new Rect(0, 0, config.encodeResolutionWidth, config.encodeResolutionHeight);

        ThunderChannelLayout channelLayout = new ThunderChannelLayout();
        channelLayout.roomId = mChannelId;
        channelLayout.layoutNo = 0;
        channelLayout.layout = rect;

        ArrayList<ThunderChannelLayout> layouts = new ArrayList<ThunderChannelLayout>();
        layouts.add(channelLayout);
        ThunderLayout layout = new ThunderLayout();
        layout.width = 0;
        layout.height = 0;
        layout.layouts = layouts;
        if (speakers == null || speakers.isEmpty()) {

            channelLayout.owner = true;
            ArrayList<String> spk = new ArrayList<String>();
            spk.add(String.valueOf(mUid));
            layout.speakers = spk;

        } else {

            channelLayout.owner = mPublishing;
            layout.speakers = speakers;
        }

        return layout;
    }

    private int convertPlayType(int playType) {
        if (mAudioOnly) {
            return ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_SINGLE;
        }
        switch (playType) {
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_SINGLE;
                break;
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_INTERACT:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_LIANMAI;
                break;
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SCREENCAP:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_SCREEN_CAPTURE;
                break;
            default:
                break;
        }
        return playType;
    }

    //audio
    public void setAudioEnable(boolean enableAudio) {
        if (mUid == 0){
            return;
        }

        if (this.mEnableAudio == enableAudio)
        {
            return;
        }

        this.mEnableAudio = enableAudio;
        //开播
        if (enableAudio) {
            ThunderNative.setAudioSourceType(0);
            if (mEnableVideo) {             /*********already start video, update publish********/
                mAudioOnly= false;
                startSinglePublish(mPlayType, mPublishMode);
            } else {                        /*********only start audio********/
                mAudioOnly = true;
                ThunderPublishAudioConfig audioConfig = convertAudioConfig();
                ThunderPublishVideoConfig videoConfig = new ThunderPublishVideoConfig();//default
                ThunderLayout layout = makeLayout(null);

                if (mAudioCapture == null) {
                    ThunderNative.attachAudioCapture(mDefaultMic);
                }

                ThunderNative.startPublishLive(mChannelId, false, videoConfig, audioConfig, layout);
                mPublishing = true;
            }
        }
        else {  //停播
            mAudioOnly = false;
            if (mEnableVideo) {             /*********only stop audio, update publish********/
                ThunderPublishAudioConfig audioConfig = convertAudioConfig();
                ThunderPublishVideoConfig videoConfig = convertVideoConfig();
                ThunderLayout layout = makeLayout(null);
                ThunderNative.stopPublishAudio();
                ThunderNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
            } else {                         /*********stop all********/
                ThunderNative.stopPublishLive(mChannelId);
                mPublishing = false;
            }
        }
    }

    //video
    public void setVideoEnable(boolean enableVideo) {
        if (mUid == 0){
            return;
        }

        if (enableVideo == this.mEnableVideo) {
            return;
        }
        this.mEnableVideo = enableVideo;
        if (enableVideo) {  //开播
            mAudioOnly = false;
            if (this.mEnableAudio) {    /*********already start audio, update publish********/
                startSinglePublish(mPlayType, mPublishMode);
            } else {                    /*********only start video********/
                ThunderPublishVideoConfig videoConfig = convertVideoConfig();
                ThunderPublishAudioConfig audioConfig = new ThunderPublishAudioConfig(ThunderPublishAudioConfig.YYPUBLISH_AUDIO_MODE_LOWDELAY_LOWFLOW_SUPERLOWQUALITY_VOIP);   //default
                ThunderLayout layout = makeLayout(null);
                ThunderNative.startPublishLive(mChannelId, false, videoConfig, audioConfig, layout);
                mPublishing = true;
            }
        } else {    //停播
            if (this.mEnableAudio) {    /*********only stop video, update publish********/
                mAudioOnly = true;
                ThunderPublishVideoConfig videoConfig = new ThunderPublishVideoConfig();
                ThunderPublishAudioConfig audioConfig = convertAudioConfig();
                ThunderLayout layout = makeLayout(null);
                ThunderNative.stopPublishVideo();
                ThunderNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
            } else {                    /*********stop all********/
                mAudioOnly = false;
                ThunderNative.stopPublishLive(mChannelId);
                mPublishing = false;
            }
        }
    }

    public int updatePlayTypeAndPublishMode(int playType, int publishMode) {

        if ((mPlayType == playType) && (mPublishMode == publishMode)) {
            ThunderLog.info(ThunderLog.kLogTagCall, "updatePlayTypeAndPublishMode ignore same");
            return 0;
        }

        boolean bSupport = isPublishParamValid(playType, publishMode);
        ThunderLog.info(ThunderLog.kLogTagCall, "updatePlayTypeAndPublishMode %d %d %b", playType, publishMode, bSupport);

        if (!bSupport) {
            return -1;
        }

        if (mEnableVideo) { //already publish video
            mPlayType = playType;
            mPublishMode = publishMode;
            ThunderPublishVideoConfig videoConfig = convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = convertAudioConfig();
            ThunderLayout layout = makeLayout(null);
            ThunderNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }
        else    //is not publishing video
        {
            mPlayType = playType;
            mPublishMode = publishMode;
            ThunderPublishVideoConfig videoConfig = convertVideoConfig();
            ThunderNative.updateVideoConfig(videoConfig);
        }
        return 0;
    }


    private boolean isPublishParamValid(int playType, int publishMode) {

        int convertType = convertPlayType(playType);
        HashMap<Integer, String> modeMap = ThunderNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            ThunderLog.info(ThunderLog.kLogTagCall, "updatePlayTypeAndPublishMode empty");
            return false;
        }
        if (publishMode == ThunderConstant.ThunderPublishVideoMode.THUNDERPUBLISH_VIDEO_MODE_DEFAULT)
        {
            return true;
        }
        for (Integer key : modeMap.keySet()) {
            if (key == publishMode) {
                return true;
            }
        }
        return false;
    }
}
