package com.yy.yylivesdk4cloud;

/**
 * Created by xiaojun on 2017/12/29.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import android.widget.FrameLayout;

import com.yy.videoplayer.decoder.GLVersionUtils;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.videoview.YCustomGLTextrueViewHighEGL;
import com.yy.videoplayer.videoview.YCustomGLTextureViewLowEGL;
import com.yy.videoplayer.videoview.YCustomGLVideoViewHighEGLExt;
import com.yy.videoplayer.videoview.YCustomGLVideoViewLowEGLExt;
import com.yy.videoplayer.videoview.YGLVideoViewExt;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YSurfaceVideoViewExt;
import com.yy.videoplayer.videoview.YTextureVideoViewExt;
import com.yy.videoplayer.videoview.YVideoViewExt;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.video.ThunderVideoConfig;

import static com.yy.videoplayer.decoder.VideoConstant.ViewType.SURFACE_VIDEO_VIEW;

/**
 * 用于播放视频的组件<br/>
 * <p>需要播放视频时，在布局文件中加入这个组件</p>
 */
public class ThunderPlayerView extends FrameLayout {

	private YSpVideoView mVideoView = null;
	private VideoConstant.ViewType mViewType;
	private VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
	private long mStreamId  = 0;
	public int getViewType(){
		if(mViewType == null){
			return -1;
		}
		if(mViewType == SURFACE_VIDEO_VIEW){
			return 1;
		}else {
			return 0;
		}
	}

	public ThunderPlayerView(Context context) {
		super(context);
		addView(new SurfaceView(context));           //防止一开始进入频道的闪烁
	}

	public ThunderPlayerView(Context context, AttributeSet attrs) {
		super(context, attrs);
		addView(new SurfaceView(context));           //防止一开始进入频道的闪烁
	}

	public ThunderPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		addView(new SurfaceView(context));           //防止一开始进入频道的闪烁
	}

	private VideoConstant.ScaleMode scaleModeConvert(int scaleMode) {
		switch (scaleMode) {
			case ThunderConstant.ThunderVideoViewScaleMode.THUNDERVIDEOVIEW_SCALE_MODE_FILL:
				return VideoConstant.ScaleMode.FillParent;
			case ThunderConstant.ThunderVideoViewScaleMode.THUNDERVIDEOVIEW_SCALE_MODE_ASPECT_FIT:
				return VideoConstant.ScaleMode.AspectFit;
			case ThunderConstant.ThunderVideoViewScaleMode.THUNDERVIDEOVIEW_SCALE_MODE_CLIP_TO_BOUNDS:
				return VideoConstant.ScaleMode.ClipToBounds;
			default:
				ThunderLog.warn(ThunderLog.kLogTagVideo, "invalid scale mode %d", scaleMode);
		}
		return VideoConstant.ScaleMode.AspectFit;
	}


	private boolean createTextureVideoView(VideoConstant.ViewType type) {
		switch (type) {
			case SURFACE_VIDEO_VIEW:
				mVideoView = new YTextureVideoViewExt(this.getContext());
				break;
			case NO_GL_VIDEO_VIEW:
				mVideoView = new YVideoViewExt(this.getContext());
				break;
			case CUSTOM_GL_VIDEO_VIEW_LOW:
				mVideoView = new YCustomGLTextureViewLowEGL(this.getContext());
				break;
			case CUSTOM_GL_VIDEO_VIEW_HIGH:
				mVideoView = new YCustomGLTextrueViewHighEGL(this.getContext());
				break;
			case GL_VIDEO_VIEW:
				mVideoView = new YGLVideoViewExt(this.getContext());
				break;
			case NO_GL_VIDEO_VIEW_MULTIVIDEO:
			case CUSTOM_GL_VIDEO_VIEW_LOW_MULTIVIDEO:
			case GL_VIDEO_VIEW_MULTIVIDEO:
			case CUSTOM_GL_VIDEO_VIEW_HIGH_MULTIVIDEO:
			default:
				// TODO: 支持一个View显示多条流
				ThunderLog.release(ThunderLog.kLogTagVideo, "createVideoView unsupported:" + type.name());
				return false;
		}
		ThunderLog.release(ThunderLog.kLogTagVideo, "createVideoView:" + type.name());

		mViewType = type;
		this.addView(((View) mVideoView));
		//((View) mVideoView).setKeepScreenOn(true);
		mVideoView.onParentSizeChanged(this.getWidth(), this.getHeight());
		mVideoView.setScaleMode(mScaleMode);
		return true;
	}

	private boolean createVideoView(VideoConstant.ViewType type) {
//		return createTextureVideoView(type);
//		/*
		switch (type) {
			case SURFACE_VIDEO_VIEW:
				mVideoView = new YSurfaceVideoViewExt(this.getContext());
				break;
			case NO_GL_VIDEO_VIEW:
				mVideoView = new YVideoViewExt(this.getContext());
				break;
			case CUSTOM_GL_VIDEO_VIEW_LOW:
				mVideoView = new YCustomGLVideoViewLowEGLExt(this.getContext());
				break;
			case CUSTOM_GL_VIDEO_VIEW_HIGH:
				mVideoView = new YCustomGLVideoViewHighEGLExt(this.getContext());
				break;
			case GL_VIDEO_VIEW:
				mVideoView = new YGLVideoViewExt(this.getContext());
				break;
			case NO_GL_VIDEO_VIEW_MULTIVIDEO:
			case CUSTOM_GL_VIDEO_VIEW_LOW_MULTIVIDEO:
			case GL_VIDEO_VIEW_MULTIVIDEO:
			case CUSTOM_GL_VIDEO_VIEW_HIGH_MULTIVIDEO:
			default:
				// TODO: 支持一个View显示多条流
				ThunderLog.release(ThunderLog.kLogTagVideo, "createVideoView unsupported:" + type.name());
				return false;
		}

		mViewType = type;
		this.addView(((View) mVideoView));
		//((View) mVideoView).setKeepScreenOn(true);
		mVideoView.onParentSizeChanged(this.getWidth(), this.getHeight());
		ThunderLog.release(ThunderLog.kLogTagVideo, "createVideoView:" + type.name() + " size " + this.getWidth() +"x"+ this.getHeight());
		mVideoView.setScaleMode(mScaleMode);
		return true;
	}

	/**
	 * 根据解码配置初始化视频播放的View<br/>
	 * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
	 * @return 成功or失败
	 */
	public boolean prepareView() {
		unPrepareView(); // 清掉构造函数添加的 SurfaceView

		VideoConstant.ViewType type;
		if (ThunderVideoConfig.isHw264DecodeEnabled() || ThunderVideoConfig.isHw265DecodeEnabled()) {
			type = SURFACE_VIDEO_VIEW;
		} else if (GLVersionUtils.isGLES20Supported()) {
			if (Build.VERSION.SDK_INT >= 16 && ThunderVideoConfig.isWindowSurfaceSupport()) {
				if (Build.VERSION.SDK_INT >= 18) {
					type = VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_HIGH;
				} else {
					type = VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_LOW;
				}
			} else {
				type = VideoConstant.ViewType.GL_VIDEO_VIEW;
			}
		} else {
			type = VideoConstant.ViewType.NO_GL_VIDEO_VIEW;
		}
		ThunderLog.release(ThunderLog.kLogTagVideo, "prepareView:" + type.name());
		return createVideoView(type);
	}

	/**
	 * 根据解码器了类型初始化视频播放的View<br/>
	 * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
	 * @param decoderType 解码器类型
	 * @return 成功or失败
	 */
	public boolean prepareView(int decoderType) {
		unPrepareView(); // 清掉构造函数添加的 SurfaceView

		VideoConstant.ViewType type;
		if (decoderType == VideoConstant.DecoderType.ANDROID_HARD_DECODER1) {
			type = SURFACE_VIDEO_VIEW;
		} else if (decoderType == VideoConstant.DecoderType.SOFT_DEOCDER && GLVersionUtils.isGLES20Supported()) {
			if (Build.VERSION.SDK_INT >= 16 && ThunderVideoConfig.isWindowSurfaceSupport()) {
				if (Build.VERSION.SDK_INT >= 18) {
					type = VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_HIGH;
				} else {
					type = VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_LOW;
				}
			} else {
				type = VideoConstant.ViewType.GL_VIDEO_VIEW;
			}
		} else if (decoderType == VideoConstant.DecoderType.SOFT_DEOCDER) {
			type = VideoConstant.ViewType.NO_GL_VIDEO_VIEW;
		} else {
			ThunderLog.error(ThunderLog.kLogTagVideo, "prepareView: invalid decoder type");
			return false;
		}
		ThunderLog.release(ThunderLog.kLogTagVideo, "prepareView:%s, decoder type:%d",
				type.name(), decoderType);
		return createVideoView(type);
	}

	/**
	 * 创建解码器时调用，确保创建的 view 和解码器匹配<br/>
	 * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
	 * @param format 视频流格式
	 * @param bHardware 是否使用硬解
	 * @return 成功or失败
	 */
	public boolean rePrepareView(int format, boolean bHardware) {
		VideoConstant.ViewType type;
		if (bHardware &&
				((format == VideoConstant.VideoFormat.H264 && H264DecRender.IsAvailable()) ||
						(format == VideoConstant.VideoFormat.H265 && H265DecRender.IsAvailable()))) {
			type = SURFACE_VIDEO_VIEW;
		} else if (GLVersionUtils.isGLES20Supported()) {
			if (Build.VERSION.SDK_INT >= 16 && ThunderVideoConfig.isWindowSurfaceSupport()) {
				if (Build.VERSION.SDK_INT >= 18) {
					type = VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_HIGH;
				} else {
					type = VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_LOW;
				}
			} else {
				type = VideoConstant.ViewType.GL_VIDEO_VIEW;
			}
		} else {
			type = VideoConstant.ViewType.NO_GL_VIDEO_VIEW;
		}

		if (mVideoView != null && mViewType == type) {
			return true;
		}

		ThunderLog.release(ThunderLog.kLogTagVideo, "rePrepareView: %s -> %s",
				mViewType.name(), type.name());
		unPrepareView();
		boolean ret = createVideoView(type);
		if (!ret) {
			return false;
		}

		// 已经链接了视频流
		if (mStreamId != 0) {
			linkToStream(mStreamId);
		}

		return mVideoView.setScaleMode(mScaleMode);
	}

	/**
	 * 反初始化视频播放的View<br/>
	 * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
	 */
	public void unPrepareView() {
		synchronized (this) {
			this.removeAllViews();
			if (mVideoView != null) {
				mVideoView.release();
				mVideoView = null;
			}
		}
		ThunderLog.release(ThunderLog.kLogTagVideo, "unPrepareView.");
	}

	/**
	 * 绑定视频流<br/>
	 * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
	 * @param streamId 流ID
	 */
	public void linkToStream(long streamId) {
		if (mVideoView == null) {
			ThunderLog.warn(ThunderLog.kLogTagVideo,
					"linkToStream: this view doesn't prepare or prepare failed!");
			return;
		}
		mStreamId = streamId;
		mVideoView.linkToStream((long) 0, streamId);
	}

	/**
	 * 解绑视频流 <br/>
	 * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
	 * @param streamId 流ID
	 */
	public void unLinkFromStream(long streamId) {
		if (mVideoView == null) {
			ThunderLog.warn(ThunderLog.kLogTagVideo,
					"unLinkFromStream: this view doesn't prepare or prepare failed!");
			return;
		}
		mStreamId = 0;
		mVideoView.unLinkFromStream((long) 0, streamId);
	}

	/**
	 * 解绑视频流 <br/>
	 * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
	 */
	public void unLinkFromStream() {
		if (mVideoView == null) {
			ThunderLog.warn(ThunderLog.kLogTagVideo,
					"unLinkFromStream: this view doesn't prepare or prepare failed!");
			return;
		}
		mStreamId = 0;
		mVideoView.unLinkFromStream();
	}

	/**
	 * 修改视频缩放模式<br/>
	 * @param scaleMode 缩放模式 {@link ThunderConstant.ThunderVideoViewScaleMode}
	 * @return 成功or失败
	 */
	public boolean setScaleMode(int scaleMode) {
		boolean  reasult = false;
		synchronized (this) {
			mScaleMode = scaleModeConvert(scaleMode);
			if (mVideoView == null) {
				ThunderLog.warn(ThunderLog.kLogTagVideo,
						"setScaleMode: this view doesn't prepare or prepare failed!");
				return false;
			}
			reasult = mVideoView.setScaleMode(mScaleMode);
		}
		return reasult;
	}

	@Override
	protected void onSizeChanged(int w, int h, int oldw, int oldh) {
		super.onSizeChanged(w, h, oldw, oldh);
		if (mVideoView != null) {
			mVideoView.onParentSizeChanged(w, h);
		}
	}

	public YSpVideoView getYspVideoView() {
		return 	mVideoView;
	}
}
