package com.yy.yylivesdk4cloud;

import com.yy.videoplayer.utils.YMFLog;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.video.IVideoDecodeObserver;;
import com.yy.yylivesdk4cloud.video.ThunderVideoLogCallback;

import java.util.ArrayList;

/**
 * Created by xiongxiong on 2017/10/30.
 */

public class ThunderPlayer {

	public ArrayList<ThunderStream> subscribeStreams = null;

	ThunderPlayer() {
		if (BuildConfig.__YY_VIDEO_SUPPORT__) {
			YMFLog.registerLogger(ThunderVideoLogCallback.sharedInstance());
		}
		subscribeStreams = new ArrayList<ThunderStream>(0);
	}

	/**
	 * 播放流
	 * <p>
	 * <br>拉流播放前使用API {@link ThunderAPI#setUserRole(int)} 设置用户角色
	 * <br>拉流播放状态通过监听通知{@link ThunderNotification#kThunderAPINotification_PlayStatus}获取
	 * <br>播放实时信息通过监听通知{@link ThunderNotification#kThunderAPINotification_PlayRunTimeInfo}获取
	 * <br>1. 填入跟自己角色匹配的流，例如：纯观众播放混画/转码的流，主播可以播放多条独立原流。
	 * <br>2. 可以同时播放streamList和groupList里面的所有流
	 * <br>3. 每个群组里的所有流都会被播放
	 * <br>4. 相同speakerUid的音频和视频配对进行同步
	 * </p>
	 *
	 * @param streamList 播放的流列表
	 * @param groupList  播放的群组列表
	 * @return 0：成功；<0：error
	 */
	public int startPlayStreams(ArrayList<ThunderStream> streamList, ArrayList<ThunderGroup> groupList) {
		if (streamList == null) {
			streamList = new ArrayList<ThunderStream>(0);
		}
		if (groupList == null) {
			groupList = new ArrayList<ThunderGroup>(0);
		}

		if (streamList.size() == 0 && groupList.size() == 0) {
			ThunderLog.warn(ThunderLog.kLogTagCall,
					"startPlayStreams both stream list and group list is empty");
			return -1;
		}

		for(ThunderStream oneStream : streamList) {
			if(oneStream.bVideo) {
				oneStream.startSubscribeTime = System.currentTimeMillis();
				subscribeStreams.add(oneStream);

				ThunderLog.release(ThunderLog.kLogTagCall, "startPlayStreams video streamName " + oneStream.streamName + "spkUid:" + oneStream.speakerUid + "toVideo: " + oneStream.toView);
			}
		}


		ThunderLog.release(ThunderLog.kLogTagCall, "startPlayStreams list size: %d %d",
				streamList.size(), groupList.size());
		return ThunderNative.startPlayStreams(streamList, groupList);
	}

	/**
	 * 停止播放流
	 * streamList，groupList 里的所有流都会被停止，不需要跟YYUserRole匹配
	 *
	 * @param streamList 流列表
	 * @param groupList  群组列表
	 * @return 0：成功；<0：error
	 */
	public int stopPlayStreams(ArrayList<ThunderStream> streamList, ArrayList<ThunderGroup> groupList) {
		if (streamList == null) {
			streamList = new ArrayList<ThunderStream>(0);
		}
		if (groupList == null) {
			groupList = new ArrayList<ThunderGroup>(0);
		}

		if (streamList.size() == 0 && groupList.size() == 0) {
			ThunderLog.warn(ThunderLog.kLogTagCall,
					"stopPlayStreams both stream list and group list is empty");
			return -1;
		}

        for(ThunderStream oneStream : streamList) {
            if(oneStream.bVideo) {
                for(ThunderStream rmStream : subscribeStreams) {
                    if(rmStream.bVideo && rmStream.speakerUid == oneStream.speakerUid) {
                        subscribeStreams.remove(rmStream);
                        break;
                    }
                }
            }
        }

		ThunderLog.release(ThunderLog.kLogTagCall, "stopPlayStreams list size: %d %d",
				streamList.size(), groupList.size());
		return ThunderNative.stopPlayStreams(streamList, groupList);
	}

	/**
	 * 是否使用硬解，播放视频之前调用
	 *
	 * @param enable 开启or关闭，默认开启
	 * @return 成功or失败
	 */
	public boolean enableHardwareDecoder(boolean enable) {
		ThunderLog.release(ThunderLog.kLogTagCall, "enableHardwareDecoder:%b", enable);
		return ThunderNative.enableHardwareDecoder(enable, ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264);
	}

//  更新渲染模式使用接口 YYLivePlayerView.setScaleMode
//	/**
//	 * 设置视频流显示模式, 一般在全屏切换等流尺寸可能变化的场合时调用
//	 * @param view      播放视频的view
//	 * @param scaleMode 显示模式
//	 * @param stream    视频流, 这个接口只取流名称、appId和主播uid
//	 * @return 成功or失败
//	 */
//	public boolean updatePlayVideoView(Object view, int scaleMode, ThunderStream stream) {
//		if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
//			return false;
//		}
//		if (stream == null || view == null) {
//			return false;
//		}
//
//		ThunderLog.release(ThunderLog.kLogTagCall, "updatePlayVideoView scale mode %d for stream %s",
//				scaleMode, stream.streamName);
//
//		return ThunderNative.updatePlayVideoView(view, scaleMode, stream);
//	}

	/**
	 * 开启静音
	 *
	 * @param enable 开启or关闭，默认关闭
	 * @param stream 音频流
	 * @return 成功or失败
	 */
	public boolean enableMute(boolean enable, ThunderStream stream) {
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}

		if (stream == null) {
			return false;
		}

		ThunderLog.release(ThunderLog.kLogTagCall,
				"enableMute %b for stream %s", enable, stream.streamName);

		return ThunderNative.enableMuteStream(enable, stream);
	}

	/**
	 * 开启静音
	 *
	 * @param enable 开启or关闭，默认关闭
	 * @param uid string型uid
	 * @return 成功or失败
	 */
	public boolean enableMute(boolean enable, String uid) {
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}

		ThunderLog.release(ThunderLog.kLogTagCall,
				"enableMute %b for %s", enable, uid);

		return ThunderNative.enableMuteStringUid(enable, uid);
	}

	/**
	 * 全部静音
	 */
	public boolean enableAllMute(boolean enable){
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}

		ThunderLog.release(ThunderLog.kLogTagCall,
				"enableAllMute %b", enable);

		ThunderNative.enableAllMute(enable);

		return true;
	}

	/**
	 * 设置播放音量， 实际播放的音量通过监听通知{@link ThunderNotification#kThunderAPINotification_AudioPlayVolume}获取
	 *
	 * @param volume 音量值，取值范围[0,100]
	 * @param stream 音频流
	 * @return 成功or失败
	 */
	public boolean setPlayVolume(int volume, ThunderStream stream) {
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}
		if (stream == null) {
			return false;
		}

		if (volume < 0) {
			volume  = 0;
		} else if (volume > 100) {
			volume = 100;
		}

		ThunderLog.release(ThunderLog.kLogTagCall,
				"setPlayVolume %d for stream %s", volume, stream.streamName);

		return ThunderNative.setStreamPlayVolume(volume, stream);
	}

	/**
	 * 设置扬声器音量
	 * @param volume
	 * @return
	 */
	public boolean setSpeakerVolume(int volume){
		if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
			return false;
		}

		if (volume < 0) {
			volume  = 0;
		} else if (volume > 100) {
			volume = 100;
		}

		ThunderLog.release(ThunderLog.kLogTagCall, "setSpeakerVolume %d", volume);

		return ThunderNative.setSpeakerVolume(volume);
	}

	/**
	 * 切换扬声器模式和听筒模式，SDK默认为扬声器模式，此接口不影响耳机的使用，插入耳机时，声音均通过耳机播放
	 *
	 * @param enable true - 扬声器模式; false - 听筒模式
	 */
	public void enableLoudSpeaker(boolean enable) {
		ThunderLog.release(ThunderLog.kLogTagCall, "enableLoudSpeaker %b", enable);
		ThunderNative.enableLoudSpeaker(enable);
	}

	/**
	 * 获取扬声器状态
	 * @return
	 */
	public boolean getLoudSpeakerEnabled(){
		ThunderLog.release(ThunderLog.kLogTagCall, "getLoudSpeakerEnabled");
		return ThunderNative.getLoudSpeakerEnabled();
	}


	public boolean isSupportPlayH265(){
		return ThunderNative.isSupportPlayH265();
	}

	public void setSubscribeStreamWHByUid(long uid, int _width, int _height) {
		for (ThunderStream oneStream : subscribeStreams) {
			if(oneStream.bVideo && oneStream.speakerUid == uid) {
				oneStream.width = _width;
				oneStream.height = _height;
			}
		}
	}

	public ThunderStream getSubscribeStreamByUid(long uid) {
		for (ThunderStream oneStream : subscribeStreams) {
			if(oneStream.bVideo && oneStream.speakerUid == uid) {
				return oneStream;
			}
		}
		return null;
	}

	public void removeSubscribeStreamByUid(long uid) {
		ThunderStream findStream = null;
		for (ThunderStream oneStream : subscribeStreams) {
			if(oneStream.bVideo && oneStream.speakerUid == uid) {
				findStream = oneStream;
			}
		}
		if(findStream != null) {
			subscribeStreams.remove(findStream);
		}
	}


	public void setVideoFrameObserver(String uid, IVideoDecodeObserver observer){
	    ThunderNative.setVideoFrameObserver(uid, observer);
	}
}
