package com.yy.yylivesdk4cloud;

import java.util.ArrayList;

/**
 * Created by aoe on 2018/11/23.
 */

public class ThunderLayout {
    /**
     * 连麦图像混画后输出视频分辨率宽
     */
    public int width;

    /**
     * 连麦图像混画后输出视频分辨率高
     */
    public int height;

    /**
     * 主播在各个连麦频道内的布局信息
     */
    public ArrayList<ThunderChannelLayout> layouts;

    /**
     * 主播uid (包括自己和连麦主播uid)
     */
    public ArrayList<String> speakers;

    /**
     * 输出字符串形式的配置信息
     * @return 返回字符串形式的配置信息，用于日志输出
     */
    public String toString() {
        String string = "{outputSize=" + this.width + "x" + this.height +
                        " speakers=";
        if (speakers != null && layouts != null) {
            for (String speaker : speakers) {
                string = string + speaker + ",";
            }
            string = string + "layouts=";
            for (ThunderChannelLayout layout : layouts) {
                string = string + layout.toString() + ",";
            }
        }
        string = string + "}";

        return string;
    }

    public String getSpeaker(int i) {
        if (this.speakers.size() <= i) {
            return "";
        }
        return this.speakers.get(i);
    }

    public ThunderChannelLayout getChannelLayout(int i) {
        if (this.layouts.size() <= i) {
            return null;
        }
        return this.layouts.get(i);
    }
}
