package com.yy.yylivesdk4cloud;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;

import com.yy.yylivesdk4cloud.helper.ThunderLog;

/**
 * Created by xiaojun on 2017/11/22.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class ThunderDeviceInfo {
	/**
	 * 设备系统版本号
	 */
	public String osVersion;
	/**
	 * 设备制造商
	 */
	public String manufacturer;
	/**
	 * 设备型号
	 */
	public String model;
	/**
	 * 设备ID
	 */
	public String deviceID;
	/**
	 * 应用信息: 名称、版本...
	 */
	public String appInfo;
	/**
	 * 用户设备识别码, 无符号64位
	 */
	public long imsi;

	private String getAppName(Context context) {
		try {
			ApplicationInfo info = context.getApplicationInfo();
			return context.getResources().getString(info.labelRes);
		}catch (Exception e){
			e.printStackTrace();
		}
		return "null";
	}

	private String getAppVersion(Context context) {
		try {
			PackageManager manager = context.getPackageManager();
			PackageInfo packageInfo = manager.getPackageInfo(context.getPackageName(), 0);
			return packageInfo.versionName;
		} catch(Exception e) {
			String msg = (e == null) ? "null" : e.getMessage();
			ThunderLog.warn(ThunderLog.kLogTagSdk, "read app version exception %s", msg);
		}
		return "null";
	}

	private static boolean isDebug(Context context) {
		ApplicationInfo info = context.getApplicationInfo();
		return info != null && (info.flags & ApplicationInfo.FLAG_DEBUGGABLE) != 0;

	}

	@SuppressLint("HardwareIds")
	ThunderDeviceInfo(Context context) {
		osVersion = "Android-" + Build.VERSION.SDK_INT;
		manufacturer = Build.MANUFACTURER;
		model = Build.MODEL;
		deviceID = "";
		imsi = 0;
		appInfo = getAppName(context);
		appInfo = appInfo + "-" + getAppVersion(context);
		if (isDebug(context)) {
			appInfo = appInfo + "-Debug";
		}

		ThunderLog.release(ThunderLog.kLogTagSdk, "Device info: %s %s %s, %s, %d, %s",
				manufacturer, model, osVersion, deviceID, imsi, appInfo);
	}
}
