/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.system;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Bundle;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;
import java.util.List;

public class YYForeBackgroundListener
implements Application.ActivityLifecycleCallbacks {
    private Context mContext;
    private boolean mIsAppOnBackground = false;

    public YYForeBackgroundListener(Context context) {
        this.mContext = context;
    }

    public void init() {
        ((Application)this.mContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void fini() {
        ((Application)this.mContext).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    private boolean isBackgroundRunning(Activity activity) {
        try {
            String processName = activity.getPackageName();
            ActivityManager activityManager = (ActivityManager)activity.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)activity.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List processList = activityManager.getRunningAppProcesses();
            if (processList == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo process : processList) {
                if (!process.processName.equalsIgnoreCase(processName)) continue;
                boolean isBackground = false;
                if (process.importance != 100 && process.importance != 200) {
                    isBackground = true;
                }
                boolean isLockedState = keyguardManager.inKeyguardRestrictedInputMode();
                return isBackground || isLockedState;
            }
        }
        catch (Exception e) {
            String msg = e == null ? "null" : e.getMessage();
            YYLiveLog.error("ysdk-Java", "isBackgroundRunning error:%s", msg);
        }
        return false;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        boolean flag;
        if (activity != null && this.mIsAppOnBackground && !(flag = this.isBackgroundRunning(activity))) {
            this.mIsAppOnBackground = false;
            YYLiveLog.info("ysdk-Java", "%s APP background -> foreground", activity.toString());
            YYLiveNative.enterForeground();
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        if (activity != null) {
            boolean flag = this.isBackgroundRunning(activity);
            if (!this.mIsAppOnBackground && flag) {
                YYLiveLog.info("ysdk-Java", "%s APP foreground -> background", activity);
                YYLiveNative.enterBackground();
            }
            this.mIsAppOnBackground = flag;
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

