/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.helper;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.yylivesdk4cloud.IYYLogCallback;
import com.yy.yylivesdk4cloud.YYDeviceInfo;
import com.yy.yylivesdk4cloud.YYLiveAPI;
import com.yy.yylivesdk4cloud.YYLiveAudioCapture;
import com.yy.yylivesdk4cloud.YYLiveAudioFilePlayer;
import com.yy.yylivesdk4cloud.YYLiveChannelLayout;
import com.yy.yylivesdk4cloud.YYLiveGroup;
import com.yy.yylivesdk4cloud.YYLiveLayout;
import com.yy.yylivesdk4cloud.YYLiveNotification;
import com.yy.yylivesdk4cloud.YYLiveNotificationInside;
import com.yy.yylivesdk4cloud.YYLiveStream;
import com.yy.yylivesdk4cloud.YYLiveStreamInfo;
import com.yy.yylivesdk4cloud.YYLiveStreamLevelInfo;
import com.yy.yylivesdk4cloud.YYLiveStreamLineInfo;
import com.yy.yylivesdk4cloud.YYLiveVideoCapture;
import com.yy.yylivesdk4cloud.YYPublishAudioConfig;
import com.yy.yylivesdk4cloud.YYPublishInfo;
import com.yy.yylivesdk4cloud.YYPublishVideoConfig;
import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.helper.GSLBMethod;
import com.yy.yylivesdk4cloud.helper.HPMarshaller;
import com.yy.yylivesdk4cloud.helper.Marshallable;
import com.yy.yylivesdk4cloud.helper.MshBuffer;
import com.yy.yylivesdk4cloud.helper.NativeByteBufferPool;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoConfigManager;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class YYLiveNative {
    private static IYYLogCallback s_logCallback = null;
    private static NotificationDispatcher s_notificationDispatcher = null;
    private static YYLiveNotificationInside.PublishVideoCfg mPublishVideoCfg = null;
    private static ReentrantLock s_notificationLock = null;
    private static GSLBMethod mGslbMethod = null;
    private static final int YYLIVE_SDK_INIT = 1;
    private static final int YYLIVE_SDK_FINI = 2;
    private static final int YYLIVE_ENABLE_LOG = 3;
    private static final int YYLIVE_SET_SCENE_ID = 4;
    private static final int YYLIVE_SET_USER_ROLE = 5;
    private static final int YYLIVE_LOG_TEXT = 6;
    private static final int YYLIVE_JOIN_MEDIA = 7;
    private static final int YYLIVE_LEAVE_MEDIA = 8;
    private static final int YYLIVE_ENABLE_LOW_LATENCY = 9;
    private static final int YYLIVE_UPDATE_TOKEN = 10;
    private static final int YYLIVE_JOIN_MEDIA_STR_UID = 11;
    private static final int YYLIVE_JOIN_CHANNEL = 12;
    private static final int YYLIVE_LEAVE_CHANNEL = 13;
    private static final int YYLIVE_SET_AREA_TYPE = 14;
    private static final int YYLIVE_SET_CHANNEL_PROFILE = 15;
    private static final int YYLIVE_SET_PLAY_VOLUME_INTERVAL = 16;
    private static final int YYLIVE_SET_CAPTURE_VOLUME_INTERVAL = 17;
    private static final int YYLIVE_START_AUDIO_SAVER = 18;
    private static final int YYLIVE_STOP_AUDIO_SAVER = 19;
    private static final int YYLIVE_FETCHED_LOG_CONFIG = 20;
    private static final int YYLIVE_SET_VOICE_ONLY_SDK = 21;
    private static final int YYLIVE_SET_ARGO_CONFIG = 22;
    private static final int YYLIVE_SET_HTTPS_RESPONSE = 23;
    private static final int YYLIVE_SET_CHANNEL_NAME = 24;
    private static final int YYLIVE_SET_RECORD_AUDIO_PARAMS = 25;
    private static final int YYLIVE_SET_PLAY_AUDIO_PARAMS = 26;
    private static final int YYLIVE_START_PLAY_STREAMS = 101;
    private static final int YYLIVE_STOP_PLAY_STREAMS = 102;
    private static final int YYLIVE_ENABLE_HARDWARE_DECODER = 103;
    private static final int YYLIVE_UPDATE_PLAY_VIDEO_VIEW = 104;
    private static final int YYLIVE_ENABLE_MUTE_STREAM = 105;
    private static final int YYLIVE_SET_STREAM_PLAY_VOLUME = 106;
    private static final int YYLIVE_VIDEO_RENDER_EVENT = 107;
    private static final int YYLIVE_ENABLE_LOUD_SPEAKER = 108;
    private static final int YYLIVE_GET_LOUDSPEAKER_ENABLED = 109;
    private static final int YYLIVE_SET_SPEAKER_VOLUME = 110;
    private static final int YYLIVE_ENABLE_ALL_MUTE = 111;
    private static final int YYLIVE_IS_SUPPORT_H265 = 112;
    private static final int YYLIVE_ENABLE_MUTE_STRING_UID = 113;
    private static final int YYLIVE_START_PUBLISH_AUDIO = 201;
    private static final int YYLIVE_STOP_PUBLISH_AUDIO = 202;
    private static final int YYLIVE_START_PUBLISH_VIDEO = 203;
    private static final int YYLIVE_STOP_PUBLISH_VIDEO = 204;
    private static final int YYLIVE_SET_MIC_VOLUME = 205;
    private static final int YYLIVE_ENABLE_VAD = 206;
    private static final int YYLIVE_START_VIDEO_PREVIEW = 207;
    private static final int YYLIVE_STOP_VIDEO_PREVIEW = 208;
    private static final int YYLIVE_UPDATE_VIDEO_CONFIG = 209;
    private static final int YYLIVE_SET_CAMERA_POSTION = 210;
    private static final int YYLIVE_SET_WATERMARK = 211;
    private static final int YYLIVE_SET_FACE_BEAUTY_LEVEL = 212;
    private static final int YYLIVE_ATTACH_AUDIO_CAPTURE = 213;
    private static final int YYLIVE_SET_MIX_AUDIO_CAPTURE = 214;
    private static final int YYLIVE_ATTACH_VIDEO_CAPTURE = 215;
    private static final int YYLIVE_SET_MIX_VIDEO_CAPTURE = 216;
    private static final int YYLIVE_SET_PUBLISH_RTMP_PARAM = 217;
    private static final int YYLIVE_CHANGE_SCREEN_LIVE_MODE = 218;
    private static final int YYLIVE_START_PUBLISH_LIVE = 220;
    private static final int YYLIVE_UPDATE_PUBLISH_LIVE = 221;
    private static final int YYLIVE_STOP_PUBLISH_LIVE = 222;
    private static final int YYLIVE_SET_ORIENTATION = 223;
    private static final int YYLIVE_SET_SOUND_EFFECT = 224;
    private static final int YYLIVE_START_CAPTURE = 225;
    private static final int YYLIVE_STOP_CAPTURE = 226;
    private static final int YYLIVE_SET_PREVIEW_RENDER_MODE = 227;
    private static final int YYLIVE_RESOLVE_SERVICE_DATA = 228;
    private static final int YYLIVE_ON_VIDEO_SIZE_CHANGE = 229;
    private static final int YYLIVE_ON_RENDER_FIRST_FRAME = 230;
    private static final int YYLIVE_SET_PLAYVIEW_SCALEMODE = 231;
    private static final int YYLIVE_STOP_AND_RECOVER_VIDEO_ENCODE = 232;
    private static final int YYLIVE_ENTER_BACKGROUND = 301;
    private static final int YYLIVE_ENTER_FOREGROUND = 302;
    private static final int YYLIVE_NOTIFY_NETWORK_STATE = 303;
    private static final int YYLIVE_AUDIO_FILE_OPEN = 401;
    private static final int YYLIVE_AUDIO_FILE_CLOSE = 402;
    private static final int YYLIVE_AUDIO_FILE_PLAY = 403;
    private static final int YYLIVE_AUDIO_FILE_STOP = 404;
    private static final int YYLIVE_AUDIO_FILE_PAUSE = 405;
    private static final int YYLIVE_AUDIO_FILE_RESUME = 406;
    private static final int YYLIVE_AUDIO_FILE_SEEK = 407;
    private static final int YYLIVE_AUDIO_FILE_GET_TOTAL_TIME = 408;
    private static final int YYLIVE_AUDIO_FILE_GET_CURRENT_TIME = 409;
    private static final int YYLIVE_AUDIO_FILE_SET_PLAY_VOLUME = 410;
    private static final int YYLIVE_AUDIO_FILE_SET_SEMITONE = 411;
    private static final int YYLIVE_AUDIO_FILE_ENABLE_PUBLISH = 412;
    private static final int YYLIVE_AUDIO_SET_EXTERNAL_PROCESSOR = 414;
    private static final int YYLIVE_AUDIO_FILE_PUBLISH_BYMODE = 415;
    private static final int YYLIVE_AUDIO_ENABLE_AUDIO_PLAY_SPECTRUM = 416;
    private static final int YYLIVE_AUDIO_SET_AUDIO_PLAY_SPECTRUM_INFO = 417;
    private static final int YYLIVE_AUDIO_FILE_SET_COMPENSATE_VALUE = 418;
    private static final int YYLIVE_AUDIO_ENABLE_CAPTURE_PCM_DATA_CALLBACK = 419;
    private static final int YYLIVE_AUDIO_ENABLE_AUDIO_DATA_INDICATION = 420;
    private static final int YYLIVE_CREATE_AUDIO_FILE_PLAYER = 421;
    private static final int YYLIVE_DESTROY_AUDIO_FILE_PLAYER = 422;
    private static final int YYLIVE_AUDIO_ENABLE_RENDER_PCM_DATA_CALLBACK = 423;
    private static final int YYLIVE_AUDIO_FILE_ENABLE_VOLUME_CALLBACK = 424;
    private static final int YYLIVE_AUDIO_EFFECT_ENABLE_EQUALIZER = 501;
    private static final int YYLIVE_AUDIO_EFFECT_SET_EQUALIZER = 502;
    private static final int YYLIVE_AUDIO_EFFECT_ENABLE_COMPRESSOR = 503;
    private static final int YYLIVE_AUDIO_EFFECT_SET_COMPRESSOR = 504;
    private static final int YYLIVE_AUDIO_EFFECT_ENABLE_REVERB = 505;
    private static final int YYLIVE_AUDIO_EFFECT_SET_REVERB = 506;
    private static final int YYLIVE_SET_AUDIO_SOURCE_TYPE = 507;
    private static final int YYLIVE_ENABLE_IN_EAR_MONITOR = 508;
    private static final int YYLIVE_AUDIO_EFFECT_SET_LIMITER = 509;
    private static final int YYLIVE_AUDIO_EFFECT_ENABLE_LIMITER = 510;
    private static final int YYLIVE_SEND_USER_APP_MSG_DATA = 601;
    private static Boolean isInit = false;
    private static int s_audioCaptureVolumeNotificationCount = 0;
    private static int s_audioPlayVolumeNotificationCount = 0;
    private static int s_playRuntimeNotificationCount = 0;
    private static int s_publishRuntimeNotificationCount = 0;

    private static native int YYLiveSdkInit(Context var0, byte[] var1);

    private static native void YYLiveSdkFini();

    private static native long YYLiveSdkProcess(int var0, byte[] var1);

    private static native String YYLiveSdkGetVersion();

    private static native int YYLiveSdkGetVersionInt();

    private static native long YYLiveObjectToPtr(Object var0);

    private static native void YYLiveRegisterAudioObserver(IAudioFrameObserver var0);

    public static YYPublishVideoConfig getVideoConfig() {
        VideoLiveConfig config = VideoConfigManager.instance().getCurrentVideoLiveConfig();
        YYPublishVideoConfig result = new YYPublishVideoConfig();
        result.playType = config.playType;
        result.mode = config.videoLevel;
        if (config.encodeId == VideoEncoderType.HARD_ENCODER_H264) {
            result.hardwareEncoder = true;
            result.encodeType = 1;
        } else if (config.encodeId == VideoEncoderType.HARD_ENCODER_H265) {
            result.hardwareEncoder = true;
            result.encodeType = 2;
        } else {
            result.hardwareEncoder = false;
            result.encodeType = 1;
        }
        result.encodeBitrate = config.curRate / 1000;
        result.encodeFrameRate = config.frameRate;
        result.encodeResolutionHeight = config.videoHeight;
        result.encodeResolutionWidth = config.videoWidth;
        return result;
    }

    public static YYPublishInfo getPublishInfo() {
        VideoLiveConfig config = VideoConfigManager.instance().getCurrentVideoLiveConfig();
        if (config == null) {
            return null;
        }
        YYPublishInfo result = new YYPublishInfo();
        result.playType = config.playType;
        result.publishMode = config.videoLevel;
        if (config.encodeId == VideoEncoderType.HARD_ENCODER_H264) {
            result.hardwareEncoder = true;
            result.encodeType = 1;
        } else if (config.encodeId == VideoEncoderType.HARD_ENCODER_H265) {
            result.hardwareEncoder = true;
            result.encodeType = 2;
        } else {
            result.hardwareEncoder = false;
            result.encodeType = 1;
        }
        result.bitrate = config.curRate / 1000;
        result.frameRate = config.frameRate;
        result.encodeHeight = config.videoHeight;
        result.encodeWidth = config.videoWidth;
        return result;
    }

    public static HashMap<Integer, String> getSupportModeInfoWithPlayType(int playType) {
        return VideoConfigManager.instance().getModeListByPlayType(playType);
    }

    public static int getDefaultPublishVideoMode(int playType) {
        return VideoConfigManager.instance().getDefaultPublishVideoMode(playType);
    }

    public static void disableHardEncoder(Boolean disable) {
        VideoConfigManager.instance().disableHardEncode(disable);
    }

    public static YYPublishVideoConfig getRemoteVideoConfig(int playType, int publishMode) {
        YYPublishVideoConfig result = new YYPublishVideoConfig();
        VideoEncoderConfig encoderConfig = VideoConfigManager.instance().getVideoEncodeConfigByType(playType, publishMode);
        result.playType = playType;
        result.mode = publishMode;
        if (encoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
            result.hardwareEncoder = true;
            result.encodeType = 1;
        } else if (encoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
            result.hardwareEncoder = true;
            result.encodeType = 2;
        } else {
            result.hardwareEncoder = false;
            result.encodeType = 1;
        }
        result.encodeBitrate = encoderConfig.mBitRate / 1000;
        result.encodeMaxBitrate = encoderConfig.mMaxBitRate / 1000;
        result.encodeFrameRate = encoderConfig.mFrameRate;
        result.encodeResolutionHeight = encoderConfig.mEncodeHeight;
        result.encodeResolutionWidth = encoderConfig.mEncodeWidth;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int init(long appId, long sceneId, Context appContext, YYDeviceInfo info, NotificationDispatcher handlers) {
        if (s_notificationLock == null) {
            s_notificationLock = new ReentrantLock();
        }
        s_notificationLock.lock();
        try {
            s_notificationDispatcher = handlers;
        }
        finally {
            s_notificationLock.unlock();
        }
        if (mGslbMethod == null) {
            mGslbMethod = new GSLBMethod();
            mGslbMethod.initService(appContext);
        }
        YLESdkInit yle = new YLESdkInit(appId, sceneId, info);
        MshBuffer buffer = new MshBuffer(4096, NativeByteBufferPool.get());
        int ret = YYLiveNative.YYLiveSdkInit(appContext, yle.HPmarshall(buffer));
        buffer.freeBuffer();
        isInit = true;
        return ret;
    }

    public static void fini() {
        isInit = false;
        s_notificationLock.lock();
        try {
            s_notificationDispatcher = null;
        }
        finally {
            s_notificationLock.unlock();
        }
        if (mGslbMethod != null) {
            mGslbMethod.destroyService();
            mGslbMethod = null;
        }
        YYLiveNative.YYLiveSdkFini();
    }

    public static String getVersion() {
        return YYLiveNative.YYLiveSdkGetVersion();
    }

    public static int getVersionInt() {
        return YYLiveNative.YYLiveSdkGetVersionInt();
    }

    public static void registerAudioFrameObserver(IAudioFrameObserver observer) {
        YYLiveNative.YYLiveRegisterAudioObserver(observer);
    }

    private static long YLEProcess(YLEBase e) {
        MshBuffer buffer = new MshBuffer(4096, NativeByteBufferPool.get());
        long ret = YYLiveNative.YYLiveSdkProcess(e.event(), e.HPmarshall(buffer));
        buffer.freeBuffer();
        return ret;
    }

    public static void enableLog(boolean enable, IYYLogCallback callback, int level, String logPath) {
        s_logCallback = callback;
        YYLiveNative.YLEProcess(new YLEEnableLog(enable, callback != null, level, logPath));
    }

    public static void fetchedLogConfig() {
        YYLiveNative.YLEProcess(new YLEFetchedLogConfig());
    }

    public static void setSceneId(long sceneId) {
        YYLiveNative.YLEProcess(new YLESetSceneId(sceneId));
    }

    public static void setUserRole(int role) {
        YYLiveNative.YLEProcess(new YLESetUserRole(role));
    }

    public static void setArgoConfig(HashMap<Integer, Integer> cfg) {
        if (isInit.booleanValue()) {
            YYLiveNative.YLEProcess(new YLESetArgoConfig(cfg));
        }
    }

    public static void logText(int level, int module, String tag, String text) {
        YYLiveNative.YLEProcess(new YLELogText(level, module, tag, text));
    }

    public static void joinMedia(long uid, long sid, long subSid) {
        YYLiveNative.YLEProcess(new YLEJoinMedia(uid, sid, subSid));
    }

    public static void joinMedia(String uid, long sid, long subSid) {
        YYLiveNative.YLEProcess(new YLEJoinMediaStrUid(uid, sid, subSid));
    }

    public static void leaveMedia() {
        YYLiveNative.YLEProcess(new YLELeaveMedia());
    }

    public static void joinChannel(String channelId, String uid, boolean is32Bit, int role) {
        YYLiveAPI.sharedInstance().getPublishChannel().syncUserInfo(channelId, uid, is32Bit, role);
        YYLiveNative.YLEProcess(new YLEJoinChannel(channelId, uid, is32Bit, role));
    }

    public static void leaveChannel() {
        YYLiveAPI.sharedInstance().getPublishChannel().syncUserInfo(null, null, true, 0);
        YYLiveNative.YLEProcess(new YLELeaveChannel());
    }

    public static void enableLowLatency(boolean enable) {
        YYLiveNative.YLEProcess(new YLEEnableLowLatency(enable));
    }

    public static void setChannelProfile(int profile) {
        YYLiveNative.YLEProcess(new YLESetChannelProfile(profile));
    }

    public static void setChannelName(String channelName) {
        YYLiveNative.YLEProcess(new YLESetChannelName(channelName));
    }

    public static void setPlayVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        YYLiveNative.YLEProcess(new YLESetPlayVolumeInterval(interval, moreThanThd, lessThanThd));
    }

    public static void onUpdateVideoSizeChanged(long uid, int width, int height) {
        YYLiveNative.YLEProcess(new YLEOnVideoSizeChange(uid, width, height));
    }

    public static void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond, long firstFrameToRenderInMilliSec, int eatenFrames) {
        YYLiveNative.YLEProcess(new YLEOnRenderFirstFrame(userGroupId, streamId, currentSystemMilliSecond, firstFrameToRenderInMilliSec, eatenFrames));
    }

    public static void setCaptureVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        YYLiveNative.YLEProcess(new YLESetCaptureVolumeInterval(interval, moreThanThd, lessThanThd));
    }

    public static boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        return YYLiveNative.YLEProcess(new YLEStartAudioSaver(fileName, saverMode, fileMode)) == 0L;
    }

    public static boolean stopAudioSaver() {
        return YYLiveNative.YLEProcess(new YLEStopAudioSaver()) == 0L;
    }

    public static boolean setSoundEffect(int soundEffectMode) {
        return YYLiveNative.YLEProcess(new YLESetSoundEffect(soundEffectMode)) == 0L;
    }

    public static void resolveServiceData(String uid, int uri, byte[] data) {
        YYLiveNative.YLEProcess(new YLEResolveServiceData(uri, uid, data));
    }

    public static void setVoiceOnlySdk(boolean enable) {
        YYLiveNative.YLEProcess(new YLESetVoiceOnlySdk(enable));
    }

    public static void updateToken(byte[] token, byte[] bizAuthExtInfo) {
        YYLiveNative.YLEProcess(new YLEUpdateToken(token, bizAuthExtInfo));
    }

    public static void setAreaType(int areaType) {
        YYLiveLog.info("ycall-Java", "setAreaType %d", areaType);
        YYLiveNative.YLEProcess(new YLESetAreaType(areaType));
    }

    public static int startPlayStreams(ArrayList<YYLiveStream> streamList, ArrayList<YYLiveGroup> groupList) {
        return (int)YYLiveNative.YLEProcess(new YLEStartPlayStreams(streamList, groupList));
    }

    public static int stopPlayStreams(ArrayList<YYLiveStream> streamList, ArrayList<YYLiveGroup> groupList) {
        return (int)YYLiveNative.YLEProcess(new YLEStopPlayStreams(streamList, groupList));
    }

    public static boolean enableHardwareDecoder(boolean enable, int decodeType) {
        return YYLiveNative.YLEProcess(new YLEEnableHardwareDecoder(enable, decodeType)) != 0L;
    }

    public static boolean updatePlayVideoView(Object view, int scaleMode, YYLiveStream stream) {
        return YYLiveNative.YLEProcess(new YLEUpdatePlayVideoView(view, scaleMode, stream)) != 0L;
    }

    public static boolean enableMuteStream(boolean enable, YYLiveStream stream) {
        return YYLiveNative.YLEProcess(new YLEEnableMuteStream(enable, stream)) != 0L;
    }

    public static boolean enableMuteStringUid(boolean enable, String uid) {
        return YYLiveNative.YLEProcess(new YLEEnableMuteStringUid(enable, uid)) != 0L;
    }

    public static boolean enableAllMute(boolean enable) {
        return YYLiveNative.YLEProcess(new YLEEnableAllMute(enable)) != 0L;
    }

    public static boolean setStreamPlayVolume(int volume, YYLiveStream stream) {
        return YYLiveNative.YLEProcess(new YLESetStreamPlayVolume(volume, stream)) != 0L;
    }

    public static boolean setSpeakerVolume(int volume) {
        return YYLiveNative.YLEProcess(new YLESetSpeakerVolume(volume)) != 0L;
    }

    public static void onVideoRenderEvent(long callBackPtr, ArrayList<VideoRenderNotify> notifications) {
        YYLiveNative.YLEProcess(new YLEVideoRenderEvent(callBackPtr, notifications));
    }

    public static void enableLoudSpeaker(boolean enable) {
        YYLiveNative.YLEProcess(new YLEEnableLoudSpeaker(enable));
    }

    public static boolean getLoudSpeakerEnabled() {
        return YYLiveNative.YLEProcess(new YLEGetLoudSpeakerEnabled()) != 0L;
    }

    public static boolean isSupportPlayH265() {
        return YYLiveNative.YLEProcess(new YLEIsSupportPlayH265()) != 0L;
    }

    public static int startPublishAudio(String streamName, ArrayList<String> groupNames, YYPublishAudioConfig config) {
        return (int)YYLiveNative.YLEProcess(new YLEStartPublishAudio(streamName, groupNames, config));
    }

    public static int stopPublishAudio() {
        return (int)YYLiveNative.YLEProcess(new YLEStopPublishAudio());
    }

    public static boolean setMicVolume(int volume) {
        return YYLiveNative.YLEProcess(new YLESetMicVolume(volume)) != 0L;
    }

    public static void enableVad(boolean enable) {
        YYLiveNative.YLEProcess(new YLEEnableVad(enable));
    }

    public static void setOrientation(int ori) {
        YYLiveNative.YLEProcess(new YLESetOrientation(ori));
    }

    public static void EnableEqualizer(boolean enable) {
        YYLiveNative.YLEProcess(new YLEEnableEqualizer(enable));
    }

    public static void SetGqGains(int[] gains) {
        YYLiveNative.YLEProcess(new YLESetGqGains(gains));
    }

    public static void EnableCompressor(boolean enable) {
        YYLiveNative.YLEProcess(new YLEEnableCompressor(enable));
    }

    public static void EnableLimiter(boolean enable) {
        YYLiveNative.YLEProcess(new YLEEnableLimiter(enable));
    }

    public static void SetCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime, int attackTime) {
        YYLiveNative.YLEProcess(new YLESetCompressorParam(threshold, makeupGain, ratio, knee, releaseTime, attackTime));
    }

    public static void EnableReverb(boolean enable) {
        YYLiveNative.YLEProcess(new YLEEnableReverb(enable));
    }

    public static void setReverbExParameter(float RoomSize, float PreDelay, float Reverberance, float HfDamping, float ToneLow, float ToneHigh, float WetGain, float DryGain, float StereoWidth) {
        YYLiveNative.YLEProcess(new YLEsetReverbExParameter(RoomSize, PreDelay, Reverberance, HfDamping, ToneLow, ToneHigh, WetGain, DryGain, StereoWidth));
    }

    public static int startVideoPreview(Object view, int playType, int publishMode) {
        return (int)YYLiveNative.YLEProcess(new YLEStartVideoPreview(view, playType, publishMode));
    }

    public static int setPlayViewScaleMode(Object view, int mode) {
        return (int)YYLiveNative.YLEProcess(new YLESetPlayViewScaleMode(view, mode));
    }

    public static void setLimiterParameter(float fCeiling, float fThreshold, float fPreGain, float fRelease, float fAttack, float fLookahead, float fLookaheadRatio, float fRMS, float fStLink) {
        YYLiveNative.YLEProcess(new YLEsetLimiterParameter(fCeiling, fThreshold, fPreGain, fRelease, fAttack, fLookahead, fLookaheadRatio, fRMS, fStLink));
    }

    public static void setAudioSourceType(int mode) {
        YYLiveNative.YLEProcess(new YLEsetAudioSourceType(mode));
    }

    public static boolean enableInEarMonitor(boolean enable) {
        return YYLiveNative.YLEProcess(new YLEenableInEarMonitor(enable)) != 0L;
    }

    public static void stopAndRecoverVideoEncode(boolean isStop) {
        YYLiveNative.YLEProcess(new YLEstopAndRcoverVideoEncode(isStop));
    }

    public static int stopVideoPreview() {
        return (int)YYLiveNative.YLEProcess(new YLEStopVideoPreview());
    }

    public static void setLivePublishRtmpParam(boolean bOpen, String url, String playPath) {
        YYLiveNative.YLEProcess(new YLEsetPublishRtmpParam(bOpen, url, playPath));
    }

    public static int startPublishVideo(String streamName, ArrayList<String> groupNames, YYPublishVideoConfig config) {
        return (int)YYLiveNative.YLEProcess(new YLEStartPublishVideo(streamName, groupNames, config));
    }

    public static int stopPublishVideo() {
        return (int)YYLiveNative.YLEProcess(new YLEStopPublishVideo());
    }

    public static int startPublishLive(String channelId, boolean uniq, YYPublishVideoConfig videoConfig, YYPublishAudioConfig audioConfig, YYLiveLayout layout) {
        return (int)YYLiveNative.YLEProcess(new YLEStartPublishLive(channelId, uniq, videoConfig, audioConfig, layout));
    }

    public static int updatePublishLive(String channelId, boolean uniq, YYPublishVideoConfig videoConfig, YYPublishAudioConfig audioConfig, YYLiveLayout layout) {
        return (int)YYLiveNative.YLEProcess(new YLEUpdatePublishLive(channelId, uniq, videoConfig, audioConfig, layout));
    }

    public static int stopPublishLive(String channelId) {
        return (int)YYLiveNative.YLEProcess(new YLEStopPublishLive(channelId));
    }

    public static boolean updateVideoConfig(YYPublishVideoConfig config) {
        return YYLiveNative.YLEProcess(new YLEUpdateVideoConfig(config)) != 0L;
    }

    public static boolean setCameraPosition(int postion) {
        return YYLiveNative.YLEProcess(new YLESetCameraPosition(postion)) != 0L;
    }

    public static int setWatermark(int posX, int posY, Bitmap image) {
        return (int)YYLiveNative.YLEProcess(new YLESetWatermark(posX, posY, image));
    }

    public static int setFaceBeautyLevel(float level) {
        return (int)YYLiveNative.YLEProcess(new YLESetFaceBeautyLevel(level));
    }

    public static void attachAudioCapture(YYLiveAudioCapture capture) {
        YYLiveNative.YLEProcess(new YLEAttachAudioCapture(capture));
    }

    public static void attachVideoCapture(YYLiveVideoCapture capture) {
        YYLiveNative.YLEProcess(new YLEAttachVideoCapture(capture));
    }

    public static int startCapture() {
        return (int)YYLiveNative.YLEProcess(new YLEStartCapture());
    }

    public static int stopCapture() {
        return (int)YYLiveNative.YLEProcess(new YLEStopCapture());
    }

    public static int setPreviewRenderMode(int mode) {
        return (int)YYLiveNative.YLEProcess(new YLESetPreviewRenderMode(mode));
    }

    public static void changeScreenLiveMode(boolean bPicMode, Object bitmap) {
        YYLiveNative.YLEProcess(new YLEChangeScreenLiveMode(bPicMode, bitmap));
    }

    public static void notifyNetState(int state) {
        YYLiveNative.YLEProcess(new YLENotifyNetworkState(state));
    }

    public static void enterBackground() {
        YYLiveNative.YLEProcess(new YLEEnterBackground());
    }

    public static void enterForeground() {
        YYLiveNative.YLEProcess(new YLEEnterForeground());
    }

    public static long createAudioFilePlayer(Object obj) {
        return YYLiveNative.YLEProcess(new YLECreateAudioFilePlayer(obj));
    }

    public static long destroyAudioFilePlayer(long ctx) {
        return YYLiveNative.YLEProcess(new YLEAudioFileEventCommon(422, ctx));
    }

    public static long audioFileOpen(long ctx, String path) {
        return YYLiveNative.YLEProcess(new YLEAudioFileOpen(ctx, path));
    }

    public static void audioFileClose(long ctx) {
        YYLiveNative.YLEProcess(new YLEAudioFileEventCommon(402, ctx));
    }

    public static void audioFilePlay(long ctx) {
        YYLiveNative.YLEProcess(new YLEAudioFileEventCommon(403, ctx));
    }

    public static void audioFileStop(long ctx) {
        YYLiveNative.YLEProcess(new YLEAudioFileEventCommon(404, ctx));
    }

    public static void audioFilePause(long ctx) {
        YYLiveNative.YLEProcess(new YLEAudioFileEventCommon(405, ctx));
    }

    public static void audioFileResume(long ctx) {
        YYLiveNative.YLEProcess(new YLEAudioFileEventCommon(406, ctx));
    }

    public static void audioFileSeek(long ctx, long timeMS) {
        YYLiveNative.YLEProcess(new YLEAudioFileSeek(ctx, timeMS));
    }

    public static long audioFileGetTotalTime(long ctx) {
        return YYLiveNative.YLEProcess(new YLEAudioFileEventCommon(408, ctx));
    }

    public static long audioFileGetCurrentPlayTime(long ctx) {
        return YYLiveNative.YLEProcess(new YLEAudioFileEventCommon(409, ctx));
    }

    public static void audioFileSetPlayVolume(long ctx, int volume) {
        YYLiveNative.YLEProcess(new YLEAudioFileSetPlayVolume(ctx, volume));
    }

    public static void audioFileSetSemitone(long ctx, float val) {
        YYLiveNative.YLEProcess(new YLEAudioFileSetSemitone(ctx, val));
    }

    public static void audioFileEnablePublish(long ctx, boolean enable) {
        YYLiveNative.YLEProcess(new YLEAudioFileEnablePublish(ctx, enable));
    }

    public static void audioFileSetCompensateValue(long ctx, int value) {
        YYLiveNative.YLEProcess(new YLEAudioFileSetCompensateValue(ctx, value));
    }

    public static void audioFilePublishByMode(long ctx, int mode) {
        YYLiveNative.YLEProcess(new YLEAudioFilePublishByMode(ctx, mode));
    }

    public static void enableAudioFileVolumeCallback(long ctx, boolean enable, int interval) {
        YYLiveNative.YLEProcess(new YLEEnableAudioFileVolumeCallback(ctx, enable, interval));
    }

    public static void setExternalAudioProcessor(long eap) {
        YYLiveNative.YLEProcess(new YLEAudioSetExternalProcessor(eap));
    }

    public static void enableAudioPlaySepctrum(boolean enable) {
        YYLiveNative.YLEProcess(new YLEEnableAudioPlaySpectrum(enable));
    }

    public static void setAudioPlaySepctrumInfo(int spectrumLen, int notifyIntervalMS) {
        YYLiveNative.YLEProcess(new YLESetAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS));
    }

    public static void enableAudioDataIndication(boolean enable) {
        YYLiveNative.YLEProcess(new YLEEnableAudioDataIndication(enable));
    }

    public static void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        YYLiveNative.YLEProcess(new YLEEnableCapturePcmDataCallBack(enable, sampleRate, channel));
    }

    public static void enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        YYLiveNative.YLEProcess(new YLEEnableRenderPcmDataCallBack(enable, sampleRate, channel));
    }

    public static void sendUserAppMsgData(byte[] msgData) {
        YYLiveNative.YLEProcess(new YLESendUserAppMsgData(msgData));
    }

    public static void setHttpsBinaryResponse(String reqUrl, byte[] response, int statusCode, int errCode, int target) {
        YYLiveNative.YLEProcess(new YLESetHttpsBinaryResponse(reqUrl, response, statusCode, errCode, target));
    }

    public static void setHttpsTextResponse(String reqUrl, String response, int statusCode, int errCode, int target) {
        YYLiveNative.YLEProcess(new YLESetHttpsTextResponse(reqUrl, response, statusCode, errCode, target));
    }

    public static void setRecordingAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        YYLiveNative.YLEProcess(new YLESetRecordingAudioFrameParameters(sampleRate, channel, mode, samplesPerCall));
    }

    public static void setPlaybackAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        YYLiveNative.YLEProcess(new YLESetPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void notificationCallback(int type, byte[] data) {
        s_notificationLock.lock();
        try {
            YLNBase yln;
            if (s_notificationDispatcher == null) {
                return;
            }
            switch (type) {
                case 0: {
                    yln = new YLNPublishStatus();
                    break;
                }
                case 1: {
                    yln = new YLNPublishRunTimeInfo();
                    break;
                }
                case 2: {
                    yln = new YLNPlayStatus();
                    break;
                }
                case 3: {
                    yln = new YLNPlayRunTimeInfo();
                    break;
                }
                case 4: {
                    yln = new YLNAudioCaptureVolume();
                    break;
                }
                case 5: {
                    yln = new YLNAudioVolume();
                    break;
                }
                case 6: {
                    yln = new YLNBizAuthRes();
                    break;
                }
                case 7: {
                    yln = new YLNSdkAuthRes();
                    break;
                }
                case 8: {
                    yln = new YLNUninstallSdk();
                    break;
                }
                case 9: {
                    yln = new YLNStringUid();
                    break;
                }
                case 10: {
                    yln = new YLNJoinChannelStatus();
                    break;
                }
                case 11: {
                    yln = new YLNAllStreamNotify();
                    break;
                }
                case 12: {
                    yln = new YLNRtmpPublishStatus();
                    break;
                }
                case 13: {
                    yln = new YLNResolutionChangeInfo();
                    break;
                }
                case 14: {
                    yln = new YLNAudioData();
                    break;
                }
                case 15: {
                    yln = new YLNAudioPlaySpectrumData();
                    break;
                }
                case 16: {
                    yln = new YLNAudioCapturePcmData();
                    break;
                }
                case 17: {
                    yln = new YLNUserAppMsgData();
                    break;
                }
                case 18: {
                    yln = new YLNAppMsgDataFailedStatus();
                    break;
                }
                case 19: {
                    yln = new YLNAudioRenderPcmData();
                    break;
                }
                case 20: {
                    yln = new YLNPublishLossResult();
                    break;
                }
                case 21: {
                    yln = new YLNPublishChannelStatus();
                    break;
                }
                case 22: {
                    yln = new YLNPublishChannelStreamInfo();
                    break;
                }
                case 23: {
                    yln = new YLNInitiateHttpsRequest();
                    break;
                }
                case 24: {
                    yln = new YLNStreamsNotify();
                    break;
                }
                case 25: {
                    yln = new YLNVideoSizeChangeNotify();
                    break;
                }
                case 26: {
                    yln = new YLNRenderFirstFrameNotify();
                    break;
                }
                default: {
                    YYLiveLog.warn("ycallback-Java", "unknown notification type %d", type);
                    return;
                }
            }
            yln.unmarshall(data);
            if (type < 1000) {
                Object[] handlers = s_notificationDispatcher.collectNotificationHandlers();
                if (handlers != null) {
                    for (Object handler : handlers) {
                        Message msg = Message.obtain();
                        msg.what = type;
                        msg.obj = yln.get();
                        ((Handler)handler).sendMessage(msg);
                    }
                }
            } else {
                switch (type) {
                    case 1000: {
                        mPublishVideoCfg = (YYLiveNotificationInside.PublishVideoCfg)yln.get();
                        break;
                    }
                }
            }
            switch (type) {
                case 0: {
                    Object notification = (YYLiveNotification.PublishStatusInfo)yln.get();
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_PublishStatus name=%s, status=%d", ((YYLiveNotification.PublishStatusInfo)notification).getStreamName(), ((YYLiveNotification.PublishStatusInfo)notification).getStatus());
                    return;
                }
                case 1: {
                    Object notification;
                    if (s_publishRuntimeNotificationCount % 10 == 0) {
                        notification = (YYLiveNotification.PublishRunTimeInfo)yln.get();
                        YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_PublishRunTimeInfo name=%s, fps=%d, bitrate=%d, audioBitrate=%d, resolution=%dx%d, realBitrate=%d, count=%d", ((YYLiveNotification.PublishRunTimeInfo)notification).getStreamName(), ((YYLiveNotification.PublishRunTimeInfo)notification).getInfo().getFps(), ((YYLiveNotification.PublishRunTimeInfo)notification).getInfo().getBitrate(), ((YYLiveNotification.PublishRunTimeInfo)notification).getInfo().getAudioBitrate(), ((YYLiveNotification.PublishRunTimeInfo)notification).getInfo().getWidth(), ((YYLiveNotification.PublishRunTimeInfo)notification).getInfo().getHeight(), ((YYLiveNotification.PublishRunTimeInfo)notification).getInfo().getPublishRealBitrate(), s_publishRuntimeNotificationCount);
                    }
                    ++s_publishRuntimeNotificationCount;
                    return;
                }
                case 2: {
                    Object notification = (YYLiveNotification.PlayStatusInfo)yln.get();
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_PlayStatus name=%s, bVideo=%b, speaker=%d, status=%d", ((YYLiveNotification.PlayStatusInfo)notification).getStream().streamName, ((YYLiveNotification.PlayStatusInfo)notification).getStream().bVideo, ((YYLiveNotification.PlayStatusInfo)notification).getStream().speakerUid, ((YYLiveNotification.PlayStatusInfo)notification).getStatus());
                    return;
                }
                case 3: {
                    Object notification;
                    if (s_playRuntimeNotificationCount % 10 == 0) {
                        notification = (YYLiveNotification.PlayRunTimeInfo)yln.get();
                        YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_PlayRunTimeInfo name=%s, bVideo=%b, speaker=%d,fps=%d, bitrate=%d, audioBitrate=%d, resolution=%dx%d, count=%d", ((YYLiveNotification.PlayRunTimeInfo)notification).getStream().streamName, ((YYLiveNotification.PlayRunTimeInfo)notification).getStream().bVideo, ((YYLiveNotification.PlayRunTimeInfo)notification).getStream().speakerUid, ((YYLiveNotification.PlayRunTimeInfo)notification).getInfo().getFps(), ((YYLiveNotification.PlayRunTimeInfo)notification).getInfo().getBitrate(), ((YYLiveNotification.PlayRunTimeInfo)notification).getInfo().getAudioBitrate(), ((YYLiveNotification.PlayRunTimeInfo)notification).getInfo().getWidth(), ((YYLiveNotification.PlayRunTimeInfo)notification).getInfo().getHeight(), s_playRuntimeNotificationCount);
                    }
                    ++s_playRuntimeNotificationCount;
                    return;
                }
                case 4: {
                    Object notification;
                    if (s_audioCaptureVolumeNotificationCount % 50 == 0) {
                        notification = (YYLiveNotification.YYAudioCaptureVolume)yln.get();
                        YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_AudioCaptureVolume volume=%d, cpt=%d, mic=%d, count=%d", ((YYLiveNotification.YYAudioCaptureVolume)notification).mVolume, ((YYLiveNotification.YYAudioCaptureVolume)notification).mCpt, ((YYLiveNotification.YYAudioCaptureVolume)notification).mMicVolume, s_audioCaptureVolumeNotificationCount);
                    }
                    ++s_audioCaptureVolumeNotificationCount;
                    return;
                }
                case 5: {
                    Object notification;
                    if (s_audioPlayVolumeNotificationCount % 50 == 0) {
                        notification = (YYLiveNotification.AudioVolumeInfo)yln.get();
                        Map<Long, YYLiveNotification.YYVolumeInfo> volumeInfos = ((YYLiveNotification.AudioVolumeInfo)notification).getVolumeInfos();
                        int index = 0;
                        for (Map.Entry<Long, YYLiveNotification.YYVolumeInfo> entry : volumeInfos.entrySet()) {
                            YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_AudioPlayVolume [%d] volume=%d, speakers=%s, count=%d", ++index, entry.getValue().mVolume, entry.getValue().mActualSpeakerUidList != null ? entry.getValue().mActualSpeakerUidList.toString() : "null", s_audioPlayVolumeNotificationCount);
                        }
                    }
                    ++s_audioPlayVolumeNotificationCount;
                    return;
                }
                case 6: {
                    Object notification = (YYLiveNotification.BizAuthResult)yln.get();
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_BizAuthRes: name=%s, group=%s, bPublish=%b, bizAuthResult=%d", ((YYLiveNotification.BizAuthResult)notification).getAuthStream() != null ? ((YYLiveNotification.BizAuthResult)notification).getAuthStream().streamName : "null", ((YYLiveNotification.BizAuthResult)notification).getAuthGroup() != null ? ((YYLiveNotification.BizAuthResult)notification).getAuthGroup().groupName : "null", ((YYLiveNotification.BizAuthResult)notification).isPublishAuth(), ((YYLiveNotification.BizAuthResult)notification).getBizAuthResult());
                    return;
                }
                case 7: {
                    Object notification = (YYLiveNotification.SdkAuthResult)yln.get();
                    YYLiveLog.info("ycallback-Java", "kYYLiveAPINotification_SdkAuthRes: appId=%d, uid=%d, sdkAuthRes=%d", ((YYLiveNotification.SdkAuthResult)notification).getAppId(), ((YYLiveNotification.SdkAuthResult)notification).getUid(), ((YYLiveNotification.SdkAuthResult)notification).getSdkAuthResult());
                    return;
                }
                case 8: {
                    YYLiveLog.info("ycallback-Java", "YYLiveNotification.UninstallSdk");
                    return;
                }
                case 9: {
                    Object notification = (YYLiveNotification.UidInt2String)yln.get();
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotifioation_StringUid: uid=%d, strUid=%s", ((YYLiveNotification.UidInt2String)notification).getUidInt(), ((YYLiveNotification.UidInt2String)notification).getUidString());
                    return;
                }
                case 13: {
                    Object notification = (YYLiveNotification.ResolutionChangeInfo)yln.get();
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_ResolutionChangeInfo: name=%s, width=%d, height=%d", ((YYLiveNotification.ResolutionChangeInfo)notification).getStream().streamName, ((YYLiveNotification.ResolutionChangeInfo)notification).getWidth(), ((YYLiveNotification.ResolutionChangeInfo)notification).getHeight());
                    return;
                }
                case 10: {
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_JoinChannelStatus");
                    return;
                }
                case 11: {
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_StreamInfoStatus");
                    return;
                }
                case 12: {
                    Object notification = (YYLiveNotification.RtmpPublishStatus)yln.get();
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_RtmpPublishStatus: appid=%d, status=%d", ((YYLiveNotification.RtmpPublishStatus)notification).getAppid(), ((YYLiveNotification.RtmpPublishStatus)notification).getStatus());
                    return;
                }
                case 14: {
                    return;
                }
                case 15: {
                    return;
                }
                case 16: {
                    return;
                }
                case 19: {
                    return;
                }
                case 17: {
                    Object notification = (YYLiveNotification.UserAppMsgData)yln.get();
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_UserAppMsgData: uid %d MsgSize %d", ((YYLiveNotification.UserAppMsgData)notification).getUid(), ((YYLiveNotification.UserAppMsgData)notification).getData().length);
                    return;
                }
                case 18: {
                    Object notification = (YYLiveNotification.AppMsgDataFailedStatus)yln.get();
                    YYLiveLog.release("ycallback-Java", "kYYLiveAPINotification_AppMsgDataFailedStatus: status:%d", ((YYLiveNotification.AppMsgDataFailedStatus)notification).getFailedStatus());
                    return;
                }
                case 20: {
                    Object notification = (YYLiveNotification.PublishLossResult)yln.get();
                    YYLiveLog.info("ycallback-Java", "kYYLiveAPINotification_PublishLossResult: appid=%d, result=%d", ((YYLiveNotification.PublishLossResult)notification).getAppid(), ((YYLiveNotification.PublishLossResult)notification).getResult());
                    return;
                }
                case 21: {
                    Object notification = (YYLiveNotification.PublishChannelStatus)yln.get();
                    YYLiveLog.info("ycallback-Java", "kYYLiveAPINotification_PublishChannelStatus: channelId=%s, status=%d", ((YYLiveNotification.PublishChannelStatus)notification).getChannelId(), ((YYLiveNotification.PublishChannelStatus)notification).getStatus());
                    return;
                }
                case 22: {
                    Object notification = (YYLiveNotification.PublishChannelStreamInfo)yln.get();
                    YYLiveLog.info("ycallback-Java", "kYYLiveAPINotification_PublishChannelStreamInfo: channelId=%s , streams size=%d", ((YYLiveNotification.PublishChannelStreamInfo)notification).getChannelId(), ((YYLiveNotification.PublishChannelStreamInfo)notification).getStreams().size());
                    return;
                }
                case 24: {
                    Object notification = (YYLiveNotification.StreamsNotify)yln.get();
                    YYLiveLog.info("ycallback-Java", "kYYLiveAPINotification_StreamsNotify: channelId=%s , streams size=%d", ((YYLiveNotification.StreamsNotify)notification).getChannelId(), ((YYLiveNotification.StreamsNotify)notification).getStreams().size());
                    return;
                }
                case 25: {
                    Object notification = (YYLiveNotification.OnVideoSizeChange)yln.get();
                    YYLiveLog.info("ycallback-Java", "kYYLiveAPINotification_OnVideoSizeChange: uid=%d , width=%d height=%d", ((YYLiveNotification.OnVideoSizeChange)notification).getUid(), ((YYLiveNotification.OnVideoSizeChange)notification).getWidth(), ((YYLiveNotification.OnVideoSizeChange)notification).getHeight());
                    return;
                }
                case 26: {
                    Object notification = (YYLiveNotification.OnRenderVideoFirstFrame)yln.get();
                    YYLiveLog.info("ycallback-Java", "kYYLiveAPINotification_OnRenderFirstFrame: userGroupId=%d streamId=%d currentTimeMs=%d firstTimeMs=%d eatenFrame=%d", ((YYLiveNotification.OnRenderVideoFirstFrame)notification).getUserGroupId(), ((YYLiveNotification.OnRenderVideoFirstFrame)notification).getStreamId(), ((YYLiveNotification.OnRenderVideoFirstFrame)notification).getCurrentTimeMs(), ((YYLiveNotification.OnRenderVideoFirstFrame)notification).getFirstTimeMs(), ((YYLiveNotification.OnRenderVideoFirstFrame)notification).getEatenFrame());
                    return;
                }
                default: {
                    YYLiveLog.warn("ycallback-Java", "unknown notification type=%d", type);
                    return;
                }
            }
        }
        finally {
            s_notificationLock.unlock();
        }
    }

    public static void logCallback(int level, byte[] tag, byte[] msg) {
        if (tag == null || msg == null || s_logCallback == null) {
            return;
        }
        s_logCallback.onYYLogWithLevel(level, new String(tag), new String(msg));
    }

    public static void audioFilePlayCallback(Object obj, int event) {
        if (obj == null) {
            return;
        }
        YYLiveAudioFilePlayer player = (YYLiveAudioFilePlayer)obj;
        player.onPlayEvent(event);
    }

    public static void audioFilePlayVolumeCallback(Object obj, int volume, int currentMs, int totalMs) {
        if (obj == null) {
            return;
        }
        YYLiveAudioFilePlayer player = (YYLiveAudioFilePlayer)obj;
        player.onAudioFileVolume(volume, currentMs, totalMs);
    }

    public static void dnsSetPreResolveHosts(byte[] msg) {
        if (msg == null || mGslbMethod == null) {
            return;
        }
        mGslbMethod.dnsSetPreResolveHosts(new String(msg));
    }

    public static byte[] dnsGetByNameWithHost(byte[] msg) {
        String ret = new String();
        if (msg == null || mGslbMethod == null) {
            return ret.getBytes();
        }
        return mGslbMethod.dnsGetByNameWithHost(new String(msg));
    }

    public static interface NotificationDispatcher {
        public void registerNotificationHandler(Handler var1);

        public void unregisterNotificationHandler(Handler var1);

        public Object[] collectNotificationHandlers();
    }

    private static class YLNRenderFirstFrameNotify
    extends YLNBase {
        private YLNRenderFirstFrameNotify() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long userGroupId = this.popInt64();
            long streamId = this.popInt64();
            long currentTimeMs = this.popInt64();
            long firstTimeMs = this.popInt64();
            int eatenFrame = this.popInt();
            this.notification = new YYLiveNotification.OnRenderVideoFirstFrame(userGroupId, streamId, currentTimeMs, firstTimeMs, eatenFrame);
        }
    }

    private static class YLNVideoSizeChangeNotify
    extends YLNBase {
        private YLNVideoSizeChangeNotify() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long uid = this.popInt64();
            int width = this.popInt();
            int height = this.popInt();
            this.notification = new YYLiveNotification.OnVideoSizeChange(uid, width, height);
        }
    }

    private static class YLNStreamsNotify
    extends YLNBase {
        private YLNStreamsNotify() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int appid = this.popInt();
            String channelId = this.popString16();
            ArrayList<YYLiveStream> streams = new ArrayList<YYLiveStream>();
            int streamSize = this.popInt();
            for (int i = 0; i < streamSize; ++i) {
                YYLiveStream stream = new YYLiveStream();
                String streamName = this.popString16();
                int configSize = this.popInt();
                for (int j = 0; j < configSize; ++j) {
                    int key = this.popInt();
                    int value = this.popInt();
                    if (key == 2) {
                        stream.speakerUid = value;
                        continue;
                    }
                    if (key != 3) continue;
                    stream.bVideo = value == 1;
                }
                stream.appId = appid;
                stream.streamName = streamName;
                streams.add(stream);
            }
            this.notification = new YYLiveNotification.StreamsNotify(channelId, streams);
        }
    }

    private static class YLNInitiateHttpsRequest
    extends YLNBase {
        private YLNInitiateHttpsRequest() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.InitiateHttpsRequest(this.popString16(), this.popInt());
        }
    }

    private static class YLNPublishChannelStreamInfo
    extends YLNBase {
        private YLNPublishChannelStreamInfo() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int appid = this.popInt();
            String channelId = this.popString16();
            ArrayList<YYLiveStream> streams = new ArrayList<YYLiveStream>();
            int streamSize = this.popInt();
            for (int i = 0; i < streamSize; ++i) {
                YYLiveStream stream = new YYLiveStream();
                String streamName = this.popString16();
                int configSize = this.popInt();
                for (int j = 0; j < configSize; ++j) {
                    int key = this.popInt();
                    int value = this.popInt();
                    if (key == 2) {
                        stream.speakerUid = value;
                        continue;
                    }
                    if (key != 3) continue;
                    stream.bVideo = value == 1;
                }
                stream.appId = appid;
                stream.streamName = streamName;
                streams.add(stream);
            }
            this.notification = new YYLiveNotification.PublishChannelStreamInfo(channelId, streams);
        }
    }

    private static class YLNPublishChannelStatus
    extends YLNBase {
        private YLNPublishChannelStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.PublishChannelStatus(this.popString16(), this.popInt());
        }
    }

    private static class YLNPublishLossResult
    extends YLNBase {
        private YLNPublishLossResult() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.PublishLossResult(this.popInt(), this.popInt());
        }
    }

    private static class YLNAppMsgDataFailedStatus
    extends YLNBase {
        private YLNAppMsgDataFailedStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int status = this.popInt();
            this.notification = new YYLiveNotification.AppMsgDataFailedStatus(status);
        }
    }

    private static class YLNUserAppMsgData
    extends YLNBase {
        private YLNUserAppMsgData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            String data = this.popString16();
            long uid = this.popInt64();
            this.notification = new YYLiveNotification.UserAppMsgData(data.getBytes(), uid);
        }
    }

    private static class YLNAudioRenderPcmData
    extends YLNBase {
        private YLNAudioRenderPcmData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            byte[] data = this.popBytes32();
            int dataSize = this.popInt();
            int duration = this.popInt();
            int sampleRate = this.popInt();
            int channel = this.popInt();
            this.notification = new YYLiveNotification.AudioRenderPcmData(data, dataSize, duration, sampleRate, channel);
        }
    }

    private static class YLNAudioCapturePcmData
    extends YLNBase {
        private YLNAudioCapturePcmData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            byte[] data = this.popBytes32();
            int dataSize = this.popInt();
            int sampleRate = this.popInt();
            int channel = this.popInt();
            this.notification = new YYLiveNotification.AudioCapturePcmData(data, dataSize, sampleRate, channel);
        }
    }

    private static class YLNAudioPlaySpectrumData
    extends YLNBase {
        private YLNAudioPlaySpectrumData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            byte[] data = this.popBytes32();
            this.notification = new YYLiveNotification.AudioPlaySpectrumData(data);
        }
    }

    private static class YLNAudioData
    extends YLNBase {
        private YLNAudioData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int uid = this.popInt();
            int duration = this.popInt();
            int cpt = this.popInt();
            int pts = this.popInt();
            byte[] data = this.popBytes32();
            long longUid = (long)uid & 0xFFFFFFFFL;
            this.notification = new YYLiveNotification.AudioDataInfo(longUid, duration, cpt, pts, data);
        }
    }

    private static class YLNStringUid
    extends YLNBase {
        private YLNStringUid() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.UidInt2String(this.popInt(), this.popString16());
        }
    }

    private static class YLNUninstallSdk
    extends YLNBase {
        private YLNUninstallSdk() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.UninstallSdk();
        }
    }

    private static class YLNRtmpPublishStatus
    extends YLNBase {
        private YLNRtmpPublishStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.RtmpPublishStatus(this.popInt(), this.popInt());
        }
    }

    private static class YLNAllStreamNotify
    extends YLNBase {
        private YLNAllStreamNotify() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int curLine = this.popInt();
            int appId = this.popInt();
            String channelId = this.popString16();
            int reason = this.popInt();
            HashMap<Integer, YYLiveStreamLevelInfo> levelMap = new HashMap<Integer, YYLiveStreamLevelInfo>();
            int levelCnt = this.popInt();
            for (int i = 0; i < levelCnt; ++i) {
                short level = this.popShort();
                YYLiveStreamLevelInfo levelInfo = new YYLiveStreamLevelInfo();
                int lineCnt = this.popInt();
                for (int j = 0; j < lineCnt; ++j) {
                    int line = this.popInt();
                    YYLiveStreamLineInfo streamLine = new YYLiveStreamLineInfo();
                    int lineSeq = this.popInt();
                    int providerId = this.popInt();
                    int urlId = this.popInt();
                    boolean isCdn = this.popBool();
                    boolean cdnType = this.popBool();
                    int streamCnt = this.popInt();
                    ArrayList<YYLiveStreamInfo> streamList = new ArrayList<YYLiveStreamInfo>();
                    for (int k = 0; k < streamCnt; ++k) {
                        YYLiveStreamInfo streamInfo = new YYLiveStreamInfo();
                        streamInfo.streamName = this.popString16();
                        streamInfo.spkUid = this.popInt();
                        String url = this.popString16();
                        streamInfo.appId = appId;
                        int configCnt = this.popInt();
                        HashMap<Integer, Integer> configMap = new HashMap<Integer, Integer>();
                        for (int l = 0; l < configCnt; ++l) {
                            int key = this.popInt();
                            int value = this.popInt();
                            configMap.put(key, value);
                        }
                        streamInfo.streamConfig = configMap;
                        streamList.add(streamInfo);
                    }
                    streamLine.lineSeq = lineSeq;
                    streamLine.isCdn = isCdn;
                    streamLine.streamInfo = streamList;
                    levelInfo.streamLine.put(line, streamLine);
                }
                levelMap.put(Integer.valueOf(level), levelInfo);
            }
            this.notification = new YYLiveNotification.StreamStatusInfo(curLine, channelId, reason, levelMap);
        }
    }

    private static class YLNJoinChannelStatus
    extends YLNBase {
        private YLNJoinChannelStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.JoinChannelStatus(this.popString16(), this.popInt());
        }
    }

    private static class YLNResolutionChangeInfo
    extends YLNBase {
        private YLNResolutionChangeInfo() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            YYLiveStream stream = new YYLiveStream();
            stream.appId = this.popInt();
            stream.streamName = this.popString16();
            stream.speakerUid = this.popInt();
            stream.bVideo = this.popBool();
            this.notification = new YYLiveNotification.ResolutionChangeInfo(stream, this.popInt(), this.popInt());
        }
    }

    private static class YLNSdkAuthRes
    extends YLNBase {
        private YLNSdkAuthRes() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.SdkAuthResult(this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNBizAuthRes
    extends YLNBase {
        private YLNBizAuthRes() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            YYLiveStream stream = new YYLiveStream();
            stream.appId = this.popInt();
            stream.streamName = this.popString16();
            stream.speakerUid = this.popInt();
            stream.bVideo = this.popBool();
            YYLiveGroup group = new YYLiveGroup();
            group.appId = this.popInt();
            group.groupName = this.popString16();
            if (group.groupName.isEmpty()) {
                group = null;
            }
            this.notification = new YYLiveNotification.BizAuthResult(stream, group, this.popBool(), this.popInt());
        }
    }

    private static class YLNAudioVolume
    extends YLNBase {
        private YLNAudioVolume() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int size = this.popInt();
            if (size > 0) {
                HashMap<Long, YYLiveNotification.YYVolumeInfo> volumeInfos = new HashMap<Long, YYLiveNotification.YYVolumeInfo>();
                for (int i = 0; i < size; ++i) {
                    long uid = this.popInt2Long();
                    int volume = this.popInt();
                    long pts = this.popInt2Long();
                    int actualSpkSize = this.popInt();
                    if (actualSpkSize > 0) {
                        ArrayList<Long> uidList = new ArrayList<Long>(actualSpkSize);
                        for (int k = 0; k < actualSpkSize; ++k) {
                            uidList.add(this.popInt2Long());
                        }
                        YYLiveNotification.YYVolumeInfo info = new YYLiveNotification.YYVolumeInfo(volume, pts, uidList);
                        volumeInfos.put(uid, info);
                        continue;
                    }
                    YYLiveNotification.YYVolumeInfo info = new YYLiveNotification.YYVolumeInfo(volume, pts, null);
                    volumeInfos.put(uid, info);
                }
                this.notification = new YYLiveNotification.AudioVolumeInfo(volumeInfos);
            }
        }
    }

    private static class YLNAudioCaptureVolume
    extends YLNBase {
        private YLNAudioCaptureVolume() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.YYAudioCaptureVolume(this.popInt(), this.popInt2Long(), this.popInt());
        }
    }

    private static class YLNPlayRunTimeInfo
    extends YLNBase {
        private YLNPlayRunTimeInfo() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            YYLiveStream stream = new YYLiveStream();
            stream.appId = this.popInt();
            stream.streamName = this.popString16();
            stream.speakerUid = this.popInt();
            stream.bVideo = this.popBool();
            this.notification = new YYLiveNotification.PlayRunTimeInfo(stream, new YYLiveNotification.YYLiveRunTimeInfo(this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt()));
        }
    }

    private static class YLNPlayStatus
    extends YLNBase {
        private YLNPlayStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            YYLiveStream stream = new YYLiveStream();
            stream.appId = this.popInt();
            stream.streamName = this.popString16();
            stream.speakerUid = this.popInt();
            stream.bVideo = this.popBool();
            this.notification = new YYLiveNotification.PlayStatusInfo(stream, this.popInt());
        }
    }

    private static class YLNPublishRunTimeInfo
    extends YLNBase {
        private YLNPublishRunTimeInfo() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.PublishRunTimeInfo(this.popString16(), new YYLiveNotification.YYLiveRunTimeInfo(this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt()));
        }
    }

    private static class YLNPublishStatus
    extends YLNBase {
        private YLNPublishStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new YYLiveNotification.PublishStatusInfo(this.popString16(), this.popInt());
        }
    }

    private static class YLNBase
    extends Marshallable {
        Object notification;

        private YLNBase() {
        }

        public Object get() {
            return this.notification;
        }
    }

    private static class YLESetPlaybackAudioFrameParameters
    extends YLEBase {
        private int sampleRate;
        private int channel;
        private int mode;
        private int samplesPerCall;

        YLESetPlaybackAudioFrameParameters(int _sampleRate, int _channel, int _mode, int _samplesPerCall) {
            this.event = 26;
            this.sampleRate = _sampleRate;
            this.channel = _channel;
            this.mode = _mode;
            this.samplesPerCall = _samplesPerCall;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.sampleRate);
            this.pushInt(this.channel);
            this.pushInt(this.mode);
            this.pushInt(this.samplesPerCall);
            return super.marshall();
        }
    }

    private static class YLESetRecordingAudioFrameParameters
    extends YLEBase {
        private int sampleRate;
        private int channel;
        private int mode;
        private int samplesPerCall;

        YLESetRecordingAudioFrameParameters(int _sampleRate, int _channel, int _mode, int _samplesPerCall) {
            this.event = 25;
            this.sampleRate = _sampleRate;
            this.channel = _channel;
            this.mode = _mode;
            this.samplesPerCall = _samplesPerCall;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.sampleRate);
            this.pushInt(this.channel);
            this.pushInt(this.mode);
            this.pushInt(this.samplesPerCall);
            return super.marshall();
        }
    }

    private static class YLESetHttpsTextResponse
    extends YLEBase {
        private String reqUrl;
        private String response;
        private int statusCode;
        private int errCode;
        private int target;

        YLESetHttpsTextResponse(String _reqUrl, String _response, int _statusCode, int _errCode, int _target) {
            this.event = 23;
            this.reqUrl = _reqUrl;
            this.response = _response;
            this.statusCode = _statusCode;
            this.errCode = _errCode;
            this.target = _target;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.reqUrl);
            this.pushString16(this.response);
            this.pushInt(this.statusCode);
            this.pushInt(this.errCode);
            this.pushInt(this.target);
            return super.marshall();
        }
    }

    private static class YLESetHttpsBinaryResponse
    extends YLEBase {
        private String reqUrl;
        private byte[] response;
        private int statusCode;
        private int errCode;
        private int target;

        YLESetHttpsBinaryResponse(String _reqUrl, byte[] _response, int _statusCode, int _errCode, int _target) {
            this.event = 23;
            this.reqUrl = _reqUrl;
            this.response = _response;
            this.statusCode = _statusCode;
            this.errCode = _errCode;
            this.target = _target;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.reqUrl);
            this.pushBytes(this.response);
            this.pushInt(this.statusCode);
            this.pushInt(this.errCode);
            this.pushInt(this.target);
            return super.marshall();
        }
    }

    private static class YLEEnableAudioDataIndication
    extends YLEBase {
        private boolean enable;

        YLEEnableAudioDataIndication(boolean enable) {
            this.event = 420;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESendUserAppMsgData
    extends YLEBase {
        private byte[] msgData;

        YLESendUserAppMsgData(byte[] _msgData) {
            this.event = 601;
            this.msgData = _msgData;
        }

        @Override
        public byte[] marshall() {
            this.pushBytes(this.msgData);
            return super.marshall();
        }
    }

    private static class YLEEnableRenderPcmDataCallBack
    extends YLEBase {
        private boolean enable;
        private int sampleRate;
        private int channel;

        YLEEnableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
            this.event = 423;
            this.enable = enable;
            this.sampleRate = sampleRate;
            this.channel = channel;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            this.pushInt(this.sampleRate);
            this.pushInt(this.channel);
            return super.marshall();
        }
    }

    private static class YLEEnableCapturePcmDataCallBack
    extends YLEBase {
        private boolean enable;
        private int sampleRate;
        private int channel;

        YLEEnableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
            this.event = 419;
            this.enable = enable;
            this.sampleRate = sampleRate;
            this.channel = channel;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            this.pushInt(this.sampleRate);
            this.pushInt(this.channel);
            return super.marshall();
        }
    }

    private static class YLESetAudioPlaySpectrumInfo
    extends YLEBase {
        private int spectrumLen;
        private int notifyIntervalMS;

        YLESetAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
            this.event = 417;
            this.spectrumLen = spectrumLen;
            this.notifyIntervalMS = notifyIntervalMS;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.spectrumLen);
            this.pushInt(this.notifyIntervalMS);
            return super.marshall();
        }
    }

    private static class YLEEnableAudioPlaySpectrum
    extends YLEBase {
        private boolean enable;

        YLEEnableAudioPlaySpectrum(boolean enable) {
            this.event = 416;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEAudioSetExternalProcessor
    extends YLEBase {
        private long eap;

        YLEAudioSetExternalProcessor(long _eap) {
            this.event = 414;
            this.eap = _eap;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.eap);
            return super.marshall();
        }
    }

    private static class YLEEnableAudioFileVolumeCallback
    extends YLEBase {
        private long ctx;
        private boolean enable;
        private int interval;

        YLEEnableAudioFileVolumeCallback(long _ctx, boolean _enable, int _interval) {
            this.event = 424;
            this.ctx = _ctx;
            this.enable = _enable;
            this.interval = _interval;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushBool(this.enable);
            this.pushInt(this.interval);
            return super.marshall();
        }
    }

    private static class YLEAudioFilePublishByMode
    extends YLEBase {
        private long ctx;
        private long mode;

        YLEAudioFilePublishByMode(long _ctx, long _mode) {
            this.event = 415;
            this.ctx = _ctx;
            this.mode = _mode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt64(this.mode);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetCompensateValue
    extends YLEBase {
        private long ctx;
        private long value;

        YLEAudioFileSetCompensateValue(long _ctx, int _value) {
            this.event = 418;
            this.ctx = _ctx;
            this.value = _value;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.value);
            return super.marshall();
        }
    }

    private static class YLEAudioFileEnablePublish
    extends YLEBase {
        private long ctx;
        private boolean enable;

        YLEAudioFileEnablePublish(long _ctx, boolean _enable) {
            this.event = 412;
            this.ctx = _ctx;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetSemitone
    extends YLEBase {
        private long ctx;
        private float val;

        YLEAudioFileSetSemitone(long _ctx, float _val) {
            this.event = 411;
            this.ctx = _ctx;
            this.val = _val;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushString16(String.valueOf(this.val * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetPlayVolume
    extends YLEBase {
        private long ctx;
        private int volume;

        YLEAudioFileSetPlayVolume(long _ctx, int _volume) {
            this.event = 410;
            this.ctx = _ctx;
            this.volume = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSeek
    extends YLEBase {
        private long ctx;
        private long timeMS;

        YLEAudioFileSeek(long _ctx, long _timeMS) {
            this.event = 407;
            this.ctx = _ctx;
            this.timeMS = _timeMS;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt(this.timeMS);
            return super.marshall();
        }
    }

    private static class YLEAudioFileEventCommon
    extends YLEBase {
        private long ctx;

        YLEAudioFileEventCommon(int _event, long _ctx) {
            this.event = _event;
            this.ctx = _ctx;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            return super.marshall();
        }
    }

    private static class YLEAudioFileOpen
    extends YLEBase {
        private long ctx;
        private String path;

        YLEAudioFileOpen(long _ctx, String _path) {
            this.event = 401;
            this.path = _path;
            this.ctx = _ctx;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushString16(this.path);
            return super.marshall();
        }
    }

    private static class YLECreateAudioFilePlayer
    extends YLEBase {
        private Object obj;

        YLECreateAudioFilePlayer(Object _obj) {
            this.event = 421;
            this.obj = _obj;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(YYLiveNative.YYLiveObjectToPtr(this.obj));
            return super.marshall();
        }
    }

    private static class YLENotifyNetworkState
    extends YLEBase {
        private int state;

        YLENotifyNetworkState(int _state) {
            this.event = 303;
            this.state = _state;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.state);
            return super.marshall();
        }
    }

    private static class YLEEnterForeground
    extends YLEBase {
        private int reverse;

        YLEEnterForeground() {
            this.event = 302;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEEnterBackground
    extends YLEBase {
        private int reverse;

        YLEEnterBackground() {
            this.event = 301;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    public static class YLEChangeScreenLiveMode
    extends YLEBase {
        private boolean bPicMode;
        private Object bitmap;

        public YLEChangeScreenLiveMode(boolean _bPicMode, Object _bitmap) {
            this.event = 218;
            this.bPicMode = _bPicMode;
            this.bitmap = _bitmap;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bPicMode);
            this.pushInt64(YYLiveNative.YYLiveObjectToPtr(this.bitmap));
            return super.marshall();
        }
    }

    private static class YLESetPreviewRenderMode
    extends YLEBase {
        private int mode;

        YLESetPreviewRenderMode(int _volume) {
            this.event = 227;
            this.mode = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.mode);
            return super.marshall();
        }
    }

    private static class YLEStopCapture
    extends YLEBase {
        private int reverse;

        YLEStopCapture() {
            this.event = 226;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEStartCapture
    extends YLEBase {
        private int reverse;

        YLEStartCapture() {
            this.event = 225;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEAttachVideoCapture
    extends YLEBase {
        private YYLiveVideoCapture capture;

        YLEAttachVideoCapture(YYLiveVideoCapture _capture) {
            this.event = 215;
            this.capture = _capture;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(YYLiveNative.YYLiveObjectToPtr(this.capture));
            return super.marshall();
        }
    }

    private static class YLEAttachAudioCapture
    extends YLEBase {
        private YYLiveAudioCapture capture;

        YLEAttachAudioCapture(YYLiveAudioCapture _capture) {
            this.event = 213;
            this.capture = _capture;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(YYLiveNative.YYLiveObjectToPtr(this.capture));
            return super.marshall();
        }
    }

    private static class YLESetFaceBeautyLevel
    extends YLEBase {
        private float level;

        YLESetFaceBeautyLevel(float _level) {
            this.event = 212;
            this.level = _level;
        }

        @Override
        public byte[] marshall() {
            this.pushInt((int)(this.level * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLESetWatermark
    extends YLEBase {
        private int posX;
        private int posY;
        private Bitmap image;

        YLESetWatermark(int _posX, int _posY, Bitmap _image) {
            this.event = 211;
            this.posX = _posX;
            this.posY = _posY;
            this.image = _image;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.posX);
            this.pushInt(this.posY);
            this.pushInt64(YYLiveNative.YYLiveObjectToPtr(this.image));
            return super.marshall();
        }
    }

    private static class YLESetCameraPosition
    extends YLEBase {
        private int position;

        YLESetCameraPosition(int _position) {
            this.event = 210;
            this.position = _position;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.position);
            return super.marshall();
        }
    }

    private static class YLEUpdateVideoConfig
    extends YLEBase {
        private YYPublishVideoConfig config;

        YLEUpdateVideoConfig(YYPublishVideoConfig _config) {
            this.event = 209;
            this.config = _config;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.config.encodeFrameRate);
            this.pushInt(this.config.encodeBitrate);
            this.pushInt(this.config.encodeResolutionWidth);
            this.pushInt(this.config.encodeResolutionHeight);
            this.pushInt(this.config.encodeType);
            this.pushBool(this.config.hardwareEncoder);
            this.pushBool(this.config.mirrorFrontCamera);
            this.pushBool(this.config.pubToGroupAndName);
            this.pushInt(this.config.playType);
            this.pushInt(this.config.mode);
            this.pushInt(this.config.screenOrientation);
            return super.marshall();
        }
    }

    private static class YLEStopPublishLive
    extends YLEBase {
        private String channelId;

        YLEStopPublishLive(String _channelId) {
            this.event = 222;
            this.channelId = _channelId;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.channelId);
            return super.marshall();
        }
    }

    private static class YLEUpdatePublishLive
    extends YLEBase {
        private String channelId;
        private boolean uniq;
        private YYPublishVideoConfig videoConfig;
        private YYPublishAudioConfig audioConfig;
        private YYLiveLayout layout;

        YLEUpdatePublishLive(String _channelId, boolean _uniq, YYPublishVideoConfig _videoConfig, YYPublishAudioConfig _audioConfig, YYLiveLayout _layout) {
            this.event = 221;
            this.channelId = _channelId;
            this.uniq = _uniq;
            this.videoConfig = _videoConfig;
            this.audioConfig = _audioConfig;
            this.layout = _layout;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.channelId);
            this.pushInt(this.videoConfig.encodeFrameRate);
            this.pushInt(this.videoConfig.encodeBitrate);
            this.pushInt(this.videoConfig.encodeMaxBitrate);
            this.pushInt(this.videoConfig.encodeResolutionWidth);
            this.pushInt(this.videoConfig.encodeResolutionHeight);
            this.pushInt(this.videoConfig.encodeType);
            this.pushBool(this.videoConfig.hardwareEncoder);
            this.pushBool(this.videoConfig.mirrorFrontCamera);
            this.pushBool(this.videoConfig.pubToGroupAndName);
            this.pushInt(this.videoConfig.playType);
            this.pushInt(this.videoConfig.mode);
            this.pushInt(this.videoConfig.screenOrientation);
            this.pushInt(this.audioConfig.mode);
            this.pushBool(this.audioConfig.pubToGroupAndName);
            this.pushBool(this.audioConfig.bUseAudioProfile);
            this.pushInt(this.audioConfig.channelProfile);
            this.pushInt(this.audioConfig.audioProfile);
            this.pushInt(this.audioConfig.commutMode);
            this.pushInt(this.audioConfig.scenarioMode);
            YYLiveChannelLayout channelLayout = this.layout.getChannelLayout(0);
            this.pushString16(channelLayout.channelId);
            this.pushBool(channelLayout.owner);
            this.pushBool(this.uniq);
            this.pushInt(channelLayout.layoutNo);
            this.pushInt(channelLayout.layout.left);
            this.pushInt(channelLayout.layout.top);
            this.pushInt(channelLayout.layout.right);
            this.pushInt(channelLayout.layout.bottom);
            this.pushInt(this.layout.width);
            this.pushInt(this.layout.height);
            int size = this.layout.speakers.size();
            this.pushInt(size);
            for (int i = 0; i < size; ++i) {
                String uid = this.layout.getSpeaker(i);
                this.pushInt(Long.parseLong(uid));
            }
            return super.marshall();
        }
    }

    private static class YLEStartPublishLive
    extends YLEBase {
        private String channelId;
        private boolean uniq;
        private YYPublishVideoConfig videoConfig;
        private YYPublishAudioConfig audioConfig;
        private YYLiveLayout layout;

        YLEStartPublishLive(String _channelId, boolean _uniq, YYPublishVideoConfig _videoConfig, YYPublishAudioConfig _audioConfig, YYLiveLayout _layout) {
            this.event = 220;
            this.channelId = _channelId;
            this.uniq = _uniq;
            this.videoConfig = _videoConfig;
            this.audioConfig = _audioConfig;
            this.layout = _layout;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.channelId);
            this.pushInt(this.videoConfig.encodeFrameRate);
            this.pushInt(this.videoConfig.encodeBitrate);
            this.pushInt(this.videoConfig.encodeMaxBitrate);
            this.pushInt(this.videoConfig.encodeResolutionWidth);
            this.pushInt(this.videoConfig.encodeResolutionHeight);
            this.pushInt(this.videoConfig.encodeType);
            this.pushBool(this.videoConfig.hardwareEncoder);
            this.pushBool(this.videoConfig.mirrorFrontCamera);
            this.pushBool(this.videoConfig.pubToGroupAndName);
            this.pushInt(this.videoConfig.playType);
            this.pushInt(this.videoConfig.mode);
            this.pushInt(this.videoConfig.screenOrientation);
            this.pushInt(this.audioConfig.mode);
            this.pushBool(this.audioConfig.pubToGroupAndName);
            this.pushBool(this.audioConfig.bUseAudioProfile);
            this.pushInt(this.audioConfig.channelProfile);
            this.pushInt(this.audioConfig.audioProfile);
            this.pushInt(this.audioConfig.commutMode);
            this.pushInt(this.audioConfig.scenarioMode);
            YYLiveChannelLayout channelLayout = this.layout.getChannelLayout(0);
            this.pushString16(channelLayout.channelId);
            this.pushBool(channelLayout.owner);
            this.pushBool(this.uniq);
            this.pushInt(channelLayout.layoutNo);
            this.pushInt(channelLayout.layout.left);
            this.pushInt(channelLayout.layout.top);
            this.pushInt(channelLayout.layout.right);
            this.pushInt(channelLayout.layout.bottom);
            this.pushInt(this.layout.width);
            this.pushInt(this.layout.height);
            int size = this.layout.speakers.size();
            this.pushInt(size);
            for (int i = 0; i < size; ++i) {
                String uid = this.layout.getSpeaker(i);
                if (uid == null || uid.isEmpty()) continue;
                this.pushInt(Long.parseLong(uid));
            }
            return super.marshall();
        }
    }

    private static class YLEStopPublishVideo
    extends YLEBase {
        private int reverse;

        YLEStopPublishVideo() {
            this.event = 204;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEStartPublishVideo
    extends YLEBase {
        private String streamName;
        private ArrayList<String> groupNames;
        private YYPublishVideoConfig config;

        YLEStartPublishVideo(String _streamName, ArrayList<String> _groupNames, YYPublishVideoConfig _config) {
            this.event = 203;
            this.streamName = _streamName;
            this.groupNames = _groupNames;
            this.config = _config;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.config.encodeFrameRate);
            this.pushInt(this.config.encodeBitrate);
            this.pushInt(this.config.encodeMaxBitrate);
            this.pushInt(this.config.encodeResolutionWidth);
            this.pushInt(this.config.encodeResolutionHeight);
            this.pushInt(this.config.encodeType);
            this.pushBool(this.config.hardwareEncoder);
            this.pushBool(this.config.mirrorFrontCamera);
            this.pushBool(this.config.pubToGroupAndName);
            this.pushInt(this.config.playType);
            this.pushInt(this.config.mode);
            this.pushInt(this.config.screenOrientation);
            this.pushString16(this.streamName);
            int size = this.groupNames.size();
            this.pushInt(size);
            for (int i = 0; i < size; ++i) {
                this.pushString16(this.groupNames.get(i));
            }
            return super.marshall();
        }
    }

    private static class YLEsetPublishRtmpParam
    extends YLEBase {
        private boolean bOpen;
        private String rtmpUrl;
        private String playPath;

        YLEsetPublishRtmpParam(boolean _bOpen, String _rtmpUrl, String _playPath) {
            this.event = 217;
            this.bOpen = _bOpen;
            this.rtmpUrl = _rtmpUrl;
            this.playPath = _playPath;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bOpen);
            this.pushString16(this.rtmpUrl);
            this.pushString16(this.playPath);
            return super.marshall();
        }
    }

    private static class YLEStopVideoPreview
    extends YLEBase {
        private int reverse;

        YLEStopVideoPreview() {
            this.event = 208;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLESetPlayViewScaleMode
    extends YLEBase {
        private Object view;
        private int mode;

        YLESetPlayViewScaleMode(Object _view, int _mode) {
            this.event = 231;
            this.view = _view;
            this.mode = _mode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(YYLiveNative.YYLiveObjectToPtr(this.view));
            this.pushInt64(this.mode);
            return super.marshall();
        }
    }

    private static class YLEStartVideoPreview
    extends YLEBase {
        private Object view;
        private int playType;
        private int publishMode;

        YLEStartVideoPreview(Object _view, int play, int mode) {
            this.event = 207;
            this.view = _view;
            this.playType = play;
            this.publishMode = mode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(YYLiveNative.YYLiveObjectToPtr(this.view));
            this.pushInt(this.playType);
            this.pushInt(this.publishMode);
            return super.marshall();
        }
    }

    private static class YLEstopAndRcoverVideoEncode
    extends YLEBase {
        private boolean stop;

        YLEstopAndRcoverVideoEncode(boolean _stop) {
            this.event = 232;
            this.stop = _stop;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.stop);
            return super.marshall();
        }
    }

    private static class YLEenableInEarMonitor
    extends YLEBase {
        private boolean enable;

        YLEenableInEarMonitor(boolean _enable) {
            this.event = 508;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEsetAudioSourceType
    extends YLEBase {
        private int mode;

        YLEsetAudioSourceType(int _mode) {
            this.event = 507;
            this.mode = _mode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.mode);
            return super.marshall();
        }
    }

    private static class YLEsetLimiterParameter
    extends YLEBase {
        private float m_fCeiling;
        private float m_fRelease;
        private float m_fLookaheadRatio;
        private float m_fThreshold;
        private float m_fAttack;
        private float m_fRMS;
        private float m_fPreGain;
        private float m_fLookahead;
        private float m_fStLink;

        YLEsetLimiterParameter(float fCeiling, float fThreshold, float fPreGain, float fRelease, float fAttack, float fLookahead, float fLookaheadRatio, float fRMS, float fStLink) {
            this.event = 509;
            this.m_fCeiling = fCeiling;
            this.m_fRelease = fRelease;
            this.m_fLookaheadRatio = fLookaheadRatio;
            this.m_fThreshold = fThreshold;
            this.m_fAttack = fAttack;
            this.m_fRMS = fRMS;
            this.m_fPreGain = fPreGain;
            this.m_fLookahead = fLookahead;
            this.m_fStLink = fStLink;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.m_fCeiling * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fRelease * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fLookaheadRatio * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fThreshold * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fAttack * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fRMS * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fPreGain * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fLookahead * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fStLink * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLEsetReverbExParameter
    extends YLEBase {
        private float mRoomSize;
        private float mPreDelay;
        private float mReverberance;
        private float mHfDamping;
        private float mToneLow;
        private float mToneHigh;
        private float mWetGain;
        private float mDryGain;
        private float mStereoWidth;

        YLEsetReverbExParameter(float RoomSize, float PreDelay, float Reverberance, float HfDamping, float ToneLow, float ToneHigh, float WetGain, float DryGain, float StereoWidth) {
            this.event = 506;
            this.mRoomSize = RoomSize;
            this.mPreDelay = PreDelay;
            this.mReverberance = Reverberance;
            this.mHfDamping = HfDamping;
            this.mToneLow = ToneLow;
            this.mToneHigh = ToneHigh;
            this.mWetGain = WetGain;
            this.mDryGain = DryGain;
            this.mStereoWidth = StereoWidth;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.mRoomSize * 1000000.0f));
            this.pushString16(String.valueOf(this.mPreDelay * 1000000.0f));
            this.pushString16(String.valueOf(this.mReverberance * 1000000.0f));
            this.pushString16(String.valueOf(this.mHfDamping * 1000000.0f));
            this.pushString16(String.valueOf(this.mToneLow * 1000000.0f));
            this.pushString16(String.valueOf(this.mToneHigh * 1000000.0f));
            this.pushString16(String.valueOf(this.mWetGain * 1000000.0f));
            this.pushString16(String.valueOf(this.mDryGain * 1000000.0f));
            this.pushString16(String.valueOf(this.mStereoWidth * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLEEnableReverb
    extends YLEBase {
        private boolean enable;

        YLEEnableReverb(boolean _enable) {
            this.event = 505;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetCompressorParam
    extends YLEBase {
        private int mthreshold;
        private int mmakeupGain;
        private int mratio;
        private int mknee;
        private int mreleaseTime;
        private int mattackTime;

        YLESetCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime, int attackTime) {
            this.event = 504;
            this.mthreshold = threshold;
            this.mmakeupGain = makeupGain;
            this.mratio = ratio;
            this.mknee = knee;
            this.mreleaseTime = releaseTime;
            this.mattackTime = attackTime;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.mthreshold);
            this.pushInt(this.mmakeupGain);
            this.pushInt(this.mratio);
            this.pushInt(this.mknee);
            this.pushInt(this.mreleaseTime);
            this.pushInt(this.mattackTime);
            return super.marshall();
        }
    }

    private static class YLEEnableLimiter
    extends YLEBase {
        private boolean enable;

        YLEEnableLimiter(boolean _enable) {
            this.event = 510;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableCompressor
    extends YLEBase {
        private boolean enable;

        YLEEnableCompressor(boolean _enable) {
            this.event = 503;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetGqGains
    extends YLEBase {
        private float mPreamp;
        private float mBand0;
        private float mBand1;
        private float mBand2;
        private float mBand3;
        private float mBand4;
        private float mBand5;
        private float mBand6;
        private float mBand7;
        private float mBand8;
        private float mBand9;

        YLESetGqGains(int[] gains) {
            this.event = 502;
            this.mPreamp = gains[0];
            this.mBand0 = gains[1];
            this.mBand1 = gains[2];
            this.mBand2 = gains[3];
            this.mBand3 = gains[4];
            this.mBand4 = gains[5];
            this.mBand5 = gains[6];
            this.mBand6 = gains[7];
            this.mBand7 = gains[8];
            this.mBand8 = gains[9];
            this.mBand9 = gains[10];
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.mPreamp * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand0 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand1 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand2 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand3 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand4 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand5 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand6 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand7 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand8 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand9 * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLEEnableEqualizer
    extends YLEBase {
        private boolean enable;

        YLEEnableEqualizer(boolean _enable) {
            this.event = 501;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableVad
    extends YLEBase {
        private boolean enable;

        YLEEnableVad(boolean _enable) {
            this.event = 206;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetOrientation
    extends YLEBase {
        private int orientation;

        YLESetOrientation(int ori) {
            this.event = 223;
            this.orientation = ori;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.orientation);
            return super.marshall();
        }
    }

    private static class YLESetMicVolume
    extends YLEBase {
        private int volume;

        YLESetMicVolume(int _volume) {
            this.event = 205;
            this.volume = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLEStopPublishAudio
    extends YLEBase {
        private int reverse;

        YLEStopPublishAudio() {
            this.event = 202;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEStartPublishAudio
    extends YLEBase {
        private String streamName;
        private ArrayList<String> groupNames;
        private YYPublishAudioConfig config;

        YLEStartPublishAudio(String _streamName, ArrayList<String> _groupNames, YYPublishAudioConfig _config) {
            this.event = 201;
            this.streamName = _streamName;
            this.groupNames = _groupNames;
            this.config = _config;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.config.mode);
            this.pushBool(this.config.pubToGroupAndName);
            this.pushBool(this.config.bUseAudioProfile);
            this.pushInt(this.config.channelProfile);
            this.pushInt(this.config.audioProfile);
            this.pushInt(this.config.commutMode);
            this.pushInt(this.config.scenarioMode);
            this.pushString16(this.streamName);
            int size = this.groupNames.size();
            this.pushInt(size);
            for (int i = 0; i < size; ++i) {
                this.pushString16(this.groupNames.get(i));
            }
            return super.marshall();
        }
    }

    private static class YLEGetLoudSpeakerEnabled
    extends YLEBase {
        private int reverse;

        YLEGetLoudSpeakerEnabled() {
            this.event = 109;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEIsSupportPlayH265
    extends YLEBase {
        YLEIsSupportPlayH265() {
            this.event = 112;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEEnableLoudSpeaker
    extends YLEBase {
        private boolean enable;

        YLEEnableLoudSpeaker(boolean _enable) {
            this.event = 108;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEVideoRenderEvent
    extends YLEBase {
        private long callbackPtr;
        private ArrayList<VideoRenderNotify> notifications;

        YLEVideoRenderEvent(long _callBackPtr, ArrayList<VideoRenderNotify> _notifications) {
            this.event = 107;
            this.callbackPtr = _callBackPtr;
            this.notifications = _notifications;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.callbackPtr);
            this.pushInt(this.notifications.size());
            for (VideoRenderNotify item : this.notifications) {
                this.pushInt64(item.mUserGroupId);
                this.pushInt64(item.mStreamId);
                this.pushInt64(item.mPts);
                this.pushInt64(item.mRenderStamp);
            }
            return super.marshall();
        }
    }

    private static class YLESetSpeakerVolume
    extends YLEBase {
        private int volume;

        YLESetSpeakerVolume(int _volume) {
            this.event = 110;
            this.volume = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLESetStreamPlayVolume
    extends YLEBase {
        private YYLiveStream stream;
        private int volume;

        YLESetStreamPlayVolume(int _volume, YYLiveStream _stream) {
            this.event = 106;
            this.volume = _volume;
            this.stream = _stream;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.stream.appId);
            this.pushString16(this.stream.streamName);
            this.pushInt(this.stream.speakerUid);
            this.pushBool(this.stream.bVideo);
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLEEnableAllMute
    extends YLEBase {
        private boolean enable;

        YLEEnableAllMute(boolean _enable) {
            this.event = 111;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableMuteStringUid
    extends YLEBase {
        private boolean enable;
        private String uid;

        YLEEnableMuteStringUid(boolean _enable, String _uid) {
            this.event = 113;
            this.enable = _enable;
            this.uid = _uid;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            this.pushString16(this.uid);
            return super.marshall();
        }
    }

    private static class YLEEnableMuteStream
    extends YLEBase {
        private YYLiveStream stream;
        private boolean enable;

        YLEEnableMuteStream(boolean _enable, YYLiveStream _stream) {
            this.event = 105;
            this.enable = _enable;
            this.stream = _stream;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.stream.appId);
            this.pushString16(this.stream.streamName);
            this.pushInt(this.stream.speakerUid);
            this.pushBool(this.stream.bVideo);
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEUpdatePlayVideoView
    extends YLEBase {
        private YYLiveStream stream;
        private int scaleMode;
        private Object view;

        YLEUpdatePlayVideoView(Object _view, int _scaleMode, YYLiveStream _stream) {
            this.event = 104;
            this.view = _view;
            this.scaleMode = _scaleMode;
            this.stream = _stream;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.stream.appId);
            this.pushString16(this.stream.streamName);
            this.pushInt(this.stream.speakerUid);
            this.pushInt(this.scaleMode);
            this.pushInt64(YYLiveNative.YYLiveObjectToPtr(this.view));
            return super.marshall();
        }
    }

    private static class YLEEnableHardwareDecoder
    extends YLEBase {
        private boolean enable;
        private int decodeType;

        YLEEnableHardwareDecoder(boolean _enable, int _decodeType) {
            this.event = 103;
            this.enable = _enable;
            this.decodeType = _decodeType;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            this.pushInt(this.decodeType);
            return super.marshall();
        }
    }

    private static class YLEStopPlayStreams
    extends YLEBase {
        ArrayList<YYLiveStream> streamList;
        ArrayList<YYLiveGroup> groupList;

        YLEStopPlayStreams(ArrayList<YYLiveStream> _streamList, ArrayList<YYLiveGroup> _groupList) {
            this.event = 102;
            this.streamList = _streamList;
            this.groupList = _groupList;
        }

        @Override
        public byte[] marshall() {
            int i;
            YYLiveStream stream = null;
            YYLiveGroup group = null;
            int size = this.streamList.size();
            this.pushInt(size);
            for (i = 0; i < size; ++i) {
                stream = this.streamList.get(i);
                this.pushInt(stream.appId);
                this.pushString16(stream.streamName);
                this.pushInt(stream.speakerUid);
                this.pushBool(stream.bVideo);
                this.pushInt(stream.scaleMode);
            }
            size = this.groupList.size();
            this.pushInt(size);
            for (i = 0; i < size; ++i) {
                group = this.groupList.get(i);
                this.pushInt(group.appId);
                this.pushString16(group.groupName);
            }
            return super.marshall();
        }
    }

    private static class YLEStartPlayStreams
    extends YLEBase {
        ArrayList<YYLiveStream> streamList;
        ArrayList<YYLiveGroup> groupList;

        YLEStartPlayStreams(ArrayList<YYLiveStream> _streamList, ArrayList<YYLiveGroup> _groupList) {
            this.event = 101;
            this.streamList = _streamList;
            this.groupList = _groupList;
        }

        @Override
        public byte[] marshall() {
            int i;
            int size = this.streamList.size();
            this.pushInt(size);
            for (i = 0; i < size; ++i) {
                YYLiveStream stream = this.streamList.get(i);
                this.pushInt(stream.appId);
                this.pushString16(stream.streamName);
                this.pushInt(stream.speakerUid);
                this.pushBool(stream.bVideo);
                this.pushInt(stream.scaleMode);
                this.pushInt(stream.lineSeq);
                this.pushInt64(YYLiveNative.YYLiveObjectToPtr(stream.toView));
            }
            size = this.groupList.size();
            this.pushInt(size);
            for (i = 0; i < size; ++i) {
                YYLiveGroup group = this.groupList.get(i);
                this.pushInt(group.appId);
                this.pushString16(group.groupName);
            }
            return super.marshall();
        }
    }

    private static class YLEUpdateToken
    extends YLEBase {
        byte[] token;
        byte[] bizAuthExtInfo;

        YLEUpdateToken(byte[] _token, byte[] _bizAuthExtInfo) {
            this.event = 10;
            this.token = _token;
            this.bizAuthExtInfo = _bizAuthExtInfo;
        }

        @Override
        public byte[] marshall() {
            this.pushBytes(this.token);
            this.pushBytes(this.bizAuthExtInfo);
            return super.marshall();
        }
    }

    private static class YLESetVoiceOnlySdk
    extends YLEBase {
        private boolean enable;

        YLESetVoiceOnlySdk(boolean _enable) {
            this.event = 21;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEResolveServiceData
    extends YLEBase {
        private int uri;
        private String uid;
        private byte[] msg;

        YLEResolveServiceData(int _uri, String _uid, byte[] _data) {
            this.event = 228;
            this.uri = _uri;
            this.uid = _uid;
            this.msg = _data;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.uri);
            this.pushString16(this.uid);
            this.pushBytes(this.msg);
            return super.marshall();
        }
    }

    private static class YLESetSoundEffect
    extends YLEBase {
        private int soundEffectMode;

        YLESetSoundEffect(int _soundEffectMode) {
            this.event = 224;
            this.soundEffectMode = _soundEffectMode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.soundEffectMode);
            return super.marshall();
        }
    }

    private static class YLEStopAudioSaver
    extends YLEBase {
        YLEStopAudioSaver() {
            this.event = 19;
        }
    }

    private static class YLEStartAudioSaver
    extends YLEBase {
        private String fileName;
        private int saverMode;
        private int fileMode;

        YLEStartAudioSaver(String _fileName, int _saverMode, int _fileMode) {
            this.event = 18;
            this.fileName = _fileName;
            this.saverMode = _saverMode;
            this.fileMode = _fileMode;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.fileName);
            this.pushInt(this.saverMode);
            this.pushInt(this.fileMode);
            return super.marshall();
        }
    }

    private static class YLESetCaptureVolumeInterval
    extends YLEBase {
        private int interval;
        private int moreThanThd;
        private int lessThanThd;

        YLESetCaptureVolumeInterval(int _interval, int _moreThanThd, int _lessThanThd) {
            this.event = 17;
            this.interval = _interval;
            this.moreThanThd = _moreThanThd;
            this.lessThanThd = _lessThanThd;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.interval);
            this.pushInt(this.moreThanThd);
            this.pushInt(this.lessThanThd);
            return super.marshall();
        }
    }

    private static class YLEOnRenderFirstFrame
    extends YLEBase {
        private long userGroupId;
        private long streamId;
        private long currentSystemMilliSecond;
        private long firstFrameToRenderInMilliSec;
        private int eatenFrames;

        YLEOnRenderFirstFrame(long _userGroupId, long _streamId, long _currentSystemMilliSecond, long _firstFrameToRenderInMilliSec, int _eatenFrames) {
            this.event = 230;
            this.userGroupId = _userGroupId;
            this.streamId = _streamId;
            this.currentSystemMilliSecond = _currentSystemMilliSecond;
            this.firstFrameToRenderInMilliSec = _firstFrameToRenderInMilliSec;
            this.eatenFrames = _eatenFrames;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.userGroupId);
            this.pushInt64(this.streamId);
            this.pushInt64(this.currentSystemMilliSecond);
            this.pushInt64(this.firstFrameToRenderInMilliSec);
            this.pushInt64(this.eatenFrames);
            return super.marshall();
        }
    }

    private static class YLEOnVideoSizeChange
    extends YLEBase {
        private long uid;
        private int width;
        private int height;

        YLEOnVideoSizeChange(long _uid, int _width, int _height) {
            this.event = 229;
            this.uid = _uid;
            this.width = _width;
            this.height = _height;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            return super.marshall();
        }
    }

    private static class YLESetPlayVolumeInterval
    extends YLEBase {
        private int interval;
        private int moreThanThd;
        private int lessThanThd;

        YLESetPlayVolumeInterval(int _interval, int _moreThanThd, int _lessThanThd) {
            this.event = 16;
            this.interval = _interval;
            this.moreThanThd = _moreThanThd;
            this.lessThanThd = _lessThanThd;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.interval);
            this.pushInt(this.moreThanThd);
            this.pushInt(this.lessThanThd);
            return super.marshall();
        }
    }

    private static class YLESetChannelName
    extends YLEBase {
        private String channelName;

        YLESetChannelName(String _channelName) {
            this.event = 24;
            this.channelName = _channelName;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.channelName);
            return super.marshall();
        }
    }

    private static class YLESetChannelProfile
    extends YLEBase {
        private int profile;

        YLESetChannelProfile(int _profile) {
            this.event = 15;
            this.profile = _profile;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.profile);
            return super.marshall();
        }
    }

    private static class YLEEnableLowLatency
    extends YLEBase {
        private boolean enable;

        YLEEnableLowLatency(boolean _enable) {
            this.event = 9;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLELeaveChannel
    extends YLEBase {
        private int reverse;

        YLELeaveChannel() {
            this.event = 13;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEJoinChannel
    extends YLEBase {
        private String channelId;
        private String uid;
        private boolean is32Bit;
        private int role;

        YLEJoinChannel(String _channelId, String _uid, boolean _is32Bit, int _role) {
            this.event = 12;
            this.channelId = _channelId;
            this.uid = _uid;
            this.is32Bit = _is32Bit;
            this.role = _role;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.channelId);
            this.pushString16(this.uid);
            this.pushBool(this.is32Bit);
            this.pushInt(this.role);
            return super.marshall();
        }
    }

    private static class YLELeaveMedia
    extends YLEBase {
        private int reverse;

        YLELeaveMedia() {
            this.event = 8;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEJoinMediaStrUid
    extends YLEBase {
        private String uid;
        private long sid;
        private long subSid;

        YLEJoinMediaStrUid(String _uid, long _sid, long _subSid) {
            this.event = 11;
            this.uid = _uid;
            this.sid = _sid;
            this.subSid = _subSid;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.uid);
            this.pushInt(this.sid);
            this.pushInt(this.subSid);
            return super.marshall();
        }
    }

    private static class YLEJoinMedia
    extends YLEBase {
        private long uid;
        private long sid;
        private long subSid;

        YLEJoinMedia(long _uid, long _sid, long _subSid) {
            this.event = 7;
            this.uid = _uid;
            this.sid = _sid;
            this.subSid = _subSid;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.sid);
            this.pushInt(this.subSid);
            return super.marshall();
        }
    }

    private static class YLELogText
    extends YLEBase {
        private int level;
        private int module;
        private String tag;
        private String text;

        YLELogText(int _level, int _module, String _tag, String _text) {
            this.event = 6;
            this.level = _level;
            this.module = _module;
            this.tag = _tag;
            this.text = _text;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.level);
            this.pushInt(this.module);
            this.pushString16(this.tag);
            this.pushString32(this.text);
            return super.marshall();
        }
    }

    private static class YLESetArgoConfig
    extends YLEBase {
        private HashMap<Integer, Integer> config;

        YLESetArgoConfig(HashMap<Integer, Integer> _config) {
            this.event = 22;
            this.config = _config;
        }

        @Override
        public byte[] marshall() {
            this.pushMap(this.config, Integer.class, Marshallable.ELenType.E_INT, Marshallable.ELenType.E_INT);
            return super.marshall();
        }
    }

    private static class YLESetUserRole
    extends YLEBase {
        private int role;

        YLESetUserRole(int _role) {
            this.event = 5;
            this.role = _role;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.role);
            return super.marshall();
        }
    }

    private static class YLESetSceneId
    extends YLEBase {
        private long sceneId;

        YLESetSceneId(long _sceneId) {
            this.event = 4;
            this.sceneId = _sceneId;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.sceneId);
            return super.marshall();
        }
    }

    private static class YLESetAreaType
    extends YLEBase {
        private int areaType;

        YLESetAreaType(int _areaType) {
            this.event = 14;
            this.areaType = _areaType;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.areaType);
            return super.marshall();
        }
    }

    private static class YLEFetchedLogConfig
    extends YLEBase {
        YLEFetchedLogConfig() {
            this.event = 20;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEEnableLog
    extends YLEBase {
        private boolean enable;
        private boolean callback;
        private int level;
        private String logPath;

        YLEEnableLog(boolean _enable, boolean _callback, int _level, String _logPath) {
            this.event = 3;
            this.enable = _enable;
            this.callback = _callback;
            this.level = _level;
            this.logPath = _logPath;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            this.pushBool(this.callback);
            this.pushInt(this.level);
            this.pushString16(this.logPath);
            return super.marshall();
        }
    }

    private static class YLEBase
    extends HPMarshaller {
        int event = 0;

        private YLEBase() {
        }

        int event() {
            return this.event;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESdkInit
    extends HPMarshaller {
        long appId;
        long sceneId;
        YYDeviceInfo info;

        YLESdkInit(long _addId, long _sceneId, YYDeviceInfo _info) {
            this.appId = _addId;
            this.sceneId = _sceneId;
            this.info = _info;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.appId);
            this.pushInt(this.sceneId);
            this.pushString16(this.info.osVersion);
            this.pushString16(this.info.manufacturer);
            this.pushString16(this.info.model);
            this.pushString16(this.info.deviceID);
            this.pushString16(this.info.appInfo);
            this.pushInt64(this.info.imsi);
            return super.marshall();
        }
    }
}

