/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.audio;

import android.util.Log;
import com.yy.audioengine.IAudioLibJniInit;
import com.yy.yylivesdk4cloud.audio.AudioCodecConfig;
import com.yy.yylivesdk4cloud.audio.AudioDeviceModeConfig;
import com.yy.yylivesdk4cloud.audio.AudioJsonParseImp;
import com.yy.yylivesdk4cloud.audio.AudioKaraokeCompensateConfig;
import com.yy.yylivesdk4cloud.audio.AudioOpenSlEsConfig;
import com.yy.yylivesdk4cloud.audio.AudioPreProcConfig;
import com.yy.yylivesdk4cloud.audio.IAudioConfigCallbackInterface;
import com.yy.yylivesdk4cloud.audio.IAudioJsonParseInterface;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import java.util.HashMap;

public class AudioConfigManager
implements IAudioConfigCallbackInterface {
    private static final String TAG = "cfg_AudioConfigManage";
    private static final String ARGO_CONFIG_KEY_AUDIO_CODEC = "Android_AudioCodec";
    private static final String ARGO_CONFIG_KEY_AUDIO_PREPROC = "Android_AudioPreProcess";
    private static final String ARGO_CONFIG_KEY_AUDIO_OPENSLES = "Android_OpenSlEs";
    private static final String ARGO_CONFIG_KEY_AUDIO_DEVICE_MODE = "Android_Audio_Device_Mode";
    private static final String ARGO_CONFIG_KEY_AUDIO_KARAOKE_COMP = "Android_Audio_Karaoke_Comp";
    public static final String[] ARGO_CONFIG_KEYS = new String[]{"Android_AudioCodec", "Android_AudioPreProcess", "Android_OpenSlEs", "Android_Audio_Device_Mode", "Android_Audio_Karaoke_Comp"};
    private IAudioJsonParseInterface mAudioJsonParseImp;
    private HashMap<String, AudioCodecConfig[]> mAudioEncodeConfigs = new HashMap();
    private HashMap<String, AudioPreProcConfig[]> mAudioPreProcConfigs = new HashMap();
    private HashMap<String, AudioOpenSlEsConfig[]> mAudioOpenSlEsConfig = new HashMap();
    private HashMap<String, AudioDeviceModeConfig[]> mAudioDeviceModeConfig = new HashMap();
    private HashMap<String, AudioKaraokeCompensateConfig[]> mAudioKaraokeCompConfig = new HashMap();

    public static AudioConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    private AudioConfigManager() {
        this.mAudioJsonParseImp = new AudioJsonParseImp(this);
    }

    public AudioCodecConfig getAudioCodecConfigByType(int type) {
        AudioCodecConfig[] configs = this.mAudioEncodeConfigs.get(ARGO_CONFIG_KEY_AUDIO_CODEC);
        AudioCodecConfig curConfig = null;
        if (configs != null && type < configs.length) {
            curConfig = configs[type];
        }
        return curConfig;
    }

    public AudioPreProcConfig getAudioPreProcConfigByType(int type) {
        AudioPreProcConfig[] configs = this.mAudioPreProcConfigs.get(ARGO_CONFIG_KEY_AUDIO_PREPROC);
        AudioPreProcConfig curConfig = null;
        if (configs != null) {
            for (int i = 0; i < configs.length; ++i) {
                if (type != configs[i].sceneId) continue;
                curConfig = configs[i];
            }
        }
        return curConfig;
    }

    public void onConfig(String key, String config) {
        if (key == null || config == null) {
            return;
        }
        Log.d((String)"AudioConfig", (String)(" onConfig " + key + " : " + config));
        switch (key) {
            case "Android_AudioCodec": {
                this.mAudioJsonParseImp.parseAudioEncodeConfig(config);
                break;
            }
            case "Android_AudioPreProcess": {
                this.mAudioJsonParseImp.parseAudioPreProcConfig(config);
                break;
            }
            case "Android_OpenSlEs": {
                this.mAudioJsonParseImp.parseAudioOpensSlEsConfig(config);
                break;
            }
            case "Android_Audio_Device_Mode": {
                this.mAudioJsonParseImp.parseAudioDeviceModeConfig(config);
                break;
            }
            case "Android_Audio_Karaoke_Comp": {
                this.mAudioJsonParseImp.parseAudioKaraokeCompConfig(config);
                break;
            }
        }
    }

    @Override
    public void notifyAudioEncodeJsonConfigResult(AudioCodecConfig[] configs) {
        if (configs == null || configs.length == 0) {
            this.mAudioEncodeConfigs.clear();
            YYLiveLog.error(TAG, "Audio Encode JsonParse error!");
            return;
        }
        for (int i = 0; i < configs.length; ++i) {
            YYLiveLog.info(TAG, " notifyAudioEncodeJsonConfigResult :" + i + ":" + configs[i].toString());
        }
        this.mAudioEncodeConfigs.put(ARGO_CONFIG_KEY_AUDIO_CODEC, configs);
    }

    @Override
    public void notifyAudioPreProcJsonConfigResult(AudioPreProcConfig[] configs) {
        if (configs == null || configs.length == 0) {
            this.mAudioPreProcConfigs.clear();
            YYLiveLog.error(TAG, "Audio PreProc JsonParse error!");
            return;
        }
        for (int i = 0; i < configs.length; ++i) {
            YYLiveLog.info(TAG, " notifyAudioPreProcJsonConfigResult :" + i + ":" + configs[i].toString());
        }
        this.mAudioPreProcConfigs.put(ARGO_CONFIG_KEY_AUDIO_PREPROC, configs);
    }

    @Override
    public void notifyAudioOpenSlEsJsonConfigResult(AudioOpenSlEsConfig[] configs) {
        if (configs == null || configs.length == 0) {
            this.mAudioOpenSlEsConfig.clear();
            YYLiveLog.error(TAG, "Audio OpenSlEs JsonParse error!");
            return;
        }
        for (int i = 0; i < configs.length; ++i) {
            YYLiveLog.info(TAG, " notifyAudioOpenSlEsJsonConfigResult :" + i + ":" + configs[i].toString());
        }
        this.mAudioOpenSlEsConfig.put(ARGO_CONFIG_KEY_AUDIO_OPENSLES, configs);
        IAudioLibJniInit.SetAndroidOpenSlEsParam((int)configs[0].inputNumSLBuffer, (int)configs[0].inputNum10msBuffer, (int)configs[0].outputNumSLBuffer, (int)configs[0].outputNum10msBuffer);
        IAudioLibJniInit.EnableOpenSlEsOutputNewLogic((boolean)configs[0].enableOpenSlEsOutputNewLogic);
    }

    @Override
    public void notifyAudioDeviceModeJsonConfigResult(AudioDeviceModeConfig[] configs) {
        try {
            if (configs == null || configs.length == 0) {
                this.mAudioDeviceModeConfig.clear();
                YYLiveLog.error(TAG, "Audio Device Mode JsonParse error!");
                return;
            }
            for (int i = 0; i < configs.length; ++i) {
                YYLiveLog.info(TAG, " notifyAudioDeviceModeJsonConfigResult :" + i + ":" + configs[i].toString());
            }
            this.mAudioDeviceModeConfig.put(ARGO_CONFIG_KEY_AUDIO_DEVICE_MODE, configs);
            int[] configArr = new int[]{configs[0].audioLoudMode, configs[0].inputLoudStreamType, configs[0].outputLoudStreamType, configs[0].audioMode, configs[0].inputStreamType, configs[0].outputStreamType, configs[0].audioHDMode, configs[0].inputHDStreamType, configs[0].outputHDStreamType};
            IAudioLibJniInit.SetAudioAdaptationConfig((int[])configArr);
        }
        catch (Exception ex) {
            YYLiveLog.info(TAG, " notifyAudioDeviceModeJsonConfigResult fail :" + ex.getMessage());
        }
    }

    @Override
    public void notifyAudioKaraokeCompJsonConfigResult(AudioKaraokeCompensateConfig[] configs) {
        try {
            if (configs == null || configs.length == 0) {
                this.mAudioKaraokeCompConfig.clear();
                YYLiveLog.error(TAG, "Audio Karaoke Comp JsonParse error!");
                return;
            }
            for (int i = 0; i < configs.length; ++i) {
                YYLiveLog.info(TAG, " notifyAudioKaraokeCompJsonConfigResult :" + i + ":" + configs[i].toString());
            }
            this.mAudioKaraokeCompConfig.put(ARGO_CONFIG_KEY_AUDIO_KARAOKE_COMP, configs);
            IAudioLibJniInit.SetAudioKaraokeCompValue((int)configs[0].compValue);
        }
        catch (Exception ex) {
            YYLiveLog.info(TAG, " notifyAudioKaraokeCompJsonConfigResult fail :" + ex.getMessage());
        }
    }

    private static class SingletonHolder {
        private static final AudioConfigManager INSTANCE = new AudioConfigManager();

        private SingletonHolder() {
        }
    }
}

