/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.content.Context;
import com.yy.platform.baseservice.IChannel;
import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.profile.ChannelProfile;
import com.yy.platform.baseservice.profile.LogProfile;
import com.yy.platform.baseservice.profile.ServiceProfileFactory;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;
import com.yy.platform.baseservice.task.RPCTask;
import com.yy.platform.baseservice.utils.UserGroupType;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;
import java.util.ArrayList;

public class YYLiveServiceChannel
implements IChannelListener.IServiceBroadcastNotify,
IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> {
    private IChannel mServiceChannel;
    private int mServiceChannelStatus = 0;
    private ArrayList<UserGroupType> mGrps = new ArrayList();
    private long mAppid = 0L;

    public void init(Context appContext, long appid) {
        this.mAppid = appid;
        this.mServiceChannel = YYServiceCore.init((Context)appContext, (long)appid, (String)"", (ServiceProfileFactory)new ServiceProfileFactory(){

            public LogProfile logProfile() {
                return new LogProfile(){

                    public LogProfile.ILog getLog() {
                        return new LogProfile.ILog(){

                            public void outputLog(String log) {
                                YYLiveLog.error("ycall-Java", log);
                            }
                        };
                    }

                    public String logPath() {
                        return null;
                    }

                    public boolean isLogCat() {
                        return false;
                    }
                };
            }

            public ChannelProfile channelProfile() {
                return null;
            }
        }, (IChannelListener.IChannelStatusNotify)new IChannelListener.IChannelStatusNotify(){

            public void onStatus(int status) {
                YYLiveServiceChannel.this.mServiceChannelStatus = status;
                YYLiveLog.error("ycall-Java", "YYLiveServiceChannel  init status =  %d", status);
            }
        });
    }

    public int getServiceChannelStatus() {
        return this.mServiceChannelStatus;
    }

    public void registBroadcastListener() {
        YYLiveLog.error("ycall-Java", "YYLiveServiceChannel registBroadcastListener");
        this.mServiceChannel.registBroadcastListener((IChannelListener.IServiceBroadcastNotify)this);
    }

    public void unregistBroadcastListener() {
        YYLiveLog.error("ycall-Java", "YYLiveServiceChannel unregistBroadcastListener");
        this.mServiceChannel.unregistBroadcastListener((IChannelListener.IServiceBroadcastNotify)this);
    }

    public int subscribeBroadcast(String channelId, String uid) {
        RPCTask.RequestParam requestParam = new RPCTask.RequestParam("", "svcLog", uid, "".getBytes(), "", null, null, null);
        this.mServiceChannel.rpcCall(requestParam, null, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<RPCTask.ResponseParam>(){

            public void onSuccess(int requestId, RPCTask.ResponseParam response) {
            }

            public void onFail(int requestId, int sdkResCode, int srvResCode, Exception e) {
            }
        });
        String strAppid = Long.toString(this.mAppid);
        String hashValue = strAppid + "-" + channelId;
        int hashChan = this.hashString(hashValue);
        UserGroupType groupTypes = new UserGroupType(2147483686L, this.toUnsigned(hashChan));
        this.mGrps.add(groupTypes);
        YYLiveLog.error("ycall-Java", "YYLiveServiceChannel subscribeBroadcast channelid = %s, hashchanid = %d , gid = %d", channelId, hashChan, groupTypes.mGroupId);
        return this.mServiceChannel.subscribeBroadcast(this.mGrps, (IRPCChannel.RPCCallback)this);
    }

    public int unSubscribeBroadcast() {
        YYLiveLog.error("ycall-Java", "YYLiveServiceChannel unSubscribeBroadcast");
        return this.mServiceChannel.unSubscribeBroadcast(this.mGrps, (IRPCChannel.RPCCallback)this);
    }

    public void onBroadCast(long uid, long grpType, long grpId, String serviceName, String functionName, String protoType, byte[] data) {
        if (this.mGrps.get((int)0).mGroupId == grpId && this.mGrps.get((int)0).mGroupType == grpType && serviceName != null && serviceName.length() != 0 && functionName != null && functionName.length() != 0 && data.length != 0) {
            YYLiveNative.resolveServiceData(String.valueOf(uid), Integer.parseInt(functionName), data);
        }
    }

    public void onSuccess(int requestId, BroadSubOrUnSubTask.ResponseParam response) {
        YYLiveLog.error("ycall-Java", "YYLiveServiceChannel registBroadcastListener Success mResCode =  %d", response.mResCode);
    }

    public void onFail(int requestId, int sdkResCode, int srvResCode, Exception e) {
        YYLiveLog.error("ycall-Java", "YYLiveServiceChannel registBroadcastListener Fail requestId = %d sdkResCode = %d srvResCode =  %d", requestId, sdkResCode, srvResCode);
    }

    private long toUnsigned(int s) {
        return (long)s & 0xFFFFFFFFL;
    }

    private int hashString(String channelId) {
        int lHash = -236792892;
        for (int i = 0; i < channelId.length(); ++i) {
            char c = channelId.charAt(i);
            lHash <<= 1;
            lHash += c;
        }
        return lHash;
    }
}

