/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.yylivesdk4cloud.ExternalVideoSource;
import com.yy.yylivesdk4cloud.IVideoSource;
import com.yy.yylivesdk4cloud.IYYLogCallback;
import com.yy.yylivesdk4cloud.ScreenRecordSource;
import com.yy.yylivesdk4cloud.YRVideoCanvas;
import com.yy.yylivesdk4cloud.YYLiveAPI;
import com.yy.yylivesdk4cloud.YYLiveAudioFilePlayer;
import com.yy.yylivesdk4cloud.YYLiveGroup;
import com.yy.yylivesdk4cloud.YYLiveNotification;
import com.yy.yylivesdk4cloud.YYLivePlayerView;
import com.yy.yylivesdk4cloud.YYLivePreviewView;
import com.yy.yylivesdk4cloud.YYLiveRtcEventHandler;
import com.yy.yylivesdk4cloud.YYLiveStream;
import com.yy.yylivesdk4cloud.YYPublishAudioConfig;
import com.yy.yylivesdk4cloud.YYVideoEncoderConfiguration;
import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.helper.YYLiveHttpsRequestHandler;
import com.yy.yylivesdk4cloud.helper.YYLiveLog;
import com.yy.yylivesdk4cloud.helper.YYLiveNative;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YYLiveRtcEngine {
    private static final String TAG = "RtcEngine";
    private static boolean mIsInited = false;
    private static int sMyAppId = 0;
    private static long sMySceneId = 0L;
    private static YYLiveRtcEventHandler mRtcEventHandler;
    private static YYLiveHttpsRequestHandler mHttpsRequestHandler;
    private long mMyUid = 0L;
    private Map<Integer, String> mUidToStringMap = new HashMap<Integer, String>();
    private boolean mIs32bitUid = false;
    private String mMyStrUid = "";
    private static String mLogPath;
    private static int mLogLevel;
    private static IYYLogCallback mYyLogCallback;
    private boolean mBGroupSubscribe = false;
    private boolean mBAudioPublish = false;
    private boolean mBVideoPublish = false;
    private String mStringName = "";
    private String mVideoStringName = "";
    private int mChannelAppId = 0;
    private String mChannelName = "";
    private int mChannelProfile = 0;
    private int mAudioProfile = 0;
    private int mCommutMode = 0;
    private int mScenarioMode = 0;
    private boolean mBEnablePlayDataIndication = false;
    private static int s_playVolumeNotifyCount;
    private static int s_playDataNotifyCount;
    private static NotificationHandler mHandler;
    private int[] mEqGains = new int[11];
    private boolean mBEnableEqualizer = false;
    private boolean mBEnableCompressor = false;
    private boolean mBEnableLimiter = false;
    private boolean mBEnableReverbEx = false;
    private ReverbExParameter mReverbExGains = new ReverbExParameter();
    private CompressorParam mCompressorGains = new CompressorParam();
    private LimterParam mLimiterGins = new LimterParam();
    private boolean mBOnlyReleaseCamera = false;
    private Set<YYLiveAudioFilePlayer> mAudioFilePlayerSet = new TreeSet<YYLiveAudioFilePlayer>();
    private Boolean isJoinChannel = false;
    private Boolean isThunder = false;
    private Boolean isBoltJoin = false;
    private Boolean isEnableAudio = true;
    private Boolean isEnableVideo = true;
    private Boolean isMuteAllVideo = false;
    private Boolean isMuteAllAudio = false;
    private Boolean isMuteLocalVideo = false;
    private Boolean isPreview = false;
    private Boolean isOtherSource = false;
    private Boolean needNotify = false;
    private int accompanyType = -1;
    private static Context appContext;
    private SurfaceView rtcSurfaceView = null;
    private long joinStart = 0L;
    private long joinEnd = 0L;
    private YRVideoCanvas localCanvas = null;
    private static YYLivePreviewView staticYYLivePreview;
    private ArrayList<YRVideoCanvas> remoteCanvas = new ArrayList(0);
    private int thunderBoltProfile = 0;
    private int playType = 0;
    private int resolutionMode = -1;
    private YYVideoEncoderConfiguration mYYVideoEncoderConfiguration = new YYVideoEncoderConfiguration();
    private ArrayList<YYLiveStream> anchorStreams = new ArrayList(0);
    private ArrayList<YYLiveStream> wholeStreams = new ArrayList(0);
    private Map<String, ArrayList<YYLiveStream>> channelStreamsList = new HashMap<String, ArrayList<YYLiveStream>>();
    private Map<String, Boolean> uidMuteVideoList = new HashMap<String, Boolean>();
    private Map<String, Boolean> uidMuteAudioList = new HashMap<String, Boolean>();
    private final Object streamLock = new Object();

    public String getChannelName() {
        return this.mChannelName;
    }

    public String getMyUid() {
        return this.mMyStrUid;
    }

    private YYLiveRtcEngine() {
    }

    private static synchronized YYLiveRtcEngine createRtcEngine(Context context, String appId, long sceneId, YYLiveRtcEventHandler handler) {
        if (SingleonHolder.INSTANCE == null) {
            SingleonHolder.INSTANCE = new YYLiveRtcEngine();
        }
        if (!mIsInited) {
            mRtcEventHandler = handler;
            mHttpsRequestHandler = new YYLiveHttpsRequestHandler();
            sMyAppId = Integer.parseInt(appId);
            sMySceneId = sceneId;
            System.loadLibrary("ffmpeg-neon");
            System.loadLibrary("Ittiamhevcdec");
            YYLiveAPI.sharedInstance().initWithAppId(sMyAppId, sMySceneId, context);
            mIsInited = true;
        }
        return SingleonHolder.INSTANCE;
    }

    public static synchronized YYLiveRtcEngine create(Context context, String appId, long sceneId, YYLiveRtcEventHandler handler) {
        YYLiveRtcEngine rtcEngine = YYLiveRtcEngine.createRtcEngine(context, appId, sceneId, handler);
        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine);
        }
        appContext = context;
        staticYYLivePreview = new YYLivePreviewView(appContext);
        return rtcEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamsNotify(YYLiveNotification.StreamsNotify streamInfo) {
        if (streamInfo.getChannelId().equals(this.mChannelName)) {
            ArrayList<YYLiveStream> curChannelStreams = streamInfo.getStreams();
            if (curChannelStreams == null) {
                return;
            }
            Iterator<YYLiveStream> it = curChannelStreams.iterator();
            while (it.hasNext()) {
                YYLiveStream stream = it.next();
                if (Long.parseLong(this.mMyStrUid, 10) != stream.speakerUid) continue;
                it.remove();
            }
            ArrayList<YYLiveStream> addStreams = new ArrayList<YYLiveStream>();
            ArrayList<YYLiveStream> removeStreams = new ArrayList<YYLiveStream>();
            ArrayList<YYLiveStream> oldStreamsInChannel = this.channelStreamsList.get(streamInfo.getChannelId());
            if (oldStreamsInChannel != null) {
                for (YYLiveStream yYLiveStream : curChannelStreams) {
                    boolean bl = false;
                    for (YYLiveStream oldStream : oldStreamsInChannel) {
                        if (!yYLiveStream.streamName.equals(oldStream.streamName)) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    addStreams.add(yYLiveStream);
                }
                for (YYLiveStream yYLiveStream : oldStreamsInChannel) {
                    boolean bl = false;
                    for (YYLiveStream newStream : curChannelStreams) {
                        if (!newStream.streamName.equals(yYLiveStream.streamName)) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    removeStreams.add(yYLiveStream);
                    Object object = this.streamLock;
                    synchronized (object) {
                        if (this.anchorStreams.contains(yYLiveStream)) {
                            this.anchorStreams.remove(yYLiveStream);
                        }
                    }
                }
            } else {
                addStreams.addAll(curChannelStreams);
            }
            it = addStreams.iterator();
            while (it.hasNext()) {
                YYLiveStream yYLiveStream = it.next();
                boolean isMute = yYLiveStream.bVideo ? this.isMuteVideoStreamWithUid(yYLiveStream.speakerUid) : this.isMuteAudioStreamWithUid(yYLiveStream.speakerUid);
                if (isMute) {
                    it.remove();
                    continue;
                }
                if (!yYLiveStream.bVideo || this.remoteCanvas == null) continue;
                for (YRVideoCanvas canvas : this.remoteCanvas) {
                    if (Long.parseLong(canvas.mUid, 10) != yYLiveStream.speakerUid) continue;
                    yYLiveStream.toView = canvas.mView;
                    yYLiveStream.scaleMode = canvas.mRenderMode;
                }
            }
            Object isMute = this.streamLock;
            synchronized (isMute) {
                this.wholeStreams.clear();
                this.channelStreamsList.put(streamInfo.getChannelId(), curChannelStreams);
                for (Map.Entry<String, ArrayList<YYLiveStream>> entry : this.channelStreamsList.entrySet()) {
                    this.wholeStreams.addAll((Collection<YYLiveStream>)entry.getValue());
                }
                this.anchorStreams.addAll(addStreams);
            }
            if (removeStreams.size() > 0) {
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(removeStreams, null);
            }
            if (addStreams.size() > 0) {
                YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(addStreams, null);
            }
            this.joinEnd = System.currentTimeMillis();
            if (!this.isJoinChannel.booleanValue() && this.needNotify.booleanValue()) {
                int elapsed = (int)(this.joinEnd - this.joinStart);
                this.isJoinChannel = true;
                this.needNotify = false;
                mRtcEventHandler.onJoinChannelSuccess(this.mChannelName, this.mMyStrUid, elapsed);
            }
            if (this.isJoinChannel.booleanValue()) {
                for (YYLiveStream yYLiveStream : removeStreams) {
                    if (yYLiveStream.bVideo) {
                        YYLiveLog.info("yrtc", "didVideoMuted id:" + yYLiveStream.speakerUid + " isMute:" + true);
                        mRtcEventHandler.didVideoMuted(String.valueOf(yYLiveStream.speakerUid), true);
                        continue;
                    }
                    YYLiveLog.info("yrtc", "didAudioMuted id:" + yYLiveStream.speakerUid + " isMute:" + true);
                    mRtcEventHandler.didAudioMuted(String.valueOf(yYLiveStream.speakerUid), true);
                }
                for (YYLiveStream yYLiveStream : addStreams) {
                    if (yYLiveStream.bVideo) {
                        YYLiveLog.info("yrtc", "didVideoMute id:" + yYLiveStream.speakerUid + " isMute:" + false);
                        mRtcEventHandler.didVideoMuted(String.valueOf(yYLiveStream.speakerUid), false);
                        continue;
                    }
                    YYLiveLog.info("yrtc", "didAudioMuted id:" + yYLiveStream.speakerUid + " isMute:" + false);
                    mRtcEventHandler.didAudioMuted(String.valueOf(yYLiveStream.speakerUid), false);
                }
            }
        }
    }

    public static synchronized YYLiveRtcEngine createWithLoop(Context context, String appId, long sceneId, YYLiveRtcEventHandler handler, Looper loop) {
        YYLiveRtcEngine rtcEngine = YYLiveRtcEngine.createRtcEngine(context, appId, sceneId, handler);
        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine, loop);
        }
        return rtcEngine;
    }

    public static synchronized void destroy() {
        if (mIsInited) {
            SingleonHolder.INSTANCE.leaveChannel();
            YYLiveAPI.sharedInstance().deInit();
            mIsInited = false;
            SingleonHolder.INSTANCE.resetRtcEngine();
            SingleonHolder.INSTANCE = null;
        }
    }

    public static String getSdkVersion() {
        return YYLiveAPI.sharedInstance().getVersion();
    }

    public static int setLogFile(String filePath) {
        mLogPath = filePath;
        if (filePath == null || filePath.isEmpty()) {
            YYLiveAPI.enableLog(false, mLogLevel, mLogPath, null);
        } else {
            YYLiveAPI.enableLog(true, mLogLevel, mLogPath, null);
        }
        return 0;
    }

    public static int setLogCallback(IYYLogCallback callback) {
        mYyLogCallback = callback;
        if (mYyLogCallback != null) {
            YYLiveAPI.enableLog(true, mLogLevel, "", mYyLogCallback);
        } else {
            YYLiveAPI.enableLog(false, mLogLevel, "", mYyLogCallback);
        }
        return 0;
    }

    public static int setLogFilter(int filter) {
        mLogLevel = filter;
        return 0;
    }

    public void setSceneId(long sceneId) {
        sMySceneId = sceneId;
        YYLiveAPI.sharedInstance().setSceneId(sceneId);
    }

    public int setChannelProfile(int profile, int channelProfile) {
        YYLiveLog.release("yrtc", "setChannelProfile: profile=%d channelProfile:%d", profile, channelProfile);
        if (this.isJoinChannel.booleanValue()) {
            return -2;
        }
        this.isThunder = profile == 2 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.mChannelProfile = channelProfile;
        boolean bLowLatency = false;
        switch (this.mChannelProfile) {
            case 0: {
                bLowLatency = false;
                break;
            }
            case 1: 
            case 3: {
                bLowLatency = true;
                break;
            }
            case 4: {
                bLowLatency = true;
                break;
            }
        }
        YYLiveAPI.sharedInstance().setChannelProfile(this.mChannelProfile);
        YYLiveAPI.sharedInstance().enableLowLatency(bLowLatency);
        return profile;
    }

    public int setArea(int area) {
        YYLiveLog.release("yrtc", "setArea: area=%d", area);
        int iResult = 0;
        int transSdkArea = 0;
        switch (area) {
            case 0: {
                transSdkArea = 0;
                break;
            }
            case 1: {
                transSdkArea = 100;
                break;
            }
            case 2: {
                transSdkArea = 101;
                break;
            }
            default: {
                iResult = -1;
            }
        }
        YYLiveAPI.sharedInstance().setAreaType(transSdkArea);
        return iResult;
    }

    public int joinChannel(byte[] token, String channelName, String info, String uid, boolean is32bitUid) {
        YYLiveLog.release("yrtc", "joinChannel: channelName=%s, uid=%s, is32bitUid=%b, token=%s, info=%s", this.getPrintString(channelName), this.getPrintString(uid), is32bitUid, this.getPrintString(token), this.getPrintString(info));
        if (!this.isValidChannelStream(channelName)) {
            return -1;
        }
        if (uid == null || uid.isEmpty()) {
            return -2;
        }
        this.mMyStrUid = uid;
        this.mIs32bitUid = is32bitUid;
        if (this.mIs32bitUid) {
            try {
                this.mMyUid = Long.parseLong(uid);
            }
            catch (NumberFormatException exception) {
                return -4;
            }
        }
        this.mChannelName = channelName;
        this.mChannelAppId = sMyAppId;
        if (this.isThunder.booleanValue()) {
            YYLiveNative.setVoiceOnlySdk(true);
        } else {
            YYLiveNative.setVoiceOnlySdk(false);
        }
        YYLiveAPI.sharedInstance().registerNotificationHandler(mHandler);
        YYLiveAPI.sharedInstance().updateToken(token);
        YYLiveNative.setChannelName(this.mChannelName);
        if (this.mIs32bitUid) {
            YYLiveAPI.sharedInstance().joinMedia(this.mMyUid);
        } else {
            YYLiveAPI.sharedInstance().joinMedia(this.mMyStrUid, 0L, 0L);
        }
        YYLiveAPI.sharedInstance().setUserRole(1);
        if (this.isThunder.booleanValue()) {
            this.joinChannelThunder();
        } else {
            this.joinChannelThunderBolt();
        }
        this.joinStart = System.currentTimeMillis();
        this.needNotify = true;
        return 0;
    }

    private boolean joinChannelThunder() {
        if (this.mBGroupSubscribe) {
            return false;
        }
        ArrayList<YYLiveGroup> audioGroup = new ArrayList<YYLiveGroup>(0);
        YYLiveGroup oneGroup = new YYLiveGroup();
        oneGroup.appId = this.mChannelAppId;
        oneGroup.groupName = "g_" + this.mChannelName;
        audioGroup.add(oneGroup);
        YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(null, audioGroup);
        this.mBGroupSubscribe = true;
        this.needNotify = false;
        return true;
    }

    private boolean joinChannelThunderBolt() {
        boolean res = YYLiveAPI.sharedInstance().joinChannel(this.mChannelName, this.mMyStrUid, 1);
        if (res) {
            this.isBoltJoin = true;
        }
        return true;
    }

    private boolean isValidChannelStream(String channelName) {
        if (channelName == null || channelName.isEmpty()) {
            return false;
        }
        int length = channelName.length();
        if (length > 64) {
            return false;
        }
        int validCharCount = 0;
        for (int i = 0; i < length; ++i) {
            int codePoint = Character.codePointAt(channelName, i);
            if (!(codePoint == 45 || codePoint == 95 || codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 90) && (codePoint < 97 || codePoint > 122)) continue;
            ++validCharCount;
        }
        if (validCharCount == length) {
            return true;
        }
        YYLiveLog.error("yrtc", "found invalid char in channelname!");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int leaveChannel() {
        YYLiveLog.release("yrtc", "leaveChannel");
        if (this.isThunder.booleanValue()) {
            this.leaveChannelThunder();
        } else {
            if (!this.isJoinChannel.booleanValue()) {
                return -2;
            }
            this.leaveChannelThunderBolt();
            this.remoteCanvas.clear();
        }
        this.removeAllUid2String();
        this.accompanyType = -1;
        this.isJoinChannel = false;
        this.isEnableAudio = true;
        this.isEnableVideo = true;
        this.isMuteAllVideo = false;
        this.isMuteAllAudio = false;
        this.isMuteLocalVideo = false;
        Object object = this.streamLock;
        synchronized (object) {
            this.wholeStreams.clear();
            this.anchorStreams.clear();
            this.channelStreamsList.clear();
        }
        this.uidMuteVideoList.clear();
        this.uidMuteAudioList.clear();
        return 0;
    }

    private int leaveChannelThunder() {
        if (!this.mBGroupSubscribe) {
            return -1;
        }
        this.tryStopPublish();
        this.tryStopSubscribe();
        YYLiveAPI.sharedInstance().leaveMedia();
        this.mBGroupSubscribe = false;
        return 0;
    }

    private int leaveChannelThunderBolt() {
        this.tryStopPublish();
        this.tryStopSubscribe();
        this.tryStopVideoSubscribe();
        this.tryStopVideoPublish();
        this.tryStopVideoPreview();
        YYLiveAPI.sharedInstance().leaveChannel();
        YYLiveRtcEventHandler.RtcStats status = new YYLiveRtcEventHandler.RtcStats();
        mRtcEventHandler.onLeaveChannel(status);
        return 0;
    }

    public int renewToken(byte[] token) {
        YYLiveLog.release("yrtc", "renewToken: %s ", this.getPrintString(token));
        YYLiveAPI.sharedInstance().updateToken(token);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enableAudio() {
        YYLiveLog.release("yrtc", "enableAudio isThunder:" + this.isThunder);
        this.isEnableAudio = true;
        if (this.isThunder.booleanValue()) {
            if (!this.mBGroupSubscribe) {
                return -1;
            }
            if (this.mBAudioPublish) {
                return -2;
            }
            this.mStringName = "a_" + this.mMyUid + "_" + this.mChannelName;
            String groupName = "g_" + this.mChannelName;
            ArrayList<String> groupList = new ArrayList<String>();
            groupList.add(groupName);
            YYPublishAudioConfig config = new YYPublishAudioConfig(2);
            config.bUseAudioProfile = true;
            config.channelProfile = this.mChannelProfile;
            config.audioProfile = this.mAudioProfile;
            config.commutMode = this.mCommutMode;
            config.scenarioMode = this.mScenarioMode;
            this.mBAudioPublish = true;
            YYLiveAPI.sharedInstance().getPublisher().startPublishAudio(this.mStringName, groupList, config);
        } else {
            if (this.mBAudioPublish) {
                return -2;
            }
            if (this.isJoinChannel.booleanValue()) {
                ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
                Object object = this.streamLock;
                synchronized (object) {
                    for (YYLiveStream oneStream : this.wholeStreams) {
                        boolean isMute;
                        if (oneStream.bVideo || this.anchorStreams.contains(oneStream) || (isMute = this.isMuteAudioStreamWithUid(oneStream.speakerUid))) continue;
                        startStreams.add(oneStream);
                        this.anchorStreams.add(oneStream);
                    }
                }
                if (startStreams.size() > 0) {
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
                if (!this.mBAudioPublish) {
                    YYLiveAPI.sharedInstance().getPublishChannel().updateProfile(this.mChannelProfile, this.mAudioProfile, this.mCommutMode, this.mScenarioMode);
                    YYLiveAPI.sharedInstance().getPublishChannel().setAudioEnable(true);
                    if (this.accompanyType >= 0) {
                        YYLiveAPI.sharedInstance().getPublisher().setAudioSourceType(this.accompanyType);
                    }
                    this.mBAudioPublish = true;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int disableAudio() {
        YYLiveLog.release("yrtc", "disableAudio isThunder:" + this.isThunder);
        if (this.isThunder.booleanValue()) {
            this.tryStopPublish();
        } else if (this.isEnableAudio.booleanValue()) {
            ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
            Object object = this.streamLock;
            synchronized (object) {
                for (YYLiveStream oneStream : this.anchorStreams) {
                    if (oneStream.bVideo) continue;
                    stopStreams.add(oneStream);
                }
            }
            YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            this.tryStopPublish();
            ArrayList<YYLiveStream> audioStreams = new ArrayList<YYLiveStream>(0);
            Object object2 = this.streamLock;
            synchronized (object2) {
                for (YYLiveStream oneStream : this.anchorStreams) {
                    if (oneStream.bVideo) continue;
                    audioStreams.add(oneStream);
                }
                for (YYLiveStream oneStream : audioStreams) {
                    this.anchorStreams.remove(oneStream);
                }
            }
            audioStreams.clear();
            this.isEnableAudio = false;
        }
        return 0;
    }

    public int setAudioProfile(int profile, int commutMode, int scenarioMode) {
        YYLiveLog.release("yrtc", "setAudioProfile: profile=%d, commutMode=%d, scenarioMode=%d", profile, commutMode, scenarioMode);
        this.mAudioProfile = profile;
        this.mCommutMode = commutMode;
        this.mScenarioMode = scenarioMode;
        return 0;
    }

    public int setEnableSpeakerphone(boolean enabled) {
        YYLiveLog.release("yrtc", "setEnableSpeakerphone: %b", enabled);
        YYLiveAPI.sharedInstance().getPlayer().enableLoudSpeaker(enabled);
        return 0;
    }

    public boolean isSpeakerphoneEnabled() {
        return YYLiveAPI.sharedInstance().getPlayer().getLoudSpeakerEnabled();
    }

    public int enableAudioVolumeIndication(int interval, int moreThanThd, int lessThanThd, int smooth) {
        YYLiveLog.release("yrtc", "enableAudioVolumeIndication: interval=%d,moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        YYLiveAPI.sharedInstance().setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    public int enableCaptureVolumeIndication(int interval, int moreThanThd, int lessThanThd, int smooth) {
        YYLiveLog.release("yrtc", "enableCaptureVolumeIndication: interval=%d,moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        YYLiveAPI.sharedInstance().setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        YYLiveLog.release("yrtc", "startAudioSaver: fileName=%s,saverMode=%d, fileMode=%d", this.getPrintString(fileName), saverMode, fileMode);
        if (fileName.isEmpty()) {
            return false;
        }
        return YYLiveAPI.sharedInstance().startAudioSaver(fileName, saverMode, fileMode);
    }

    public boolean stopAudioSaver() {
        YYLiveLog.release("yrtc", "stopAudioSaver");
        return YYLiveAPI.sharedInstance().stopAudioSaver();
    }

    public void setSoundEffect(int mode) {
        YYLiveLog.release("yrtc", "YYLiveRtcEngine::setSoundEffect %d", mode);
        YYLiveAPI.sharedInstance().getPublisher().setSoundEffect(mode);
    }

    public int muteLocalAudioStream(boolean muted) {
        YYLiveLog.release("yrtc", "muteLocalAudioStream: %b isThunder:%b", muted, this.isThunder);
        if (this.isThunder.booleanValue()) {
            int volume = 80;
            if (muted) {
                volume = 0;
            }
            YYLiveAPI.sharedInstance().getPublisher().setMicVolume(volume);
        } else if (muted) {
            if (this.mBAudioPublish) {
                YYLiveAPI.sharedInstance().getPublishChannel().setAudioEnable(false);
                this.mBAudioPublish = false;
            }
        } else if (!this.mBAudioPublish && this.isJoinChannel.booleanValue()) {
            YYLiveAPI.sharedInstance().getPublishChannel().setAudioEnable(true);
            if (this.accompanyType >= 0) {
                YYLiveAPI.sharedInstance().getPublisher().setAudioSourceType(this.accompanyType);
            }
            this.mBAudioPublish = true;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int muteAllRemoteAudioStreams(boolean muted) {
        if (this.isMuteAllAudio == muted) {
            return 0;
        }
        YYLiveLog.release("yrtc", "muteAllRemoteAudioStreams: %b isThunder:%b isEnableAudio:%b isJoinChannel:%b", muted, this.isThunder, this.isEnableAudio, this.isJoinChannel);
        if (!this.isEnableAudio.booleanValue()) {
            return -2;
        }
        if (this.isThunder.booleanValue()) {
            YYLiveAPI.sharedInstance().getPlayer().enableAllMute(muted);
        } else {
            this.isMuteAllAudio = muted;
            this.uidMuteAudioList.clear();
            if (muted) {
                ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
                Object object = this.streamLock;
                synchronized (object) {
                    for (YYLiveStream oneStream : this.anchorStreams) {
                        if (oneStream.bVideo) continue;
                        stopStreams.add(oneStream);
                    }
                    for (YYLiveStream oneStream : stopStreams) {
                        this.anchorStreams.remove(oneStream);
                    }
                }
                if (this.isJoinChannel.booleanValue()) {
                    YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            } else {
                ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
                Object object = this.streamLock;
                synchronized (object) {
                    for (YYLiveStream oneStream : this.wholeStreams) {
                        boolean isPlaying = false;
                        if (oneStream.bVideo) continue;
                        for (YYLiveStream anStream : this.anchorStreams) {
                            if (anStream.speakerUid != oneStream.speakerUid || anStream.bVideo) continue;
                            isPlaying = true;
                            break;
                        }
                        if (isPlaying) continue;
                        startStreams.add(oneStream);
                        this.anchorStreams.add(oneStream);
                    }
                }
                if (this.isJoinChannel.booleanValue()) {
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    public int setDefaultMuteAllRemoteAudioStreams(boolean defaultMute) {
        if (!this.isEnableAudio.booleanValue()) {
            return -1;
        }
        return this.muteAllRemoteAudioStreams(defaultMute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int muteRemoteAudioStream(String uid, boolean muted) {
        YYLiveLog.release("yrtc", "muteRemoteAudioStream: uid=%s, %b isThunder:%b isEnableAudio:%b isJoinChannel:%b", this.getPrintString(uid), muted, this.isThunder, this.isEnableAudio, this.isJoinChannel);
        if (this.isThunder.booleanValue()) {
            YYLiveStream stream = new YYLiveStream();
            if (this.mIs32bitUid) {
                try {
                    stream.speakerUid = Long.parseLong(uid);
                }
                catch (NumberFormatException exception) {
                    return -1;
                }
            } else {
                if (uid == null) {
                    return -2;
                }
                YYLiveAPI.sharedInstance().getPlayer().enableMute(muted, uid);
                stream.speakerUid = this.getIntUid(uid);
                if (stream.speakerUid == 0L) {
                    return 0;
                }
            }
            YYLiveAPI.sharedInstance().getPlayer().enableMute(muted, stream);
        } else {
            if (!this.isEnableAudio.booleanValue()) {
                return -2;
            }
            this.uidMuteAudioList.put(uid, muted);
            if (muted) {
                ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
                Object exception = this.streamLock;
                synchronized (exception) {
                    for (YYLiveStream oneStream : this.anchorStreams) {
                        if (Long.parseLong(uid, 10) != oneStream.speakerUid || oneStream.bVideo) continue;
                        stopStreams.add(oneStream);
                    }
                    for (YYLiveStream oneStream : stopStreams) {
                        this.anchorStreams.remove(oneStream);
                    }
                }
                if (this.isJoinChannel.booleanValue()) {
                    YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            } else {
                ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
                YYLiveStream newStream = null;
                boolean alreadyPlay = false;
                Object object = this.streamLock;
                synchronized (object) {
                    for (YYLiveStream oneStream : this.wholeStreams) {
                        if (Long.parseLong(uid, 10) != oneStream.speakerUid || oneStream.bVideo) continue;
                        newStream = oneStream;
                        break;
                    }
                    if (newStream == null) {
                        return 0;
                    }
                    for (YYLiveStream oneStream : this.anchorStreams) {
                        if (Long.parseLong(uid, 10) != oneStream.speakerUid || oneStream.bVideo) continue;
                        alreadyPlay = true;
                        break;
                    }
                    if (!alreadyPlay) {
                        startStreams.add(newStream);
                        this.anchorStreams.add(newStream);
                    }
                }
                if (this.isJoinChannel.booleanValue()) {
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    public int setSpeakerphoneVolume(int volume) {
        YYLiveLog.release("yrtc", "setSpeakerphoneVolume: %d", volume);
        boolean bResult = YYLiveAPI.sharedInstance().getPlayer().setSpeakerVolume(volume);
        if (bResult) {
            return 0;
        }
        return -1;
    }

    public int setMicVolume(int volume) {
        YYLiveLog.release("yrtc", "setMicVolume: %d", volume);
        boolean bResult = YYLiveAPI.sharedInstance().getPublisher().setMicVolume(volume);
        if (bResult) {
            return 0;
        }
        return -1;
    }

    public int setRemoteAudioStreamsVolume(String uid, int volume) {
        YYLiveLog.release("yrtc", "setRemoteAudioStreamsVolume: uid=%s, volume=%d", this.getPrintString(uid), volume);
        if (this.isThunder.booleanValue() && !this.mBGroupSubscribe) {
            return -1;
        }
        YYLiveStream stream = new YYLiveStream();
        if (this.mIs32bitUid) {
            try {
                stream.speakerUid = Long.parseLong(uid);
            }
            catch (NumberFormatException exception) {
                return -1;
            }
        } else {
            stream.speakerUid = this.getIntUid(uid);
            if (stream.speakerUid == 0L) {
                if (this.isNumeric(uid)) {
                    try {
                        stream.speakerUid = Long.parseLong(uid);
                    }
                    catch (NumberFormatException exception) {
                        return -2;
                    }
                } else {
                    return -3;
                }
            }
        }
        if (YYLiveAPI.sharedInstance().getPlayer().setPlayVolume(volume, stream)) {
            return 0;
        }
        return -4;
    }

    public YYLiveAudioFilePlayer createAudioFilePlayer() {
        YYLiveLog.release("yrtc", "createAudioFilePlayer");
        YYLiveAudioFilePlayer audioFilePlayer = new YYLiveAudioFilePlayer();
        this.mAudioFilePlayerSet.add(audioFilePlayer);
        return audioFilePlayer;
    }

    public void destroyAudioFilePlayer(YYLiveAudioFilePlayer audioFilePlayer) {
        YYLiveLog.release("yrtc", "destroyAudioFilePlayer: %s", this.getPrintString(audioFilePlayer));
        if (audioFilePlayer == null) {
            return;
        }
        audioFilePlayer.destroyAudioFilePlayer();
        this.mAudioFilePlayerSet.remove(audioFilePlayer);
    }

    public int setEnableEqualizer(boolean enabled) {
        this.mBEnableEqualizer = enabled;
        YYLiveAPI.sharedInstance().getPublisher().EnableEqualizer(enabled);
        return 0;
    }

    public int setEqGains(int[] gains) {
        if (gains == null) {
            return -1;
        }
        if (gains.length < 11) {
            return -2;
        }
        for (int i = 0; i <= 10; ++i) {
            if (gains[i] >= -12 && gains[i] <= 12) continue;
            return -3;
        }
        this.mEqGains = gains;
        YYLiveAPI.sharedInstance().getPublisher().SetGqGains(gains);
        return 0;
    }

    public int setEnableReverb(boolean enabled) {
        this.mBEnableReverbEx = enabled;
        YYLiveAPI.sharedInstance().getPublisher().EnableReverb(enabled);
        return 0;
    }

    public int setReverbExParameter(ReverbExParameter param) {
        if (param == null) {
            return -1;
        }
        if ((double)param.mRoomSize < 0.0 || (double)param.mRoomSize > 100.0 || (double)param.mPreDelay < 0.0 || (double)param.mPreDelay > 200.0 || (double)param.mReverberance < 0.0 || (double)param.mReverberance > 100.0 || (double)param.mHfDamping < 0.0 || (double)param.mHfDamping > 100.0 || (double)param.mToneLow < 0.0 || (double)param.mToneLow > 100.0 || (double)param.mToneHigh < 0.0 || (double)param.mToneHigh > 100.0 || (double)param.mWetGain < -20.0 || (double)param.mWetGain > 10.0 || (double)param.mDryGain < -20.0 || (double)param.mDryGain > 10.0 || (double)param.mStereoWidth < 0.0 || (double)param.mStereoWidth > 100.0) {
            return -2;
        }
        this.mReverbExGains = param;
        YYLiveAPI.sharedInstance().getPublisher().setReverbExParameter(param.mRoomSize, param.mPreDelay, param.mReverberance, param.mHfDamping, param.mToneLow, param.mToneHigh, param.mWetGain, param.mDryGain, param.mStereoWidth);
        return 0;
    }

    public int setEnableCompressor(boolean enabled) {
        this.mBEnableCompressor = enabled;
        YYLiveAPI.sharedInstance().getPublisher().EnableCompressor(enabled);
        return 0;
    }

    public int setCompressorParam(CompressorParam param) {
        if (param == null) {
            return -1;
        }
        if (param.mThreshold < -40 || param.mThreshold > 0 || param.mReleaseTime <= 0 || param.mAttackTime <= 0) {
            return -2;
        }
        this.mCompressorGains = param;
        YYLiveAPI.sharedInstance().getPublisher().SetCompressorParam(param.mThreshold, param.mMakeupGain, param.mRatio, param.mKnee, param.mReleaseTime, param.mAttackTime);
        return 0;
    }

    public int setEnableLimiter(boolean enabled) {
        this.mBEnableLimiter = enabled;
        YYLiveAPI.sharedInstance().getPublisher().EnableLimiter(enabled);
        return 0;
    }

    public int setLimiterParam(LimterParam param) {
        if (param == null) {
            return -1;
        }
        this.mLimiterGins = param;
        YYLiveAPI.sharedInstance().getPublisher().SetLimiterParam(param.fCeiling, param.fThreshold, param.fPreGain, param.fRelease, param.fAttack, param.fLookahead, param.fLookaheadRatio, param.fRMS, param.fStLink);
        return 0;
    }

    public void setExternalAudioProcessor(long eap) {
        YYLiveAPI.sharedInstance().setExternalAudioProcessor(eap);
    }

    public void enableAudioPlaySpectrum(boolean enable) {
        YYLiveAPI.sharedInstance().enableAudioPlaySpectrum(enable);
    }

    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        YYLiveAPI.sharedInstance().setAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS);
    }

    public int sendUserAppMsgData(byte[] msgData) {
        YYLiveAPI.sharedInstance().sendUserAppMsgData(msgData);
        return 0;
    }

    public void enableAudioDataIndication(boolean enablePlay) {
        this.mBEnablePlayDataIndication = enablePlay;
        YYLiveAPI.sharedInstance().enableAudioDataIndication(enablePlay);
    }

    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        YYLiveAPI.sharedInstance().enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        YYLiveLog.release("yrtc", "enableRenderPcmDataCallBack enable = %b sampleRate: %d, channel = %d ", enable, sampleRate, channel);
        return YYLiveAPI.sharedInstance().enableRenderPcmDataCallBack(enable, sampleRate, channel);
    }

    public void publishByMode(int mode) {
        YYLiveLog.release("ycall-Java", "publishByMode: mode=%d", mode);
        YYLiveAPI.sharedInstance().getPublisher().setAudioSourceType(mode);
        this.accompanyType = mode;
    }

    public int setEnableInEarMonitor(boolean enable) {
        YYLiveLog.release("ycall-Java", "setEnableInEarMonitor: %b", enable);
        if (YYLiveAPI.sharedInstance().getPublisher().enableInEarMonitor(enable)) {
            return 0;
        }
        return -1;
    }

    public Object CreateRendererView(Context context, int type) {
        FrameLayout view = null;
        switch (type) {
            case 2: {
                view = new YYLivePlayerView(context);
                break;
            }
            case 1: {
                view = new YYLivePreviewView(context);
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enableVideo() {
        if (this.isThunder.booleanValue()) {
            return -2;
        }
        this.isEnableVideo = true;
        YYLiveLog.release("yrtc", "enableVideo ," + this.isOtherSource);
        if (this.isJoinChannel.booleanValue()) {
            Object object = this.streamLock;
            synchronized (object) {
                ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
                for (YYLiveStream stream : this.wholeStreams) {
                    boolean isMute;
                    if (!stream.bVideo || this.anchorStreams.contains(stream) || (isMute = this.isMuteVideoStreamWithUid(stream.speakerUid))) continue;
                    for (YRVideoCanvas canvas : this.remoteCanvas) {
                        if (Long.parseLong(canvas.mUid, 10) != stream.speakerUid) continue;
                        stream.toView = canvas.mView;
                        stream.scaleMode = canvas.mRenderMode;
                    }
                    startStreams.add(stream);
                    this.anchorStreams.add(stream);
                }
                if (startStreams.size() > 0) {
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        if (this.isJoinChannel.booleanValue() && (this.isPreview.booleanValue() || this.isOtherSource.booleanValue()) && !this.mBVideoPublish) {
            YYLiveAPI.sharedInstance().getPublishChannel().setVideoEnable(true);
            this.mBVideoPublish = true;
        }
        return 0;
    }

    public int disableVideo() {
        YYLiveLog.release("yrtc", "disable Video ");
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -1;
        }
        this.tryStopVideoSubscribe();
        this.tryStopVideoPublish();
        this.tryStopVideoPreview();
        this.isEnableVideo = false;
        this.isOtherSource = false;
        return 0;
    }

    public int setVideoEncoderConfiguration(YYVideoEncoderConfiguration yyVideoConfig) {
        YYLiveLog.info("yrtc", "setVideoEncoderConfiguration playtype:" + yyVideoConfig.playType + " publishmode:" + yyVideoConfig.publishMode + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        this.mYYVideoEncoderConfiguration = yyVideoConfig;
        YYLiveAPI.sharedInstance().getPublishChannel().updatePlayTypeAndPublishMode(yyVideoConfig.playType, yyVideoConfig.publishMode);
        return 0;
    }

    public int setupLocalVideo(YRVideoCanvas local) {
        YYLiveLog.info("yrtc", "setupLocalVideo view:" + local.mView + " isEnableVideo:" + this.isEnableVideo + " isPreview:" + this.isPreview);
        if (this.isEnableVideo.booleanValue() && !this.isThunder.booleanValue()) {
            if (this.isPreview.booleanValue()) {
                boolean isRemoveFromParent = false;
                if (this.localCanvas != null && this.localCanvas.mView != null) {
                    if (local != null && local.mView != this.localCanvas.mView) {
                        ((ViewGroup)this.localCanvas.mView).removeAllViews();
                        isRemoveFromParent = true;
                    }
                } else {
                    isRemoveFromParent = true;
                }
                if (local != null) {
                    if (local.mView != null && isRemoveFromParent) {
                        ViewGroup viewGroup = (ViewGroup)local.mView;
                        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
                        staticYYLivePreview.setLayoutParams(params);
                        viewGroup.addView((View)staticYYLivePreview);
                    }
                    if (this.localCanvas == null || this.localCanvas.mRenderMode != local.mRenderMode) {
                        // empty if block
                    }
                }
            }
            this.localCanvas = local;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setupRemoteVideo(YRVideoCanvas remote) {
        YYLiveLog.info("yrtc", "setupRemoteVideo view:" + remote.mView + "uid:" + remote.mUid + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        if (remote == null) {
            return -1;
        }
        ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
        if (remote.mView != null) {
            Iterator<YRVideoCanvas> iterator;
            if (this.remoteCanvas.size() > 0) {
                iterator = this.remoteCanvas.iterator();
                if (iterator.hasNext()) {
                    YRVideoCanvas oneCanvas = iterator.next();
                    if (oneCanvas.mView == remote.mView && !oneCanvas.mUid.equals(remote.mUid)) {
                        ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
                        Object object = this.streamLock;
                        synchronized (object) {
                            for (YYLiveStream oneStream : this.anchorStreams) {
                                if (!oneStream.bVideo || Long.parseLong(oneCanvas.mUid, 10) != oneStream.speakerUid) continue;
                                oneStream.toView = null;
                                oneStream.scaleMode = 1;
                                stopStreams.add(oneStream);
                                YYLiveLog.info("yrtc", "setupRemoteVideo view:" + oneCanvas.mView + "uid:" + oneStream.speakerUid + " anchorStreams restart");
                                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                                YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(stopStreams, null);
                                break;
                            }
                            for (YYLiveStream oneStream : this.wholeStreams) {
                                if (!oneStream.bVideo || Long.parseLong(oneCanvas.mUid, 10) != oneStream.speakerUid) continue;
                                YYLiveLog.info("yrtc", "setupRemoteVideo view:" + oneCanvas.mView + "uid:" + oneStream.speakerUid + " wholeStreams");
                                oneStream.toView = null;
                                oneStream.scaleMode = 1;
                            }
                        }
                        this.remoteCanvas.remove(oneCanvas);
                        this.remoteCanvas.add(remote);
                    } else {
                        if (oneCanvas.mView == remote.mView && oneCanvas.mUid.equals(remote.mUid)) {
                            return 0;
                        }
                        this.remoteCanvas.add(remote);
                    }
                }
            } else {
                this.remoteCanvas.add(remote);
            }
            iterator = this.streamLock;
            synchronized (iterator) {
                for (YYLiveStream oneStream : this.anchorStreams) {
                    if (!oneStream.bVideo || Long.parseLong(remote.mUid, 10) != oneStream.speakerUid) continue;
                    oneStream.toView = remote.mView;
                    oneStream.scaleMode = remote.mRenderMode;
                    YYLiveLog.info("yrtc", "setupRemoteVideo view:" + remote.mView + "uid:" + oneStream.speakerUid + " startStreams restart");
                    startStreams.add(oneStream);
                }
                if (startStreams.size() > 0) {
                    YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(startStreams, null);
                    YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                    startStreams.clear();
                }
                for (YYLiveStream oneStream : this.wholeStreams) {
                    if (!oneStream.bVideo || Long.parseLong(remote.mUid, 10) != oneStream.speakerUid) continue;
                    oneStream.toView = remote.mView;
                    oneStream.scaleMode = remote.mRenderMode;
                }
            }
        }
        return 0;
    }

    public int setLocalRenderMode(int mode) {
        YYLiveLog.info("yrtc", "setLocalRenderMode mode:" + mode + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        YYLiveAPI.sharedInstance().setPreviewRenderMode(mode);
        return 0;
    }

    public int setRemoteRenderMode(String uid, int mode) {
        YYLiveLog.info("yrtc", "setRemoteRenderMode Uid:" + uid + " mode:" + mode + " isEnableVideo:" + this.isEnableVideo + " isThunder " + this.isThunder);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        for (YRVideoCanvas oneCanvas : this.remoteCanvas) {
            if (!uid.equals(oneCanvas.mUid)) continue;
            YYLivePlayerView remote = (YYLivePlayerView)((Object)oneCanvas.mView);
            oneCanvas.mRenderMode = mode;
            YYLiveNative.setPlayViewScaleMode((Object)remote, mode);
        }
        return 0;
    }

    public int startPreview() {
        YYLiveLog.info("yrtc", "startPreview local view:" + this.localCanvas + ",isEnableVideo:" + this.isEnableVideo + ",isThunder" + this.isThunder + ",isMuteLocalVideo " + this.isMuteLocalVideo + ",isPreview " + this.isPreview + ",mBVideoPublish " + this.mBVideoPublish + " mBOnlyReleaseCamera:" + this.mBOnlyReleaseCamera);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue() || this.isMuteLocalVideo.booleanValue()) {
            return -2;
        }
        if (this.isPreview.booleanValue()) {
            return 0;
        }
        if (this.mBVideoPublish && !this.isOtherSource.booleanValue() && this.mBOnlyReleaseCamera) {
            YYLiveNative.stopAndRecoverVideoEncode(false);
            this.mBOnlyReleaseCamera = false;
        } else {
            YYLiveAPI.sharedInstance().getPublishChannel().startPreview((Object)staticYYLivePreview, this.mYYVideoEncoderConfiguration.playType, this.mYYVideoEncoderConfiguration.publishMode);
        }
        if (this.localCanvas != null && this.localCanvas.mView != null) {
            ViewGroup viewGroup = (ViewGroup)this.localCanvas.mView;
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
            staticYYLivePreview.setLayoutParams(params);
            viewGroup.addView((View)staticYYLivePreview);
        }
        this.isPreview = true;
        return 0;
    }

    public int stopPreview() {
        YYLiveLog.info("yrtc", "stopPreview local view:" + this.localCanvas + " isEnableVideo:" + this.isEnableVideo + " isPreview " + this.isPreview + " mBVideoPublish " + this.mBVideoPublish);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        if (this.isPreview.booleanValue()) {
            if (this.mBVideoPublish && !this.isOtherSource.booleanValue() && !this.mBOnlyReleaseCamera) {
                YYLiveNative.stopAndRecoverVideoEncode(true);
                this.mBOnlyReleaseCamera = true;
            } else {
                YYLiveAPI.sharedInstance().getPublishChannel().stopPreview();
            }
            if (this.localCanvas != null && this.localCanvas.mView != null) {
                ((ViewGroup)this.localCanvas.mView).removeAllViews();
                this.isPreview = false;
            }
        }
        return 0;
    }

    public int enableLocalVideo(boolean enable) {
        YYLiveLog.info("yrtc", "enableLocalVideo localCanvas:" + this.localCanvas + " isEnableVideo:" + this.isEnableVideo + " isThunder " + this.isThunder + ":" + enable);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        if (!enable) {
            this.tryStopVideoPublish();
            this.tryStopVideoPreview();
            this.isMuteLocalVideo = true;
        } else {
            this.isMuteLocalVideo = false;
        }
        return 0;
    }

    public int muteLocalVideoStream(boolean mute) {
        YYLiveLog.info("yrtc", " muteLocalVideoStream:" + mute + " isEnableVideo:" + this.isEnableVideo + ",isOtherSource" + this.isOtherSource + " isMuteLocalVideo " + this.isMuteLocalVideo + " isPreview " + this.isPreview);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue() || this.isMuteLocalVideo.booleanValue()) {
            return -2;
        }
        if (mute) {
            if (this.mBVideoPublish) {
                YYLiveAPI.sharedInstance().getPublishChannel().setVideoEnable(false);
                this.mBVideoPublish = false;
                this.mVideoStringName = "";
            }
        } else if (this.isJoinChannel.booleanValue() && !this.mBVideoPublish && (this.isPreview.booleanValue() || this.isOtherSource.booleanValue())) {
            YYLiveAPI.sharedInstance().getPublishChannel().setVideoEnable(true);
            this.mBVideoPublish = true;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int muteRemoteVideoStream(String uid, boolean mute) {
        YYLiveLog.info("yrtc", "muteRemoteVideoStream Uid:" + uid + " mute:" + mute + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        this.uidMuteVideoList.put(uid, mute);
        if (mute) {
            ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
            for (YYLiveStream yYLiveStream : this.anchorStreams) {
                if (Long.parseLong(uid, 10) != yYLiveStream.speakerUid || !yYLiveStream.bVideo) continue;
                stopStreams.add(yYLiveStream);
            }
            Object object = this.streamLock;
            synchronized (object) {
                for (YYLiveStream oneStream : stopStreams) {
                    this.anchorStreams.remove(oneStream);
                }
            }
            if (this.isJoinChannel.booleanValue()) {
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        } else {
            ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
            YYLiveStream newStream = null;
            boolean bl = false;
            Object object = this.streamLock;
            synchronized (object) {
                boolean bl2;
                for (YYLiveStream oneStream : this.wholeStreams) {
                    if (Long.parseLong(uid, 10) != oneStream.speakerUid || !oneStream.bVideo) continue;
                    newStream = oneStream;
                    break;
                }
                if (newStream == null) {
                    return 0;
                }
                for (YYLiveStream oneStream : this.anchorStreams) {
                    if (Long.parseLong(uid, 10) != oneStream.speakerUid || !oneStream.bVideo) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (this.remoteCanvas != null) {
                        for (YRVideoCanvas oneCanvas : this.remoteCanvas) {
                            if (Long.parseLong(oneCanvas.mUid, 10) != newStream.speakerUid) continue;
                            newStream.toView = oneCanvas.mView;
                            newStream.scaleMode = oneCanvas.mRenderMode;
                        }
                    }
                    startStreams.add(newStream);
                    this.anchorStreams.add(newStream);
                }
            }
            if (this.isJoinChannel.booleanValue()) {
                YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int muteAllRemoteVideoStreams(boolean mute) {
        if (this.isMuteAllVideo == mute) {
            return 0;
        }
        YYLiveLog.info("yrtc", "muteAllRemoteVideoStream  mute:" + mute + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        this.isMuteAllVideo = mute;
        this.uidMuteVideoList.clear();
        if (mute) {
            ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
            Object object = this.streamLock;
            synchronized (object) {
                for (YYLiveStream oneStream : this.anchorStreams) {
                    if (!oneStream.bVideo) continue;
                    stopStreams.add(oneStream);
                }
                for (YYLiveStream oneStream : stopStreams) {
                    this.anchorStreams.remove(oneStream);
                }
            }
            if (this.isJoinChannel.booleanValue()) {
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        } else {
            ArrayList<YYLiveStream> startStreams = new ArrayList<YYLiveStream>(0);
            Object object = this.streamLock;
            synchronized (object) {
                for (YYLiveStream oneStream : this.wholeStreams) {
                    boolean isPlaying = false;
                    if (!oneStream.bVideo) continue;
                    for (YYLiveStream anStream : this.anchorStreams) {
                        if (anStream.speakerUid != oneStream.speakerUid || !anStream.bVideo) continue;
                        isPlaying = true;
                        break;
                    }
                    if (isPlaying) continue;
                    if (this.remoteCanvas != null) {
                        for (YRVideoCanvas oneCanvas : this.remoteCanvas) {
                            if (Long.parseLong(oneCanvas.mUid, 10) != oneStream.speakerUid) continue;
                            oneStream.toView = oneCanvas.mView;
                            oneStream.scaleMode = oneCanvas.mRenderMode;
                        }
                    }
                    startStreams.add(oneStream);
                    this.anchorStreams.add(oneStream);
                }
            }
            if (this.isJoinChannel.booleanValue()) {
                YYLiveAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
            }
        }
        return 0;
    }

    public int setDefaultMuteAllRemoteVideoStreams(boolean defaultMute) {
        if (this.isThunder.booleanValue() || !this.isEnableVideo.booleanValue()) {
            return -1;
        }
        return this.muteAllRemoteVideoStreams(defaultMute);
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        return YYLiveAPI.sharedInstance().registerAudioFrameObserver(observer);
    }

    public int setRecordingAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        return YYLiveAPI.sharedInstance().setRecordingAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
    }

    public int setPlaybackAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        return YYLiveAPI.sharedInstance().setPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
    }

    public int setVideoSource(IVideoSource videoSource) {
        YYLiveLog.info("yrtc", "setVideoSource  isThunder:" + this.isThunder + " isEnableVideo:" + this.isEnableVideo + "videoSource == null ?" + (videoSource == null));
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        if (videoSource == null) {
            YYLiveAPI.sharedInstance().getPublishChannel().attachVideoCapture(null);
            this.isOtherSource = false;
        } else if (videoSource instanceof ScreenRecordSource) {
            YYLiveAPI.sharedInstance().getPublishChannel().attachVideoCapture(((ScreenRecordSource)videoSource).mScreenCapture);
            this.isOtherSource = true;
        } else {
            ExternalVideoSource externalVideoSource = new ExternalVideoSource(videoSource);
            YYLiveAPI.sharedInstance().getPublishChannel().attachVideoCapture(externalVideoSource);
            this.isOtherSource = true;
        }
        return 0;
    }

    public boolean getIsThunder() {
        return this.isThunder;
    }

    private void tryStopPublish() {
        if (this.isThunder.booleanValue()) {
            if (this.mBAudioPublish) {
                YYLiveAPI.sharedInstance().getPublisher().stopPublishAudio();
                this.mBAudioPublish = false;
                this.mStringName = "";
            }
        } else if (this.mBAudioPublish) {
            YYLiveAPI.sharedInstance().getPublishChannel().setAudioEnable(false);
            this.mBAudioPublish = false;
            this.mStringName = "";
        }
    }

    private void tryStopVideoPublish() {
        if (this.mBVideoPublish) {
            YYLiveAPI.sharedInstance().getPublishChannel().setVideoEnable(false);
            this.mBVideoPublish = false;
            this.mVideoStringName = "";
        }
    }

    private boolean isNumeric(String strNum) {
        String bigStr;
        Pattern pattern = Pattern.compile("^\\d+$");
        try {
            bigStr = new BigDecimal(strNum).toString();
        }
        catch (Exception e) {
            return false;
        }
        Matcher isNum = pattern.matcher(bigStr);
        return isNum.matches();
    }

    private void tryStopSubscribe() {
        if (this.isThunder.booleanValue()) {
            if (this.mBGroupSubscribe) {
                ArrayList<YYLiveGroup> audioGroup = new ArrayList<YYLiveGroup>(0);
                YYLiveGroup oneGroup = new YYLiveGroup();
                oneGroup.appId = this.mChannelAppId;
                oneGroup.groupName = "g_" + this.mChannelName;
                audioGroup.add(oneGroup);
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);
                this.mBGroupSubscribe = false;
            }
        } else {
            ArrayList<YYLiveStream> stopSteams = new ArrayList<YYLiveStream>(0);
            for (YYLiveStream oneStream : this.anchorStreams) {
                if (oneStream.bVideo) continue;
                stopSteams.add(oneStream);
            }
            if (stopSteams.size() > 0) {
                for (YYLiveStream oneStream : stopSteams) {
                    this.anchorStreams.remove(oneStream.streamName);
                }
                YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopSteams, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStopVideoSubscribe() {
        ArrayList<YYLiveStream> stopStreams = new ArrayList<YYLiveStream>(0);
        Object object = this.streamLock;
        synchronized (object) {
            for (YYLiveStream oneStream : this.anchorStreams) {
                if (!oneStream.bVideo) continue;
                stopStreams.add(oneStream);
            }
            YYLiveAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            for (YYLiveStream oneStream : stopStreams) {
                this.anchorStreams.remove(oneStream);
            }
        }
    }

    private void tryStopVideoPreview() {
        if (this.isPreview.booleanValue() || this.mBOnlyReleaseCamera) {
            this.stopPreview();
            this.isPreview = false;
            this.mBOnlyReleaseCamera = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUid2String(int iUid, String strUid) {
        this.removeUid2String(strUid);
        YYLiveRtcEngine yYLiveRtcEngine = this;
        synchronized (yYLiveRtcEngine) {
            this.mUidToStringMap.put(iUid, strUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringUid(int iUid) {
        YYLiveRtcEngine yYLiveRtcEngine = this;
        synchronized (yYLiveRtcEngine) {
            return this.mUidToStringMap.get(iUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIntUid(String strUid) {
        int iUid = 0;
        YYLiveRtcEngine yYLiveRtcEngine = this;
        synchronized (yYLiveRtcEngine) {
            if (strUid != null && strUid.length() != 0) {
                for (Integer key : this.mUidToStringMap.keySet()) {
                    if (!strUid.equals(this.mUidToStringMap.get(key))) continue;
                    iUid = key;
                    break;
                }
            }
        }
        return iUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUid2String(int iUid) {
        YYLiveRtcEngine yYLiveRtcEngine = this;
        synchronized (yYLiveRtcEngine) {
            this.mUidToStringMap.remove(iUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUid2String(String strUid) {
        YYLiveRtcEngine yYLiveRtcEngine = this;
        synchronized (yYLiveRtcEngine) {
            if (strUid != null && strUid.length() != 0) {
                for (Integer key : this.mUidToStringMap.keySet()) {
                    if (!strUid.equals(this.mUidToStringMap.get(key))) continue;
                    this.mUidToStringMap.remove(key);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllUid2String() {
        YYLiveRtcEngine yYLiveRtcEngine = this;
        synchronized (yYLiveRtcEngine) {
            this.mUidToStringMap.clear();
        }
    }

    private void resetRtcEngine() {
        mHandler = null;
        sMyAppId = 0;
        sMySceneId = 0L;
        mRtcEventHandler = null;
        mHttpsRequestHandler = null;
        this.mMyUid = 0L;
        this.mIs32bitUid = false;
        this.mMyStrUid = "";
        this.mUidToStringMap = new HashMap<Integer, String>();
        mLogLevel = 0;
        mLogPath = "";
        mYyLogCallback = null;
        this.mBGroupSubscribe = false;
        this.mBAudioPublish = false;
        this.mChannelAppId = 0;
        this.mChannelName = "";
        this.mChannelProfile = 0;
        this.mAudioProfile = 0;
        this.mCommutMode = 0;
        this.mScenarioMode = 0;
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        this.mBEnablePlayDataIndication = false;
        this.mEqGains = new int[11];
        this.mBEnableEqualizer = false;
        this.mBEnableCompressor = false;
        this.mBEnableLimiter = false;
        this.mBEnableReverbEx = false;
        this.mReverbExGains = new ReverbExParameter();
        this.mCompressorGains = new CompressorParam();
        this.mLimiterGins = new LimterParam();
        for (YYLiveAudioFilePlayer audioFilePlayer : this.mAudioFilePlayerSet) {
            audioFilePlayer.destroyAudioFilePlayer();
        }
        this.mAudioFilePlayerSet.clear();
        this.accompanyType = -1;
    }

    private String getPrintString(String str) {
        String result = "";
        if (str != null) {
            result = str;
        }
        return result;
    }

    private String getPrintString(byte[] data) {
        String result = "";
        if (data != null) {
            result = data.toString();
        }
        return result;
    }

    private String getPrintString(Object obj) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }

    private boolean isMuteVideoStreamWithUid(long uid) {
        if (!this.isEnableVideo.booleanValue()) {
            return true;
        }
        Boolean result = this.uidMuteVideoList.get(String.valueOf(uid));
        if (result != null) {
            return result;
        }
        return this.isMuteAllVideo;
    }

    private boolean isMuteAudioStreamWithUid(long uid) {
        if (!this.isEnableAudio.booleanValue()) {
            return true;
        }
        Boolean result = this.uidMuteAudioList.get(String.valueOf(uid));
        if (result != null) {
            return result;
        }
        return this.isMuteAllAudio;
    }

    static {
        mLogPath = "";
        mLogLevel = 0;
        mYyLogCallback = null;
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        mHandler = null;
        appContext = null;
        staticYYLivePreview = null;
    }

    private static class SingleonHolder {
        private static YYLiveRtcEngine INSTANCE = new YYLiveRtcEngine();

        private SingleonHolder() {
        }
    }

    public static final class LimterParam {
        public float fCeiling = 0.0f;
        public float fThreshold = 0.0f;
        public float fPreGain = 0.0f;
        public float fRelease = 0.0f;
        public float fAttack = 0.0f;
        public float fLookahead = 0.0f;
        public float fLookaheadRatio = 0.0f;
        public float fRMS = 0.0f;
        public float fStLink = 0.0f;
    }

    public static final class CompressorParam {
        public int mThreshold = 0;
        public int mMakeupGain = 0;
        public int mRatio = 0;
        public int mKnee = 0;
        public int mReleaseTime = 0;
        public int mAttackTime = 0;
    }

    public static final class ReverbExParameter {
        public float mRoomSize = 0.0f;
        public float mPreDelay = 0.0f;
        public float mReverberance = 0.0f;
        public float mHfDamping = 0.0f;
        public float mToneLow = 0.0f;
        public float mToneHigh = 0.0f;
        public float mWetGain = 0.0f;
        public float mDryGain = 0.0f;
        public float mStereoWidth = 0.0f;
    }

    private static class NotificationHandler
    extends Handler {
        private final WeakReference<YYLiveRtcEngine> mRtcEngine;

        public NotificationHandler(YYLiveRtcEngine rtc) {
            this.mRtcEngine = new WeakReference<YYLiveRtcEngine>(rtc);
        }

        public NotificationHandler(YYLiveRtcEngine rtc, Looper loop) {
            super(loop);
            this.mRtcEngine = new WeakReference<YYLiveRtcEngine>(rtc);
        }

        public void handleMessage(Message msg) {
            block44: {
                block0 : switch (msg.what) {
                    case 0: {
                        YYLiveNotification.PublishStatusInfo info = (YYLiveNotification.PublishStatusInfo)msg.obj;
                        YYLiveLog.release(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.PublishStatusInfo stream=%s status=%d", info.getStreamName(), info.getStatus()));
                        break;
                    }
                    case 1: {
                        YYLiveNotification.PublishRunTimeInfo info = (YYLiveNotification.PublishRunTimeInfo)msg.obj;
                        YYLiveLog.info(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.PublishRunTimeInfo stream=%s fps=%d bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStreamName(), info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(), info.getInfo().getWidth(), info.getInfo().getHeight()));
                        break;
                    }
                    case 2: {
                        YYLiveNotification.PlayStatusInfo info = (YYLiveNotification.PlayStatusInfo)msg.obj;
                        YYLiveLog.release(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.PlayStatusInfo stream=%s status=%d", info.getStream().streamName, info.getStatus()));
                        switch (info.getStatus()) {
                            case -1: {
                                break;
                            }
                            case 0: {
                                if (mRtcEventHandler != null && ((YYLiveRtcEngine)this.mRtcEngine.get()).getIsThunder()) {
                                    ((YYLiveRtcEngine)this.mRtcEngine.get()).isJoinChannel = true;
                                    mRtcEventHandler.onJoinChannelSuccess(((YYLiveRtcEngine)this.mRtcEngine.get()).getChannelName(), ((YYLiveRtcEngine)this.mRtcEngine.get()).getMyUid(), 0);
                                    break;
                                }
                                break block44;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                if (mRtcEventHandler != null && ((YYLiveRtcEngine)this.mRtcEngine.get()).getIsThunder()) {
                                    YYLiveRtcEventHandler.RtcStats status = new YYLiveRtcEventHandler.RtcStats();
                                    mRtcEventHandler.onLeaveChannel(status);
                                    break;
                                }
                                break block44;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                long renderTime = System.currentTimeMillis();
                                YYLiveStream playStream = info.getStream();
                                YYLiveStream findStream = YYLiveAPI.sharedInstance().getPlayer().getSubscribeStreamByUid(playStream.speakerUid);
                                if (findStream == null) break block0;
                                int elapseTime = (int)(renderTime - findStream.startSubscribeTime);
                                mRtcEventHandler.onFirstRemoteVideoFrame(findStream.speakerUid, findStream.width, findStream.height, elapseTime);
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        YYLiveNotification.YYAudioCaptureVolume info = (YYLiveNotification.YYAudioCaptureVolume)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onCaptureVolumeIndication(info.mVolume, (int)info.mCpt, info.mMicVolume);
                        break;
                    }
                    case 5: {
                        YYLiveNotification.AudioVolumeInfo info = (YYLiveNotification.AudioVolumeInfo)msg.obj;
                        if (info.getVolumeInfos() == null) break;
                        int maxVol = 0;
                        int index = 0;
                        ArrayList<YYLiveRtcEventHandler.AudioVolumeInfo> volInfos = new ArrayList<YYLiveRtcEventHandler.AudioVolumeInfo>();
                        for (Map.Entry<Long, YYLiveNotification.YYVolumeInfo> entry : info.getVolumeInfos().entrySet()) {
                            if (entry.getValue().mActualSpeakerUidList == null || entry.getValue().mActualSpeakerUidList.isEmpty()) continue;
                            for (long uid : entry.getValue().mActualSpeakerUidList) {
                                YYLiveRtcEventHandler.AudioVolumeInfo volInfo = new YYLiveRtcEventHandler.AudioVolumeInfo();
                                if (((YYLiveRtcEngine)this.mRtcEngine.get()).mIs32bitUid) {
                                    volInfo.uid = Long.toString(uid);
                                } else {
                                    volInfo.uid = ((YYLiveRtcEngine)this.mRtcEngine.get()).getStringUid((int)uid);
                                    if (volInfo.uid == null || volInfo.uid.isEmpty()) continue;
                                }
                                volInfo.volume = entry.getValue().mVolume;
                                volInfo.pts = (int)entry.getValue().mPts;
                                if (maxVol < volInfo.volume) {
                                    maxVol = volInfo.volume;
                                }
                                ++index;
                                volInfos.add(volInfo);
                                if (s_playVolumeNotifyCount % 200 != 0) continue;
                                YYLiveLog.release(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.AudioPlayVolume, [%d] uid %s, volume %d", index, volInfo.uid.toString(), volInfo.volume));
                            }
                        }
                        int volSize = volInfos.size();
                        if (volSize <= 0) break;
                        YYLiveRtcEventHandler.AudioVolumeInfo[] volList = new YYLiveRtcEventHandler.AudioVolumeInfo[volSize];
                        for (int i = 0; i < volSize; ++i) {
                            volList[i] = (YYLiveRtcEventHandler.AudioVolumeInfo)volInfos.get(i);
                        }
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioVolumeIndication(volList, maxVol);
                        ++s_playVolumeNotifyCount;
                        break;
                    }
                    case 6: {
                        YYLiveNotification.BizAuthResult result = (YYLiveNotification.BizAuthResult)msg.obj;
                        YYLiveLog.release(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.BizAuthResult stream=%s group=%s result=%d", result.getAuthStream() != null ? result.getAuthStream().streamName : "null", result.getAuthGroup() != null ? result.getAuthGroup().groupName : "null", result.getBizAuthResult()));
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onBizAuthResult(result.isPublishAuth(), result.getBizAuthResult());
                        break;
                    }
                    case 7: {
                        YYLiveNotification.SdkAuthResult result = (YYLiveNotification.SdkAuthResult)msg.obj;
                        YYLiveLog.release(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.SdkAuthResult appId=%d uid=%d result=%d", result.getAppId(), result.getUid(), result.getSdkAuthResult()));
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onSdkAuthResult(result.getSdkAuthResult());
                        break;
                    }
                    case 9: {
                        YYLiveNotification.UidInt2String result = (YYLiveNotification.UidInt2String)msg.obj;
                        ((YYLiveRtcEngine)this.mRtcEngine.get()).addUid2String(result.getUidInt(), result.getUidString());
                        YYLiveLog.release(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.UidInt2String uid=%d str=%s", result.getUidInt(), result.getUidString()));
                        break;
                    }
                    case 14: {
                        YYLiveNotification.AudioDataInfo result = (YYLiveNotification.AudioDataInfo)msg.obj;
                        long uid = result.getUid();
                        String strUid = "";
                        if (((YYLiveRtcEngine)this.mRtcEngine.get()).mIs32bitUid) {
                            strUid = Long.toString(uid);
                        } else {
                            strUid = ((YYLiveRtcEngine)this.mRtcEngine.get()).getStringUid((int)uid);
                            if ((strUid == null || strUid.isEmpty()) && ((strUid = Long.toString(uid)) == null || strUid.isEmpty())) {
                                return;
                            }
                        }
                        int duration = result.getDuration();
                        int cpt = result.getCpt();
                        int pts = result.getPts();
                        byte[] data = result.getData();
                        int len = 0;
                        if (null != data) {
                            len = data.length;
                        }
                        if (s_playDataNotifyCount % 500 == 0) {
                            YYLiveLog.release(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.AudioPlayData,cpt:%d,pts:%d, len:%d", cpt, pts, len));
                        }
                        ++s_playDataNotifyCount;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioPlayData(data, cpt, pts, strUid, duration);
                        break;
                    }
                    case 15: {
                        YYLiveNotification.AudioPlaySpectrumData result = (YYLiveNotification.AudioPlaySpectrumData)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioPlaySpectrumData(result.getData());
                        break;
                    }
                    case 16: {
                        YYLiveNotification.AudioCapturePcmData result = (YYLiveNotification.AudioCapturePcmData)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioCapturePcmData(result.getData(), result.getDataSize(), result.getSampleRate(), result.getChannel());
                        break;
                    }
                    case 19: {
                        YYLiveNotification.AudioRenderPcmData result = (YYLiveNotification.AudioRenderPcmData)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioRenderPcmData(result.getData(), result.getDataSize(), result.getDuration(), result.getSampleRate(), result.getChannel());
                        break;
                    }
                    case 17: {
                        YYLiveNotification.UserAppMsgData result = (YYLiveNotification.UserAppMsgData)msg.obj;
                        long uid = result.getUid();
                        String strUid = "";
                        strUid = Long.toString(uid);
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onRecvUserAppMsgData(result.getData(), strUid);
                        break;
                    }
                    case 18: {
                        YYLiveNotification.AppMsgDataFailedStatus result = (YYLiveNotification.AppMsgDataFailedStatus)msg.obj;
                        YYLiveLog.info(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.AppMsgDataFailedStatus status=%d", result.getFailedStatus()));
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onSendAppMsgDataFailedStatus(result.getFailedStatus());
                        break;
                    }
                    case 23: {
                        YYLiveNotification.InitiateHttpsRequest result = (YYLiveNotification.InitiateHttpsRequest)msg.obj;
                        String reqUrl = result.getReqUrl();
                        int target = result.getTarget();
                        YYLiveLog.info(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.InitiateHttpsRequest reqUrl=%s target=%d", reqUrl, target));
                        if (mHttpsRequestHandler == null) break;
                        mHttpsRequestHandler.send(reqUrl, target);
                        break;
                    }
                    case 22: {
                        YYLiveNotification.PublishChannelStreamInfo info = (YYLiveNotification.PublishChannelStreamInfo)msg.obj;
                        YYLiveLog.info(YYLiveRtcEngine.TAG, "*************** (Not deal in thunderbolt)PublishChannelStreamInfo ***************");
                        YYLiveLog.info(YYLiveRtcEngine.TAG, "YYLiveNotification.PublishChannelStreamInfo channelID:" + info.getChannelId() + " streams:" + info.getStreams().size());
                        for (YYLiveStream oneStream : info.getStreams()) {
                            YYLiveLog.info(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.PublishChannelStreamInfo stream name:%s speak id:%d appid:%d", oneStream.streamName, oneStream.speakerUid, oneStream.appId));
                        }
                        YYLiveLog.info(YYLiveRtcEngine.TAG, "*************** *********************************************** ***************");
                        break;
                    }
                    case 24: {
                        YYLiveNotification.StreamsNotify info = (YYLiveNotification.StreamsNotify)msg.obj;
                        YYLiveLog.info(YYLiveRtcEngine.TAG, "*************** kYYLiveAPINotification_StreamsNotify ***************");
                        YYLiveLog.info(YYLiveRtcEngine.TAG, "YYLiveNotification.StreamsNotify channelID:" + info.getChannelId() + " streams:" + info.getStreams().size());
                        for (YYLiveStream oneStream : info.getStreams()) {
                            YYLiveLog.info(YYLiveRtcEngine.TAG, String.format("YYLiveNotification.StreamsNotify stream name:%s speak id:%d appid:%d", oneStream.streamName, oneStream.speakerUid, oneStream.appId));
                        }
                        YYLiveLog.info(YYLiveRtcEngine.TAG, "*************** *********************************************** ***************");
                        ((YYLiveRtcEngine)this.mRtcEngine.get()).onStreamsNotify(info);
                        break;
                    }
                    case 13: {
                        YYLiveNotification.ResolutionChangeInfo info = (YYLiveNotification.ResolutionChangeInfo)msg.obj;
                        YYLiveAPI.sharedInstance().getPlayer().setSubscribeStreamWHByUid(info.getStream().speakerUid, info.getWidth(), info.getHeight());
                        mRtcEventHandler.onVideoSizeChanged(info.getStream().speakerUid, info.getWidth(), info.getHeight(), 0);
                        break;
                    }
                }
            }
        }
    }
}

